/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util;

import com.atlassian.jira.util.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.concurrent.Immutable;

@Immutable
public class Window<T>
implements Iterable<T> {
    private final List<T> fullCollection;
    private final int start;
    private final int end;

    private Window(Collection<T> fullCollection, int start, int end) {
        Window.checkIndex(start >= 0, "Start of a window cannot be lower than zero");
        Window.checkIndex(end <= fullCollection.size(), "End of a window cannot be larger than the size of the collection");
        this.fullCollection = ImmutableList.copyOf(fullCollection);
        this.start = start;
        this.end = end;
    }

    private static void checkIndex(boolean condition, String message) {
        if (!condition) {
            throw new IndexOutOfBoundsException(message);
        }
    }

    public static <T> Window<T> of(Collection<T> coll) {
        return new Window<T>(coll, 0, coll.size());
    }

    public static <T> Window<T> empty() {
        return Window.of(Collections.emptyList());
    }

    public int size() {
        return this.end - this.start;
    }

    public boolean hasElementsAfter() {
        return this.fullCollection.size() > this.end;
    }

    public boolean hasElementsBefore() {
        return this.start > 0;
    }

    public T first() {
        return this.fullCollection.get(this.start);
    }

    public T last() {
        return this.fullCollection.get(this.end - 1);
    }

    public Window<T> keepUntil(Predicate<T> predicate) {
        int newEnd = this.start;
        for (T elem : this) {
            if (!predicate.evaluate(elem)) break;
            ++newEnd;
        }
        return new Window<T>(this.fullCollection, this.start, newEnd);
    }

    public Window<T> dropUntil(Predicate<T> predicate) {
        int newStart = this.start;
        for (T elem : this) {
            if (predicate.evaluate(elem)) break;
            ++newStart;
        }
        return new Window<T>(this.fullCollection, newStart, this.end);
    }

    public Window<T> dropUntilElement(T expected) {
        for (int i = this.start; i < this.end; ++i) {
            if (!expected.equals(this.fullCollection.get(i))) continue;
            return new Window<T>(this.fullCollection, i, this.end);
        }
        throw new IllegalArgumentException("Element doesn't exist in the collection");
    }

    public Window<T> keepUntilElement(T expected) {
        for (int i = this.start; i < this.end; ++i) {
            if (!expected.equals(this.fullCollection.get(i))) continue;
            return new Window<T>(this.fullCollection, this.start, i + 1);
        }
        throw new IllegalArgumentException("Element doesn't exist in the collection");
    }

    public Window<T> focusElement(T expected, int radius) {
        if (radius < 0) {
            throw new IllegalArgumentException("Radius cannot be negative");
        }
        for (int i = this.start; i < this.end; ++i) {
            if (!expected.equals(this.fullCollection.get(i))) continue;
            return this.focusAt(i, radius);
        }
        throw new IllegalArgumentException("Element doesn't exist in the collection");
    }

    private Window<T> focusAt(int index, int radius) {
        int newStart = Math.max(index - radius, 0);
        int newEnd = Math.min(index + radius + 1, this.end);
        return new Window<T>(this.fullCollection, newStart, newEnd);
    }

    public Window<T> shrinkFromStart(int size) {
        int diff = this.size() - size;
        if (diff > 0) {
            return new Window<T>(this.fullCollection, this.start + diff, this.end);
        }
        return this;
    }

    public Window<T> shrinkFromEnd(int size) {
        int diff = this.size() - size;
        if (diff > 0) {
            return new Window<T>(this.fullCollection, this.start, this.end - diff);
        }
        return this;
    }

    public List<T> get() {
        return this.fullCollection.stream().skip(this.start).limit(this.size()).collect(Collectors.toCollection(ArrayList::new));
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Window<T> reverse() {
        int newStart = this.fullCollection.size() - this.end;
        int newEnd = newStart + this.size();
        return new Window<T>(Lists.reverse(this.fullCollection), newStart, newEnd);
    }

    public String toString() {
        return this.get().toString();
    }

    @Override
    public Iterator<T> iterator() {
        return this.get().iterator();
    }
}

