/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.beans;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.user.ApplicationUser;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;

public class UserDTO {
    @JsonProperty
    private final boolean active;
    @JsonProperty
    private final long directoryId;
    @JsonProperty
    private final String displayName;
    @JsonProperty
    private final String email;
    @JsonProperty
    private final String key;
    @JsonProperty
    private final Long id;
    @JsonProperty
    private final String name;
    @JsonProperty
    private final String username;

    @JsonCreator
    public UserDTO(@JsonProperty(value="active") boolean active, @JsonProperty(value="directoryId") long directoryId, @JsonProperty(value="displayName") String displayName, @JsonProperty(value="email") String email, @JsonProperty(value="key") String key, @JsonProperty(value="name") String name, @JsonProperty(value="username") String username, @JsonProperty(value="id") Long id) {
        Validate.notBlank((CharSequence)key);
        Validate.notBlank((CharSequence)username);
        this.active = active;
        this.directoryId = directoryId;
        this.displayName = displayName;
        this.email = email;
        this.key = key;
        this.name = name;
        this.username = username;
        this.id = id;
    }

    public UserDTO(ApplicationUser user) {
        this(user.isActive(), user.getDirectoryId(), user.getDisplayName(), user.getEmailAddress(), user.getKey(), user.getName(), user.getUsername(), user.getId());
    }

    public long getDirectoryId() {
        return this.directoryId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getEmail() {
        return this.email;
    }

    public String getKey() {
        return this.key;
    }

    public String getName() {
        return this.name;
    }

    public String getUsername() {
        return this.username;
    }

    public boolean isActive() {
        return this.active;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public ApplicationUser asApplicationUser(final User directoryUser) {
        Validate.notNull((Object)directoryUser);
        return new ApplicationUser(){

            public Long getId() {
                return UserDTO.this.id;
            }

            public String getKey() {
                return UserDTO.this.key;
            }

            public String getUsername() {
                return UserDTO.this.username;
            }

            public String getName() {
                return UserDTO.this.name;
            }

            public long getDirectoryId() {
                return UserDTO.this.directoryId;
            }

            public boolean isActive() {
                return UserDTO.this.active;
            }

            public String getEmailAddress() {
                return UserDTO.this.email;
            }

            public String getDisplayName() {
                return UserDTO.this.displayName;
            }

            public User getDirectoryUser() {
                return new User(){

                    public long getDirectoryId() {
                        return UserDTO.this.directoryId;
                    }

                    public String getDisplayName() {
                        return UserDTO.this.displayName;
                    }

                    public String getEmailAddress() {
                        return UserDTO.this.email;
                    }

                    public String getName() {
                        return UserDTO.this.name;
                    }

                    public boolean isActive() {
                        return UserDTO.this.active;
                    }

                    public int compareTo(User user) {
                        return directoryUser.compareTo(user);
                    }
                };
            }
        };
    }
}

