/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps;

import com.atlassian.maven.plugins.amps.DataSource;
import com.atlassian.maven.plugins.amps.MavenContext;
import com.atlassian.maven.plugins.amps.PdkParams;
import com.atlassian.maven.plugins.amps.PluginInformation;
import com.atlassian.maven.plugins.amps.Product;
import com.atlassian.maven.plugins.amps.ProductArtifact;
import com.atlassian.maven.plugins.amps.XmlOverride;
import com.atlassian.maven.plugins.amps.product.ImportMethod;
import com.atlassian.maven.plugins.amps.product.jira.JiraDatabase;
import com.atlassian.maven.plugins.amps.product.jira.JiraDatabaseFactory;
import com.atlassian.maven.plugins.amps.util.AmpsCreatePluginPrompter;
import com.atlassian.maven.plugins.amps.util.CreatePluginProperties;
import com.atlassian.maven.plugins.amps.util.FileUtils;
import com.atlassian.maven.plugins.amps.util.PluginXmlUtils;
import com.atlassian.maven.plugins.amps.util.ProductHandlerUtil;
import com.atlassian.maven.plugins.amps.util.VersionUtils;
import com.atlassian.maven.plugins.amps.util.minifier.MinifierParameters;
import com.atlassian.maven.plugins.amps.util.minifier.ResourcesMinifier;
import com.google.common.annotations.VisibleForTesting;
import com.googlecode.htmlcompressor.compressor.XmlCompressor;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.archetype.common.DefaultPomManager;
import org.apache.maven.archetype.common.MavenJDOMWriter;
import org.apache.maven.archetype.common.util.Format;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.components.interactivity.PrompterException;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.jdom.Document;
import org.jdom.input.SAXBuilder;
import org.twdata.maven.mojoexecutor.MojoExecutor;

public class MavenGoals {
    @VisibleForTesting
    static final String AJP_PORT_PROPERTY = "cargo.tomcat.ajp.port";
    private final Log log;
    @VisibleForTesting
    final Map<String, String> pluginArtifactIdToVersionMap;
    private final MavenContext ctx;
    private final Map<String, Container> idToContainerMap = new HashMap<String, Container>(){
        {
            this.put("tomcat5x", new Container("tomcat5x", "org.apache.tomcat", "apache-tomcat", "5.5.36"));
            this.put("tomcat6x", new Container("tomcat6x", "org.apache.tomcat", "apache-tomcat", "6.0.41"));
            this.put("tomcat7x", new Container("tomcat7x", "org.apache.tomcat", "apache-tomcat", "7.0.52", "windows-x64"));
            this.put("tomcat8x", new Container("tomcat8x", "org.apache.tomcat", "apache-tomcat", "8.0.48-atlassian-hosted", "windows-x64"));
            this.put("tomcat85x", new Container("tomcat8x", "org.apache.tomcat", "apache-tomcat", "8.5.32-atlassian-hosted", "windows-x64"));
            this.put("tomcat85_6", new Container("tomcat8x", "org.apache.tomcat", "apache-tomcat", "8.5.6-atlassian-hosted", "windows-x64"));
            this.put("tomcat9x", new Container("tomcat9x", "org.apache.tomcat", "apache-tomcat", "9.0.11-atlassian-hosted", "windows-x64"));
            this.put("resin3x", new Container("resin3x", "com.caucho", "resin", "3.0.26"));
            this.put("jboss42x", new Container("jboss42x", "org.jboss.jbossas", "jbossas", "4.2.3.GA"));
            this.put("jetty6x", new Container("jetty6x"));
        }
    };
    private final Map<String, String> defaultArtifactIdToVersionMap;

    public MavenGoals(MavenContext ctx) {
        this.ctx = ctx;
        this.log = ctx.getLog();
        this.defaultArtifactIdToVersionMap = Collections.unmodifiableMap(this.getArtifactIdToVersionMap(ctx));
        this.pluginArtifactIdToVersionMap = this.defaultArtifactIdToVersionMap;
    }

    private Map<String, String> getArtifactIdToVersionMap(MavenContext ctx) {
        final Properties overrides = ctx.getVersionOverrides();
        return new HashMap<String, String>(){
            {
                this.put("maven-cli-plugin", overrides.getProperty("maven-cli-plugin", "1.0.11"));
                this.put("org.codehaus.cargo:cargo-maven2-plugin", overrides.getProperty("org.codehaus.cargo:cargo-maven2-plugin", "1.6.10"));
                this.put("atlassian-pdk", overrides.getProperty("atlassian-pdk", "2.3.3"));
                this.put("maven-archetype-plugin", overrides.getProperty("maven-archetype-plugin", "2.0-alpha-4"));
                this.put("maven-bundle-plugin", overrides.getProperty("maven-bundle-plugin", "3.5.0"));
                this.put("yuicompressor-maven-plugin", overrides.getProperty("yuicompressor-maven-plugin", "1.3.0"));
                this.put("build-helper-maven-plugin", overrides.getProperty("build-helper-maven-plugin", "1.7"));
                this.put("maven-install-plugin", overrides.getProperty("maven-install-plugin", "2.3"));
                this.put("maven-deploy-plugin", overrides.getProperty("maven-deploy-plugin", "2.4"));
                this.put("maven-release-plugin", overrides.getProperty("maven-release-plugin", "2.5.3"));
                this.put("maven-dependency-plugin", overrides.getProperty("maven-dependency-plugin", "2.5.1"));
                this.put("maven-resources-plugin", overrides.getProperty("maven-resources-plugin", "2.3"));
                this.put("maven-jar-plugin", overrides.getProperty("maven-jar-plugin", "2.2"));
                this.put("maven-surefire-plugin", overrides.getProperty("maven-surefire-plugin", "2.12.4"));
                this.put("maven-failsafe-plugin", overrides.getProperty("maven-failsafe-plugin", "2.12.4"));
                this.put("maven-exec-plugin", overrides.getProperty("maven-exec-plugin", "1.2.1"));
                this.put("sql-maven-plugin", overrides.getProperty("sql-maven-plugin", "1.5"));
                this.put("maven-javadoc-plugin", overrides.getProperty("maven-javadoc-plugin", "2.8.1"));
            }
        };
    }

    private MojoExecutor.ExecutionEnvironment executionEnvironment() {
        return this.ctx.getExecutionEnvironment();
    }

    public MavenProject getContextProject() {
        return this.ctx.getProject();
    }

    public void executeAmpsRecursively(String ampsVersion, String ampsGoal, Xpp3Dom cfg) throws MojoExecutionException {
        MojoExecutor.executeMojo(MojoExecutor.plugin(MojoExecutor.groupId("com.atlassian.maven.plugins"), MojoExecutor.artifactId("maven-amps-plugin"), MojoExecutor.version(ampsVersion)), MojoExecutor.goal(ampsGoal), cfg, this.executionEnvironment());
    }

    public static void warnDeprecated(Log log) {
        log.warn((CharSequence)"");
        log.warn((CharSequence)"^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^");
        log.warn((CharSequence)"^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^");
        log.warn((CharSequence)"^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^");
        log.warn((CharSequence)"^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^");
        log.warn((CharSequence)"");
        log.warn((CharSequence)">>>  WARNING: atlas-cli and fastdev are DEPRECATED in favour of QuickReload  <<<");
        log.warn((CharSequence)"");
        log.warn((CharSequence)">>>  WARNING: Support for atlas-cli and fastdev will be completely removed in the next AMPS version.  <<<");
        log.warn((CharSequence)"");
        log.warn((CharSequence)"^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^");
        log.warn((CharSequence)"^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^");
        log.warn((CharSequence)"^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^");
        log.warn((CharSequence)"^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^");
        log.warn((CharSequence)"");
    }

    public void startCli(PluginInformation pluginInformation, int port) throws MojoExecutionException {
        MavenGoals.warnDeprecated(this.log);
        String groupId = pluginInformation.getGroupId();
        String artifactId = pluginInformation.getArtifactId();
        ArrayList<MojoExecutor.Element> configs = new ArrayList<MojoExecutor.Element>();
        configs.add(MojoExecutor.element(MojoExecutor.name("commands"), MojoExecutor.element(MojoExecutor.name("pi"), groupId + ":" + artifactId + ":copy-bundled-dependencies " + groupId + ":" + artifactId + ":compress-resources org.apache.maven.plugins:maven-resources-plugin:resources " + groupId + ":" + artifactId + ":filter-plugin-descriptor compile " + groupId + ":" + artifactId + ":generate-manifest " + groupId + ":" + artifactId + ":validate-manifest " + groupId + ":" + artifactId + ":jar org.apache.maven.plugins:maven-install-plugin:install " + groupId + ":" + artifactId + ":install"), MojoExecutor.element(MojoExecutor.name("tpi"), groupId + ":" + artifactId + ":copy-bundled-dependencies " + groupId + ":" + artifactId + ":compress-resources org.apache.maven.plugins:maven-resources-plugin:resources " + groupId + ":" + artifactId + ":filter-plugin-descriptor compile " + groupId + ":" + artifactId + ":generate-manifest org.apache.maven.plugins:maven-resources-plugin:testResources " + groupId + ":" + artifactId + ":filter-test-plugin-descriptor " + groupId + ":" + artifactId + ":copy-test-bundled-dependencies org.apache.maven.plugins:maven-compiler-plugin:testCompile " + groupId + ":" + artifactId + ":generate-test-manifest " + groupId + ":" + artifactId + ":validate-manifest " + groupId + ":" + artifactId + ":validate-test-manifest " + groupId + ":" + artifactId + ":jar " + groupId + ":" + artifactId + ":test-jar org.apache.maven.plugins:maven-install-plugin:install " + groupId + ":" + artifactId + ":install " + groupId + ":" + artifactId + ":test-install"), MojoExecutor.element(MojoExecutor.name("package"), groupId + ":" + artifactId + ":copy-bundled-dependencies " + groupId + ":" + artifactId + ":compress-resources org.apache.maven.plugins:maven-resources-plugin:resources " + groupId + ":" + artifactId + ":filter-plugin-descriptor compile " + groupId + ":" + artifactId + ":generate-manifest " + groupId + ":" + artifactId + ":validate-manifest " + groupId + ":" + artifactId + ":jar ")));
        if (port > 0) {
            configs.add(MojoExecutor.element(MojoExecutor.name("port"), String.valueOf(port)));
        }
        MojoExecutor.executeMojo(MojoExecutor.plugin(MojoExecutor.groupId("org.twdata.maven"), MojoExecutor.artifactId("maven-cli-plugin"), MojoExecutor.version(this.pluginArtifactIdToVersionMap.get("maven-cli-plugin"))), MojoExecutor.goal("execute"), MojoExecutor.configuration(configs.toArray(new MojoExecutor.Element[configs.size()])), this.executionEnvironment());
    }

    public void createPlugin(String productId, AmpsCreatePluginPrompter createPrompter) throws MojoExecutionException {
        CreatePluginProperties props = null;
        Properties systemProps = System.getProperties();
        if (systemProps.containsKey("groupId") && systemProps.containsKey("artifactId") && systemProps.containsKey("version") && systemProps.containsKey("package")) {
            props = new CreatePluginProperties(systemProps.getProperty("groupId"), systemProps.getProperty("artifactId"), systemProps.getProperty("version"), systemProps.getProperty("package"));
        }
        if (productId.equals("stash")) {
            MavenGoals.printStashDeprecationWarning(this.log);
        }
        if (null == props) {
            try {
                props = createPrompter.prompt();
            }
            catch (PrompterException e) {
                throw new MojoExecutionException("Unable to gather properties", (Exception)((Object)e));
            }
        }
        if (null != props) {
            MojoExecutor.ExecutionEnvironment execEnv = this.executionEnvironment();
            Properties sysProps = execEnv.getMavenSession().getExecutionProperties();
            sysProps.setProperty("groupId", props.getGroupId());
            sysProps.setProperty("artifactId", props.getArtifactId());
            sysProps.setProperty("version", props.getVersion());
            sysProps.setProperty("package", props.getThePackage());
            MojoExecutor.executeMojo(MojoExecutor.plugin(MojoExecutor.groupId("org.apache.maven.plugins"), MojoExecutor.artifactId("maven-archetype-plugin"), MojoExecutor.version(this.defaultArtifactIdToVersionMap.get("maven-archetype-plugin"))), MojoExecutor.goal("generate"), MojoExecutor.configuration(MojoExecutor.element(MojoExecutor.name("archetypeGroupId"), "com.atlassian.maven.archetypes"), MojoExecutor.element(MojoExecutor.name("archetypeArtifactId"), (productId.equals("all") ? "" : productId + "-") + "plugin-archetype"), MojoExecutor.element(MojoExecutor.name("archetypeVersion"), VersionUtils.getVersion()), MojoExecutor.element(MojoExecutor.name("interactiveMode"), "false")), execEnv);
            this.correctCrlf(props.getArtifactId());
            File pluginDir = new File(this.ctx.getProject().getBasedir(), props.getArtifactId());
            if (pluginDir.exists()) {
                File src = new File(pluginDir, "src");
                File test = new File(src, "test");
                File java = new File(test, "java");
                String packagePath = props.getThePackage().replaceAll("\\.", Matcher.quoteReplacement(File.separator));
                File packageFile = new File(java, packagePath);
                File packageUT = new File(packageFile, "ut");
                File packageIT = new File(packageFile, "it");
                File ut = new File(new File(java, "ut"), packagePath);
                File it = new File(new File(java, "it"), packagePath);
                if (packageFile.exists()) {
                    try {
                        if (packageUT.exists()) {
                            org.apache.commons.io.FileUtils.copyDirectory((File)packageUT, (File)ut);
                        }
                        if (packageIT.exists()) {
                            org.apache.commons.io.FileUtils.copyDirectory((File)packageIT, (File)it);
                        }
                        IOFileFilter filter = FileFilterUtils.and((IOFileFilter[])new IOFileFilter[]{FileFilterUtils.notFileFilter((IOFileFilter)FileFilterUtils.nameFileFilter((String)"it")), FileFilterUtils.notFileFilter((IOFileFilter)FileFilterUtils.nameFileFilter((String)"ut"))});
                        FileUtils.cleanDirectory(java, (FileFilter)filter);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    static void printStashDeprecationWarning(Log log) {
        log.warn((CharSequence)"^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^");
        log.warn((CharSequence)"^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^");
        log.warn((CharSequence)"^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^");
        log.warn((CharSequence)">>> WARNING: Since version 4.0, Stash has been rebranded. Stash is <<<");
        log.warn((CharSequence)">>> now known as Bitbucket Server. Running stash commands will re- <<<");
        log.warn((CharSequence)">>> sult in a plugin for a version which is now EOL.               <<<");
        log.warn((CharSequence)">>> For the latest version of Bitbucket server, please use the co- <<<");
        log.warn((CharSequence)">>> rresponding bitbucket command.                                 <<<");
        log.warn((CharSequence)">>> Eg.  atlas-create-bitbucket-plugin or mvn bitbucket:create     <<<");
        log.warn((CharSequence)">>> Stash commands will be deprecated in the next major version.   <<<");
        log.warn((CharSequence)"^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^");
        log.warn((CharSequence)"^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^");
        log.warn((CharSequence)"^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^");
    }

    private void correctCrlf(String artifactId) throws MojoExecutionException {
        File outputDirectoryFile;
        if (null != this.ctx && null != this.ctx.getProject() && null != this.ctx.getProject().getBasedir() && this.ctx.getProject().getBasedir().exists() && (outputDirectoryFile = new File(this.ctx.getProject().getBasedir(), artifactId)).exists()) {
            FilenameFilter pomFilter = new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return "pom.xml".equals(name);
                }
            };
            File[] pomFiles = outputDirectoryFile.listFiles(pomFilter);
            DefaultPomManager pomManager = new DefaultPomManager();
            for (File pom : pomFiles) {
                this.processCorrectCrlf(pomManager, pom);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processCorrectCrlf(DefaultPomManager pomManager, File pom) {
        block5: {
            FileInputStream inputStream = null;
            OutputStreamWriter outputStreamWriter = null;
            try {
                Model model = pomManager.readPom(pom);
                String fileEncoding = StringUtils.isEmpty((String)model.getModelEncoding()) ? model.getModelEncoding() : "UTF-8";
                inputStream = new FileInputStream(pom);
                SAXBuilder builder = new SAXBuilder();
                Document doc = builder.build((InputStream)inputStream);
                MavenJDOMWriter writer = new MavenJDOMWriter();
                outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(pom), fileEncoding);
                Format form = Format.getRawFormat().setEncoding(fileEncoding);
                form.setLineSeparator("\n");
                writer.write(model, doc, (Writer)outputStreamWriter, form);
                IOUtil.close((InputStream)inputStream);
            }
            catch (Exception e) {
                this.log.error((CharSequence)"Have exception when try correct line ending.", (Throwable)e);
                break block5;
            }
            finally {
                IOUtil.close(inputStream);
                IOUtil.close(outputStreamWriter);
            }
            IOUtil.close((Writer)outputStreamWriter);
        }
    }

    public void copyBundledDependencies() throws MojoExecutionException {
        MojoExecutor.executeMojo(MojoExecutor.plugin(MojoExecutor.groupId("org.apache.maven.plugins"), MojoExecutor.artifactId("maven-dependency-plugin"), MojoExecutor.version(this.defaultArtifactIdToVersionMap.get("maven-dependency-plugin"))), MojoExecutor.goal("copy-dependencies"), MojoExecutor.configuration(MojoExecutor.element(MojoExecutor.name("includeScope"), "runtime"), MojoExecutor.element(MojoExecutor.name("excludeScope"), "provided"), MojoExecutor.element(MojoExecutor.name("excludeScope"), "test"), MojoExecutor.element(MojoExecutor.name("includeTypes"), "jar"), MojoExecutor.element(MojoExecutor.name("outputDirectory"), "${project.build.outputDirectory}/META-INF/lib")), this.executionEnvironment());
    }

    public void copyTestBundledDependencies(List<ProductArtifact> testBundleExcludes) throws MojoExecutionException {
        StringBuilder sb = new StringBuilder();
        for (ProductArtifact artifact : testBundleExcludes) {
            this.log.info((CharSequence)("excluding artifact from test jar: " + artifact.getArtifactId()));
            sb.append(",").append(artifact.getArtifactId());
        }
        String customExcludes = sb.toString();
        MojoExecutor.executeMojo(MojoExecutor.plugin(MojoExecutor.groupId("org.apache.maven.plugins"), MojoExecutor.artifactId("maven-dependency-plugin"), MojoExecutor.version(this.defaultArtifactIdToVersionMap.get("maven-dependency-plugin"))), MojoExecutor.goal("copy-dependencies"), MojoExecutor.configuration(MojoExecutor.element(MojoExecutor.name("includeScope"), "test"), MojoExecutor.element(MojoExecutor.name("excludeScope"), "provided"), MojoExecutor.element(MojoExecutor.name("excludeArtifactIds"), "junit" + customExcludes), MojoExecutor.element(MojoExecutor.name("useSubDirectoryPerScope"), "true"), MojoExecutor.element(MojoExecutor.name("outputDirectory"), "${project.build.directory}/testlibs")), this.executionEnvironment());
        File targetDir = new File(this.ctx.getProject().getBuild().getDirectory());
        File testlibsDir = new File(targetDir, "testlibs");
        File compileLibs = new File(testlibsDir, "compile");
        File testLibs = new File(testlibsDir, "test");
        File testClassesDir = new File(this.ctx.getProject().getBuild().getTestOutputDirectory());
        File metainfDir = new File(testClassesDir, "META-INF");
        File libDir = new File(metainfDir, "lib");
        try {
            compileLibs.mkdirs();
            testLibs.mkdirs();
            libDir.mkdirs();
            org.apache.commons.io.FileUtils.copyDirectory((File)compileLibs, (File)libDir);
            org.apache.commons.io.FileUtils.copyDirectory((File)testLibs, (File)libDir);
        }
        catch (IOException e) {
            throw new MojoExecutionException("unable to copy test libs", (Exception)e);
        }
    }

    public void copyTestBundledDependenciesExcludingTestScope(List<ProductArtifact> testBundleExcludes) throws MojoExecutionException {
        StringBuilder sb = new StringBuilder();
        for (ProductArtifact artifact : testBundleExcludes) {
            this.log.info((CharSequence)("excluding artifact from test jar: " + artifact.getArtifactId()));
            sb.append(",").append(artifact.getArtifactId());
        }
        String customExcludes = sb.toString();
        MojoExecutor.executeMojo(MojoExecutor.plugin(MojoExecutor.groupId("org.apache.maven.plugins"), MojoExecutor.artifactId("maven-dependency-plugin"), MojoExecutor.version(this.defaultArtifactIdToVersionMap.get("maven-dependency-plugin"))), MojoExecutor.goal("copy-dependencies"), MojoExecutor.configuration(MojoExecutor.element(MojoExecutor.name("includeScope"), "runtime"), MojoExecutor.element(MojoExecutor.name("excludeScope"), "provided"), MojoExecutor.element(MojoExecutor.name("excludeScope"), "test"), MojoExecutor.element(MojoExecutor.name("includeTypes"), "jar"), MojoExecutor.element(MojoExecutor.name("excludeArtifactIds"), "junit" + customExcludes), MojoExecutor.element(MojoExecutor.name("outputDirectory"), "${project.build.testOutputDirectory}/META-INF/lib")), this.executionEnvironment());
    }

    public void extractBundledDependencies() throws MojoExecutionException {
        MojoExecutor.executeMojo(MojoExecutor.plugin(MojoExecutor.groupId("org.apache.maven.plugins"), MojoExecutor.artifactId("maven-dependency-plugin"), MojoExecutor.version(this.defaultArtifactIdToVersionMap.get("maven-dependency-plugin"))), MojoExecutor.goal("unpack-dependencies"), MojoExecutor.configuration(MojoExecutor.element(MojoExecutor.name("includeScope"), "runtime"), MojoExecutor.element(MojoExecutor.name("excludeScope"), "provided"), MojoExecutor.element(MojoExecutor.name("excludeScope"), "test"), MojoExecutor.element(MojoExecutor.name("includeTypes"), "jar"), MojoExecutor.element(MojoExecutor.name("excludes"), "atlassian-plugin.xml, META-INF/MANIFEST.MF, META-INF/*.DSA, META-INF/*.SF"), MojoExecutor.element(MojoExecutor.name("outputDirectory"), "${project.build.outputDirectory}")), this.executionEnvironment());
    }

    public void extractTestBundledDependenciesExcludingTestScope(List<ProductArtifact> testBundleExcludes) throws MojoExecutionException {
        StringBuilder sb = new StringBuilder();
        for (ProductArtifact artifact : testBundleExcludes) {
            sb.append(",").append(artifact.getArtifactId());
        }
        String customExcludes = sb.toString();
        MojoExecutor.executeMojo(MojoExecutor.plugin(MojoExecutor.groupId("org.apache.maven.plugins"), MojoExecutor.artifactId("maven-dependency-plugin"), MojoExecutor.version(this.defaultArtifactIdToVersionMap.get("maven-dependency-plugin"))), MojoExecutor.goal("unpack-dependencies"), MojoExecutor.configuration(MojoExecutor.element(MojoExecutor.name("includeScope"), "runtime"), MojoExecutor.element(MojoExecutor.name("excludeScope"), "provided"), MojoExecutor.element(MojoExecutor.name("excludeScope"), "test"), MojoExecutor.element(MojoExecutor.name("includeTypes"), "jar"), MojoExecutor.element(MojoExecutor.name("excludeArtifactIds"), "junit" + customExcludes), MojoExecutor.element(MojoExecutor.name("excludes"), "META-INF/MANIFEST.MF, META-INF/*.DSA, META-INF/*.SF"), MojoExecutor.element(MojoExecutor.name("outputDirectory"), "${project.build.testOutputDirectory}")), this.executionEnvironment());
    }

    public void extractTestBundledDependencies(List<ProductArtifact> testBundleExcludes) throws MojoExecutionException {
        StringBuilder sb = new StringBuilder();
        for (ProductArtifact artifact : testBundleExcludes) {
            sb.append(",").append(artifact.getArtifactId());
        }
        String customExcludes = sb.toString();
        MojoExecutor.executeMojo(MojoExecutor.plugin(MojoExecutor.groupId("org.apache.maven.plugins"), MojoExecutor.artifactId("maven-dependency-plugin"), MojoExecutor.version(this.defaultArtifactIdToVersionMap.get("maven-dependency-plugin"))), MojoExecutor.goal("unpack-dependencies"), MojoExecutor.configuration(MojoExecutor.element(MojoExecutor.name("includeScope"), "test"), MojoExecutor.element(MojoExecutor.name("excludeScope"), "provided"), MojoExecutor.element(MojoExecutor.name("excludeArtifactIds"), "junit" + customExcludes), MojoExecutor.element(MojoExecutor.name("includeTypes"), "jar"), MojoExecutor.element(MojoExecutor.name("useSubDirectoryPerScope"), "true"), MojoExecutor.element(MojoExecutor.name("outputDirectory"), "${project.build.directory}/testlibs")), this.executionEnvironment());
        File targetDir = new File(this.ctx.getProject().getBuild().getDirectory());
        File testlibsDir = new File(targetDir, "testlibs");
        File compileLibs = new File(testlibsDir, "compile");
        File testLibs = new File(testlibsDir, "test");
        File testClassesDir = new File(this.ctx.getProject().getBuild().getTestOutputDirectory());
        try {
            compileLibs.mkdirs();
            testLibs.mkdirs();
            org.apache.commons.io.FileUtils.copyDirectory((File)compileLibs, (File)testClassesDir, (FileFilter)FileFilterUtils.notFileFilter((IOFileFilter)FileFilterUtils.nameFileFilter((String)"META-INF")));
            org.apache.commons.io.FileUtils.copyDirectory((File)testLibs, (File)testClassesDir, (FileFilter)FileFilterUtils.notFileFilter((IOFileFilter)FileFilterUtils.nameFileFilter((String)"META-INF")));
        }
        catch (IOException e) {
            throw new MojoExecutionException("unable to copy test libs", (Exception)e);
        }
    }

    public void compressResources(boolean compressJs, boolean compressCss, boolean useClosureForJs, Charset cs, Map<String, String> closureOptions) throws MojoExecutionException {
        MinifierParameters closureParameters = new MinifierParameters(compressJs, compressCss, useClosureForJs, cs, this.log, closureOptions);
        ResourcesMinifier.minify(this.ctx.getProject().getBuild().getResources(), this.ctx.getProject().getBuild().getOutputDirectory(), closureParameters);
    }

    public void filterPluginDescriptor() throws MojoExecutionException {
        MojoExecutor.executeMojo(MojoExecutor.plugin(MojoExecutor.groupId("org.apache.maven.plugins"), MojoExecutor.artifactId("maven-resources-plugin"), MojoExecutor.version(this.defaultArtifactIdToVersionMap.get("maven-resources-plugin"))), MojoExecutor.goal("copy-resources"), MojoExecutor.configuration(MojoExecutor.element(MojoExecutor.name("encoding"), "UTF-8"), MojoExecutor.element(MojoExecutor.name("resources"), MojoExecutor.element(MojoExecutor.name("resource"), MojoExecutor.element(MojoExecutor.name("directory"), "src/main/resources"), MojoExecutor.element(MojoExecutor.name("filtering"), "true"), MojoExecutor.element(MojoExecutor.name("includes"), MojoExecutor.element(MojoExecutor.name("include"), "atlassian-plugin.xml")))), MojoExecutor.element(MojoExecutor.name("outputDirectory"), "${project.build.outputDirectory}")), this.executionEnvironment());
        XmlCompressor compressor = new XmlCompressor();
        File pluginXmlFile = new File(this.ctx.getProject().getBuild().getOutputDirectory(), "atlassian-plugin.xml");
        if (pluginXmlFile.exists()) {
            try {
                String source = org.apache.commons.io.FileUtils.readFileToString((File)pluginXmlFile);
                String min = compressor.compress(source);
                org.apache.commons.io.FileUtils.writeStringToFile((File)pluginXmlFile, (String)min);
            }
            catch (IOException e) {
                throw new MojoExecutionException("IOException while minifying plugin XML file", (Exception)e);
            }
        }
    }

    public void filterTestPluginDescriptor() throws MojoExecutionException {
        MojoExecutor.executeMojo(MojoExecutor.plugin(MojoExecutor.groupId("org.apache.maven.plugins"), MojoExecutor.artifactId("maven-resources-plugin"), MojoExecutor.version(this.defaultArtifactIdToVersionMap.get("maven-resources-plugin"))), MojoExecutor.goal("copy-resources"), MojoExecutor.configuration(MojoExecutor.element(MojoExecutor.name("encoding"), "UTF-8"), MojoExecutor.element(MojoExecutor.name("resources"), MojoExecutor.element(MojoExecutor.name("resource"), MojoExecutor.element(MojoExecutor.name("directory"), "src/test/resources"), MojoExecutor.element(MojoExecutor.name("filtering"), "true"), MojoExecutor.element(MojoExecutor.name("includes"), MojoExecutor.element(MojoExecutor.name("include"), "atlassian-plugin.xml")))), MojoExecutor.element(MojoExecutor.name("outputDirectory"), "${project.build.testOutputDirectory}")), this.executionEnvironment());
    }

    public void runUnitTests(Map<String, Object> systemProperties) throws MojoExecutionException {
        this.runUnitTests(systemProperties, null, null);
    }

    public void runUnitTests(Map<String, Object> systemProperties, String excludedGroups, String category) throws MojoExecutionException {
        MojoExecutor.Element systemProps = this.convertPropsToElements(systemProperties);
        Xpp3Dom config = MojoExecutor.configuration(systemProps, MojoExecutor.element(MojoExecutor.name("excludes"), MojoExecutor.element(MojoExecutor.name("exclude"), "it/**"), MojoExecutor.element(MojoExecutor.name("exclude"), "**/*$*")), MojoExecutor.element(MojoExecutor.name("excludedGroups"), excludedGroups));
        if (this.isRelevantCategory(category)) {
            this.appendJunitCategoryToConfiguration(category, config);
        }
        MojoExecutor.executeMojo(MojoExecutor.plugin(MojoExecutor.groupId("org.apache.maven.plugins"), MojoExecutor.artifactId("maven-surefire-plugin"), MojoExecutor.version(this.defaultArtifactIdToVersionMap.get("maven-surefire-plugin"))), MojoExecutor.goal("test"), config, this.executionEnvironment());
    }

    public File copyWebappWar(String productId, File targetDirectory, ProductArtifact artifact) throws MojoExecutionException {
        File webappWarFile = new File(targetDirectory, productId + "-original.war");
        MojoExecutor.executeMojo(MojoExecutor.plugin(MojoExecutor.groupId("org.apache.maven.plugins"), MojoExecutor.artifactId("maven-dependency-plugin"), MojoExecutor.version(this.defaultArtifactIdToVersionMap.get("maven-dependency-plugin"))), MojoExecutor.goal("copy"), MojoExecutor.configuration(MojoExecutor.element(MojoExecutor.name("artifactItems"), MojoExecutor.element(MojoExecutor.name("artifactItem"), MojoExecutor.element(MojoExecutor.name("groupId"), artifact.getGroupId()), MojoExecutor.element(MojoExecutor.name("artifactId"), artifact.getArtifactId()), MojoExecutor.element(MojoExecutor.name("type"), "war"), MojoExecutor.element(MojoExecutor.name("version"), artifact.getVersion()), MojoExecutor.element(MojoExecutor.name("destFileName"), webappWarFile.getName()))), MojoExecutor.element(MojoExecutor.name("outputDirectory"), targetDirectory.getPath())), this.executionEnvironment());
        return webappWarFile;
    }

    public void unpackWebappWar(File targetDirectory, ProductArtifact artifact) throws MojoExecutionException {
        MojoExecutor.executeMojo(MojoExecutor.plugin(MojoExecutor.groupId("org.apache.maven.plugins"), MojoExecutor.artifactId("maven-dependency-plugin"), MojoExecutor.version(this.defaultArtifactIdToVersionMap.get("maven-dependency-plugin"))), MojoExecutor.goal("unpack"), MojoExecutor.configuration(MojoExecutor.element(MojoExecutor.name("artifactItems"), MojoExecutor.element(MojoExecutor.name("artifactItem"), MojoExecutor.element(MojoExecutor.name("groupId"), artifact.getGroupId()), MojoExecutor.element(MojoExecutor.name("artifactId"), artifact.getArtifactId()), MojoExecutor.element(MojoExecutor.name("type"), "war"), MojoExecutor.element(MojoExecutor.name("version"), artifact.getVersion()))), MojoExecutor.element(MojoExecutor.name("outputDirectory"), targetDirectory.getPath()), MojoExecutor.element(MojoExecutor.name("overWriteReleases"), "true"), MojoExecutor.element(MojoExecutor.name("overWriteSnapshots"), "true")), this.executionEnvironment());
    }

    public File copyArtifact(String targetFileName, File targetDirectory, ProductArtifact artifact, String type) throws MojoExecutionException {
        File targetFile = new File(targetDirectory, targetFileName);
        MojoExecutor.executeMojo(MojoExecutor.plugin(MojoExecutor.groupId("org.apache.maven.plugins"), MojoExecutor.artifactId("maven-dependency-plugin"), MojoExecutor.version(this.defaultArtifactIdToVersionMap.get("maven-dependency-plugin"))), MojoExecutor.goal("copy"), MojoExecutor.configuration(MojoExecutor.element(MojoExecutor.name("artifactItems"), MojoExecutor.element(MojoExecutor.name("artifactItem"), MojoExecutor.element(MojoExecutor.name("groupId"), artifact.getGroupId()), MojoExecutor.element(MojoExecutor.name("artifactId"), artifact.getArtifactId()), MojoExecutor.element(MojoExecutor.name("type"), type), MojoExecutor.element(MojoExecutor.name("version"), artifact.getVersion()), MojoExecutor.element(MojoExecutor.name("destFileName"), targetFile.getName()))), MojoExecutor.element(MojoExecutor.name("outputDirectory"), targetDirectory.getPath())), this.executionEnvironment());
        return targetFile;
    }

    public void copyPlugins(File outputDirectory, List<ProductArtifact> artifacts) throws MojoExecutionException {
        for (ProductArtifact artifact : artifacts) {
            MavenProject artifactReactorProject = this.getReactorProjectForArtifact(artifact);
            if (artifactReactorProject != null) {
                this.log.debug((CharSequence)(artifact + " will be copied from reactor project " + artifactReactorProject));
                File artifactFile = artifactReactorProject.getArtifact().getFile();
                if (artifactFile == null) {
                    this.log.warn((CharSequence)("The plugin " + artifact + " is in the reactor but not the file hasn't been attached.  Skipping."));
                    continue;
                }
                this.log.debug((CharSequence)("Copying " + artifactFile + " to " + outputDirectory));
                try {
                    org.apache.commons.io.FileUtils.copyFile((File)artifactFile, (File)new File(outputDirectory, artifactFile.getName()));
                    continue;
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Could not copy " + artifact + " to " + outputDirectory, (Exception)e);
                }
            }
            MojoExecutor.executeMojo(MojoExecutor.plugin(MojoExecutor.groupId("org.apache.maven.plugins"), MojoExecutor.artifactId("maven-dependency-plugin"), MojoExecutor.version(this.defaultArtifactIdToVersionMap.get("maven-dependency-plugin"))), MojoExecutor.goal("copy"), MojoExecutor.configuration(MojoExecutor.element(MojoExecutor.name("artifactItems"), MojoExecutor.element(MojoExecutor.name("artifactItem"), MojoExecutor.element(MojoExecutor.name("groupId"), artifact.getGroupId()), MojoExecutor.element(MojoExecutor.name("artifactId"), artifact.getArtifactId()), MojoExecutor.element(MojoExecutor.name("version"), artifact.getVersion()))), MojoExecutor.element(MojoExecutor.name("outputDirectory"), outputDirectory.getPath())), this.executionEnvironment());
        }
    }

    private MavenProject getReactorProjectForArtifact(ProductArtifact artifact) {
        for (MavenProject project : this.ctx.getReactor()) {
            if (!project.getGroupId().equals(artifact.getGroupId()) || !project.getArtifactId().equals(artifact.getArtifactId()) || !project.getVersion().equals(artifact.getVersion())) continue;
            return project;
        }
        return null;
    }

    private void unpackContainer(Container container) throws MojoExecutionException {
        MojoExecutor.executeMojo(MojoExecutor.plugin(MojoExecutor.groupId("org.apache.maven.plugins"), MojoExecutor.artifactId("maven-dependency-plugin"), MojoExecutor.version(this.defaultArtifactIdToVersionMap.get("maven-dependency-plugin"))), MojoExecutor.goal("unpack"), MojoExecutor.configuration(MojoExecutor.element(MojoExecutor.name("artifactItems"), MojoExecutor.element(MojoExecutor.name("artifactItem"), MojoExecutor.element(MojoExecutor.name("groupId"), container.getGroupId()), MojoExecutor.element(MojoExecutor.name("artifactId"), container.getArtifactId()), MojoExecutor.element(MojoExecutor.name("version"), container.getVersion()), MojoExecutor.element(MojoExecutor.name("classifier"), container.getClassifier()), MojoExecutor.element(MojoExecutor.name("type"), "zip"))), MojoExecutor.element(MojoExecutor.name("outputDirectory"), container.getRootDirectory(this.getBuildDirectory()))), this.executionEnvironment());
    }

    private String getBuildDirectory() {
        return this.ctx.getProject().getBuild().getDirectory();
    }

    private static Xpp3Dom configurationWithoutNullElements(MojoExecutor.Element ... elements) {
        return MojoExecutor.configuration(MavenGoals.removeNullElements(elements));
    }

    private static MojoExecutor.Element[] removeNullElements(MojoExecutor.Element ... elements) {
        return (MojoExecutor.Element[])Arrays.stream(elements).filter(Objects::nonNull).toArray(MojoExecutor.Element[]::new);
    }

    private Plugin bndPlugin() {
        this.log.info((CharSequence)("using maven-bundle-plugin v" + this.pluginArtifactIdToVersionMap.get("maven-bundle-plugin")));
        return MojoExecutor.plugin(MojoExecutor.groupId("org.apache.felix"), MojoExecutor.artifactId("maven-bundle-plugin"), MojoExecutor.version(this.defaultArtifactIdToVersionMap.get("maven-bundle-plugin")));
    }

    @VisibleForTesting
    protected void executeMojoExcludeProductCargoConfig(Plugin internalCargo, String goal, Xpp3Dom configuration, MojoExecutor.ExecutionEnvironment env) throws MojoExecutionException {
        Plugin globalCargo = env.getMavenProject().getPlugin("org.codehaus.cargo:cargo-maven2-plugin");
        env.getMavenProject().getBuild().removePlugin(globalCargo);
        env.executeMojo(internalCargo, goal, configuration);
        if (null != globalCargo) {
            env.getMavenProject().getBuild().addPlugin(globalCargo);
        }
    }

    public int startWebapp(String productInstanceId, File war, Map<String, String> systemProperties, List<ProductArtifact> extraContainerDependencies, List<ProductArtifact> extraProductDeployables, Product webappContext) throws MojoExecutionException {
        int actualHttpPort;
        Container container = this.findContainer(webappContext.getContainerId());
        File containerDir = new File(container.getRootDirectory(this.getBuildDirectory()));
        if (!container.isEmbedded()) {
            if (containerDir.exists()) {
                this.log.info((CharSequence)("Reusing unpacked container '" + container.getId() + "' from " + containerDir.getPath()));
            } else {
                this.log.info((CharSequence)("Unpacking container '" + container.getId() + "' from container artifact: " + container.toString()));
                this.unpackContainer(container);
            }
        }
        int rmiPort = ProductHandlerUtil.pickFreePort(webappContext.getRmiPort());
        int actualAjpPort = ProductHandlerUtil.pickFreePort(webappContext.getAjpPort());
        String protocol = "http";
        if (webappContext.getUseHttps().booleanValue()) {
            actualHttpPort = webappContext.getHttpsPort();
            protocol = "https";
        } else {
            actualHttpPort = ProductHandlerUtil.pickFreePort(webappContext.getHttpPort());
        }
        ArrayList<MojoExecutor.Element> sysProps = new ArrayList<MojoExecutor.Element>();
        for (Map.Entry<String, String> entry : systemProperties.entrySet()) {
            sysProps.add(MojoExecutor.element(MojoExecutor.name(entry.getKey()), entry.getValue()));
        }
        this.log.info((CharSequence)("Starting " + productInstanceId + " on the " + container.getId() + " container on ports " + actualHttpPort + " (" + protocol + "), " + rmiPort + " (rmi) and " + actualAjpPort + " (ajp)"));
        String baseUrl = MavenGoals.getBaseUrl(webappContext, actualHttpPort);
        sysProps.add(MojoExecutor.element(MojoExecutor.name("baseurl"), baseUrl));
        List<MojoExecutor.Element> deps = this.extractDependencies(extraContainerDependencies, webappContext);
        ArrayList<MojoExecutor.Element> deployables = new ArrayList<MojoExecutor.Element>();
        deployables.add(MojoExecutor.element(MojoExecutor.name("deployable"), MojoExecutor.element(MojoExecutor.name("groupId"), "foo"), MojoExecutor.element(MojoExecutor.name("artifactId"), "bar"), MojoExecutor.element(MojoExecutor.name("type"), "war"), MojoExecutor.element(MojoExecutor.name("location"), war.getPath()), MojoExecutor.element(MojoExecutor.name("properties"), MojoExecutor.element(MojoExecutor.name("context"), webappContext.getContextPath()))));
        for (ProductArtifact extra : extraProductDeployables) {
            deployables.add(MojoExecutor.element(MojoExecutor.name("deployable"), MojoExecutor.element(MojoExecutor.name("groupId"), extra.getGroupId()), MojoExecutor.element(MojoExecutor.name("artifactId"), extra.getArtifactId()), MojoExecutor.element(MojoExecutor.name("type"), extra.getType()), MojoExecutor.element(MojoExecutor.name("location"), extra.getPath())));
        }
        List<MojoExecutor.Element> props = this.getConfigurationProperties(systemProperties, webappContext, rmiPort, actualHttpPort, actualAjpPort, protocol);
        int startupTimeout = webappContext.getStartupTimeout();
        if (Boolean.FALSE.equals(webappContext.getSynchronousStartup())) {
            startupTimeout = 0;
        }
        Plugin cargo = this.cargo(webappContext);
        this.executeMojoExcludeProductCargoConfig(cargo, MojoExecutor.goal("start"), MavenGoals.configurationWithoutNullElements(MojoExecutor.element(MojoExecutor.name("deployables"), deployables.toArray(new MojoExecutor.Element[deployables.size()])), this.waitElement(cargo), MojoExecutor.element(MojoExecutor.name("container"), MojoExecutor.element(MojoExecutor.name("containerId"), container.getId()), MojoExecutor.element(MojoExecutor.name("type"), container.getType()), MojoExecutor.element(MojoExecutor.name("home"), container.getInstallDirectory(this.getBuildDirectory())), MojoExecutor.element(MojoExecutor.name("output"), webappContext.getOutput()), MojoExecutor.element(MojoExecutor.name("systemProperties"), sysProps.toArray(new MojoExecutor.Element[sysProps.size()])), MojoExecutor.element(MojoExecutor.name("dependencies"), deps.toArray(new MojoExecutor.Element[deps.size()])), MojoExecutor.element(MojoExecutor.name("timeout"), String.valueOf(startupTimeout))), MojoExecutor.element(MojoExecutor.name("configuration"), MavenGoals.removeNullElements(MojoExecutor.element(MojoExecutor.name("home"), container.getConfigDirectory(this.getBuildDirectory(), productInstanceId)), MojoExecutor.element(MojoExecutor.name("type"), "standalone"), MojoExecutor.element(MojoExecutor.name("properties"), props.toArray(new MojoExecutor.Element[props.size()])), this.xmlReplacementsElement(webappContext.getCargoXmlOverrides()))), MojoExecutor.element(MojoExecutor.name("deployer"), new MojoExecutor.Element[0])), this.executionEnvironment());
        return actualHttpPort;
    }

    private List<MojoExecutor.Element> extractDependencies(List<ProductArtifact> extraContainerDependencies, Product webappContext) throws MojoExecutionException {
        ArrayList<MojoExecutor.Element> deps = new ArrayList<MojoExecutor.Element>();
        for (ProductArtifact dep : extraContainerDependencies) {
            deps.add(MojoExecutor.element(MojoExecutor.name("dependency"), MojoExecutor.element(MojoExecutor.name("location"), webappContext.getArtifactRetriever().resolve(dep))));
        }
        for (DataSource dataSource : webappContext.getDataSources()) {
            for (ProductArtifact productArtifact : dataSource.getLibArtifacts()) {
                deps.add(MojoExecutor.element(MojoExecutor.name("dependency"), MojoExecutor.element(MojoExecutor.name("location"), webappContext.getArtifactRetriever().resolve(productArtifact))));
            }
        }
        return deps;
    }

    private MojoExecutor.Element xmlReplacementsElement(Collection<XmlOverride> cargoXmlOverrides) {
        if (cargoXmlOverrides == null) {
            return null;
        }
        MojoExecutor.Element[] xmlReplacementsElements = (MojoExecutor.Element[])cargoXmlOverrides.stream().map(xmlOverride -> MojoExecutor.element(MojoExecutor.name("xmlReplacement"), MojoExecutor.element(MojoExecutor.name("file"), xmlOverride.getFile()), MojoExecutor.element(MojoExecutor.name("xpathExpression"), xmlOverride.getxPathExpression()), MojoExecutor.element(MojoExecutor.name("attributeName"), xmlOverride.getAttributeName()), MojoExecutor.element(MojoExecutor.name("value"), xmlOverride.getValue()))).toArray(MojoExecutor.Element[]::new);
        return MojoExecutor.element(MojoExecutor.name("xmlReplacements"), xmlReplacementsElements);
    }

    @VisibleForTesting
    List<MojoExecutor.Element> getConfigurationProperties(Map<String, String> systemProperties, Product webappContext, int rmiPort, int actualHttpPort, int actualAjpPort, String protocol) {
        ArrayList<MojoExecutor.Element> props = new ArrayList<MojoExecutor.Element>();
        for (Map.Entry<String, String> entry : systemProperties.entrySet()) {
            props.add(MojoExecutor.element(MojoExecutor.name(entry.getKey()), entry.getValue()));
        }
        props.add(MojoExecutor.element(MojoExecutor.name("cargo.servlet.port"), String.valueOf(actualHttpPort)));
        if (webappContext.getUseHttps().booleanValue()) {
            this.log.debug((CharSequence)"starting tomcat using Https via cargo with the following parameters:");
            this.log.debug((CharSequence)("cargo.servlet.port = " + actualHttpPort));
            this.log.debug((CharSequence)("cargo.protocol = " + protocol));
            props.add(MojoExecutor.element(MojoExecutor.name("cargo.protocol"), protocol));
            this.log.debug((CharSequence)("cargo.tomcat.connector.clientAuth = " + webappContext.getHttpsClientAuth().toString()));
            props.add(MojoExecutor.element(MojoExecutor.name("cargo.tomcat.connector.clientAuth"), webappContext.getHttpsClientAuth().toString()));
            this.log.debug((CharSequence)("cargo.tomcat.connector.sslProtocol = " + webappContext.getHttpsSSLProtocol()));
            props.add(MojoExecutor.element(MojoExecutor.name("cargo.tomcat.connector.sslProtocol"), webappContext.getHttpsSSLProtocol()));
            this.log.debug((CharSequence)("cargo.tomcat.connector.keystoreFile = " + webappContext.getHttpsKeystoreFile()));
            props.add(MojoExecutor.element(MojoExecutor.name("cargo.tomcat.connector.keystoreFile"), webappContext.getHttpsKeystoreFile()));
            this.log.debug((CharSequence)("cargo.tomcat.connector.keystorePass = " + webappContext.getHttpsKeystorePass()));
            props.add(MojoExecutor.element(MojoExecutor.name("cargo.tomcat.connector.keystorePass"), webappContext.getHttpsKeystorePass()));
            this.log.debug((CharSequence)("cargo.tomcat.connector.keyAlias = " + webappContext.getHttpsKeyAlias()));
            props.add(MojoExecutor.element(MojoExecutor.name("cargo.tomcat.connector.keyAlias"), webappContext.getHttpsKeyAlias()));
            this.log.debug((CharSequence)("cargo.tomcat.httpSecure = " + webappContext.getHttpsHttpSecure().toString()));
            props.add(MojoExecutor.element(MojoExecutor.name("cargo.tomcat.httpSecure"), webappContext.getHttpsHttpSecure().toString()));
        }
        props.add(MojoExecutor.element(MojoExecutor.name(AJP_PORT_PROPERTY), String.valueOf(actualAjpPort)));
        props.add(MojoExecutor.element(MojoExecutor.name("cargo.rmi.port"), String.valueOf(rmiPort)));
        props.add(MojoExecutor.element(MojoExecutor.name("cargo.jvmargs"), webappContext.getJvmArgs() + webappContext.getDebugArgs()));
        return props;
    }

    public void stopWebapp(String productId, String containerId, Product webappContext) throws MojoExecutionException {
        Container container = this.findContainer(containerId);
        String actualShutdownTimeout = webappContext.getSynchronousStartup() != false ? "0" : String.valueOf(webappContext.getShutdownTimeout());
        this.executeMojoExcludeProductCargoConfig(this.cargo(webappContext), MojoExecutor.goal("stop"), MojoExecutor.configuration(MojoExecutor.element(MojoExecutor.name("container"), MojoExecutor.element(MojoExecutor.name("containerId"), container.getId()), MojoExecutor.element(MojoExecutor.name("type"), container.getType()), MojoExecutor.element(MojoExecutor.name("timeout"), actualShutdownTimeout), MojoExecutor.element(MojoExecutor.name("home"), container.getInstallDirectory(this.getBuildDirectory()))), MojoExecutor.element(MojoExecutor.name("configuration"), MojoExecutor.element(MojoExecutor.name("home"), container.getConfigDirectory(this.getBuildDirectory(), productId)), MojoExecutor.element(MojoExecutor.name("properties"), this.createShutdownPortsPropertiesConfiguration(webappContext)))), this.executionEnvironment());
    }

    private MojoExecutor.Element[] createShutdownPortsPropertiesConfiguration(Product webappContext) {
        ArrayList<MojoExecutor.Element> properties = new ArrayList<MojoExecutor.Element>();
        String portUsedToDetermineIfShutdownSucceeded = String.valueOf(webappContext.getHttpPort());
        properties.add(MojoExecutor.element(MojoExecutor.name("cargo.servlet.port"), portUsedToDetermineIfShutdownSucceeded));
        properties.add(MojoExecutor.element(MojoExecutor.name("cargo.rmi.port"), portUsedToDetermineIfShutdownSucceeded));
        properties.add(MojoExecutor.element(MojoExecutor.name(AJP_PORT_PROPERTY), portUsedToDetermineIfShutdownSucceeded));
        return properties.toArray(new MojoExecutor.Element[properties.size()]);
    }

    protected Plugin cargo(Product context) {
        this.log.info((CharSequence)("using codehaus cargo v" + this.pluginArtifactIdToVersionMap.get("org.codehaus.cargo:cargo-maven2-plugin")));
        return MojoExecutor.plugin(MojoExecutor.groupId("org.codehaus.cargo"), MojoExecutor.artifactId("cargo-maven2-plugin"), MojoExecutor.version(this.pluginArtifactIdToVersionMap.get("org.codehaus.cargo:cargo-maven2-plugin")));
    }

    private MojoExecutor.Element waitElement(Plugin cargo) {
        if (cargo.getGroupId().equals("org.twdata.maven")) {
            return MojoExecutor.element(MojoExecutor.name("wait"), "false");
        }
        return null;
    }

    public static String getBaseUrl(Product product, int actualHttpPort) {
        return MavenGoals.getBaseUrl(product.getServer(), product.getHttpPort(), product.getContextPath());
    }

    private static String getBaseUrl(String server, int actualHttpPort, String contextPath) {
        String port = actualHttpPort != 80 ? ":" + actualHttpPort : "";
        String string = server = server.startsWith("http") ? server : "http://" + server;
        if (!contextPath.startsWith("/") && StringUtils.isNotBlank((String)contextPath)) {
            contextPath = "/" + contextPath;
        }
        return server + port + contextPath;
    }

    public void runIntegrationTests(String testGroupId, String containerId, List<String> includes, List<String> excludes, Map<String, Object> systemProperties, File targetDirectory, String category, boolean skipVerifyGoal) throws MojoExecutionException {
        ArrayList<MojoExecutor.Element> includeElements = new ArrayList<MojoExecutor.Element>(includes.size());
        for (String string : includes) {
            includeElements.add(MojoExecutor.element(MojoExecutor.name("include"), string));
        }
        ArrayList<MojoExecutor.Element> excludeElements = new ArrayList<MojoExecutor.Element>(excludes.size() + 2);
        excludeElements.add(MojoExecutor.element(MojoExecutor.name("exclude"), "**/*$*"));
        excludeElements.add(MojoExecutor.element(MojoExecutor.name("exclude"), "**/Abstract*"));
        for (String exclude : excludes) {
            excludeElements.add(MojoExecutor.element(MojoExecutor.name("exclude"), exclude));
        }
        String string = targetDirectory.getAbsolutePath() + "/" + testGroupId + "/" + containerId + "/surefire-reports";
        String reportsDirectory = "reportsDirectory";
        systemProperties.put("reportsDirectory", string);
        MojoExecutor.Element systemProps = this.convertPropsToElements(systemProperties);
        Xpp3Dom itconfig = MojoExecutor.configuration(MojoExecutor.element(MojoExecutor.name("includes"), includeElements.toArray(new MojoExecutor.Element[includeElements.size()])), MojoExecutor.element(MojoExecutor.name("excludes"), excludeElements.toArray(new MojoExecutor.Element[excludeElements.size()])), systemProps, MojoExecutor.element(MojoExecutor.name("reportsDirectory"), string));
        if (this.isRelevantCategory(category)) {
            this.appendJunitCategoryToConfiguration(category, itconfig);
        }
        Xpp3Dom verifyconfig = MojoExecutor.configuration(MojoExecutor.element(MojoExecutor.name("reportsDirectory"), string));
        this.log.info((CharSequence)"Failsafe integration-test configuration:");
        this.log.info((CharSequence)itconfig.toString());
        MojoExecutor.executeMojo(MojoExecutor.plugin(MojoExecutor.groupId("org.apache.maven.plugins"), MojoExecutor.artifactId("maven-failsafe-plugin"), MojoExecutor.version(this.defaultArtifactIdToVersionMap.get("maven-failsafe-plugin"))), MojoExecutor.goal("integration-test"), itconfig, this.executionEnvironment());
        if (!skipVerifyGoal) {
            MojoExecutor.executeMojo(MojoExecutor.plugin(MojoExecutor.groupId("org.apache.maven.plugins"), MojoExecutor.artifactId("maven-failsafe-plugin"), MojoExecutor.version(this.defaultArtifactIdToVersionMap.get("maven-failsafe-plugin"))), MojoExecutor.goal("verify"), verifyconfig, this.executionEnvironment());
        } else {
            this.log.info((CharSequence)"Skipping failsafe IT failure verification.");
        }
    }

    public void runPreIntegrationTest(DataSource dataSource) throws MojoExecutionException {
        String dumpFilePath = dataSource.getDumpFilePath();
        JiraDatabaseFactory factory = JiraDatabaseFactory.getJiraDatabaseFactory();
        JiraDatabase jiraDatabase = factory.getJiraDatabase(dataSource);
        Xpp3Dom sqlMavenPluginConfiguration = jiraDatabase.getPluginConfiguration();
        List<Dependency> libs = jiraDatabase.getDependencies();
        Plugin sqlMaven = MojoExecutor.plugin(MojoExecutor.groupId("org.codehaus.mojo"), MojoExecutor.artifactId("sql-maven-plugin"), MojoExecutor.version(this.defaultArtifactIdToVersionMap.get("sql-maven-plugin")));
        sqlMaven.getDependencies().addAll(libs);
        MojoExecutor.executeMojo(sqlMaven, MojoExecutor.goal("execute"), sqlMavenPluginConfiguration, this.executionEnvironment());
        if (StringUtils.isNotEmpty((String)dumpFilePath)) {
            this.log.info((CharSequence)("Do import for dump file: " + dumpFilePath));
            File dumpFile = new File(dumpFilePath);
            if (!dumpFile.exists() || !dumpFile.isFile()) {
                throw new MojoExecutionException("SQL dump file does not exist: " + dumpFilePath);
            }
            if (ImportMethod.SQL.equals((Object)ImportMethod.getValueOf(dataSource.getImportMethod()))) {
                MojoExecutor.executeMojo(sqlMaven, MojoExecutor.goal("execute"), jiraDatabase.getConfigImportFile(), this.executionEnvironment());
            } else {
                Xpp3Dom configDatabaseTool = jiraDatabase.getConfigDatabaseTool();
                Plugin execMaven = MojoExecutor.plugin(MojoExecutor.groupId("org.codehaus.mojo"), MojoExecutor.artifactId("exec-maven-plugin"), MojoExecutor.version(this.defaultArtifactIdToVersionMap.get("maven-exec-plugin")));
                MojoExecutor.executeMojo(execMaven, MojoExecutor.goal("exec"), configDatabaseTool, this.executionEnvironment());
            }
        }
    }

    private void appendJunitCategoryToConfiguration(String category, Xpp3Dom config) {
        MojoExecutor.Element groups = MojoExecutor.element(MojoExecutor.name("groups"), category);
        config.addChild(groups.toDom());
    }

    private boolean isRelevantCategory(String category) {
        return category != null && !"".equals(category);
    }

    private MojoExecutor.Element convertPropsToElements(Map<String, Object> systemProperties) {
        ArrayList<MojoExecutor.Element> properties = new ArrayList<MojoExecutor.Element>();
        for (Map.Entry<String, Object> entry : systemProperties.entrySet()) {
            this.log.info((CharSequence)("adding system property to configuration: " + entry.getKey() + "::" + entry.getValue()));
            properties.add(MojoExecutor.element(MojoExecutor.name(entry.getKey()), entry.getValue().toString()));
        }
        return MojoExecutor.element(MojoExecutor.name("systemPropertyVariables"), properties.toArray(new MojoExecutor.Element[properties.size()]));
    }

    private Container findContainer(String containerId) {
        Container container = this.idToContainerMap.get(containerId);
        if (container == null) {
            throw new IllegalArgumentException("Container " + containerId + " not supported");
        }
        return container;
    }

    public void installPlugin(PdkParams pdkParams) throws MojoExecutionException {
        String baseUrl = MavenGoals.getBaseUrl(pdkParams.getServer(), pdkParams.getPort(), pdkParams.getContextPath());
        MojoExecutor.executeMojo(MojoExecutor.plugin(MojoExecutor.groupId("com.atlassian.maven.plugins"), MojoExecutor.artifactId("atlassian-pdk"), MojoExecutor.version(this.pluginArtifactIdToVersionMap.get("atlassian-pdk"))), MojoExecutor.goal("install"), MojoExecutor.configuration(MojoExecutor.element(MojoExecutor.name("pluginFile"), pdkParams.getPluginFile()), MojoExecutor.element(MojoExecutor.name("username"), pdkParams.getUsername()), MojoExecutor.element(MojoExecutor.name("password"), pdkParams.getPassword()), MojoExecutor.element(MojoExecutor.name("serverUrl"), baseUrl), MojoExecutor.element(MojoExecutor.name("pluginKey"), pdkParams.getPluginKey())), this.executionEnvironment());
    }

    public void uninstallPlugin(String pluginKey, String server, int port, String contextPath) throws MojoExecutionException {
        String baseUrl = MavenGoals.getBaseUrl(server, port, contextPath);
        MojoExecutor.executeMojo(MojoExecutor.plugin(MojoExecutor.groupId("com.atlassian.maven.plugins"), MojoExecutor.artifactId("atlassian-pdk"), MojoExecutor.version(this.pluginArtifactIdToVersionMap.get("atlassian-pdk"))), MojoExecutor.goal("uninstall"), MojoExecutor.configuration(MojoExecutor.element(MojoExecutor.name("username"), "admin"), MojoExecutor.element(MojoExecutor.name("password"), "admin"), MojoExecutor.element(MojoExecutor.name("serverUrl"), baseUrl), MojoExecutor.element(MojoExecutor.name("pluginKey"), pluginKey)), this.executionEnvironment());
    }

    public void installIdeaPlugin() throws MojoExecutionException {
        MojoExecutor.executeMojo(MojoExecutor.plugin(MojoExecutor.groupId("org.twdata.maven"), MojoExecutor.artifactId("maven-cli-plugin"), MojoExecutor.version(this.pluginArtifactIdToVersionMap.get("maven-cli-plugin"))), MojoExecutor.goal("idea"), MojoExecutor.configuration(new MojoExecutor.Element[0]), this.executionEnvironment());
    }

    public File copyDist(File targetDirectory, ProductArtifact artifact) throws MojoExecutionException {
        return this.copyZip(targetDirectory, artifact, "test-dist.zip");
    }

    public File copyHome(File targetDirectory, ProductArtifact artifact) throws MojoExecutionException {
        return this.copyZip(targetDirectory, artifact, artifact.getArtifactId() + ".zip");
    }

    public File copyZip(File targetDirectory, ProductArtifact artifact, String localName) throws MojoExecutionException {
        File artifactZip = new File(targetDirectory, localName);
        MojoExecutor.executeMojo(MojoExecutor.plugin(MojoExecutor.groupId("org.apache.maven.plugins"), MojoExecutor.artifactId("maven-dependency-plugin"), MojoExecutor.version(this.defaultArtifactIdToVersionMap.get("maven-dependency-plugin"))), MojoExecutor.goal("copy"), MojoExecutor.configuration(MojoExecutor.element(MojoExecutor.name("artifactItems"), MojoExecutor.element(MojoExecutor.name("artifactItem"), MojoExecutor.element(MojoExecutor.name("groupId"), artifact.getGroupId()), MojoExecutor.element(MojoExecutor.name("artifactId"), artifact.getArtifactId()), MojoExecutor.element(MojoExecutor.name("type"), "zip"), MojoExecutor.element(MojoExecutor.name("version"), artifact.getVersion()), MojoExecutor.element(MojoExecutor.name("destFileName"), artifactZip.getName()))), MojoExecutor.element(MojoExecutor.name("outputDirectory"), artifactZip.getParent())), this.executionEnvironment());
        return artifactZip;
    }

    public void generateBundleManifest(Map<String, String> instructions, Map<String, String> basicAttributes) throws MojoExecutionException {
        ArrayList<MojoExecutor.Element> instlist = new ArrayList<MojoExecutor.Element>();
        for (Map.Entry<String, String> entry : instructions.entrySet()) {
            instlist.add(MojoExecutor.element(entry.getKey(), entry.getValue()));
        }
        if (!instructions.containsKey("Import-Package")) {
            instlist.add(MojoExecutor.element("Import-Package", "*;resolution:=optional"));
        }
        for (Map.Entry<String, String> entry : basicAttributes.entrySet()) {
            instlist.add(MojoExecutor.element(entry.getKey(), entry.getValue()));
        }
        MojoExecutor.executeMojo(this.bndPlugin(), MojoExecutor.goal("manifest"), MojoExecutor.configuration(MojoExecutor.element(MojoExecutor.name("supportedProjectTypes"), MojoExecutor.element(MojoExecutor.name("supportedProjectType"), "jar"), MojoExecutor.element(MojoExecutor.name("supportedProjectType"), "bundle"), MojoExecutor.element(MojoExecutor.name("supportedProjectType"), "war"), MojoExecutor.element(MojoExecutor.name("supportedProjectType"), "atlassian-plugin")), MojoExecutor.element(MojoExecutor.name("instructions"), instlist.toArray(new MojoExecutor.Element[instlist.size()]))), this.executionEnvironment());
    }

    public void generateTestBundleManifest(Map<String, String> instructions, Map<String, String> basicAttributes) throws MojoExecutionException {
        ArrayList<MojoExecutor.Element> instlist = new ArrayList<MojoExecutor.Element>();
        for (Map.Entry<String, String> entry : instructions.entrySet()) {
            instlist.add(MojoExecutor.element(entry.getKey(), entry.getValue()));
        }
        if (!instructions.containsKey("Import-Package")) {
            instlist.add(MojoExecutor.element("Import-Package", "*;resolution:=optional"));
        }
        for (Map.Entry<String, String> entry : basicAttributes.entrySet()) {
            instlist.add(MojoExecutor.element(entry.getKey(), entry.getValue()));
        }
        MojoExecutor.executeMojo(this.bndPlugin(), MojoExecutor.goal("manifest"), MojoExecutor.configuration(MojoExecutor.element(MojoExecutor.name("manifestLocation"), "${project.build.testOutputDirectory}/META-INF"), MojoExecutor.element(MojoExecutor.name("supportedProjectTypes"), MojoExecutor.element(MojoExecutor.name("supportedProjectType"), "jar"), MojoExecutor.element(MojoExecutor.name("supportedProjectType"), "bundle"), MojoExecutor.element(MojoExecutor.name("supportedProjectType"), "war"), MojoExecutor.element(MojoExecutor.name("supportedProjectType"), "atlassian-plugin")), MojoExecutor.element(MojoExecutor.name("instructions"), instlist.toArray(new MojoExecutor.Element[instlist.size()]))), this.executionEnvironment());
    }

    public void generateMinimalManifest(Map<String, String> basicAttributes) throws MojoExecutionException {
        File metaInf = FileUtils.file(this.ctx.getProject().getBuild().getOutputDirectory(), "META-INF");
        if (!metaInf.exists()) {
            metaInf.mkdirs();
        }
        File mf = FileUtils.file(this.ctx.getProject().getBuild().getOutputDirectory(), "META-INF", "MANIFEST.MF");
        Manifest m = new Manifest();
        m.getMainAttributes().putValue("Manifest-Version", "1.0");
        for (Map.Entry<String, String> entry : basicAttributes.entrySet()) {
            m.getMainAttributes().putValue(entry.getKey(), entry.getValue());
        }
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(mf);
            m.write(fos);
        }
        catch (IOException e) {
            try {
                throw new MojoExecutionException("Unable to create manifest", (Exception)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fos);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)fos);
    }

    public void generateTestMinimalManifest(Map<String, String> basicAttributes) throws MojoExecutionException {
        File metaInf = FileUtils.file(this.ctx.getProject().getBuild().getTestOutputDirectory(), "META-INF");
        if (!metaInf.exists()) {
            metaInf.mkdirs();
        }
        File mf = FileUtils.file(this.ctx.getProject().getBuild().getTestOutputDirectory(), "META-INF", "MANIFEST.MF");
        Manifest m = new Manifest();
        m.getMainAttributes().putValue("Manifest-Version", "1.0");
        for (Map.Entry<String, String> entry : basicAttributes.entrySet()) {
            m.getMainAttributes().putValue(entry.getKey(), entry.getValue());
        }
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(mf);
            m.write(fos);
        }
        catch (IOException e) {
            try {
                throw new MojoExecutionException("Unable to create manifest", (Exception)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fos);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)fos);
    }

    public void jarWithOptionalManifest(boolean manifestExists) throws MojoExecutionException {
        MojoExecutor.Element[] archive = new MojoExecutor.Element[]{};
        if (manifestExists) {
            archive = new MojoExecutor.Element[]{MojoExecutor.element(MojoExecutor.name("manifestFile"), "${project.build.outputDirectory}/META-INF/MANIFEST.MF")};
        }
        MojoExecutor.executeMojo(MojoExecutor.plugin(MojoExecutor.groupId("org.apache.maven.plugins"), MojoExecutor.artifactId("maven-jar-plugin"), MojoExecutor.version(this.defaultArtifactIdToVersionMap.get("maven-jar-plugin"))), MojoExecutor.goal("jar"), MojoExecutor.configuration(MojoExecutor.element(MojoExecutor.name("archive"), archive)), this.executionEnvironment());
    }

    private String artifactToString(Artifact artifact) {
        return String.format("GAV: %s:%s:%s Type: %s, Classifier: %s", artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getType(), artifact.getClassifier());
    }

    public void jarTests(String finalName) throws MojoExecutionException {
        MojoExecutor.executeMojo(MojoExecutor.plugin(MojoExecutor.groupId("org.apache.maven.plugins"), MojoExecutor.artifactId("maven-jar-plugin"), MojoExecutor.version(this.defaultArtifactIdToVersionMap.get("maven-jar-plugin"))), MojoExecutor.goal("test-jar"), MojoExecutor.configuration(MojoExecutor.element(MojoExecutor.name("finalName"), finalName), MojoExecutor.element(MojoExecutor.name("archive"), MojoExecutor.element(MojoExecutor.name("manifestFile"), "${project.build.testOutputDirectory}/META-INF/MANIFEST.MF"))), this.executionEnvironment());
    }

    public void generateObrXml(File dep, File obrXml) throws MojoExecutionException {
        MojoExecutor.executeMojo(this.bndPlugin(), MojoExecutor.goal("install-file"), MojoExecutor.configuration(MojoExecutor.element(MojoExecutor.name("obrRepository"), obrXml.getPath()), MojoExecutor.element(MojoExecutor.name("groupId"), "doesntmatter"), MojoExecutor.element(MojoExecutor.name("artifactId"), "doesntmatter"), MojoExecutor.element(MojoExecutor.name("version"), "doesntmatter"), MojoExecutor.element(MojoExecutor.name("packaging"), "jar"), MojoExecutor.element(MojoExecutor.name("file"), dep.getPath())), this.executionEnvironment());
    }

    public void attachArtifact(File file, String type) throws MojoExecutionException {
        MojoExecutor.executeMojo(MojoExecutor.plugin(MojoExecutor.groupId("org.codehaus.mojo"), MojoExecutor.artifactId("build-helper-maven-plugin"), MojoExecutor.version(this.defaultArtifactIdToVersionMap.get("build-helper-maven-plugin"))), MojoExecutor.goal("attach-artifact"), MojoExecutor.configuration(MojoExecutor.element(MojoExecutor.name("artifacts"), MojoExecutor.element(MojoExecutor.name("artifact"), MojoExecutor.element(MojoExecutor.name("file"), file.getAbsolutePath()), MojoExecutor.element(MojoExecutor.name("type"), type)))), this.executionEnvironment());
    }

    public void release(String mavenArgs) throws MojoExecutionException {
        String args = "";
        if (StringUtils.isNotBlank((String)mavenArgs)) {
            args = mavenArgs;
        }
        MojoExecutor.executeMojo(MojoExecutor.plugin(MojoExecutor.groupId("org.apache.maven.plugins"), MojoExecutor.artifactId("maven-release-plugin"), MojoExecutor.version(this.defaultArtifactIdToVersionMap.get("maven-release-plugin"))), MojoExecutor.goal("prepare"), MojoExecutor.configuration(MojoExecutor.element(MojoExecutor.name("arguments"), args), MojoExecutor.element(MojoExecutor.name("autoVersionSubmodules"), "true")), this.executionEnvironment());
        MojoExecutor.executeMojo(MojoExecutor.plugin(MojoExecutor.groupId("org.apache.maven.plugins"), MojoExecutor.artifactId("maven-release-plugin"), MojoExecutor.version(this.defaultArtifactIdToVersionMap.get("maven-release-plugin"))), MojoExecutor.goal("perform"), MojoExecutor.configuration(MojoExecutor.element(MojoExecutor.name("arguments"), args), MojoExecutor.element(MojoExecutor.name("useReleaseProfile"), "true")), this.executionEnvironment());
    }

    public void generateRestDocs(String jacksonModules) throws MojoExecutionException {
        MavenProject prj = this.ctx.getProject();
        StringBuffer packagesPath = new StringBuffer();
        List<PluginXmlUtils.RESTModuleInfo> restModules = PluginXmlUtils.getRestModules(this.ctx);
        for (PluginXmlUtils.RESTModuleInfo moduleInfo : restModules) {
            List<String> packageList = moduleInfo.getPackagesToScan();
            for (String packageToScan : packageList) {
                if (packagesPath.length() > 0) {
                    packagesPath.append(File.pathSeparator);
                }
                String filePath = prj.getBuild().getSourceDirectory() + File.separator + packageToScan.replaceAll("\\.", Matcher.quoteReplacement(File.separator));
                packagesPath.append(filePath);
            }
        }
        if (!restModules.isEmpty() && packagesPath.length() > 0) {
            Plugin globalJavadoc;
            HashSet<String> docletPaths = new HashSet<String>();
            StringBuffer docletPath = new StringBuffer(File.pathSeparator + prj.getBuild().getOutputDirectory());
            String resourcedocPath = FileUtils.fixWindowsSlashes(prj.getBuild().getOutputDirectory() + File.separator + "resourcedoc.xml");
            PluginXmlUtils.PluginInfo pluginInfo = PluginXmlUtils.getPluginInfo(this.ctx);
            try {
                docletPaths.addAll(prj.getCompileClasspathElements());
                docletPaths.addAll(prj.getRuntimeClasspathElements());
                docletPaths.addAll(prj.getSystemClasspathElements());
                URL[] pluginUrls = ((URLClassLoader)Thread.currentThread().getContextClassLoader()).getURLs();
                for (URL pluginUrl : pluginUrls) {
                    docletPaths.add(new File(pluginUrl.getFile()).getPath());
                }
                for (String path : docletPaths) {
                    docletPath.append(File.pathSeparator);
                    docletPath.append(path);
                }
            }
            catch (DependencyResolutionRequiredException e) {
                throw new MojoExecutionException("Dependencies must be resolved", (Exception)((Object)e));
            }
            String additionalParam = "-output \"" + resourcedocPath + "\"";
            if (jacksonModules != null) {
                additionalParam = additionalParam + " -modules \"" + jacksonModules + "\"";
            }
            if (null != (globalJavadoc = this.executionEnvironment().getMavenProject().getPlugin("org.apache.maven.plugins:maven-javadoc-plugin"))) {
                this.executionEnvironment().getMavenProject().getBuild().removePlugin(globalJavadoc);
            }
            MojoExecutor.executeMojo(MojoExecutor.plugin(MojoExecutor.groupId("org.apache.maven.plugins"), MojoExecutor.artifactId("maven-javadoc-plugin"), MojoExecutor.version(this.defaultArtifactIdToVersionMap.get("maven-javadoc-plugin"))), MojoExecutor.goal("javadoc"), MojoExecutor.configuration(MojoExecutor.element(MojoExecutor.name("maxmemory"), "1024m"), MojoExecutor.element(MojoExecutor.name("sourcepath"), packagesPath.toString()), MojoExecutor.element(MojoExecutor.name("doclet"), "com.sun.jersey.wadl.resourcedoc.ResourceDocletJSON"), MojoExecutor.element(MojoExecutor.name("docletPath"), docletPath.toString()), MojoExecutor.element(MojoExecutor.name("docletArtifacts"), MojoExecutor.element(MojoExecutor.name("docletArtifact"), MojoExecutor.element(MojoExecutor.name("groupId"), "com.atlassian.plugins.rest"), MojoExecutor.element(MojoExecutor.name("artifactId"), "atlassian-rest-doclet"), MojoExecutor.element(MojoExecutor.name("version"), "2.9.2")), MojoExecutor.element(MojoExecutor.name("docletArtifact"), MojoExecutor.element(MojoExecutor.name("groupId"), "xerces"), MojoExecutor.element(MojoExecutor.name("artifactId"), "xercesImpl"), MojoExecutor.element(MojoExecutor.name("version"), "2.9.1")), MojoExecutor.element(MojoExecutor.name("docletArtifact"), MojoExecutor.element(MojoExecutor.name("groupId"), "commons-lang"), MojoExecutor.element(MojoExecutor.name("artifactId"), "commons-lang"), MojoExecutor.element(MojoExecutor.name("version"), "2.6"))), MojoExecutor.element(MojoExecutor.name("additionalparam"), additionalParam), MojoExecutor.element(MojoExecutor.name("useStandardDocletOptions"), "false")), this.executionEnvironment());
            if (null != globalJavadoc) {
                this.executionEnvironment().getMavenProject().getBuild().addPlugin(globalJavadoc);
            }
            try {
                File userGrammars;
                File userAppDocs = new File(prj.getBuild().getOutputDirectory(), "application-doc.xml");
                if (!userAppDocs.exists()) {
                    String appDocText = com.atlassian.core.util.FileUtils.getResourceContent((String)"application-doc.xml");
                    appDocText = StringUtils.replace((String)appDocText, (String)"${rest.doc.title}", (String)pluginInfo.getName());
                    appDocText = StringUtils.replace((String)appDocText, (String)"${rest.doc.description}", (String)pluginInfo.getDescription());
                    File appDocFile = new File(prj.getBuild().getOutputDirectory(), "application-doc.xml");
                    org.apache.commons.io.FileUtils.writeStringToFile((File)appDocFile, (String)appDocText);
                    this.log.info((CharSequence)("Wrote " + appDocFile.getAbsolutePath()));
                }
                if (!(userGrammars = new File(prj.getBuild().getOutputDirectory(), "application-grammars.xml")).exists()) {
                    String grammarText = com.atlassian.core.util.FileUtils.getResourceContent((String)"application-grammars.xml");
                    File grammarFile = new File(prj.getBuild().getOutputDirectory(), "application-grammars.xml");
                    org.apache.commons.io.FileUtils.writeStringToFile((File)grammarFile, (String)grammarText);
                    this.log.info((CharSequence)("Wrote " + grammarFile.getAbsolutePath()));
                }
            }
            catch (Exception e) {
                throw new MojoExecutionException("Error writing REST application xml files", e);
            }
        }
    }

    public void copyContainerToOutputDirectory(String containerVersion) throws MojoExecutionException {
        MojoExecutor.executeMojo(MojoExecutor.plugin(MojoExecutor.groupId("org.apache.maven.plugins"), MojoExecutor.artifactId("maven-dependency-plugin"), MojoExecutor.version(this.defaultArtifactIdToVersionMap.get("maven-dependency-plugin"))), MojoExecutor.goal("copy"), MojoExecutor.configuration(MojoExecutor.element(MojoExecutor.name("artifactItems"), MojoExecutor.element(MojoExecutor.name("artifactItem"), MojoExecutor.element(MojoExecutor.name("groupId"), "com.atlassian.plugins"), MojoExecutor.element(MojoExecutor.name("artifactId"), "remotable-plugins-container"), MojoExecutor.element(MojoExecutor.name("version"), containerVersion))), MojoExecutor.element(MojoExecutor.name("stripVersion"), "true"), MojoExecutor.element(MojoExecutor.name("outputDirectory"), "${project.build.directory}")), this.executionEnvironment());
    }

    public void debugStandaloneContainer(File pluginFile) throws MojoExecutionException {
        StringBuilder resourceProp = new StringBuilder();
        List resList = this.getContextProject().getResources();
        for (int i = 0; i < resList.size(); ++i) {
            resourceProp.append(((Resource)resList.get(i)).getDirectory());
            if (i + 1 == resList.size()) continue;
            resourceProp.append(",");
        }
        MojoExecutor.executeMojo(MojoExecutor.plugin(MojoExecutor.groupId("org.codehaus.mojo"), MojoExecutor.artifactId("exec-maven-plugin"), MojoExecutor.version(this.defaultArtifactIdToVersionMap.get("maven-exec-plugin"))), MojoExecutor.goal("exec"), MojoExecutor.configuration(MojoExecutor.element(MojoExecutor.name("executable"), "java"), MojoExecutor.element(MojoExecutor.name("arguments"), MojoExecutor.element(MojoExecutor.name("argument"), "-Datlassian.dev.mode=true"), MojoExecutor.element(MojoExecutor.name("argument"), "-Dplugin.resource.directories=" + resourceProp), MojoExecutor.element(MojoExecutor.name("argument"), "-Xdebug"), MojoExecutor.element(MojoExecutor.name("argument"), "-Xrunjdwp:transport=dt_socket,server=y,suspend=n,address=5004"), MojoExecutor.element(MojoExecutor.name("argument"), "-jar"), MojoExecutor.element(MojoExecutor.name("argument"), "${project.build.directory}/remotable-plugins-container-standalone.jar"), MojoExecutor.element(MojoExecutor.name("argument"), pluginFile.getPath()))), this.executionEnvironment());
    }

    public void saveArtifactToCurrentDirectory(String groupId, String artifactId, String version, String type, String filename) throws MojoExecutionException {
        MojoExecutor.executeMojo(MojoExecutor.plugin(MojoExecutor.groupId("org.apache.maven.plugins"), MojoExecutor.artifactId("maven-dependency-plugin"), MojoExecutor.version(this.defaultArtifactIdToVersionMap.get("maven-dependency-plugin"))), MojoExecutor.goal("copy"), MojoExecutor.configuration(MojoExecutor.element(MojoExecutor.name("artifactItems"), MojoExecutor.element(MojoExecutor.name("artifactItem"), MojoExecutor.element(MojoExecutor.name("groupId"), groupId), MojoExecutor.element(MojoExecutor.name("artifactId"), artifactId), MojoExecutor.element(MojoExecutor.name("version"), version), MojoExecutor.element(MojoExecutor.name("type"), type), MojoExecutor.element(MojoExecutor.name("destFileName"), filename))), MojoExecutor.element(MojoExecutor.name("outputDirectory"), ".")), this.executionEnvironment());
    }

    private static class Container
    extends ProductArtifact {
        private final String id;
        private final String type;
        private final String classifier;

        public Container(String id, String groupId, String artifactId, String version) {
            super(groupId, artifactId, version);
            this.id = id;
            this.type = "installed";
            this.classifier = "";
        }

        public Container(String id, String groupId, String artifactId, String version, String classifier) {
            super(groupId, artifactId, version);
            this.id = id;
            this.type = "installed";
            this.classifier = classifier;
        }

        public Container(String id) {
            this.id = id;
            this.type = "embedded";
            this.classifier = "";
        }

        public String getId() {
            return this.id;
        }

        @Override
        public String getType() {
            return this.type;
        }

        public String getClassifier() {
            return this.classifier;
        }

        public boolean isEmbedded() {
            return "embedded".equals(this.type);
        }

        public String getRootDirectory(String buildDir) {
            return buildDir + File.separator + "container" + File.separator + this.getId();
        }

        public String getInstallDirectory(String buildDir) {
            String installDirectory = this.getRootDirectory(buildDir) + File.separator + this.getArtifactId() + "-";
            String version = this.getVersion();
            if (version.endsWith("-atlassian-hosted") && !new File(installDirectory + version).exists()) {
                version = version.substring(0, version.indexOf("-atlassian-hosted"));
            }
            return installDirectory + version;
        }

        public String getConfigDirectory(String buildDir, String productId) {
            return this.getRootDirectory(buildDir) + File.separator + "cargo-" + productId + "-home";
        }
    }
}

