/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.product;

import com.atlassian.maven.plugins.amps.MavenContext;
import com.atlassian.maven.plugins.amps.MavenGoals;
import com.atlassian.maven.plugins.amps.Product;
import com.atlassian.maven.plugins.amps.ProductArtifact;
import com.atlassian.maven.plugins.amps.XmlOverride;
import com.atlassian.maven.plugins.amps.product.AbstractPluginProvider;
import com.atlassian.maven.plugins.amps.product.AbstractWebappProductHandler;
import com.atlassian.maven.plugins.amps.util.ConfigFileUtils;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.apache.maven.plugin.MojoExecutionException;

public class ConfluenceProductHandler
extends AbstractWebappProductHandler {
    private static final TreeMap<ComparableVersion, String> synchronyProxyVersions = new TreeMap();
    public static final String REQUIRE_SYNCHRONY_PROXY = "require.synchrony.proxy";
    public static final String SYNCHRONY_PROXY_VERSION = "synchrony.proxy.version";
    private final ProductArtifact synchronyProxy = new ProductArtifact("com.atlassian.synchrony", "synchrony-proxy", "RELEASE", "war");

    public ConfluenceProductHandler(MavenContext context, MavenGoals goals, ArtifactFactory artifactFactory) {
        super(context, goals, new ConfluencePluginProvider(), artifactFactory);
        synchronyProxyVersions.put(new ComparableVersion("6.4.10000"), "1.0.17");
        synchronyProxyVersions.put(new ComparableVersion("10000"), "RELEASE");
    }

    @Override
    public String getId() {
        return "confluence";
    }

    @Override
    protected boolean isStaticPlugin() {
        return false;
    }

    @Override
    public ProductArtifact getArtifact() {
        return new ProductArtifact("com.atlassian.confluence", "confluence-webapp", "RELEASE");
    }

    @Override
    public ProductArtifact getTestResourcesArtifact() {
        return new ProductArtifact("com.atlassian.confluence.plugins", "confluence-plugin-test-resources");
    }

    @Override
    public int getDefaultHttpPort() {
        return 1990;
    }

    @Override
    public int getDefaultHttpsPort() {
        return 8441;
    }

    @Override
    public Map<String, String> getSystemProperties(Product ctx) {
        ImmutableMap.Builder systemProperties = ImmutableMap.builder();
        systemProperties.putAll(super.getSystemProperties(ctx));
        systemProperties.put((Object)"confluence.home", (Object)this.getHomeDirectory(ctx).getPath());
        systemProperties.put((Object)"cargo.servlet.uriencoding", (Object)"UTF-8");
        return systemProperties.build();
    }

    @Override
    public File getUserInstalledPluginsDirectory(Product product, File webappDir, File homeDir) {
        return null;
    }

    @Override
    public List<ProductArtifact> getExtraContainerDependencies() {
        return Collections.emptyList();
    }

    private boolean shouldDeploySynchronyProxy(Product ctx) {
        boolean synchronyProxyRequired = true;
        if (StringUtils.isNotBlank((String)System.getProperty(REQUIRE_SYNCHRONY_PROXY))) {
            synchronyProxyRequired = Boolean.parseBoolean(System.getProperty(REQUIRE_SYNCHRONY_PROXY));
        }
        return Character.getNumericValue(ctx.getVersion().charAt(0)) >= 6 && synchronyProxyRequired;
    }

    @Override
    public List<ProductArtifact> getExtraProductDeployables(Product ctx) {
        return this.shouldDeploySynchronyProxy(ctx) ? Arrays.asList(this.synchronyProxy) : Collections.emptyList();
    }

    @Override
    protected void customiseInstance(Product ctx, File homeDir, File explodedWarDir) throws MojoExecutionException {
        ctx.setCargoXmlOverrides(this.serverXmlConfluenceOverride());
        if (!this.shouldDeploySynchronyProxy(ctx)) {
            this.log.debug((CharSequence)"Synchrony proxy is disabled or not supported");
            return;
        }
        this.log.debug((CharSequence)("Resolving synchrony proxy version for Confluence " + ctx.getVersion()));
        if (StringUtils.isNotBlank((String)System.getProperty(SYNCHRONY_PROXY_VERSION))) {
            this.log.debug((CharSequence)("Synchrony proxy version is already set in system variable (" + System.getProperty(SYNCHRONY_PROXY_VERSION) + ")"));
            this.synchronyProxy.setVersion(System.getProperty(SYNCHRONY_PROXY_VERSION));
        } else {
            this.log.debug((CharSequence)"Synchrony proxy version is not set. Attempting to set corresponding version");
            Map.Entry<ComparableVersion, String> synchronyProxyVersion = synchronyProxyVersions.ceilingEntry(new ComparableVersion(ctx.getVersion()));
            if (synchronyProxyVersion != null) {
                this.synchronyProxy.setVersion(synchronyProxyVersion.getValue());
                this.log.debug((CharSequence)("Synchrony proxy version is set to " + synchronyProxyVersion.getValue()));
            }
        }
        if ("RELEASE".equals(this.synchronyProxy.getVersion()) || "LATEST".equals(this.synchronyProxy.getVersion())) {
            this.log.debug((CharSequence)"determining latest stable synchrony-proxy version...");
            Artifact warArtifact = this.artifactFactory.createProjectArtifact(this.synchronyProxy.getGroupId(), this.synchronyProxy.getArtifactId(), this.synchronyProxy.getVersion());
            String stableVersion = ctx.getArtifactRetriever().getLatestStableVersion(warArtifact);
            this.log.debug((CharSequence)("using latest stable synchrony-proxy version: " + stableVersion));
            this.synchronyProxy.setVersion(stableVersion);
        }
        File confInstall = this.getBaseDirectory(ctx);
        File war = this.goals.copyWebappWar("synchrony-proxy", new File(confInstall, "synchrony-proxy"), this.synchronyProxy);
        this.synchronyProxy.setPath(war.getPath());
    }

    private Collection<XmlOverride> serverXmlConfluenceOverride() {
        return Collections.singletonList(new XmlOverride("conf/server.xml", "//Connector", "maxThreads", "48"));
    }

    @Override
    public File getBundledPluginPath(Product ctx, File appDir) {
        String bundleDirPath = "WEB-INF/atlassian-bundled-plugins";
        File bundleDir = new File(appDir, bundleDirPath);
        if (bundleDir.exists() && bundleDir.isDirectory()) {
            return bundleDir;
        }
        return new File(appDir, "WEB-INF/classes/com/atlassian/confluence/setup/atlassian-bundled-plugins.zip");
    }

    @Override
    public List<ConfigFileUtils.Replacement> getReplacements(Product ctx) {
        List<ConfigFileUtils.Replacement> replacements = super.getReplacements(ctx);
        File homeDir = this.getHomeDirectory(ctx);
        replacements.add(new ConfigFileUtils.Replacement("@project-dir@", homeDir.getParent()));
        replacements.add(new ConfigFileUtils.Replacement("/confluence-home/", "/home/", false));
        replacements.add(new ConfigFileUtils.Replacement("<baseUrl>http://localhost:1990/confluence</baseUrl>", "<baseUrl>" + ctx.getProtocol() + "://" + ctx.getServer() + ":" + ctx.getHttpPort() + "/" + ctx.getContextPath().replaceAll("^/|/$", "") + "</baseUrl>", false));
        replacements.add(new ConfigFileUtils.Replacement("<baseUrl>http://localhost:8080</baseUrl>", "<baseUrl>" + ctx.getProtocol() + "://" + ctx.getServer() + ":" + ctx.getHttpPort() + "/" + ctx.getContextPath().replaceAll("^/|/$", "") + "</baseUrl>", false));
        return replacements;
    }

    @Override
    public List<File> getConfigFiles(Product product, File homeDirectory) {
        List<File> configFiles = super.getConfigFiles(product, homeDirectory);
        configFiles.add(new File(new File(homeDirectory, "database"), "confluencedb.script"));
        configFiles.add(new File(new File(homeDirectory, "database"), "confluencedb.log"));
        configFiles.add(new File(homeDirectory, "confluence.cfg.xml"));
        return configFiles;
    }

    public List<ProductArtifact> getDefaultLibPlugins() {
        return Collections.emptyList();
    }

    public List<ProductArtifact> getDefaultBundledPlugins() {
        return Collections.emptyList();
    }

    @Override
    public void cleanupProductHomeForZip(Product product, File snapshotDir) throws MojoExecutionException, IOException {
        super.cleanupProductHomeForZip(product, snapshotDir);
        FileUtils.deleteDirectory((File)new File(snapshotDir, "plugins-osgi-cache"));
        FileUtils.deleteDirectory((File)new File(snapshotDir, "plugins-temp"));
        FileUtils.deleteDirectory((File)new File(snapshotDir, "temp"));
    }

    private static class ConfluencePluginProvider
    extends AbstractPluginProvider {
        private ConfluencePluginProvider() {
        }

        @Override
        protected Collection<ProductArtifact> getSalArtifacts(String salVersion) {
            return Arrays.asList(new ProductArtifact("com.atlassian.sal", "sal-api", salVersion), new ProductArtifact("com.atlassian.sal", "sal-confluence-plugin", salVersion));
        }

        @Override
        protected Collection<ProductArtifact> getPdkInstallArtifacts(String pdkInstallVersion) {
            return Collections.emptyList();
        }
    }
}

