/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.pseudoloc;

import com.atlassian.maven.plugins.pseudoloc.FileActionParameter;
import com.atlassian.maven.plugins.pseudoloc.PseudoLocResources;
import com.atlassian.maven.plugins.pseudoloc.filters.IFileFilter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;

public class CopyFileAction {
    protected String sourceLocale;
    protected String targetLocale;
    protected File sourceFile;
    protected File targetFile;
    protected IFileFilter[] filters;

    public String getSuccessMessage() {
        StringBuffer message = new StringBuffer();
        message.append(PseudoLocResources.getString("SUCCESS_COPY"));
        if (this.filters != null) {
            for (IFileFilter filter : this.filters) {
                message.append(", ");
                message.append(filter.getSuccessMessage());
            }
        }
        message.append(PseudoLocResources.getString("SUCCESS_FILE_NAMES"));
        return message.toString();
    }

    public CopyFileAction(String sourceLocale, String targetLocale, FileActionParameter params) {
        this(sourceLocale, targetLocale, params, (IFileFilter[])null);
    }

    public CopyFileAction(String sourceLocale, String targetLocale, FileActionParameter params, IFileFilter filter) {
        this(sourceLocale, targetLocale, params, new IFileFilter[]{filter});
    }

    public CopyFileAction(String sourceLocale, String targetLocale, FileActionParameter params, IFileFilter[] filters) {
        if (params == null) {
            throw new RuntimeException(PseudoLocResources.getString("ERROR_NULL_PARAMETERS"));
        }
        this.sourceFile = params.source;
        this.targetFile = params.target;
        if (this.sourceFile == null || this.targetFile == null) {
            throw new RuntimeException(PseudoLocResources.getString("ERROR_NULL_PARAMETERS"));
        }
        this.sourceLocale = sourceLocale;
        this.targetLocale = targetLocale;
        this.filters = filters;
    }

    public File getSourceFile() {
        return this.sourceFile;
    }

    public File getTargetFile() {
        return this.targetFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws Exception {
        this.sourceFile = this.replaceLocaleTokens(this.sourceFile, this.sourceLocale);
        this.targetFile = this.replaceLocaleTokens(this.targetFile, this.targetLocale);
        FileInputStream inputStream = null;
        FileOutputStream outputStream = null;
        try {
            inputStream = this.getSourceStream();
            outputStream = this.getTargetStream();
            this.copyFileContent(inputStream, outputStream);
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
            if (outputStream != null) {
                outputStream.close();
            }
        }
    }

    protected FileInputStream getSourceStream() {
        FileInputStream sourceStream;
        try {
            sourceStream = new FileInputStream(this.sourceFile);
        }
        catch (FileNotFoundException fnfe) {
            throw new RuntimeException(String.format(PseudoLocResources.getString("ERROR_SOURCE_NOT_FOUND"), this.sourceFile.getPath()));
        }
        catch (IOException ioe) {
            throw new RuntimeException(String.format(PseudoLocResources.getString("ERROR_SOURCE_FILE_READ_EXCEPTION"), ioe.getLocalizedMessage()));
        }
        return sourceStream;
    }

    protected FileOutputStream getTargetStream() {
        FileOutputStream targetStream;
        try {
            File parentDir = new File(this.targetFile.getParent());
            parentDir.mkdirs();
            targetStream = new FileOutputStream(this.targetFile);
        }
        catch (IOException ioe) {
            throw new RuntimeException(String.format(PseudoLocResources.getString("ERROR_TARGET_FILE_WRITE_EXCEPTION"), ioe.getLocalizedMessage()));
        }
        return targetStream;
    }

    protected File replaceLocaleTokens(File file, String locale) {
        return new File(file.getPath().replace(PseudoLocResources.getString("LOCALE_TAG"), locale));
    }

    protected void copyFileContent(FileInputStream inputStream, FileOutputStream outputStream) {
        try {
            int read;
            ByteArrayOutputStream contentStream = new ByteArrayOutputStream();
            byte[] buf = new byte[1024];
            while ((read = inputStream.read(buf)) != -1) {
                contentStream.write(buf, 0, read);
            }
            byte[] content = contentStream.toByteArray();
            if (this.filters != null) {
                for (IFileFilter filter : this.filters) {
                    content = filter.filter(content, this.sourceLocale, this.targetLocale);
                }
            }
            outputStream.write(content);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe.getMessage());
        }
    }
}

