/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.pseudoloc;

import com.atlassian.maven.plugins.pseudoloc.CopyFileAction;
import com.atlassian.maven.plugins.pseudoloc.FileActionParameter;
import com.atlassian.maven.plugins.pseudoloc.PseudoLocResources;
import com.atlassian.maven.plugins.pseudoloc.filters.PseudoLocaliseFilter;
import com.atlassian.maven.plugins.pseudoloc.filters.ReplaceLocaleFilter;
import java.util.ArrayList;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class PseudoLocPlugin
extends AbstractMojo {
    protected FileActionParameter[] copyActions;
    protected FileActionParameter[] replaceLocaleActions;
    protected FileActionParameter[] pseudoLocaliseActions;
    protected String sourceLocale;
    protected String targetLocale;

    public void execute() throws MojoExecutionException {
        if (this.sourceLocale == null || this.targetLocale == null) {
            String error = PseudoLocResources.getErrorMessageFromKey("ERROR_NULL_LOCALES");
            this.getLog().error((CharSequence)error);
            throw new MojoExecutionException(error);
        }
        ArrayList<CopyFileAction> actions = new ArrayList<CopyFileAction>();
        if (this.copyActions != null) {
            for (FileActionParameter params : this.copyActions) {
                actions.add(new CopyFileAction(this.sourceLocale, this.targetLocale, params));
            }
        }
        if (this.replaceLocaleActions != null) {
            for (FileActionParameter params : this.replaceLocaleActions) {
                actions.add(new CopyFileAction(this.sourceLocale, this.targetLocale, params, new ReplaceLocaleFilter()));
            }
        }
        if (this.pseudoLocaliseActions != null) {
            for (FileActionParameter params : this.pseudoLocaliseActions) {
                actions.add(new CopyFileAction(this.sourceLocale, this.targetLocale, params, new PseudoLocaliseFilter()));
            }
        }
        for (CopyFileAction action : actions) {
            try {
                action.execute();
            }
            catch (Exception e) {
                String error = PseudoLocResources.getErrorMessage(e.getMessage());
                this.getLog().error((CharSequence)error);
                e.printStackTrace();
                throw new MojoExecutionException(error);
            }
            this.getLog().info((CharSequence)String.format(action.getSuccessMessage(), action.getSourceFile(), action.getTargetFile()));
        }
    }
}

