/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.pseudoloc.filters;

import com.atlassian.maven.plugins.pseudoloc.PseudoLocResources;
import com.atlassian.maven.plugins.pseudoloc.filters.IFileFilter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PseudoLocaliseFilter
implements IFileFilter {
    protected static final String PADDING = " ---";
    protected static final int HASH_LENGTH = 0;
    private static final Pattern ESCAPE_PATTERN = Pattern.compile("\\{\\d+,(choice,|number)");
    private final boolean USE_MORE_CHARS = Boolean.getBoolean("com.atlassian.mavin.plugins.pseudoloc.more");
    private final boolean USE_CJK_CHARS = Boolean.getBoolean("com.atlassian.mavin.plugins.pseudoloc.cjk");
    private final boolean USE_ASTRAL_CHARS = Boolean.getBoolean("com.atlassian.mavin.plugins.pseudoloc.astral");
    protected final String START_TAG = this.USE_CJK_CHARS ? "\u3008__" : "[__";
    protected final String MIDDLE_TAG = this.USE_ASTRAL_CHARS ? "__\ud83d\udc95__" : "__";
    protected final String END_TAG = this.USE_CJK_CHARS ? "\u3009" : "]";
    private final char[] CHAR_MAP = new char[128];
    private boolean loggedTagWarning = false;
    protected static final int ALPHABET_LENGTH = 26;

    public PseudoLocaliseFilter() {
        this.CHAR_MAP[68] = 270;
        this.CHAR_MAP[69] = 8364;
        this.CHAR_MAP[83] = 536;
        this.CHAR_MAP[63] = 191;
        this.CHAR_MAP[97] = 228;
        this.CHAR_MAP[101] = 233;
        this.CHAR_MAP[105] = 305;
        this.CHAR_MAP[111] = 248;
        if (this.USE_MORE_CHARS) {
            this.CHAR_MAP[33] = 161;
            this.CHAR_MAP[65] = 197;
            this.CHAR_MAP[66] = 946;
            this.CHAR_MAP[67] = 199;
            this.CHAR_MAP[73] = 205;
            this.CHAR_MAP[74] = 308;
            this.CHAR_MAP[78] = 1048;
            this.CHAR_MAP[79] = 216;
            this.CHAR_MAP[82] = 1071;
            this.CHAR_MAP[85] = 217;
            this.CHAR_MAP[88] = 935;
            this.CHAR_MAP[89] = 376;
            this.CHAR_MAP[90] = 379;
            this.CHAR_MAP[99] = 231;
            this.CHAR_MAP[100] = 273;
            this.CHAR_MAP[103] = 285;
            this.CHAR_MAP[106] = 309;
            this.CHAR_MAP[107] = 312;
            this.CHAR_MAP[110] = 241;
            this.CHAR_MAP[112] = 254;
            this.CHAR_MAP[114] = 1103;
            this.CHAR_MAP[115] = 537;
            this.CHAR_MAP[117] = 249;
            this.CHAR_MAP[118] = 957;
            this.CHAR_MAP[119] = 969;
            this.CHAR_MAP[120] = 967;
            this.CHAR_MAP[121] = 255;
            this.CHAR_MAP[122] = 380;
        }
        if (this.USE_CJK_CHARS) {
            this.CHAR_MAP[44] = 12289;
            this.CHAR_MAP[46] = 12290;
            this.CHAR_MAP[40] = 12296;
            this.CHAR_MAP[41] = 12297;
            this.CHAR_MAP[91] = 12298;
            this.CHAR_MAP[93] = 12299;
            this.CHAR_MAP[69] = 12520;
            this.CHAR_MAP[73] = 12456;
            this.CHAR_MAP[79] = 12295;
            this.CHAR_MAP[84] = 12390;
            this.CHAR_MAP[85] = 12402;
            this.CHAR_MAP[42] = 27700;
        }
    }

    @Override
    public String getSuccessMessage() {
        return PseudoLocResources.getString("SUCCESS_PSEUDO_LOC");
    }

    @Override
    public byte[] filter(byte[] content, String sourceLocale, String targetLocale) {
        Properties properties = new Properties();
        try {
            properties.load(new ByteArrayInputStream(content));
        }
        catch (IOException ioe) {
            throw new RuntimeException(String.format(PseudoLocResources.getString("ERROR_SOURCE_FILE_READ_EXCEPTION"), ioe.getMessage()));
        }
        for (Object key : properties.keySet()) {
            String keyString = key.toString();
            String value = this.pseudoLocaliseValue(keyString, properties.getProperty(keyString));
            properties.setProperty(keyString, value);
        }
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            properties.store(outputStream, PseudoLocResources.getString("PROPERTIES_HEADER"));
            return outputStream.toByteArray();
        }
        catch (IOException ioe) {
            throw new RuntimeException(String.format(PseudoLocResources.getString("ERROR_TARGET_FILE_WRITE_EXCEPTION"), ioe.getMessage()));
        }
    }

    protected String pseudoLocaliseValue(String key, String value) {
        if (value == null) {
            return value;
        }
        int targetLength = (int)((double)value.length() * 1.5) - this.MIDDLE_TAG.length() - this.END_TAG.length() - 0;
        StringBuilder sb = new StringBuilder(targetLength < 0 ? 16 : targetLength + 16);
        sb.append(this.START_TAG);
        int mark = 0;
        Matcher matcher = ESCAPE_PATTERN.matcher(value);
        while (matcher.find(mark)) {
            sb.append(this.pseudoLocaliseString(value.substring(mark, matcher.start())));
            sb.append(matcher.group());
            mark = matcher.end();
        }
        sb.append(this.pseudoLocaliseString(value.substring(mark)));
        while (sb.length() < targetLength) {
            sb.append(PADDING);
        }
        sb.append(this.MIDDLE_TAG);
        String hash = this.getHash(key, 0);
        if (hash != null) {
            sb.append(hash);
        }
        sb.append(this.END_TAG);
        return sb.toString();
    }

    private String pseudoLocaliseString(String value) {
        boolean inTag = false;
        boolean inDoubleQuote = false;
        char[] chars = value.toCharArray();
        int len = chars.length;
        for (int i = 0; i < len; ++i) {
            char c = chars[i];
            if (inTag) {
                if (c != '>') continue;
                inTag = false;
                continue;
            }
            if (c == '<') {
                inTag = true;
                continue;
            }
            if (c == '\\') {
                if (++i >= len) break;
                if (chars[i] != 'u') continue;
                i += 4;
                continue;
            }
            if (c == '\'') {
                ++i;
                continue;
            }
            if (c >= '\u0080') continue;
            if ((c = this.CHAR_MAP[c]) != '\u0000') {
                chars[i] = c;
                continue;
            }
            if (!this.USE_CJK_CHARS || c != '\"') continue;
            chars[i] = inDoubleQuote ? 12301 : 12300;
            inDoubleQuote = !inDoubleQuote;
        }
        return new String(chars);
    }

    protected String getHash(String value, int hashLength) {
        if (value == null || hashLength < 1) {
            return null;
        }
        int fullHash = Math.abs(value.hashCode());
        int maxHashValue = (int)Math.pow(26.0, hashLength);
        int hashValue = fullHash % maxHashValue;
        StringBuilder shortHash = new StringBuilder();
        for (int i = hashLength - 1; i >= 0; --i) {
            int placeValue = (int)Math.pow(26.0, i);
            int charValue = hashValue / placeValue;
            hashValue %= placeValue;
            shortHash.append(this.getChar(charValue));
        }
        return shortHash.toString();
    }

    protected char getChar(int charValue) {
        if (charValue >= 26) {
            throw new RuntimeException(String.format(PseudoLocResources.getString("ERROR_TOO_LARGE_FOR_ASCII"), charValue));
        }
        return (char)(97 + charValue);
    }
}

