/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.osgi.factory.transform.model;

import com.atlassian.plugin.osgi.util.OsgiHeaderUtil;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.LinkedHashMap;
import java.util.Map;

public class SystemExports {
    private final Map<String, Map<String, String>> exports;
    public static final SystemExports NONE = new SystemExports("");

    public SystemExports(String exportsLine) {
        if (exportsLine == null) {
            exportsLine = "";
        }
        this.exports = SystemExports.internAttributeKeys(OsgiHeaderUtil.parseHeader(exportsLine));
    }

    private static Map<String, Map<String, String>> internAttributeKeys(Map<String, Map<String, String>> map) {
        return Maps.transformValues(map, (Function)new Function<Map<String, String>, Map<String, String>>(){

            public Map<String, String> apply(Map<String, String> innerMap) {
                return SystemExports.internKeys(innerMap);
            }
        });
    }

    private static Map<String, String> internKeys(Map<String, String> innerMap) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<String, String> entry : innerMap.entrySet()) {
            builder.put((Object)entry.getKey().intern(), (Object)entry.getValue());
        }
        return builder.build();
    }

    public String getFullExport(String pkg) {
        if (this.exports.containsKey(pkg)) {
            LinkedHashMap<String, String> attrs = new LinkedHashMap<String, String>(this.exports.get(pkg));
            if (attrs.containsKey("version")) {
                String version = (String)attrs.get("version");
                attrs.put("version", "[" + version + "," + version + "]");
            }
            return OsgiHeaderUtil.buildHeader(pkg, attrs);
        }
        return pkg;
    }

    public boolean isExported(String pkg) {
        return this.exports.containsKey(pkg);
    }
}

