/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.signing.tool;

import com.atlassian.upm.signing.tool.AtlassianCertificate;
import com.atlassian.upm.signing.tool.CustomCertificateProperties;
import com.atlassian.upm.signing.tool.PrivateKeyAndCert;
import com.atlassian.upm.signing.tool.UpmConfigShutdownAction;
import com.atlassian.upm.signing.tool.UpmConfigWriter;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.time.format.DateTimeParseException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpmConfigHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(UpmConfigHandler.class);
    private final UpmConfigWriter writer;
    private final UpmConfigShutdownAction shutdownAction;
    private final Set<AtlassianCertificate> atlassianCertificates;
    private final String customCertificateIssuer;
    private final String customCertificateName;
    private final String customCertificateDuration;
    private final String customCertificateStartOffset;
    private final boolean overwriteConfiguration;

    private UpmConfigHandler(Builder builder) {
        this.writer = builder.buildWriter();
        this.shutdownAction = builder.resolveShutdownAction();
        this.overwriteConfiguration = builder.overwriteConfiguration;
        this.atlassianCertificates = builder.atlassianCertificates;
        this.customCertificateIssuer = builder.customCertificateIssuer;
        this.customCertificateDuration = builder.customCertificateDuration;
        this.customCertificateName = builder.customCertificateName;
        this.customCertificateStartOffset = builder.customCertificateStartOffset;
    }

    public static Builder builder(Path path) {
        return new Builder(path);
    }

    public UpmConfigWriter getWriter() {
        return this.writer;
    }

    private static Map<String, String> getDisablingProperties() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("atlassian.upm.signature.check.disabled", Boolean.TRUE.toString());
        return map;
    }

    public Map<String, String> getSystemProperties() {
        if (this.writer == null) {
            return UpmConfigHandler.getDisablingProperties();
        }
        return this.writer.getSystemProperties();
    }

    public void writeConfiguration() {
        this.writer.createConfig(this.overwriteConfiguration, this.atlassianCertificates);
        if (this.customCertificateIssuer != null) {
            String name = this.customCertificateName.replaceAll("\\s", "_");
            PrivateKeyAndCert privateKeyAndCert = this.createPrivateKeyAndCertificate(this.customCertificateIssuer, this.customCertificateDuration, this.customCertificateStartOffset);
            this.writer.writePrivateKeyAndCertificate(name, privateKeyAndCert);
        }
        LOGGER.info("UPM plugin signature check configuration file written to {}", (Object)this.writer.getConfigFilePath());
        LOGGER.info("UPM TrustStore written to {}", (Object)this.writer.getTrustStorePath());
    }

    public void shutdown() {
        if (this.shutdownAction != null) {
            try {
                LOGGER.info(this.shutdownAction.getMessage());
                this.shutdownAction.perform(this.writer);
            }
            catch (Exception e) {
                LOGGER.error(this.shutdownAction.getFailureMessage(e.getMessage()));
            }
        }
    }

    private PrivateKeyAndCert createPrivateKeyAndCertificate(String issuer, String duration, String startOffset) {
        Duration d = this.safeParse(duration).orElse(Duration.ofDays(1L));
        ZonedDateTime start = ZonedDateTime.now();
        if (startOffset != null) {
            Duration offsetDuration = this.safeParse(startOffset).orElse(Duration.ZERO);
            start = start.plus(offsetDuration);
        }
        return PrivateKeyAndCert.generateSelfSignedX509Certificate(start, start.plus(d), issuer);
    }

    private Optional<Duration> safeParse(String duration) {
        if (duration == null || duration.trim().isEmpty()) {
            return Optional.empty();
        }
        try {
            return Optional.of(Duration.parse(duration));
        }
        catch (DateTimeParseException dateTimeParseException) {
            return Optional.empty();
        }
    }

    public static class Builder {
        private final Path basePath;
        private boolean enabled = false;
        private boolean readonly = true;
        private String upmConfigPathProperty;
        private String upmConfigFilePathProperty;
        private String upmTrustStorePathProperty;
        private boolean overwriteConfiguration = false;
        private Set<AtlassianCertificate> atlassianCertificates = EnumSet.noneOf(AtlassianCertificate.class);
        private String customCertificateIssuer;
        private String customCertificateName;
        private String customCertificateDuration;
        private String customCertificateStartOffset;
        private UpmConfigShutdownAction shutdownAction = UpmConfigShutdownAction.MAKE_WRITABLE;

        public Builder(Path basePath) {
            this.basePath = basePath;
        }

        public Builder readonly(boolean readonly) {
            this.readonly = readonly;
            return this;
        }

        public Builder enabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public Builder upmConfigPath(String upmConfigPathProperty) {
            this.upmConfigPathProperty = upmConfigPathProperty;
            return this;
        }

        public Builder upmConfigFilePath(String upmConfigFilePathProperty) {
            this.upmConfigFilePathProperty = upmConfigFilePathProperty;
            return this;
        }

        public Builder upmTrustStorePath(String upmTrustStorePathProperty) {
            this.upmTrustStorePathProperty = upmTrustStorePathProperty;
            return this;
        }

        public Builder overwriteUpmConfig(boolean overwriteUpmConfig) {
            this.overwriteConfiguration = overwriteUpmConfig;
            return this;
        }

        public Builder atlassianCertificates(String atlassianCertificates) {
            this.atlassianCertificates = AtlassianCertificate.getCertificates(atlassianCertificates);
            return this;
        }

        public Builder customCertificate(CustomCertificateProperties customCertificateProperties) {
            if (customCertificateProperties != null) {
                this.customCertificateIssuer = customCertificateProperties.getIssuer();
                this.customCertificateName = customCertificateProperties.getName();
                this.customCertificateDuration = customCertificateProperties.getDuration();
                this.customCertificateStartOffset = customCertificateProperties.getStartOffset();
            }
            return this;
        }

        public Builder deleteUpmConfigOnShutdown(boolean deleteUpmConfigOnShutdown) {
            this.shutdownAction = deleteUpmConfigOnShutdown ? UpmConfigShutdownAction.DELETE : UpmConfigShutdownAction.MAKE_WRITABLE;
            return this;
        }

        public Builder onShutdown(String shutdownAction) {
            this.shutdownAction = UpmConfigShutdownAction.resolve(shutdownAction);
            return this;
        }

        private Path resolve(String param, String defaultPath) {
            if (param == null) {
                return this.basePath.resolve(defaultPath);
            }
            Path path = Paths.get(param, new String[0]);
            if (path.isAbsolute()) {
                return path;
            }
            return this.basePath.resolve(param);
        }

        private Path getUpmConfigFilePath() {
            return this.resolve(this.upmConfigFilePathProperty, "upm.properties");
        }

        private Path getUpmTrustStorePath() {
            return this.resolve(this.upmTrustStorePathProperty, "truststore");
        }

        @Deprecated
        private Path getUpmConfigPath() {
            return this.resolve(this.upmConfigPathProperty, "upmconfig");
        }

        private UpmConfigWriter buildWriter() {
            if (this.upmTrustStorePathProperty != null || this.upmConfigFilePathProperty != null) {
                return new UpmConfigWriter(this.getUpmConfigFilePath(), this.getUpmTrustStorePath(), this.enabled, this.readonly);
            }
            return new UpmConfigWriter(this.getUpmConfigPath(), this.enabled, this.readonly);
        }

        public UpmConfigHandler build() {
            return new UpmConfigHandler(this);
        }

        private UpmConfigShutdownAction resolveShutdownAction() {
            if (this.shutdownAction == UpmConfigShutdownAction.MAKE_WRITABLE) {
                return this.readonly ? this.shutdownAction : null;
            }
            return this.shutdownAction;
        }
    }
}

