/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.implementation;

import com.azure.ai.openai.models.ChatCompletionsOptions;
import com.azure.ai.openai.models.CompletionsOptions;
import com.azure.ai.openai.models.EmbeddingsOptions;
import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.annotation.UnexpectedResponseExceptionTypes;
import com.azure.core.exception.ClientAuthenticationException;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.exception.ResourceModifiedException;
import com.azure.core.exception.ResourceNotFoundException;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import reactor.core.publisher.Mono;

public final class NonAzureOpenAIClientImpl {
    private final NonAzureOpenAIClientService service;
    private final HttpPipeline httpPipeline;
    private final SerializerAdapter serializerAdapter;
    public static final String OPEN_AI_ENDPOINT = "https://api.openai.com/v1";

    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    public SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    public NonAzureOpenAIClientImpl(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter) {
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.service = (NonAzureOpenAIClientService)RestProxy.create(NonAzureOpenAIClientService.class, (HttpPipeline)this.httpPipeline, (SerializerAdapter)this.getSerializerAdapter());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getEmbeddingsWithResponseAsync(String modelId, BinaryData embeddingsOptions, RequestOptions requestOptions) {
        String accept = "application/json";
        BinaryData embeddingsOptionsUpdated = BinaryData.fromObject((Object)((EmbeddingsOptions)embeddingsOptions.toObject(EmbeddingsOptions.class)).setModel(modelId));
        return FluxUtil.withContext(context -> this.service.getEmbeddings(OPEN_AI_ENDPOINT, "application/json", embeddingsOptionsUpdated, requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getEmbeddingsWithResponse(String modelId, BinaryData embeddingsOptions, RequestOptions requestOptions) {
        String accept = "application/json";
        BinaryData embeddingsOptionsUpdated = BinaryData.fromObject((Object)((EmbeddingsOptions)embeddingsOptions.toObject(EmbeddingsOptions.class)).setModel(modelId));
        return this.service.getEmbeddingsSync(OPEN_AI_ENDPOINT, "application/json", embeddingsOptionsUpdated, requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getCompletionsWithResponseAsync(String modelId, BinaryData completionsOptions, RequestOptions requestOptions) {
        String accept = "application/json";
        BinaryData completionsOptionsUpdated = BinaryData.fromObject((Object)((CompletionsOptions)completionsOptions.toObject(CompletionsOptions.class)).setModel(modelId));
        return FluxUtil.withContext(context -> this.service.getCompletions(OPEN_AI_ENDPOINT, "application/json", completionsOptionsUpdated, requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getCompletionsWithResponse(String modelId, BinaryData completionsOptions, RequestOptions requestOptions) {
        String accept = "application/json";
        BinaryData completionsOptionsUpdated = BinaryData.fromObject((Object)((CompletionsOptions)completionsOptions.toObject(CompletionsOptions.class)).setModel(modelId));
        return this.service.getCompletionsSync(OPEN_AI_ENDPOINT, "application/json", completionsOptionsUpdated, requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getChatCompletionsWithResponseAsync(String modelId, BinaryData chatCompletionsOptions, RequestOptions requestOptions) {
        String accept = "application/json";
        BinaryData chatCompletionsOptionsUpdated = BinaryData.fromObject((Object)((ChatCompletionsOptions)chatCompletionsOptions.toObject(ChatCompletionsOptions.class)).setModel(modelId));
        return FluxUtil.withContext(context -> this.service.getChatCompletions(OPEN_AI_ENDPOINT, "application/json", chatCompletionsOptionsUpdated, requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getChatCompletionsWithResponse(String modelId, BinaryData chatCompletionsOptions, RequestOptions requestOptions) {
        String accept = "application/json";
        BinaryData chatCompletionsOptionsUpdated = BinaryData.fromObject((Object)((ChatCompletionsOptions)chatCompletionsOptions.toObject(ChatCompletionsOptions.class)).setModel(modelId));
        return this.service.getChatCompletionsSync(OPEN_AI_ENDPOINT, "application/json", chatCompletionsOptionsUpdated, requestOptions, Context.NONE);
    }

    @Host(value="{endpoint}")
    @ServiceInterface(name="OpenAIClient")
    public static interface NonAzureOpenAIClientService {
        @Post(value="/embeddings")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> getEmbeddings(@HostParam(value="endpoint") String var1, @HeaderParam(value="accept") String var2, @BodyParam(value="application/json") BinaryData var3, RequestOptions var4, Context var5);

        @Post(value="/embeddings")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> getEmbeddingsSync(@HostParam(value="endpoint") String var1, @HeaderParam(value="accept") String var2, @BodyParam(value="application/json") BinaryData var3, RequestOptions var4, Context var5);

        @Post(value="/completions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> getCompletions(@HostParam(value="endpoint") String var1, @HeaderParam(value="accept") String var2, @BodyParam(value="application/json") BinaryData var3, RequestOptions var4, Context var5);

        @Post(value="/completions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> getCompletionsSync(@HostParam(value="endpoint") String var1, @HeaderParam(value="accept") String var2, @BodyParam(value="application/json") BinaryData var3, RequestOptions var4, Context var5);

        @Post(value="/chat/completions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> getChatCompletions(@HostParam(value="endpoint") String var1, @HeaderParam(value="accept") String var2, @BodyParam(value="application/json") BinaryData var3, RequestOptions var4, Context var5);

        @Post(value="/chat/completions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> getChatCompletionsSync(@HostParam(value="endpoint") String var1, @HeaderParam(value="accept") String var2, @BodyParam(value="application/json") BinaryData var3, RequestOptions var4, Context var5);
    }
}

