/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.implementation;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import reactor.core.publisher.Flux;

public final class OpenAIServerSentEvents<T> {
    private final Flux<ByteBuffer> source;
    private final Class<T> type;
    private AtomicReference<String> lastLine = new AtomicReference<String>("");
    private AtomicBoolean expectEmptyLine = new AtomicBoolean();
    private static final ObjectMapper SERIALIZER = new ObjectMapper().enable(DeserializationFeature.FAIL_ON_TRAILING_TOKENS).disable(DeserializationFeature.FAIL_ON_MISSING_CREATOR_PROPERTIES).disable(DeserializationFeature.FAIL_ON_NULL_CREATOR_PROPERTIES).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES).disable(DeserializationFeature.FAIL_ON_IGNORED_PROPERTIES);

    public OpenAIServerSentEvents(Flux<ByteBuffer> source, Class<T> type) {
        this.source = source;
        this.type = type;
    }

    public Flux<T> getEvents() {
        return this.source.concatMap(byteBuffer -> {
            try {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteBuffer.array());
                BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)byteArrayInputStream, StandardCharsets.UTF_8));
                String currentLine = this.getFirstDataLine(reader);
                currentLine = this.lastLine.get() + currentLine;
                ArrayList<Object> values = new ArrayList<Object>();
                while (currentLine != null) {
                    if ("data: [DONE]".equals(currentLine)) {
                        return Flux.fromIterable(values);
                    }
                    if (this.expectEmptyLine.get() && !currentLine.isEmpty()) {
                        return Flux.error((Throwable)new UnsupportedOperationException("Multi-line data not supported " + currentLine));
                    }
                    if (!this.expectEmptyLine.get()) {
                        this.expectEmptyLine.set(true);
                        String[] split = currentLine.split(":", 2);
                        if (split.length != 2) {
                            String line = reader.readLine();
                            if (line == null) {
                                this.lastLine.set(currentLine);
                                this.expectEmptyLine.set(false);
                                return Flux.fromIterable(values);
                            }
                            return Flux.error((Throwable)new IllegalStateException("Invalid data format " + currentLine));
                        }
                        String dataValue = split[1];
                        if (split[1].startsWith(" ")) {
                            dataValue = split[1].substring(1);
                        }
                        if (!dataValue.isEmpty() && OpenAIServerSentEvents.isValidJson(dataValue)) {
                            Object value = SERIALIZER.readValue(dataValue, this.type);
                            values.add(value);
                            this.lastLine.set("");
                        } else {
                            this.lastLine.set(currentLine);
                            this.expectEmptyLine.set(false);
                        }
                    } else {
                        this.expectEmptyLine.set(false);
                    }
                    currentLine = reader.readLine();
                }
                return Flux.fromIterable(values);
            }
            catch (IOException e) {
                return Flux.error((Throwable)e);
            }
        });
    }

    private String getFirstDataLine(BufferedReader reader) throws IOException {
        String currentLine = reader.readLine();
        if (currentLine != null && currentLine.isEmpty() && this.expectEmptyLine.get()) {
            currentLine = reader.readLine();
            if (currentLine != null && currentLine.isEmpty()) {
                currentLine = reader.readLine();
            }
            this.expectEmptyLine.set(false);
        }
        return currentLine;
    }

    private static boolean isValidJson(String json) {
        try {
            SERIALIZER.readTree(json);
            return true;
        }
        catch (JacksonException exception) {
            return false;
        }
    }
}

