/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.textanalytics;

import com.azure.ai.textanalytics.TextAnalyticsServiceVersion;
import com.azure.ai.textanalytics.implementation.MicrosoftCognitiveLanguageServiceTextAnalysisImpl;
import com.azure.ai.textanalytics.implementation.Utility;
import com.azure.ai.textanalytics.implementation.models.AnalyzeTextDynamicClassificationInput;
import com.azure.ai.textanalytics.implementation.models.ClassificationType;
import com.azure.ai.textanalytics.implementation.models.DynamicClassificationTaskParameters;
import com.azure.ai.textanalytics.implementation.models.ErrorResponseException;
import com.azure.ai.textanalytics.implementation.models.MultiLanguageAnalysisInput;
import com.azure.ai.textanalytics.models.DynamicClassifyOptions;
import com.azure.ai.textanalytics.models.TextDocumentInput;
import com.azure.ai.textanalytics.util.DynamicClassifyDocumentResultCollection;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.IterableStream;
import com.azure.core.util.logging.ClientLogger;
import java.util.Arrays;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;

class DynamicClassifyUtilClient {
    private static final ClientLogger LOGGER = new ClientLogger(DynamicClassifyUtilClient.class);
    private final MicrosoftCognitiveLanguageServiceTextAnalysisImpl service;
    private final TextAnalyticsServiceVersion serviceVersion;

    DynamicClassifyUtilClient(MicrosoftCognitiveLanguageServiceTextAnalysisImpl service, TextAnalyticsServiceVersion serviceVersion) {
        this.service = service;
        this.serviceVersion = serviceVersion;
    }

    Mono<Response<DynamicClassifyDocumentResultCollection>> dynamicClassifyBatch(Iterable<TextDocumentInput> documents, Iterable<String> categories, DynamicClassifyOptions options) {
        try {
            return FluxUtil.withContext(context -> this.getDynamicClassifyDocumentResultCollectionResponse(documents, categories, options, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    Mono<Response<DynamicClassifyDocumentResultCollection>> getDynamicClassifyDocumentResultCollectionResponse(Iterable<TextDocumentInput> documents, Iterable<String> categories, DynamicClassifyOptions options, Context context) {
        Utility.throwIfTargetServiceVersionFound(this.serviceVersion, Arrays.asList(TextAnalyticsServiceVersion.V3_0, TextAnalyticsServiceVersion.V3_1, TextAnalyticsServiceVersion.V2022_05_01), Utility.getUnsupportedServiceApiVersionMessage("Dynamic Classification", this.serviceVersion, TextAnalyticsServiceVersion.V2022_10_01_PREVIEW));
        Utility.inputDocumentsValidation(documents);
        options = this.getNotNullDynamicClassificationOptions(options);
        com.azure.ai.textanalytics.models.ClassificationType finalClassificationType = options.getClassificationType();
        return this.service.analyzeTextWithResponseAsync(new AnalyzeTextDynamicClassificationInput().setParameters(new DynamicClassificationTaskParameters().setCategories(IterableStream.of(categories).stream().collect(Collectors.toList())).setClassificationType(finalClassificationType == null ? null : ClassificationType.fromString(finalClassificationType.toString())).setModelVersion(options.getModelVersion()).setLoggingOptOut(options.isServiceLogsDisabled())).setAnalysisInput(new MultiLanguageAnalysisInput().setDocuments(Utility.toMultiLanguageInput(documents))), options.isIncludeStatistics(), Utility.getNotNullContext(context)).doOnSubscribe(ignoredValue -> LOGGER.info("A batch of documents with count - {}", new Object[]{Utility.getDocumentCount(documents)})).doOnSuccess(response -> LOGGER.info("Analyze dynamic classification for a batch of documents - {}", new Object[]{response})).doOnError(error -> LOGGER.warning("Failed to analyze dynamic classification - {}", new Object[]{error})).map(Utility::toDynamicClassifyDocumentResultCollectionResponse).onErrorMap(Utility::mapToHttpResponseExceptionIfExists);
    }

    Response<DynamicClassifyDocumentResultCollection> getResultCollectionResponseSync(Iterable<TextDocumentInput> documents, Iterable<String> categories, DynamicClassifyOptions options, Context context) {
        Utility.throwIfTargetServiceVersionFound(this.serviceVersion, Arrays.asList(TextAnalyticsServiceVersion.V3_0, TextAnalyticsServiceVersion.V3_1, TextAnalyticsServiceVersion.V2022_05_01), Utility.getUnsupportedServiceApiVersionMessage("Dynamic Classification", this.serviceVersion, TextAnalyticsServiceVersion.V2022_10_01_PREVIEW));
        Utility.inputDocumentsValidation(documents);
        options = this.getNotNullDynamicClassificationOptions(options);
        com.azure.ai.textanalytics.models.ClassificationType finalClassificationType = options.getClassificationType();
        try {
            return Utility.toDynamicClassifyDocumentResultCollectionResponse(this.service.analyzeTextWithResponse(new AnalyzeTextDynamicClassificationInput().setParameters(new DynamicClassificationTaskParameters().setCategories(IterableStream.of(categories).stream().collect(Collectors.toList())).setClassificationType(finalClassificationType == null ? null : ClassificationType.fromString(finalClassificationType.toString())).setModelVersion(options.getModelVersion()).setLoggingOptOut(options.isServiceLogsDisabled())).setAnalysisInput(new MultiLanguageAnalysisInput().setDocuments(Utility.toMultiLanguageInput(documents))), options.isIncludeStatistics(), Utility.enableSyncRestProxy(Utility.getNotNullContext(context))));
        }
        catch (ErrorResponseException ex) {
            throw LOGGER.logExceptionAsError((RuntimeException)Utility.getHttpResponseException(ex));
        }
    }

    private DynamicClassifyOptions getNotNullDynamicClassificationOptions(DynamicClassifyOptions options) {
        return options == null ? new DynamicClassifyOptions() : options;
    }
}

