/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.textanalytics.implementation;

import com.azure.ai.textanalytics.TextAnalyticsServiceVersion;
import com.azure.ai.textanalytics.implementation.AbstractSummaryResultCollectionPropertiesHelper;
import com.azure.ai.textanalytics.implementation.AbstractSummaryResultPropertiesHelper;
import com.azure.ai.textanalytics.implementation.AbstractiveSummaryPropertiesHelper;
import com.azure.ai.textanalytics.implementation.AgeResolutionPropertiesHelper;
import com.azure.ai.textanalytics.implementation.AnalyzeHealthcareEntitiesResultPropertiesHelper;
import com.azure.ai.textanalytics.implementation.AnalyzeSentimentResultPropertiesHelper;
import com.azure.ai.textanalytics.implementation.AreaResolutionPropertiesHelper;
import com.azure.ai.textanalytics.implementation.AssessmentSentimentPropertiesHelper;
import com.azure.ai.textanalytics.implementation.CategorizedEntityPropertiesHelper;
import com.azure.ai.textanalytics.implementation.ClassificationCategoryPropertiesHelper;
import com.azure.ai.textanalytics.implementation.ClassifyDocumentResultCollectionPropertiesHelper;
import com.azure.ai.textanalytics.implementation.ClassifyDocumentResultPropertiesHelper;
import com.azure.ai.textanalytics.implementation.CurrencyResolutionPropertiesHelper;
import com.azure.ai.textanalytics.implementation.DateTimeResolutionPropertiesHelper;
import com.azure.ai.textanalytics.implementation.DetectedLanguagePropertiesHelper;
import com.azure.ai.textanalytics.implementation.DynamicClassifyDocumentResultCollectionPropertiesHelper;
import com.azure.ai.textanalytics.implementation.EntityDataSourcePropertiesHelper;
import com.azure.ai.textanalytics.implementation.ExtractKeyPhraseResultPropertiesHelper;
import com.azure.ai.textanalytics.implementation.ExtractSummaryResultCollectionPropertiesHelper;
import com.azure.ai.textanalytics.implementation.ExtractSummaryResultPropertiesHelper;
import com.azure.ai.textanalytics.implementation.HealthcareEntityAssertionPropertiesHelper;
import com.azure.ai.textanalytics.implementation.HealthcareEntityPropertiesHelper;
import com.azure.ai.textanalytics.implementation.HealthcareEntityRelationPropertiesHelper;
import com.azure.ai.textanalytics.implementation.HealthcareEntityRelationRolePropertiesHelper;
import com.azure.ai.textanalytics.implementation.InformationResolutionPropertiesHelper;
import com.azure.ai.textanalytics.implementation.LengthResolutionPropertiesHelper;
import com.azure.ai.textanalytics.implementation.LinkedEntityMatchPropertiesHelper;
import com.azure.ai.textanalytics.implementation.LinkedEntityPropertiesHelper;
import com.azure.ai.textanalytics.implementation.NumberResolutionPropertiesHelper;
import com.azure.ai.textanalytics.implementation.NumericRangeResolutionPropertiesHelper;
import com.azure.ai.textanalytics.implementation.OrdinalResolutionPropertiesHelper;
import com.azure.ai.textanalytics.implementation.PiiEntityPropertiesHelper;
import com.azure.ai.textanalytics.implementation.RecognizeCustomEntitiesResultCollectionPropertiesHelper;
import com.azure.ai.textanalytics.implementation.RecognizeEntitiesResultPropertiesHelper;
import com.azure.ai.textanalytics.implementation.RecognizeLinkedEntitiesResultPropertiesHelper;
import com.azure.ai.textanalytics.implementation.RecognizePiiEntitiesResultPropertiesHelper;
import com.azure.ai.textanalytics.implementation.SentenceOpinionPropertiesHelper;
import com.azure.ai.textanalytics.implementation.SentenceSentimentPropertiesHelper;
import com.azure.ai.textanalytics.implementation.SpeedResolutionPropertiesHelper;
import com.azure.ai.textanalytics.implementation.SummaryContextPropertiesHelper;
import com.azure.ai.textanalytics.implementation.SummarySentencePropertiesHelper;
import com.azure.ai.textanalytics.implementation.TargetSentimentPropertiesHelper;
import com.azure.ai.textanalytics.implementation.TemperatureResolutionPropertiesHelper;
import com.azure.ai.textanalytics.implementation.TemporalSpanResolutionPropertiesHelper;
import com.azure.ai.textanalytics.implementation.VolumeResolutionPropertiesHelper;
import com.azure.ai.textanalytics.implementation.WeightResolutionPropertiesHelper;
import com.azure.ai.textanalytics.implementation.models.AbstractiveSummarizationResult;
import com.azure.ai.textanalytics.implementation.models.AbstractiveSummary;
import com.azure.ai.textanalytics.implementation.models.AbstractiveSummaryDocumentResultWithDetectedLanguage;
import com.azure.ai.textanalytics.implementation.models.AgeResolution;
import com.azure.ai.textanalytics.implementation.models.AnalyzeTextTaskResult;
import com.azure.ai.textanalytics.implementation.models.AreaResolution;
import com.azure.ai.textanalytics.implementation.models.Association;
import com.azure.ai.textanalytics.implementation.models.BaseResolution;
import com.azure.ai.textanalytics.implementation.models.Certainty;
import com.azure.ai.textanalytics.implementation.models.ClassificationResult;
import com.azure.ai.textanalytics.implementation.models.Conditionality;
import com.azure.ai.textanalytics.implementation.models.CurrencyResolution;
import com.azure.ai.textanalytics.implementation.models.CustomEntitiesResult;
import com.azure.ai.textanalytics.implementation.models.CustomEntitiesResultDocumentsItem;
import com.azure.ai.textanalytics.implementation.models.CustomLabelClassificationResult;
import com.azure.ai.textanalytics.implementation.models.CustomLabelClassificationResultDocumentsItem;
import com.azure.ai.textanalytics.implementation.models.DateTimeResolution;
import com.azure.ai.textanalytics.implementation.models.DetectedLanguage;
import com.azure.ai.textanalytics.implementation.models.DocumentError;
import com.azure.ai.textanalytics.implementation.models.DocumentLanguage;
import com.azure.ai.textanalytics.implementation.models.DocumentSentimentValue;
import com.azure.ai.textanalytics.implementation.models.DocumentStatistics;
import com.azure.ai.textanalytics.implementation.models.DocumentWarning;
import com.azure.ai.textanalytics.implementation.models.DynamicClassificationResult;
import com.azure.ai.textanalytics.implementation.models.DynamicClassificationResultDocumentsItem;
import com.azure.ai.textanalytics.implementation.models.DynamicClassificationTaskResult;
import com.azure.ai.textanalytics.implementation.models.EntitiesResult;
import com.azure.ai.textanalytics.implementation.models.EntitiesResultWithDetectedLanguage;
import com.azure.ai.textanalytics.implementation.models.EntitiesTaskResult;
import com.azure.ai.textanalytics.implementation.models.EntityLinkingResult;
import com.azure.ai.textanalytics.implementation.models.EntityLinkingTaskResult;
import com.azure.ai.textanalytics.implementation.models.Error;
import com.azure.ai.textanalytics.implementation.models.ErrorCode;
import com.azure.ai.textanalytics.implementation.models.ErrorResponse;
import com.azure.ai.textanalytics.implementation.models.ErrorResponseException;
import com.azure.ai.textanalytics.implementation.models.ExtractedSummaryDocumentResultWithDetectedLanguage;
import com.azure.ai.textanalytics.implementation.models.ExtractedSummarySentence;
import com.azure.ai.textanalytics.implementation.models.ExtractiveSummarizationResult;
import com.azure.ai.textanalytics.implementation.models.FhirVersion;
import com.azure.ai.textanalytics.implementation.models.HealthcareAssertion;
import com.azure.ai.textanalytics.implementation.models.HealthcareResult;
import com.azure.ai.textanalytics.implementation.models.InformationResolution;
import com.azure.ai.textanalytics.implementation.models.InnerErrorCode;
import com.azure.ai.textanalytics.implementation.models.InnerErrorModel;
import com.azure.ai.textanalytics.implementation.models.InputError;
import com.azure.ai.textanalytics.implementation.models.KeyPhraseResult;
import com.azure.ai.textanalytics.implementation.models.KeyPhraseResultDocumentsItem;
import com.azure.ai.textanalytics.implementation.models.KeyPhraseTaskResult;
import com.azure.ai.textanalytics.implementation.models.LanguageDetectionDocumentResult;
import com.azure.ai.textanalytics.implementation.models.LanguageDetectionResult;
import com.azure.ai.textanalytics.implementation.models.LanguageDetectionTaskResult;
import com.azure.ai.textanalytics.implementation.models.LanguageInput;
import com.azure.ai.textanalytics.implementation.models.LanguageResult;
import com.azure.ai.textanalytics.implementation.models.LengthResolution;
import com.azure.ai.textanalytics.implementation.models.MultiLanguageInput;
import com.azure.ai.textanalytics.implementation.models.NumberResolution;
import com.azure.ai.textanalytics.implementation.models.NumericRangeResolution;
import com.azure.ai.textanalytics.implementation.models.OrdinalResolution;
import com.azure.ai.textanalytics.implementation.models.PiiCategory;
import com.azure.ai.textanalytics.implementation.models.PiiResult;
import com.azure.ai.textanalytics.implementation.models.PiiTaskResult;
import com.azure.ai.textanalytics.implementation.models.RelationType;
import com.azure.ai.textanalytics.implementation.models.RequestStatistics;
import com.azure.ai.textanalytics.implementation.models.SentenceAssessment;
import com.azure.ai.textanalytics.implementation.models.SentenceSentiment;
import com.azure.ai.textanalytics.implementation.models.SentenceSentimentValue;
import com.azure.ai.textanalytics.implementation.models.SentenceTarget;
import com.azure.ai.textanalytics.implementation.models.SentimentConfidenceScorePerLabel;
import com.azure.ai.textanalytics.implementation.models.SentimentResponse;
import com.azure.ai.textanalytics.implementation.models.SentimentResponseDocumentsItem;
import com.azure.ai.textanalytics.implementation.models.SentimentTaskResult;
import com.azure.ai.textanalytics.implementation.models.SpeedResolution;
import com.azure.ai.textanalytics.implementation.models.SummaryContext;
import com.azure.ai.textanalytics.implementation.models.TargetConfidenceScoreLabel;
import com.azure.ai.textanalytics.implementation.models.TargetRelationType;
import com.azure.ai.textanalytics.implementation.models.TemperatureResolution;
import com.azure.ai.textanalytics.implementation.models.TemporalSpanResolution;
import com.azure.ai.textanalytics.implementation.models.VolumeResolution;
import com.azure.ai.textanalytics.implementation.models.WarningCodeValue;
import com.azure.ai.textanalytics.implementation.models.WeightResolution;
import com.azure.ai.textanalytics.models.AbstractSummaryResult;
import com.azure.ai.textanalytics.models.AgeUnit;
import com.azure.ai.textanalytics.models.AnalyzeHealthcareEntitiesResult;
import com.azure.ai.textanalytics.models.AnalyzeSentimentResult;
import com.azure.ai.textanalytics.models.AreaUnit;
import com.azure.ai.textanalytics.models.AssessmentSentiment;
import com.azure.ai.textanalytics.models.CategorizedEntity;
import com.azure.ai.textanalytics.models.CategorizedEntityCollection;
import com.azure.ai.textanalytics.models.ClassificationCategory;
import com.azure.ai.textanalytics.models.ClassifyDocumentResult;
import com.azure.ai.textanalytics.models.DateTimeSubKind;
import com.azure.ai.textanalytics.models.DetectLanguageInput;
import com.azure.ai.textanalytics.models.DetectLanguageResult;
import com.azure.ai.textanalytics.models.DocumentSentiment;
import com.azure.ai.textanalytics.models.EntityAssociation;
import com.azure.ai.textanalytics.models.EntityCategory;
import com.azure.ai.textanalytics.models.EntityCertainty;
import com.azure.ai.textanalytics.models.EntityConditionality;
import com.azure.ai.textanalytics.models.EntityDataSource;
import com.azure.ai.textanalytics.models.ExtractKeyPhraseResult;
import com.azure.ai.textanalytics.models.ExtractSummaryResult;
import com.azure.ai.textanalytics.models.HealthcareEntity;
import com.azure.ai.textanalytics.models.HealthcareEntityAssertion;
import com.azure.ai.textanalytics.models.HealthcareEntityCategory;
import com.azure.ai.textanalytics.models.HealthcareEntityRelation;
import com.azure.ai.textanalytics.models.HealthcareEntityRelationRole;
import com.azure.ai.textanalytics.models.HealthcareEntityRelationType;
import com.azure.ai.textanalytics.models.InformationUnit;
import com.azure.ai.textanalytics.models.KeyPhrasesCollection;
import com.azure.ai.textanalytics.models.LengthUnit;
import com.azure.ai.textanalytics.models.LinkedEntity;
import com.azure.ai.textanalytics.models.LinkedEntityCollection;
import com.azure.ai.textanalytics.models.LinkedEntityMatch;
import com.azure.ai.textanalytics.models.NumberKind;
import com.azure.ai.textanalytics.models.PiiEntity;
import com.azure.ai.textanalytics.models.PiiEntityCategory;
import com.azure.ai.textanalytics.models.PiiEntityCollection;
import com.azure.ai.textanalytics.models.RangeKind;
import com.azure.ai.textanalytics.models.RecognizeEntitiesResult;
import com.azure.ai.textanalytics.models.RecognizeLinkedEntitiesResult;
import com.azure.ai.textanalytics.models.RecognizePiiEntitiesResult;
import com.azure.ai.textanalytics.models.RelativeTo;
import com.azure.ai.textanalytics.models.ScriptKind;
import com.azure.ai.textanalytics.models.SentenceOpinion;
import com.azure.ai.textanalytics.models.SentimentConfidenceScores;
import com.azure.ai.textanalytics.models.SpeedUnit;
import com.azure.ai.textanalytics.models.SummarySentence;
import com.azure.ai.textanalytics.models.TargetSentiment;
import com.azure.ai.textanalytics.models.TemperatureUnit;
import com.azure.ai.textanalytics.models.TemporalModifier;
import com.azure.ai.textanalytics.models.TextAnalyticsError;
import com.azure.ai.textanalytics.models.TextAnalyticsErrorCode;
import com.azure.ai.textanalytics.models.TextAnalyticsException;
import com.azure.ai.textanalytics.models.TextAnalyticsWarning;
import com.azure.ai.textanalytics.models.TextDocumentBatchStatistics;
import com.azure.ai.textanalytics.models.TextDocumentInput;
import com.azure.ai.textanalytics.models.TextDocumentStatistics;
import com.azure.ai.textanalytics.models.TextSentiment;
import com.azure.ai.textanalytics.models.VolumeUnit;
import com.azure.ai.textanalytics.models.WarningCode;
import com.azure.ai.textanalytics.models.WeightUnit;
import com.azure.ai.textanalytics.util.AbstractSummaryResultCollection;
import com.azure.ai.textanalytics.util.AnalyzeHealthcareEntitiesResultCollection;
import com.azure.ai.textanalytics.util.AnalyzeSentimentResultCollection;
import com.azure.ai.textanalytics.util.ClassifyDocumentResultCollection;
import com.azure.ai.textanalytics.util.DetectLanguageResultCollection;
import com.azure.ai.textanalytics.util.DynamicClassifyDocumentResultCollection;
import com.azure.ai.textanalytics.util.ExtractKeyPhrasesResultCollection;
import com.azure.ai.textanalytics.util.ExtractSummaryResultCollection;
import com.azure.ai.textanalytics.util.RecognizeCustomEntitiesResultCollection;
import com.azure.ai.textanalytics.util.RecognizeEntitiesResultCollection;
import com.azure.ai.textanalytics.util.RecognizeLinkedEntitiesResultCollection;
import com.azure.ai.textanalytics.util.RecognizePiiEntitiesResultCollection;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.IterableStream;
import com.azure.core.util.logging.ClientLogger;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public final class Utility {
    public static final Duration DEFAULT_POLL_INTERVAL = Duration.ofSeconds(30L);
    public static final String HTTP_REST_PROXY_SYNC_PROXY_ENABLE = "com.azure.core.http.restproxy.syncproxy.enable";
    private static final ClientLogger LOGGER = new ClientLogger(Utility.class);
    private static final int NEUTRAL_SCORE_ZERO = 0;
    private static final int OPERATION_ID_LENGTH = 37;
    private static final String DOCUMENT_SENTENCES_ASSESSMENTS_REG_EXP = "#/documents/(\\d+)/sentences/(\\d+)/assessments/(\\d+)";
    private static final Pattern PATTERN = Pattern.compile("#/documents/(\\d+)/sentences/(\\d+)/assessments/(\\d+)");

    private Utility() {
    }

    public static void inputDocumentsValidation(Iterable<?> documents) {
        Objects.requireNonNull(documents, "'documents' cannot be null.");
        Iterator<?> iterator = documents.iterator();
        if (!iterator.hasNext()) {
            throw new IllegalArgumentException("'documents' cannot be empty.");
        }
    }

    public static Throwable mapToHttpResponseExceptionIfExists(Throwable throwable) {
        if (throwable instanceof ErrorResponseException) {
            return Utility.getHttpResponseException((ErrorResponseException)((Object)throwable));
        }
        return throwable;
    }

    public static HttpResponseException getHttpResponseException(ErrorResponseException errorException) {
        ErrorResponse errorResponse = errorException.getValue();
        TextAnalyticsError textAnalyticsError = null;
        if (errorResponse != null && errorResponse.getError() != null) {
            textAnalyticsError = Utility.toTextAnalyticsError(errorResponse.getError());
        }
        return new HttpResponseException(errorException.getMessage(), errorException.getResponse(), (Object)textAnalyticsError);
    }

    public static <T> List<T> mapByIndex(Iterable<String> documents, BiFunction<String, String, T> mappingFunction) {
        Objects.requireNonNull(documents, "'documents' cannot be null.");
        AtomicInteger i = new AtomicInteger(0);
        ArrayList result = new ArrayList();
        documents.forEach(document -> result.add(mappingFunction.apply(String.valueOf(i.getAndIncrement()), (String)document)));
        return result;
    }

    public static TextDocumentStatistics toTextDocumentStatistics(DocumentStatistics statistics) {
        return new TextDocumentStatistics(statistics.getCharactersCount(), statistics.getTransactionsCount());
    }

    public static TextDocumentBatchStatistics toBatchStatistics(RequestStatistics statistics) {
        return new TextDocumentBatchStatistics(statistics.getDocumentsCount(), statistics.getValidDocumentsCount(), statistics.getErroneousDocumentsCount(), statistics.getTransactionsCount());
    }

    public static TextAnalyticsError toTextAnalyticsError(Error error) {
        InnerErrorModel innerError = error.getInnererror();
        if (innerError == null) {
            ErrorCode errorCode = error.getCode();
            return new TextAnalyticsError(TextAnalyticsErrorCode.fromString(errorCode == null ? null : errorCode.toString()), error.getMessage(), error.getTarget());
        }
        InnerErrorCode innerErrorCodeValue = innerError.getCode();
        return new TextAnalyticsError(TextAnalyticsErrorCode.fromString(innerErrorCodeValue == null ? null : innerErrorCodeValue.toString()), innerError.getMessage(), innerError.getTarget());
    }

    public static TextAnalyticsWarning toTextAnalyticsWarning(DocumentWarning warning) {
        WarningCodeValue warningCodeValue = warning.getCode();
        return new TextAnalyticsWarning(WarningCode.fromString(warningCodeValue == null ? null : warningCodeValue.toString()), warning.getMessage());
    }

    public static List<MultiLanguageInput> toMultiLanguageInput(Iterable<TextDocumentInput> documents) {
        ArrayList<MultiLanguageInput> multiLanguageInputs = new ArrayList<MultiLanguageInput>();
        for (TextDocumentInput textDocumentInput : documents) {
            multiLanguageInputs.add(new MultiLanguageInput().setId(textDocumentInput.getId()).setText(textDocumentInput.getText()).setLanguage(textDocumentInput.getLanguage()));
        }
        return multiLanguageInputs;
    }

    public static TextAnalyticsException toTextAnalyticsException(TextAnalyticsError error) {
        return new TextAnalyticsException(error.getMessage(), error.getErrorCode(), error.getTarget());
    }

    public static List<LanguageInput> toLanguageInput(Iterable<DetectLanguageInput> documents) {
        ArrayList<LanguageInput> multiLanguageInputs = new ArrayList<LanguageInput>();
        documents.forEach(textDocumentInput -> multiLanguageInputs.add(new LanguageInput().setId(textDocumentInput.getId()).setText(textDocumentInput.getText()).setCountryHint(textDocumentInput.getCountryHint())));
        return multiLanguageInputs;
    }

    public static String parseOperationId(String operationLocation) {
        int indexBeforeOperationId;
        if (!CoreUtils.isNullOrEmpty((CharSequence)operationLocation) && (indexBeforeOperationId = operationLocation.lastIndexOf(47)) != -1) {
            return operationLocation.substring(indexBeforeOperationId + 1, indexBeforeOperationId + 37);
        }
        throw LOGGER.logExceptionAsError(new RuntimeException("Failed to parse operation header for operation Id from: " + operationLocation));
    }

    public static Map<String, Object> parseNextLink(String nextLink) {
        if (!CoreUtils.isNullOrEmpty((CharSequence)nextLink)) {
            String[] parameters;
            HashMap<String, Object> parameterMap = new HashMap<String, Object>();
            String[] strings = nextLink.split("\\?", 2);
            for (String parameter : parameters = strings[1].split("&")) {
                String[] parameterPair = parameter.split("=");
                String key = parameterPair[0];
                String value = parameterPair[1];
                if ("showStats".equals(key)) {
                    parameterMap.put(key, value);
                    continue;
                }
                if ("$skip".equals(key) || "$top".equals(key)) {
                    parameterMap.put(key, Integer.valueOf(value));
                    continue;
                }
                if (!"skip".equals(key) && !"top".equals(key)) continue;
                parameterMap.put("$" + key, Integer.valueOf(value));
            }
            return parameterMap;
        }
        return new HashMap<String, Object>();
    }

    public static Integer getTopContinuesToken(Map<String, Object> continuationTokenMap) {
        return continuationTokenMap.getOrDefault("$top", null);
    }

    public static Integer getSkipContinuesToken(Map<String, Object> continuationTokenMap) {
        return continuationTokenMap.getOrDefault("$skip", null);
    }

    public static Boolean getShowStatsContinuesToken(Map<String, Object> continuationTokenMap) {
        return continuationTokenMap.getOrDefault("showStats", null);
    }

    public static Response<AnalyzeSentimentResultCollection> toAnalyzeSentimentResultCollectionResponseLegacyApi(Response<SentimentResponse> response) {
        return new SimpleResponse(response, (Object)Utility.toAnalyzeSentimentResultCollection((SentimentResponse)response.getValue()));
    }

    public static Response<AnalyzeSentimentResultCollection> toAnalyzeSentimentResultCollectionResponseLanguageApi(Response<AnalyzeTextTaskResult> response) {
        return new SimpleResponse(response, (Object)Utility.toAnalyzeSentimentResultCollection(((SentimentTaskResult)response.getValue()).getResults()));
    }

    public static Response<DynamicClassifyDocumentResultCollection> toDynamicClassifyDocumentResultCollectionResponse(Response<AnalyzeTextTaskResult> response) {
        return new SimpleResponse(response, (Object)Utility.toDynamicClassificationResultCollection(((DynamicClassificationTaskResult)response.getValue()).getResults()));
    }

    public static Response<DetectLanguageResultCollection> toDetectLanguageResultCollectionLegacyApi(Response<LanguageResult> response) {
        LanguageResult languageResult = (LanguageResult)response.getValue();
        ArrayList<DetectLanguageResult> detectLanguageResults = new ArrayList<DetectLanguageResult>();
        for (DocumentLanguage documentLanguage : languageResult.getDocuments()) {
            DetectedLanguage detectedLanguage = documentLanguage.getDetectedLanguage();
            List warnings = documentLanguage.getWarnings().stream().map(warning -> Utility.toTextAnalyticsWarning(warning)).collect(Collectors.toList());
            detectLanguageResults.add(new DetectLanguageResult(documentLanguage.getId(), documentLanguage.getStatistics() == null ? null : Utility.toTextDocumentStatistics(documentLanguage.getStatistics()), null, new com.azure.ai.textanalytics.models.DetectedLanguage(detectedLanguage.getName(), detectedLanguage.getIso6391Name(), detectedLanguage.getConfidenceScore(), (IterableStream<TextAnalyticsWarning>)new IterableStream(warnings))));
        }
        for (DocumentError documentError : languageResult.getErrors()) {
            detectLanguageResults.add(new DetectLanguageResult(documentError.getId(), null, Utility.toTextAnalyticsError(documentError.getError()), null));
        }
        return new SimpleResponse(response, (Object)new DetectLanguageResultCollection(detectLanguageResults, languageResult.getModelVersion(), languageResult.getStatistics() == null ? null : Utility.toBatchStatistics(languageResult.getStatistics())));
    }

    public static Response<DetectLanguageResultCollection> toDetectLanguageResultCollectionLanguageApi(Response<AnalyzeTextTaskResult> response) {
        LanguageDetectionResult languageResult = ((LanguageDetectionTaskResult)response.getValue()).getResults();
        ArrayList<DetectLanguageResult> detectLanguageResults = new ArrayList<DetectLanguageResult>();
        for (LanguageDetectionDocumentResult documentLanguage : languageResult.getDocuments()) {
            DetectedLanguage detectedLanguage = documentLanguage.getDetectedLanguage();
            List warnings = documentLanguage.getWarnings().stream().map(warning -> Utility.toTextAnalyticsWarning(warning)).collect(Collectors.toList());
            detectLanguageResults.add(new DetectLanguageResult(documentLanguage.getId(), documentLanguage.getStatistics() == null ? null : Utility.toTextDocumentStatistics(documentLanguage.getStatistics()), null, new com.azure.ai.textanalytics.models.DetectedLanguage(detectedLanguage.getName(), detectedLanguage.getIso6391Name(), detectedLanguage.getConfidenceScore(), (IterableStream<TextAnalyticsWarning>)new IterableStream(warnings))));
        }
        for (InputError documentError : languageResult.getErrors()) {
            detectLanguageResults.add(new DetectLanguageResult(documentError.getId(), null, Utility.toTextAnalyticsError(documentError.getError()), null));
        }
        return new SimpleResponse(response, (Object)new DetectLanguageResultCollection(detectLanguageResults, languageResult.getModelVersion(), languageResult.getStatistics() == null ? null : Utility.toBatchStatistics(languageResult.getStatistics())));
    }

    public static com.azure.ai.textanalytics.models.DetectedLanguage toDetectedLanguage(DetectedLanguage detectedLanguageImpl) {
        com.azure.ai.textanalytics.models.DetectedLanguage detectedLanguage = new com.azure.ai.textanalytics.models.DetectedLanguage(detectedLanguageImpl.getName(), detectedLanguageImpl.getIso6391Name(), detectedLanguageImpl.getConfidenceScore(), null);
        if (detectedLanguageImpl.getScript() != null) {
            DetectedLanguagePropertiesHelper.setScriptKind(detectedLanguage, ScriptKind.fromString(detectedLanguageImpl.getScript().toString()));
        }
        return detectedLanguage;
    }

    public static Response<ExtractKeyPhrasesResultCollection> toResultCollectionResponseLegacyApi(Response<KeyPhraseResult> response) {
        KeyPhraseResult keyPhraseResult = (KeyPhraseResult)response.getValue();
        ArrayList<ExtractKeyPhraseResult> keyPhraseResultList = new ArrayList<ExtractKeyPhraseResult>();
        for (KeyPhraseResultDocumentsItem documentKeyPhrases : keyPhraseResult.getDocuments()) {
            String documentId = documentKeyPhrases.getId();
            keyPhraseResultList.add(new ExtractKeyPhraseResult(documentId, documentKeyPhrases.getStatistics() == null ? null : Utility.toTextDocumentStatistics(documentKeyPhrases.getStatistics()), null, new KeyPhrasesCollection((IterableStream<String>)new IterableStream(documentKeyPhrases.getKeyPhrases()), (IterableStream<TextAnalyticsWarning>)new IterableStream((Iterable)documentKeyPhrases.getWarnings().stream().map(warning -> Utility.toTextAnalyticsWarning(warning)).collect(Collectors.toList())))));
        }
        for (InputError documentError : keyPhraseResult.getErrors()) {
            keyPhraseResultList.add(new ExtractKeyPhraseResult(documentError.getId(), null, Utility.toTextAnalyticsError(documentError.getError()), null));
        }
        return new SimpleResponse(response, (Object)new ExtractKeyPhrasesResultCollection(keyPhraseResultList, keyPhraseResult.getModelVersion(), keyPhraseResult.getStatistics() == null ? null : Utility.toBatchStatistics(keyPhraseResult.getStatistics())));
    }

    public static Response<ExtractKeyPhrasesResultCollection> toResultCollectionResponseLanguageApi(Response<AnalyzeTextTaskResult> response) {
        KeyPhraseResult keyPhraseResult = ((KeyPhraseTaskResult)response.getValue()).getResults();
        ArrayList<ExtractKeyPhraseResult> keyPhraseResultList = new ArrayList<ExtractKeyPhraseResult>();
        for (KeyPhraseResultDocumentsItem documentKeyPhrases : keyPhraseResult.getDocuments()) {
            String documentId = documentKeyPhrases.getId();
            keyPhraseResultList.add(new ExtractKeyPhraseResult(documentId, documentKeyPhrases.getStatistics() == null ? null : Utility.toTextDocumentStatistics(documentKeyPhrases.getStatistics()), null, new KeyPhrasesCollection((IterableStream<String>)new IterableStream(documentKeyPhrases.getKeyPhrases()), (IterableStream<TextAnalyticsWarning>)new IterableStream((Iterable)documentKeyPhrases.getWarnings().stream().map(warning -> Utility.toTextAnalyticsWarning(warning)).collect(Collectors.toList())))));
        }
        for (InputError documentError : keyPhraseResult.getErrors()) {
            keyPhraseResultList.add(new ExtractKeyPhraseResult(documentError.getId(), null, Utility.toTextAnalyticsError(documentError.getError()), null));
        }
        return new SimpleResponse(response, (Object)new ExtractKeyPhrasesResultCollection(keyPhraseResultList, keyPhraseResult.getModelVersion(), keyPhraseResult.getStatistics() == null ? null : Utility.toBatchStatistics(keyPhraseResult.getStatistics())));
    }

    public static DynamicClassifyDocumentResultCollection toDynamicClassificationResultCollection(DynamicClassificationResult classificationResult) {
        ArrayList<ClassifyDocumentResult> dynamicClassificationResults = new ArrayList<ClassifyDocumentResult>();
        for (DynamicClassificationResultDocumentsItem documentItem : classificationResult.getDocuments()) {
            dynamicClassificationResults.add(Utility.toDynamicClassificationResult(documentItem));
        }
        for (InputError documentError : classificationResult.getErrors()) {
            dynamicClassificationResults.add(new ClassifyDocumentResult(documentError.getId(), null, Utility.toTextAnalyticsError(documentError.getError())));
        }
        DynamicClassifyDocumentResultCollection resultCollection = new DynamicClassifyDocumentResultCollection(dynamicClassificationResults);
        DynamicClassifyDocumentResultCollectionPropertiesHelper.setStatistics(resultCollection, Utility.toBatchStatistics(classificationResult.getStatistics()));
        DynamicClassifyDocumentResultCollectionPropertiesHelper.setModelVersion(resultCollection, classificationResult.getModelVersion());
        return resultCollection;
    }

    public static ClassifyDocumentResult toDynamicClassificationResult(DynamicClassificationResultDocumentsItem documentItem) {
        ClassifyDocumentResult classifyDocumentResult = new ClassifyDocumentResult(documentItem.getId(), documentItem.getStatistics() == null ? null : Utility.toTextDocumentStatistics(documentItem.getStatistics()), null);
        ClassifyDocumentResultPropertiesHelper.setClassifications(classifyDocumentResult, (IterableStream<ClassificationCategory>)new IterableStream(Utility.toDocumentClassifications(documentItem.getClassifications())));
        ClassifyDocumentResultPropertiesHelper.setWarnings(classifyDocumentResult, (IterableStream<TextAnalyticsWarning>)new IterableStream((Iterable)documentItem.getWarnings().stream().map(warning -> Utility.toTextAnalyticsWarning(warning)).collect(Collectors.toList())));
        return classifyDocumentResult;
    }

    public static RecognizeEntitiesResultCollection toRecognizeEntitiesResultCollection(EntitiesResult entitiesResult) {
        ArrayList<RecognizeEntitiesResult> recognizeEntitiesResults = new ArrayList<RecognizeEntitiesResult>();
        entitiesResult.getDocuments().forEach(documentEntities -> recognizeEntitiesResults.add(Utility.toRecognizeEntitiesResult(documentEntities)));
        for (InputError documentError : entitiesResult.getErrors()) {
            recognizeEntitiesResults.add(new RecognizeEntitiesResult(documentError.getId(), null, Utility.toTextAnalyticsError(documentError.getError()), null));
        }
        return new RecognizeEntitiesResultCollection(recognizeEntitiesResults, entitiesResult.getModelVersion(), entitiesResult.getStatistics() == null ? null : Utility.toBatchStatistics(entitiesResult.getStatistics()));
    }

    public static Response<RecognizeEntitiesResultCollection> toRecognizeEntitiesResultCollectionResponseLegacyApi(Response<EntitiesResult> response) {
        EntitiesResult entitiesResult = (EntitiesResult)response.getValue();
        return new SimpleResponse(response, (Object)new RecognizeEntitiesResultCollection(Utility.toRecognizeEntitiesResults(entitiesResult), entitiesResult.getModelVersion(), entitiesResult.getStatistics() == null ? null : Utility.toBatchStatistics(entitiesResult.getStatistics())));
    }

    public static Response<RecognizeEntitiesResultCollection> toRecognizeEntitiesResultCollectionResponseLanguageApi(Response<AnalyzeTextTaskResult> response) {
        EntitiesTaskResult entitiesTaskResult = (EntitiesTaskResult)response.getValue();
        EntitiesResult results = entitiesTaskResult.getResults();
        return new SimpleResponse(response, (Object)new RecognizeEntitiesResultCollection(Utility.toRecognizeEntitiesResults(results), results.getModelVersion(), results.getStatistics() == null ? null : Utility.toBatchStatistics(results.getStatistics())));
    }

    public static List<RecognizeEntitiesResult> toRecognizeEntitiesResults(EntitiesResult results) {
        ArrayList<RecognizeEntitiesResult> recognizeEntitiesResults = new ArrayList<RecognizeEntitiesResult>();
        results.getDocuments().forEach(documentEntities -> recognizeEntitiesResults.add(new RecognizeEntitiesResult(documentEntities.getId(), documentEntities.getStatistics() == null ? null : Utility.toTextDocumentStatistics(documentEntities.getStatistics()), null, new CategorizedEntityCollection((IterableStream<CategorizedEntity>)new IterableStream((Iterable)documentEntities.getEntities().stream().map(entity -> {
            CategorizedEntity categorizedEntity = new CategorizedEntity(entity.getText(), EntityCategory.fromString(entity.getCategory()), entity.getSubcategory(), entity.getConfidenceScore());
            CategorizedEntityPropertiesHelper.setLength(categorizedEntity, entity.getLength());
            CategorizedEntityPropertiesHelper.setOffset(categorizedEntity, entity.getOffset());
            CategorizedEntityPropertiesHelper.setResolutions(categorizedEntity, Utility.toBaseResolutions(entity.getResolutions()));
            return categorizedEntity;
        }).collect(Collectors.toList())), (IterableStream<TextAnalyticsWarning>)new IterableStream((Iterable)documentEntities.getWarnings().stream().map(warning -> Utility.toTextAnalyticsWarning(warning)).collect(Collectors.toList()))))));
        for (InputError documentError : results.getErrors()) {
            recognizeEntitiesResults.add(new RecognizeEntitiesResult(documentError.getId(), null, Utility.toTextAnalyticsError(documentError.getError()), null));
        }
        return recognizeEntitiesResults;
    }

    public static IterableStream<com.azure.ai.textanalytics.models.BaseResolution> toBaseResolutions(List<BaseResolution> resolutions) {
        if (resolutions == null) {
            return null;
        }
        ArrayList baseResolutions = new ArrayList();
        resolutions.forEach(resolution -> baseResolutions.add(Utility.toBaseResolution(resolution)));
        return new IterableStream(baseResolutions);
    }

    public static com.azure.ai.textanalytics.models.BaseResolution toBaseResolution(BaseResolution resolution) {
        if (resolution instanceof AgeResolution) {
            AgeResolution ageResolutionImpl = (AgeResolution)resolution;
            com.azure.ai.textanalytics.models.AgeResolution ageResolution = new com.azure.ai.textanalytics.models.AgeResolution();
            AgeResolutionPropertiesHelper.setUnit(ageResolution, AgeUnit.fromString(ageResolutionImpl.getUnit().toString()));
            AgeResolutionPropertiesHelper.setValue(ageResolution, ageResolutionImpl.getValue());
            return ageResolution;
        }
        if (resolution instanceof VolumeResolution) {
            VolumeResolution volumeResolutionImpl = (VolumeResolution)resolution;
            com.azure.ai.textanalytics.models.VolumeResolution volumeResolution = new com.azure.ai.textanalytics.models.VolumeResolution();
            VolumeResolutionPropertiesHelper.setUnit(volumeResolution, VolumeUnit.fromString(volumeResolutionImpl.getUnit().toString()));
            VolumeResolutionPropertiesHelper.setValue(volumeResolution, volumeResolutionImpl.getValue());
            return volumeResolution;
        }
        if (resolution instanceof SpeedResolution) {
            SpeedResolution speedResolutionImpl = (SpeedResolution)resolution;
            com.azure.ai.textanalytics.models.SpeedResolution speedResolution = new com.azure.ai.textanalytics.models.SpeedResolution();
            SpeedResolutionPropertiesHelper.setUnit(speedResolution, SpeedUnit.fromString(speedResolutionImpl.getUnit().toString()));
            SpeedResolutionPropertiesHelper.setValue(speedResolution, speedResolutionImpl.getValue());
            return speedResolution;
        }
        if (resolution instanceof AreaResolution) {
            AreaResolution areaResolutionImpl = (AreaResolution)resolution;
            com.azure.ai.textanalytics.models.AreaResolution areaResolution = new com.azure.ai.textanalytics.models.AreaResolution();
            AreaResolutionPropertiesHelper.setUnit(areaResolution, AreaUnit.fromString(areaResolutionImpl.getUnit().toString()));
            AreaResolutionPropertiesHelper.setValue(areaResolution, areaResolutionImpl.getValue());
            return areaResolution;
        }
        if (resolution instanceof LengthResolution) {
            LengthResolution lengthResolutionImpl = (LengthResolution)resolution;
            com.azure.ai.textanalytics.models.LengthResolution lengthResolution = new com.azure.ai.textanalytics.models.LengthResolution();
            LengthResolutionPropertiesHelper.setUnit(lengthResolution, LengthUnit.fromString(lengthResolutionImpl.getUnit().toString()));
            LengthResolutionPropertiesHelper.setValue(lengthResolution, lengthResolutionImpl.getValue());
            return lengthResolution;
        }
        if (resolution instanceof InformationResolution) {
            InformationResolution informationResolutionImpl = (InformationResolution)resolution;
            com.azure.ai.textanalytics.models.InformationResolution informationResolution = new com.azure.ai.textanalytics.models.InformationResolution();
            InformationResolutionPropertiesHelper.setUnit(informationResolution, InformationUnit.fromString(informationResolutionImpl.getUnit().toString()));
            InformationResolutionPropertiesHelper.setValue(informationResolution, informationResolutionImpl.getValue());
            return informationResolution;
        }
        if (resolution instanceof TemperatureResolution) {
            TemperatureResolution temperatureResolutionImpl = (TemperatureResolution)resolution;
            com.azure.ai.textanalytics.models.TemperatureResolution temperatureResolution = new com.azure.ai.textanalytics.models.TemperatureResolution();
            TemperatureResolutionPropertiesHelper.setUnit(temperatureResolution, TemperatureUnit.fromString(temperatureResolutionImpl.getUnit().toString()));
            TemperatureResolutionPropertiesHelper.setValue(temperatureResolution, temperatureResolutionImpl.getValue());
            return temperatureResolution;
        }
        if (resolution instanceof WeightResolution) {
            WeightResolution weightResolutionImpl = (WeightResolution)resolution;
            com.azure.ai.textanalytics.models.WeightResolution weightResolution = new com.azure.ai.textanalytics.models.WeightResolution();
            WeightResolutionPropertiesHelper.setUnit(weightResolution, WeightUnit.fromString(weightResolutionImpl.getUnit().toString()));
            WeightResolutionPropertiesHelper.setValue(weightResolution, weightResolutionImpl.getValue());
            return weightResolution;
        }
        if (resolution instanceof CurrencyResolution) {
            CurrencyResolution currencyResolutionImpl = (CurrencyResolution)resolution;
            com.azure.ai.textanalytics.models.CurrencyResolution currencyResolution = new com.azure.ai.textanalytics.models.CurrencyResolution();
            CurrencyResolutionPropertiesHelper.setISO4217(currencyResolution, currencyResolutionImpl.getIso4217());
            CurrencyResolutionPropertiesHelper.setUnit(currencyResolution, currencyResolutionImpl.getUnit());
            CurrencyResolutionPropertiesHelper.setValue(currencyResolution, currencyResolutionImpl.getValue());
            return currencyResolution;
        }
        if (resolution instanceof DateTimeResolution) {
            DateTimeResolution dateTimeResolutionImpl = (DateTimeResolution)resolution;
            com.azure.ai.textanalytics.models.DateTimeResolution dateTimeResolution = new com.azure.ai.textanalytics.models.DateTimeResolution();
            DateTimeResolutionPropertiesHelper.setTimex(dateTimeResolution, dateTimeResolutionImpl.getTimex());
            DateTimeResolutionPropertiesHelper.setDateTimeSubKind(dateTimeResolution, DateTimeSubKind.fromString(dateTimeResolutionImpl.getDateTimeSubKind().toString()));
            DateTimeResolutionPropertiesHelper.setValue(dateTimeResolution, dateTimeResolutionImpl.getValue());
            DateTimeResolutionPropertiesHelper.setModifier(dateTimeResolution, TemporalModifier.fromString(dateTimeResolutionImpl.getModifier().toString()));
            return dateTimeResolution;
        }
        if (resolution instanceof NumberResolution) {
            NumberResolution numberResolutionImpl = (NumberResolution)resolution;
            com.azure.ai.textanalytics.models.NumberResolution numberResolution = new com.azure.ai.textanalytics.models.NumberResolution();
            NumberResolutionPropertiesHelper.setNumberKind(numberResolution, NumberKind.fromString(numberResolutionImpl.getNumberKind().toString()));
            NumberResolutionPropertiesHelper.setValue(numberResolution, numberResolutionImpl.getValue());
            return numberResolution;
        }
        if (resolution instanceof OrdinalResolution) {
            OrdinalResolution ordinalResolutionImpl = (OrdinalResolution)resolution;
            com.azure.ai.textanalytics.models.OrdinalResolution ordinalResolution = new com.azure.ai.textanalytics.models.OrdinalResolution();
            OrdinalResolutionPropertiesHelper.setOffset(ordinalResolution, ordinalResolutionImpl.getOffset());
            OrdinalResolutionPropertiesHelper.setRelativeTo(ordinalResolution, RelativeTo.fromString(ordinalResolutionImpl.getRelativeTo().toString()));
            OrdinalResolutionPropertiesHelper.setValue(ordinalResolution, ordinalResolutionImpl.getValue());
            return ordinalResolution;
        }
        if (resolution instanceof TemporalSpanResolution) {
            TemporalSpanResolution temporalSpanResolutionImpl = (TemporalSpanResolution)resolution;
            com.azure.ai.textanalytics.models.TemporalSpanResolution temporalSpanResolution = new com.azure.ai.textanalytics.models.TemporalSpanResolution();
            TemporalSpanResolutionPropertiesHelper.setBegin(temporalSpanResolution, temporalSpanResolutionImpl.getBegin());
            TemporalSpanResolutionPropertiesHelper.setEnd(temporalSpanResolution, temporalSpanResolutionImpl.getEnd());
            TemporalSpanResolutionPropertiesHelper.setDuration(temporalSpanResolution, temporalSpanResolutionImpl.getDuration());
            TemporalSpanResolutionPropertiesHelper.setModifier(temporalSpanResolution, TemporalModifier.fromString(temporalSpanResolutionImpl.getModifier().toString()));
            return temporalSpanResolution;
        }
        if (resolution instanceof NumericRangeResolution) {
            NumericRangeResolution numericRangeResolutionImpl = (NumericRangeResolution)resolution;
            com.azure.ai.textanalytics.models.NumericRangeResolution numericRangeResolution = new com.azure.ai.textanalytics.models.NumericRangeResolution();
            NumericRangeResolutionPropertiesHelper.setRangeKind(numericRangeResolution, RangeKind.fromString(numericRangeResolutionImpl.getRangeKind().toString()));
            NumericRangeResolutionPropertiesHelper.setMinimum(numericRangeResolution, numericRangeResolutionImpl.getMinimum());
            NumericRangeResolutionPropertiesHelper.setMaximum(numericRangeResolution, numericRangeResolutionImpl.getMaximum());
            return numericRangeResolution;
        }
        throw LOGGER.logExceptionAsError(new RuntimeException("Unknown Resolution type: " + resolution.getClass()));
    }

    public static RecognizeEntitiesResult toRecognizeEntitiesResult(EntitiesResultWithDetectedLanguage documentEntities) {
        RecognizeEntitiesResult recognizeEntitiesResult = new RecognizeEntitiesResult(documentEntities.getId(), documentEntities.getStatistics() == null ? null : Utility.toTextDocumentStatistics(documentEntities.getStatistics()), null, new CategorizedEntityCollection((IterableStream<CategorizedEntity>)new IterableStream((Iterable)documentEntities.getEntities().stream().map(entity -> {
            CategorizedEntity categorizedEntity = new CategorizedEntity(entity.getText(), EntityCategory.fromString(entity.getCategory()), entity.getSubcategory(), entity.getConfidenceScore());
            CategorizedEntityPropertiesHelper.setLength(categorizedEntity, entity.getLength());
            CategorizedEntityPropertiesHelper.setOffset(categorizedEntity, entity.getOffset());
            CategorizedEntityPropertiesHelper.setResolutions(categorizedEntity, Utility.toBaseResolutions(entity.getResolutions()));
            return categorizedEntity;
        }).collect(Collectors.toList())), (IterableStream<TextAnalyticsWarning>)new IterableStream((Iterable)documentEntities.getWarnings().stream().map(warning -> Utility.toTextAnalyticsWarning(warning)).collect(Collectors.toList()))));
        if (documentEntities.getDetectedLanguage() != null) {
            RecognizeEntitiesResultPropertiesHelper.setDetectedLanguage(recognizeEntitiesResult, Utility.toDetectedLanguage(documentEntities.getDetectedLanguage()));
        }
        return recognizeEntitiesResult;
    }

    public static RecognizeEntitiesResult toRecognizeEntitiesResult(CustomEntitiesResultDocumentsItem documentEntities) {
        RecognizeEntitiesResult recognizeEntitiesResult = new RecognizeEntitiesResult(documentEntities.getId(), documentEntities.getStatistics() == null ? null : Utility.toTextDocumentStatistics(documentEntities.getStatistics()), null, new CategorizedEntityCollection((IterableStream<CategorizedEntity>)new IterableStream((Iterable)documentEntities.getEntities().stream().map(entity -> {
            CategorizedEntity categorizedEntity = new CategorizedEntity(entity.getText(), EntityCategory.fromString(entity.getCategory()), entity.getSubcategory(), entity.getConfidenceScore());
            CategorizedEntityPropertiesHelper.setLength(categorizedEntity, entity.getLength());
            CategorizedEntityPropertiesHelper.setOffset(categorizedEntity, entity.getOffset());
            CategorizedEntityPropertiesHelper.setResolutions(categorizedEntity, Utility.toBaseResolutions(entity.getResolutions()));
            return categorizedEntity;
        }).collect(Collectors.toList())), (IterableStream<TextAnalyticsWarning>)new IterableStream((Iterable)documentEntities.getWarnings().stream().map(warning -> Utility.toTextAnalyticsWarning(warning)).collect(Collectors.toList()))));
        if (documentEntities.getDetectedLanguage() != null) {
            RecognizeEntitiesResultPropertiesHelper.setDetectedLanguage(recognizeEntitiesResult, Utility.toDetectedLanguage(documentEntities.getDetectedLanguage()));
        }
        return recognizeEntitiesResult;
    }

    public static Response<RecognizePiiEntitiesResultCollection> toRecognizePiiEntitiesResultCollectionResponseLegacyApi(Response<PiiResult> response) {
        return new SimpleResponse(response, (Object)Utility.toRecognizePiiEntitiesResultCollection((PiiResult)response.getValue()));
    }

    public static Response<RecognizePiiEntitiesResultCollection> toRecognizePiiEntitiesResultCollectionResponseLanguageApi(Response<AnalyzeTextTaskResult> response) {
        return new SimpleResponse(response, (Object)Utility.toRecognizePiiEntitiesResultCollection(((PiiTaskResult)response.getValue()).getResults()));
    }

    public static RecognizePiiEntitiesResultCollection toRecognizePiiEntitiesResultCollection(PiiResult piiEntitiesResult) {
        ArrayList<RecognizePiiEntitiesResult> recognizePiiEntitiesResults = new ArrayList<RecognizePiiEntitiesResult>();
        piiEntitiesResult.getDocuments().forEach(documentEntities -> {
            List piiEntities = documentEntities.getEntities().stream().map(entity -> {
                PiiEntity piiEntity = new PiiEntity();
                PiiEntityPropertiesHelper.setText(piiEntity, entity.getText());
                PiiEntityPropertiesHelper.setCategory(piiEntity, PiiEntityCategory.fromString(entity.getCategory()));
                PiiEntityPropertiesHelper.setSubcategory(piiEntity, entity.getSubcategory());
                PiiEntityPropertiesHelper.setConfidenceScore(piiEntity, entity.getConfidenceScore());
                PiiEntityPropertiesHelper.setOffset(piiEntity, entity.getOffset());
                PiiEntityPropertiesHelper.setLength(piiEntity, entity.getLength());
                return piiEntity;
            }).collect(Collectors.toList());
            List warnings = documentEntities.getWarnings().stream().map(warning -> Utility.toTextAnalyticsWarning(warning)).collect(Collectors.toList());
            RecognizePiiEntitiesResult recognizePiiEntitiesResult = new RecognizePiiEntitiesResult(documentEntities.getId(), documentEntities.getStatistics() == null ? null : Utility.toTextDocumentStatistics(documentEntities.getStatistics()), null, new PiiEntityCollection((IterableStream<PiiEntity>)new IterableStream(piiEntities), documentEntities.getRedactedText(), (IterableStream<TextAnalyticsWarning>)new IterableStream(warnings)));
            if (documentEntities.getDetectedLanguage() != null) {
                RecognizePiiEntitiesResultPropertiesHelper.setDetectedLanguage(recognizePiiEntitiesResult, Utility.toDetectedLanguage(documentEntities.getDetectedLanguage()));
            }
            recognizePiiEntitiesResults.add(recognizePiiEntitiesResult);
        });
        for (InputError documentError : piiEntitiesResult.getErrors()) {
            recognizePiiEntitiesResults.add(new RecognizePiiEntitiesResult(documentError.getId(), null, Utility.toTextAnalyticsError(documentError.getError()), null));
        }
        return new RecognizePiiEntitiesResultCollection(recognizePiiEntitiesResults, piiEntitiesResult.getModelVersion(), piiEntitiesResult.getStatistics() == null ? null : Utility.toBatchStatistics(piiEntitiesResult.getStatistics()));
    }

    public static ExtractKeyPhrasesResultCollection toExtractKeyPhrasesResultCollection(KeyPhraseResult keyPhraseResult) {
        ArrayList<ExtractKeyPhraseResult> keyPhraseResultList = new ArrayList<ExtractKeyPhraseResult>();
        for (KeyPhraseResultDocumentsItem documentKeyPhrases : keyPhraseResult.getDocuments()) {
            String documentId = documentKeyPhrases.getId();
            ExtractKeyPhraseResult extractKeyPhraseResult = new ExtractKeyPhraseResult(documentId, documentKeyPhrases.getStatistics() == null ? null : Utility.toTextDocumentStatistics(documentKeyPhrases.getStatistics()), null, new KeyPhrasesCollection((IterableStream<String>)new IterableStream(documentKeyPhrases.getKeyPhrases()), (IterableStream<TextAnalyticsWarning>)new IterableStream((Iterable)documentKeyPhrases.getWarnings().stream().map(warning -> Utility.toTextAnalyticsWarning(warning)).collect(Collectors.toList()))));
            if (documentKeyPhrases.getDetectedLanguage() != null) {
                ExtractKeyPhraseResultPropertiesHelper.setDetectedLanguage(extractKeyPhraseResult, Utility.toDetectedLanguage(documentKeyPhrases.getDetectedLanguage()));
            }
            keyPhraseResultList.add(extractKeyPhraseResult);
        }
        for (InputError documentError : keyPhraseResult.getErrors()) {
            keyPhraseResultList.add(new ExtractKeyPhraseResult(documentError.getId(), null, Utility.toTextAnalyticsError(documentError.getError()), null));
        }
        return new ExtractKeyPhrasesResultCollection(keyPhraseResultList, keyPhraseResult.getModelVersion(), keyPhraseResult.getStatistics() == null ? null : Utility.toBatchStatistics(keyPhraseResult.getStatistics()));
    }

    public static Response<RecognizeLinkedEntitiesResultCollection> toRecognizeLinkedEntitiesResultCollectionResponseLegacyApi(Response<EntityLinkingResult> response) {
        return new SimpleResponse(response, (Object)Utility.toRecognizeLinkedEntitiesResultCollection((EntityLinkingResult)response.getValue()));
    }

    public static Response<RecognizeLinkedEntitiesResultCollection> toRecognizeLinkedEntitiesResultCollectionResponseLanguageApi(Response<AnalyzeTextTaskResult> response) {
        return new SimpleResponse(response, (Object)Utility.toRecognizeLinkedEntitiesResultCollection(((EntityLinkingTaskResult)response.getValue()).getResults()));
    }

    public static RecognizeLinkedEntitiesResultCollection toRecognizeLinkedEntitiesResultCollection(EntityLinkingResult entityLinkingResult) {
        List<RecognizeLinkedEntitiesResult> linkedEntitiesResults = entityLinkingResult.getDocuments().stream().map(documentLinkedEntities -> {
            RecognizeLinkedEntitiesResult recognizeLinkedEntitiesResult = new RecognizeLinkedEntitiesResult(documentLinkedEntities.getId(), documentLinkedEntities.getStatistics() == null ? null : Utility.toTextDocumentStatistics(documentLinkedEntities.getStatistics()), null, new LinkedEntityCollection((IterableStream<LinkedEntity>)new IterableStream((Iterable)documentLinkedEntities.getEntities().stream().map(linkedEntity -> {
                LinkedEntity entity = new LinkedEntity(linkedEntity.getName(), (IterableStream<LinkedEntityMatch>)new IterableStream((Iterable)linkedEntity.getMatches().stream().map(match -> {
                    LinkedEntityMatch linkedEntityMatch = new LinkedEntityMatch(match.getText(), match.getConfidenceScore());
                    LinkedEntityMatchPropertiesHelper.setOffset(linkedEntityMatch, match.getOffset());
                    LinkedEntityMatchPropertiesHelper.setLength(linkedEntityMatch, match.getLength());
                    return linkedEntityMatch;
                }).collect(Collectors.toList())), linkedEntity.getLanguage(), linkedEntity.getId(), linkedEntity.getUrl(), linkedEntity.getDataSource());
                LinkedEntityPropertiesHelper.setBingEntitySearchApiId(entity, linkedEntity.getBingId());
                return entity;
            }).collect(Collectors.toList())), (IterableStream<TextAnalyticsWarning>)new IterableStream((Iterable)documentLinkedEntities.getWarnings().stream().map(warning -> Utility.toTextAnalyticsWarning(warning)).collect(Collectors.toList()))));
            if (documentLinkedEntities.getDetectedLanguage() != null) {
                RecognizeLinkedEntitiesResultPropertiesHelper.setDetectedLanguage(recognizeLinkedEntitiesResult, Utility.toDetectedLanguage(documentLinkedEntities.getDetectedLanguage()));
            }
            return recognizeLinkedEntitiesResult;
        }).collect(Collectors.toList());
        for (InputError documentError : entityLinkingResult.getErrors()) {
            linkedEntitiesResults.add(new RecognizeLinkedEntitiesResult(documentError.getId(), null, Utility.toTextAnalyticsError(documentError.getError()), null));
        }
        return new RecognizeLinkedEntitiesResultCollection(linkedEntitiesResults, entityLinkingResult.getModelVersion(), entityLinkingResult.getStatistics() == null ? null : Utility.toBatchStatistics(entityLinkingResult.getStatistics()));
    }

    public static AnalyzeSentimentResultCollection toAnalyzeSentimentResultCollection(SentimentResponse sentimentResponse) {
        ArrayList<AnalyzeSentimentResult> analyzeSentimentResults = new ArrayList<AnalyzeSentimentResult>();
        List<SentimentResponseDocumentsItem> documentSentiments = sentimentResponse.getDocuments();
        for (SentimentResponseDocumentsItem documentSentiment : documentSentiments) {
            analyzeSentimentResults.add(Utility.toAnalyzeSentimentResult(documentSentiment, documentSentiments));
        }
        for (InputError documentError : sentimentResponse.getErrors()) {
            analyzeSentimentResults.add(new AnalyzeSentimentResult(documentError.getId(), null, Utility.toTextAnalyticsError(documentError.getError()), null));
        }
        return new AnalyzeSentimentResultCollection(analyzeSentimentResults, sentimentResponse.getModelVersion(), sentimentResponse.getStatistics() == null ? null : Utility.toBatchStatistics(sentimentResponse.getStatistics()));
    }

    public static AnalyzeHealthcareEntitiesResultCollection toAnalyzeHealthcareEntitiesResultCollection(HealthcareResult healthcareResult) {
        ArrayList analyzeHealthcareEntitiesResults = new ArrayList();
        healthcareResult.getDocuments().forEach(documentEntities -> {
            AnalyzeHealthcareEntitiesResult analyzeHealthcareEntitiesResult = new AnalyzeHealthcareEntitiesResult(documentEntities.getId(), documentEntities.getStatistics() == null ? null : Utility.toTextDocumentStatistics(documentEntities.getStatistics()), null);
            List warnings = documentEntities.getWarnings().stream().map(textAnalyticsWarning -> new TextAnalyticsWarning(Optional.ofNullable(textAnalyticsWarning.getCode()).map(warningCodeValue -> WarningCode.fromString(warningCodeValue.toString())).orElse(null), textAnalyticsWarning.getMessage())).collect(Collectors.toList());
            AnalyzeHealthcareEntitiesResultPropertiesHelper.setWarnings(analyzeHealthcareEntitiesResult, (IterableStream<TextAnalyticsWarning>)IterableStream.of(warnings));
            List healthcareEntities = documentEntities.getEntities().stream().map(entity -> {
                HealthcareEntity healthcareEntity = new HealthcareEntity();
                HealthcareEntityPropertiesHelper.setText(healthcareEntity, entity.getText());
                HealthcareEntityPropertiesHelper.setNormalizedText(healthcareEntity, entity.getName());
                if (entity.getCategory() != null) {
                    HealthcareEntityPropertiesHelper.setCategory(healthcareEntity, HealthcareEntityCategory.fromString(entity.getCategory().toString()));
                }
                HealthcareEntityPropertiesHelper.setConfidenceScore(healthcareEntity, entity.getConfidenceScore());
                HealthcareEntityPropertiesHelper.setOffset(healthcareEntity, entity.getOffset());
                HealthcareEntityPropertiesHelper.setLength(healthcareEntity, entity.getLength());
                List entityDataSources = Optional.ofNullable(entity.getLinks()).map(links -> links.stream().map(link -> {
                    EntityDataSource dataSource = new EntityDataSource();
                    EntityDataSourcePropertiesHelper.setName(dataSource, link.getDataSource());
                    EntityDataSourcePropertiesHelper.setEntityId(dataSource, link.getId());
                    return dataSource;
                }).collect(Collectors.toList())).orElse(new ArrayList());
                HealthcareEntityPropertiesHelper.setDataSources(healthcareEntity, (IterableStream<EntityDataSource>)IterableStream.of((Iterable)entityDataSources));
                HealthcareAssertion assertion = entity.getAssertion();
                if (assertion != null) {
                    HealthcareEntityPropertiesHelper.setAssertion(healthcareEntity, Utility.toHealthcareEntityAssertion(assertion));
                }
                return healthcareEntity;
            }).collect(Collectors.toList());
            AnalyzeHealthcareEntitiesResultPropertiesHelper.setEntities(analyzeHealthcareEntitiesResult, (IterableStream<HealthcareEntity>)IterableStream.of(healthcareEntities));
            List healthcareEntityRelations = documentEntities.getRelations().stream().map(healthcareRelation -> {
                HealthcareEntityRelation entityRelation = new HealthcareEntityRelation();
                RelationType relationType = healthcareRelation.getRelationType();
                if (relationType != null) {
                    HealthcareEntityRelationPropertiesHelper.setRelationType(entityRelation, HealthcareEntityRelationType.fromString(relationType.toString()));
                }
                List relationRoles = healthcareRelation.getEntities().stream().map(relationEntity -> {
                    HealthcareEntityRelationRole relationRole = new HealthcareEntityRelationRole();
                    HealthcareEntityRelationRolePropertiesHelper.setName(relationRole, relationEntity.getRole());
                    HealthcareEntityRelationRolePropertiesHelper.setEntity(relationRole, (HealthcareEntity)healthcareEntities.get(Utility.getHealthcareEntityIndex(relationEntity.getRef())));
                    return relationRole;
                }).collect(Collectors.toList());
                HealthcareEntityRelationPropertiesHelper.setRoles(entityRelation, (IterableStream<HealthcareEntityRelationRole>)IterableStream.of(relationRoles));
                HealthcareEntityRelationPropertiesHelper.setConfidenceScore(entityRelation, healthcareRelation.getConfidenceScore());
                return entityRelation;
            }).collect(Collectors.toList());
            AnalyzeHealthcareEntitiesResultPropertiesHelper.setEntityRelations(analyzeHealthcareEntitiesResult, (IterableStream<HealthcareEntityRelation>)IterableStream.of(healthcareEntityRelations));
            AnalyzeHealthcareEntitiesResultPropertiesHelper.setFhirBundle(analyzeHealthcareEntitiesResult, documentEntities.getFhirBundle());
            if (documentEntities.getDetectedLanguage() != null) {
                AnalyzeHealthcareEntitiesResultPropertiesHelper.setDetectedLanguage(analyzeHealthcareEntitiesResult, Utility.toDetectedLanguage(new DetectedLanguage().setName(documentEntities.getDetectedLanguage())));
            }
            analyzeHealthcareEntitiesResults.add(analyzeHealthcareEntitiesResult);
        });
        healthcareResult.getErrors().forEach(documentError -> analyzeHealthcareEntitiesResults.add(new AnalyzeHealthcareEntitiesResult(documentError.getId(), null, Utility.toTextAnalyticsError(documentError.getError()))));
        return new AnalyzeHealthcareEntitiesResultCollection((Iterable<AnalyzeHealthcareEntitiesResult>)IterableStream.of(analyzeHealthcareEntitiesResults));
    }

    public static FhirVersion toFhirVersion(com.azure.ai.textanalytics.models.FhirVersion fhirVersion) {
        return fhirVersion == null ? null : FhirVersion.fromString(fhirVersion.toString());
    }

    public static HealthcareEntityAssertion toHealthcareEntityAssertion(HealthcareAssertion healthcareAssertion) {
        Association association = healthcareAssertion.getAssociation();
        Certainty certainty = healthcareAssertion.getCertainty();
        Conditionality conditionality = healthcareAssertion.getConditionality();
        HealthcareEntityAssertion entityAssertion = new HealthcareEntityAssertion();
        if (association != null) {
            HealthcareEntityAssertionPropertiesHelper.setAssociation(entityAssertion, EntityAssociation.fromString(association.toString()));
        }
        if (certainty != null) {
            HealthcareEntityAssertionPropertiesHelper.setCertainty(entityAssertion, Utility.toCertainty(certainty));
        }
        if (conditionality != null) {
            HealthcareEntityAssertionPropertiesHelper.setConditionality(entityAssertion, Utility.toConditionality(conditionality));
        }
        return entityAssertion;
    }

    private static EntityCertainty toCertainty(Certainty certainty) {
        EntityCertainty entityCertainty1 = null;
        switch (certainty) {
            case POSITIVE: {
                entityCertainty1 = EntityCertainty.POSITIVE;
                break;
            }
            case POSITIVE_POSSIBLE: {
                entityCertainty1 = EntityCertainty.POSITIVE_POSSIBLE;
                break;
            }
            case NEUTRAL_POSSIBLE: {
                entityCertainty1 = EntityCertainty.NEUTRAL_POSSIBLE;
                break;
            }
            case NEGATIVE_POSSIBLE: {
                entityCertainty1 = EntityCertainty.NEGATIVE_POSSIBLE;
                break;
            }
            case NEGATIVE: {
                entityCertainty1 = EntityCertainty.NEGATIVE;
                break;
            }
        }
        return entityCertainty1;
    }

    private static EntityConditionality toConditionality(Conditionality conditionality) {
        EntityConditionality conditionality1 = null;
        switch (conditionality) {
            case HYPOTHETICAL: {
                conditionality1 = EntityConditionality.HYPOTHETICAL;
                break;
            }
            case CONDITIONAL: {
                conditionality1 = EntityConditionality.CONDITIONAL;
                break;
            }
        }
        return conditionality1;
    }

    private static Integer getHealthcareEntityIndex(String entityReference) {
        int lastIndex;
        if (!CoreUtils.isNullOrEmpty((CharSequence)entityReference) && (lastIndex = entityReference.lastIndexOf(47)) != -1) {
            return Integer.parseInt(entityReference.substring(lastIndex + 1));
        }
        throw LOGGER.logExceptionAsError(new RuntimeException("Failed to parse healthcare entity index from: " + entityReference));
    }

    public static Context enableSyncRestProxy(Context context) {
        return context.addData((Object)HTTP_REST_PROXY_SYNC_PROXY_ENABLE, (Object)true);
    }

    public static Context getNotNullContext(Context context) {
        return context == null ? Context.NONE : context;
    }

    public static int getDocumentCount(Iterable<?> documents) {
        if (documents instanceof Collection) {
            return ((Collection)documents).size();
        }
        int[] count = new int[]{0};
        documents.forEach(ignored -> {
            count[0] = count[0] + 1;
        });
        return count[0];
    }

    public static List<PiiCategory> toCategoriesFilter(Iterable<PiiEntityCategory> categoriesFilter) {
        if (categoriesFilter == null) {
            return null;
        }
        ArrayList<PiiCategory> piiCategories = new ArrayList<PiiCategory>();
        categoriesFilter.forEach(category -> piiCategories.add(PiiCategory.fromString(category.toString())));
        return piiCategories;
    }

    private static AnalyzeSentimentResult toAnalyzeSentimentResult(SentimentResponseDocumentsItem documentSentiment, List<SentimentResponseDocumentsItem> documentSentimentList) {
        SentimentConfidenceScorePerLabel confidenceScorePerLabel = documentSentiment.getConfidenceScores();
        List sentenceSentiments = documentSentiment.getSentences().stream().map(sentenceSentiment -> {
            SentimentConfidenceScorePerLabel confidenceScorePerSentence = sentenceSentiment.getConfidenceScores();
            SentenceSentimentValue sentenceSentimentValue = sentenceSentiment.getSentiment();
            com.azure.ai.textanalytics.models.SentenceSentiment sentenceSentiment1 = new com.azure.ai.textanalytics.models.SentenceSentiment(sentenceSentiment.getText(), TextSentiment.fromString(sentenceSentimentValue == null ? null : sentenceSentimentValue.toString()), new SentimentConfidenceScores(confidenceScorePerSentence.getNegative(), confidenceScorePerSentence.getNeutral(), confidenceScorePerSentence.getPositive()));
            SentenceSentimentPropertiesHelper.setOpinions(sentenceSentiment1, Utility.toSentenceOpinionList(sentenceSentiment, documentSentimentList));
            SentenceSentimentPropertiesHelper.setOffset(sentenceSentiment1, sentenceSentiment.getOffset());
            SentenceSentimentPropertiesHelper.setLength(sentenceSentiment1, sentenceSentiment.getLength());
            return sentenceSentiment1;
        }).collect(Collectors.toList());
        List warnings = documentSentiment.getWarnings().stream().map(warning -> Utility.toTextAnalyticsWarning(warning)).collect(Collectors.toList());
        DocumentSentimentValue documentSentimentValue = documentSentiment.getSentiment();
        AnalyzeSentimentResult analyzeSentimentResult = new AnalyzeSentimentResult(documentSentiment.getId(), documentSentiment.getStatistics() == null ? null : Utility.toTextDocumentStatistics(documentSentiment.getStatistics()), null, new DocumentSentiment(TextSentiment.fromString(documentSentimentValue == null ? null : documentSentimentValue.toString()), new SentimentConfidenceScores(confidenceScorePerLabel.getNegative(), confidenceScorePerLabel.getNeutral(), confidenceScorePerLabel.getPositive()), (IterableStream<com.azure.ai.textanalytics.models.SentenceSentiment>)new IterableStream(sentenceSentiments), (IterableStream<TextAnalyticsWarning>)new IterableStream(warnings)));
        if (documentSentiment.getDetectedLanguage() != null) {
            AnalyzeSentimentResultPropertiesHelper.setDetectedLanguage(analyzeSentimentResult, Utility.toDetectedLanguage(documentSentiment.getDetectedLanguage()));
        }
        return analyzeSentimentResult;
    }

    private static IterableStream<SentenceOpinion> toSentenceOpinionList(SentenceSentiment sentenceSentiment, List<SentimentResponseDocumentsItem> documentSentimentList) {
        List<SentenceTarget> sentenceTargets = sentenceSentiment.getTargets();
        if (sentenceTargets == null) {
            return null;
        }
        ArrayList sentenceOpinions = new ArrayList();
        sentenceTargets.forEach(sentenceTarget -> {
            ArrayList assessmentSentiments = new ArrayList();
            sentenceTarget.getRelations().forEach(targetRelation -> {
                TargetRelationType targetRelationType = targetRelation.getRelationType();
                String opinionPointer = targetRelation.getRef();
                if (TargetRelationType.ASSESSMENT == targetRelationType) {
                    assessmentSentiments.add(Utility.toAssessmentSentiment(Utility.findSentimentAssessment(opinionPointer, documentSentimentList)));
                }
            });
            TargetSentiment targetSentiment = new TargetSentiment();
            TargetSentimentPropertiesHelper.setText(targetSentiment, sentenceTarget.getText());
            TargetSentimentPropertiesHelper.setSentiment(targetSentiment, TextSentiment.fromString(sentenceTarget.getSentiment().toString()));
            TargetSentimentPropertiesHelper.setConfidenceScores(targetSentiment, Utility.toSentimentConfidenceScores(sentenceTarget.getConfidenceScores()));
            TargetSentimentPropertiesHelper.setOffset(targetSentiment, sentenceTarget.getOffset());
            TargetSentimentPropertiesHelper.setLength(targetSentiment, sentenceTarget.getLength());
            SentenceOpinion sentenceOpinion = new SentenceOpinion();
            SentenceOpinionPropertiesHelper.setTarget(sentenceOpinion, targetSentiment);
            SentenceOpinionPropertiesHelper.setAssessments(sentenceOpinion, (IterableStream<AssessmentSentiment>)new IterableStream(assessmentSentiments));
            sentenceOpinions.add(sentenceOpinion);
        });
        return new IterableStream(sentenceOpinions);
    }

    private static SentimentConfidenceScores toSentimentConfidenceScores(TargetConfidenceScoreLabel targetConfidenceScoreLabel) {
        return new SentimentConfidenceScores(targetConfidenceScoreLabel.getNegative(), 0.0, targetConfidenceScoreLabel.getPositive());
    }

    private static AssessmentSentiment toAssessmentSentiment(SentenceAssessment sentenceAssessment) {
        AssessmentSentiment assessmentSentiment = new AssessmentSentiment();
        AssessmentSentimentPropertiesHelper.setText(assessmentSentiment, sentenceAssessment.getText());
        AssessmentSentimentPropertiesHelper.setSentiment(assessmentSentiment, TextSentiment.fromString(sentenceAssessment.getSentiment().toString()));
        AssessmentSentimentPropertiesHelper.setConfidenceScores(assessmentSentiment, Utility.toSentimentConfidenceScores(sentenceAssessment.getConfidenceScores()));
        AssessmentSentimentPropertiesHelper.setNegated(assessmentSentiment, sentenceAssessment.isNegated());
        AssessmentSentimentPropertiesHelper.setOffset(assessmentSentiment, sentenceAssessment.getOffset());
        AssessmentSentimentPropertiesHelper.setLength(assessmentSentiment, sentenceAssessment.getLength());
        return assessmentSentiment;
    }

    public static RecognizeCustomEntitiesResultCollection toRecognizeCustomEntitiesResultCollection(CustomEntitiesResult customEntitiesResult) {
        ArrayList<RecognizeEntitiesResult> recognizeEntitiesResults = new ArrayList<RecognizeEntitiesResult>();
        List<CustomEntitiesResultDocumentsItem> customEntitiesResultDocuments = customEntitiesResult.getDocuments();
        for (CustomEntitiesResultDocumentsItem documentSummary : customEntitiesResultDocuments) {
            recognizeEntitiesResults.add(Utility.toRecognizeEntitiesResult(documentSummary));
        }
        for (DocumentError documentError : customEntitiesResult.getErrors()) {
            recognizeEntitiesResults.add(new RecognizeEntitiesResult(documentError.getId(), null, Utility.toTextAnalyticsError(documentError.getError()), null));
        }
        RecognizeCustomEntitiesResultCollection resultCollection = new RecognizeCustomEntitiesResultCollection(recognizeEntitiesResults);
        RecognizeCustomEntitiesResultCollectionPropertiesHelper.setProjectName(resultCollection, customEntitiesResult.getProjectName());
        RecognizeCustomEntitiesResultCollectionPropertiesHelper.setDeploymentName(resultCollection, customEntitiesResult.getDeploymentName());
        if (customEntitiesResult.getStatistics() != null) {
            RecognizeCustomEntitiesResultCollectionPropertiesHelper.setStatistics(resultCollection, Utility.toBatchStatistics(customEntitiesResult.getStatistics()));
        }
        return resultCollection;
    }

    public static ClassifyDocumentResultCollection toLabelClassificationResultCollection(CustomLabelClassificationResult customSingleClassificationResult) {
        ArrayList<ClassifyDocumentResult> classifyDocumentResults = new ArrayList<ClassifyDocumentResult>();
        List<CustomLabelClassificationResultDocumentsItem> singleClassificationDocuments = customSingleClassificationResult.getDocuments();
        for (CustomLabelClassificationResultDocumentsItem documentSummary : singleClassificationDocuments) {
            classifyDocumentResults.add(Utility.toSingleCategoryClassifyResult(documentSummary));
        }
        for (DocumentError documentError : customSingleClassificationResult.getErrors()) {
            classifyDocumentResults.add(new ClassifyDocumentResult(documentError.getId(), null, Utility.toTextAnalyticsError(documentError.getError())));
        }
        ClassifyDocumentResultCollection resultCollection = new ClassifyDocumentResultCollection(classifyDocumentResults);
        ClassifyDocumentResultCollectionPropertiesHelper.setProjectName(resultCollection, customSingleClassificationResult.getProjectName());
        ClassifyDocumentResultCollectionPropertiesHelper.setDeploymentName(resultCollection, customSingleClassificationResult.getDeploymentName());
        if (customSingleClassificationResult.getStatistics() != null) {
            ClassifyDocumentResultCollectionPropertiesHelper.setStatistics(resultCollection, Utility.toBatchStatistics(customSingleClassificationResult.getStatistics()));
        }
        return resultCollection;
    }

    private static ClassifyDocumentResult toSingleCategoryClassifyResult(CustomLabelClassificationResultDocumentsItem singleClassificationDocument) {
        List warnings = singleClassificationDocument.getWarnings().stream().map(warning -> Utility.toTextAnalyticsWarning(warning)).collect(Collectors.toList());
        ClassifyDocumentResult classifyDocumentResult = new ClassifyDocumentResult(singleClassificationDocument.getId(), singleClassificationDocument.getStatistics() == null ? null : Utility.toTextDocumentStatistics(singleClassificationDocument.getStatistics()), null);
        List<ClassificationResult> classificationResult = singleClassificationDocument.getClassProperty();
        if (classificationResult != null) {
            ClassifyDocumentResultPropertiesHelper.setClassifications(classifyDocumentResult, (IterableStream<ClassificationCategory>)IterableStream.of(Utility.toDocumentClassifications(classificationResult)));
        }
        ClassifyDocumentResultPropertiesHelper.setWarnings(classifyDocumentResult, (IterableStream<TextAnalyticsWarning>)new IterableStream(warnings));
        if (singleClassificationDocument.getDetectedLanguage() != null) {
            ClassifyDocumentResultPropertiesHelper.setDetectedLanguage(classifyDocumentResult, Utility.toDetectedLanguage(singleClassificationDocument.getDetectedLanguage()));
        }
        return classifyDocumentResult;
    }

    private static List<ClassificationCategory> toDocumentClassifications(List<ClassificationResult> classificationResults) {
        ArrayList<ClassificationCategory> classifications = new ArrayList<ClassificationCategory>();
        for (ClassificationResult classificationResult : classificationResults) {
            ClassificationCategory classification = new ClassificationCategory();
            ClassificationCategoryPropertiesHelper.setCategory(classification, classificationResult.getCategory());
            ClassificationCategoryPropertiesHelper.setConfidenceScore(classification, classificationResult.getConfidenceScore());
            classifications.add(classification);
        }
        return classifications;
    }

    public static AbstractSummaryResultCollection toAbstractiveSummaryResultCollection(AbstractiveSummarizationResult abstractiveSummarizationResult) {
        List<AbstractiveSummaryDocumentResultWithDetectedLanguage> documentResults = abstractiveSummarizationResult.getDocuments();
        ArrayList<AbstractSummaryResult> summaryResults = new ArrayList<AbstractSummaryResult>();
        for (AbstractiveSummaryDocumentResultWithDetectedLanguage documentResult : documentResults) {
            summaryResults.add(Utility.toAbstractiveSummaryResult(documentResult));
        }
        for (InputError documentError : abstractiveSummarizationResult.getErrors()) {
            summaryResults.add(new AbstractSummaryResult(documentError.getId(), null, Utility.toTextAnalyticsError(documentError.getError())));
        }
        AbstractSummaryResultCollection resultCollection = new AbstractSummaryResultCollection(summaryResults);
        AbstractSummaryResultCollectionPropertiesHelper.setModelVersion(resultCollection, abstractiveSummarizationResult.getModelVersion());
        AbstractSummaryResultCollectionPropertiesHelper.setStatistics(resultCollection, abstractiveSummarizationResult.getStatistics() == null ? null : Utility.toBatchStatistics(abstractiveSummarizationResult.getStatistics()));
        return resultCollection;
    }

    public static AbstractSummaryResult toAbstractiveSummaryResult(AbstractiveSummaryDocumentResultWithDetectedLanguage documentResult) {
        AbstractSummaryResult summaryResult = new AbstractSummaryResult(documentResult.getId(), documentResult.getStatistics() == null ? null : Utility.toTextDocumentStatistics(documentResult.getStatistics()), null);
        AbstractSummaryResultPropertiesHelper.setSummaries(summaryResult, (IterableStream<com.azure.ai.textanalytics.models.AbstractiveSummary>)new IterableStream(Utility.toAbstractiveSummaries(documentResult.getSummaries())));
        if (documentResult.getDetectedLanguage() != null) {
            AbstractSummaryResultPropertiesHelper.setDetectedLanguage(summaryResult, Utility.toDetectedLanguage(documentResult.getDetectedLanguage()));
        }
        List warnings = documentResult.getWarnings().stream().map(warning -> Utility.toTextAnalyticsWarning(warning)).collect(Collectors.toList());
        AbstractSummaryResultPropertiesHelper.setWarnings(summaryResult, (IterableStream<TextAnalyticsWarning>)IterableStream.of(warnings));
        return summaryResult;
    }

    public static List<com.azure.ai.textanalytics.models.AbstractiveSummary> toAbstractiveSummaries(List<AbstractiveSummary> abstractiveSummariesImpl) {
        ArrayList<com.azure.ai.textanalytics.models.AbstractiveSummary> summaries = new ArrayList<com.azure.ai.textanalytics.models.AbstractiveSummary>();
        abstractiveSummariesImpl.forEach(summaryImpl -> summaries.add(Utility.toAbstractiveSummary(summaryImpl)));
        return summaries;
    }

    public static com.azure.ai.textanalytics.models.AbstractiveSummary toAbstractiveSummary(AbstractiveSummary summary) {
        com.azure.ai.textanalytics.models.AbstractiveSummary abstractiveSummary = new com.azure.ai.textanalytics.models.AbstractiveSummary();
        AbstractiveSummaryPropertiesHelper.setText(abstractiveSummary, summary.getText());
        AbstractiveSummaryPropertiesHelper.setSummaryContexts(abstractiveSummary, Utility.toSummaryContexts(summary.getContexts()));
        return abstractiveSummary;
    }

    public static IterableStream<com.azure.ai.textanalytics.models.SummaryContext> toSummaryContexts(List<SummaryContext> contexts) {
        ArrayList summaryContexts = new ArrayList();
        contexts.forEach(context -> {
            com.azure.ai.textanalytics.models.SummaryContext summaryContext = new com.azure.ai.textanalytics.models.SummaryContext();
            SummaryContextPropertiesHelper.setOffset(summaryContext, context.getOffset());
            SummaryContextPropertiesHelper.setLength(summaryContext, context.getLength());
            summaryContexts.add(summaryContext);
        });
        return IterableStream.of(summaryContexts);
    }

    public static ExtractSummaryResultCollection toExtractSummaryResultCollection(ExtractiveSummarizationResult extractiveSummarizationResult) {
        ArrayList<ExtractSummaryResult> extractSummaryResults = new ArrayList<ExtractSummaryResult>();
        List<ExtractedSummaryDocumentResultWithDetectedLanguage> extractedDocumentSummaries = extractiveSummarizationResult.getDocuments();
        for (ExtractedSummaryDocumentResultWithDetectedLanguage documentSummary : extractedDocumentSummaries) {
            extractSummaryResults.add(Utility.toExtractSummaryResult(documentSummary));
        }
        for (InputError documentError : extractiveSummarizationResult.getErrors()) {
            extractSummaryResults.add(new ExtractSummaryResult(documentError.getId(), null, Utility.toTextAnalyticsError(documentError.getError())));
        }
        ExtractSummaryResultCollection resultCollection = new ExtractSummaryResultCollection(extractSummaryResults);
        ExtractSummaryResultCollectionPropertiesHelper.setModelVersion(resultCollection, extractiveSummarizationResult.getModelVersion());
        ExtractSummaryResultCollectionPropertiesHelper.setStatistics(resultCollection, extractiveSummarizationResult.getStatistics() == null ? null : Utility.toBatchStatistics(extractiveSummarizationResult.getStatistics()));
        return resultCollection;
    }

    private static ExtractSummaryResult toExtractSummaryResult(ExtractedSummaryDocumentResultWithDetectedLanguage documentSummary) {
        List<ExtractedSummarySentence> sentences = documentSummary.getSentences();
        List summarySentences = sentences.stream().map(sentence -> {
            SummarySentence summarySentence = new SummarySentence();
            SummarySentencePropertiesHelper.setText(summarySentence, sentence.getText());
            SummarySentencePropertiesHelper.setRankScore(summarySentence, sentence.getRankScore());
            SummarySentencePropertiesHelper.setLength(summarySentence, sentence.getLength());
            SummarySentencePropertiesHelper.setOffset(summarySentence, sentence.getOffset());
            return summarySentence;
        }).collect(Collectors.toList());
        List warnings = documentSummary.getWarnings().stream().map(warning -> Utility.toTextAnalyticsWarning(warning)).collect(Collectors.toList());
        ExtractSummaryResult extractSummaryResult = new ExtractSummaryResult(documentSummary.getId(), documentSummary.getStatistics() == null ? null : Utility.toTextDocumentStatistics(documentSummary.getStatistics()), null);
        ExtractSummaryResultPropertiesHelper.setSentences(extractSummaryResult, (IterableStream<SummarySentence>)new IterableStream(summarySentences));
        ExtractSummaryResultPropertiesHelper.setWarnings(extractSummaryResult, (IterableStream<TextAnalyticsWarning>)new IterableStream(warnings));
        if (documentSummary.getDetectedLanguage() != null) {
            ExtractSummaryResultPropertiesHelper.setDetectedLanguage(extractSummaryResult, Utility.toDetectedLanguage(documentSummary.getDetectedLanguage()));
        }
        return extractSummaryResult;
    }

    public static int[] parseRefPointerToIndexArray(String assessmentPointer) {
        Matcher matcher = PATTERN.matcher(assessmentPointer);
        boolean isMatched = matcher.find();
        int[] result = new int[3];
        if (!isMatched) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException(String.format("'%s' is not a valid assessment pointer.", assessmentPointer)));
        }
        result[0] = Integer.parseInt(matcher.group(1));
        result[1] = Integer.parseInt(matcher.group(2));
        result[2] = Integer.parseInt(matcher.group(3));
        return result;
    }

    public static SentenceAssessment findSentimentAssessment(String assessmentPointer, List<SentimentResponseDocumentsItem> documentSentiments) {
        int[] assessmentIndexes = Utility.parseRefPointerToIndexArray(assessmentPointer);
        int documentIndex = assessmentIndexes[0];
        int sentenceIndex = assessmentIndexes[1];
        int assessmentIndex = assessmentIndexes[2];
        if (documentIndex >= documentSentiments.size()) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException(String.format("Invalid document index '%s' in '%s'.", documentIndex, assessmentPointer)));
        }
        SentimentResponseDocumentsItem documentsentiment = documentSentiments.get(documentIndex);
        List<SentenceSentiment> sentenceSentiments = documentsentiment.getSentences();
        if (sentenceIndex >= sentenceSentiments.size()) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException(String.format("Invalid sentence index '%s' in '%s'.", sentenceIndex, assessmentPointer)));
        }
        List<SentenceAssessment> assessments = sentenceSentiments.get(sentenceIndex).getAssessments();
        if (assessmentIndex >= assessments.size()) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException(String.format("Invalid assessment index '%s' in '%s'.", assessmentIndex, assessmentPointer)));
        }
        return assessments.get(assessmentIndex);
    }

    public static void throwIfTargetServiceVersionFound(TextAnalyticsServiceVersion sourceVersion, List<TextAnalyticsServiceVersion> targetVersions, String errorMessage) {
        for (TextAnalyticsServiceVersion targetVersion : targetVersions) {
            if (targetVersion == null || sourceVersion == null || !targetVersion.getVersion().equals(sourceVersion.getVersion())) continue;
            throw LOGGER.logExceptionAsError((RuntimeException)new UnsupportedOperationException(errorMessage));
        }
    }

    public static String getUnsupportedServiceApiVersionMessage(String unsupportedName, TextAnalyticsServiceVersion sourceVersion, TextAnalyticsServiceVersion minSupportedVersion) {
        return String.format("'%s' is not available in API version %s. Use service API version '%s' or newer.", new Object[]{unsupportedName, sourceVersion, minSupportedVersion});
    }
}

