/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.textanalytics.models;

import com.azure.ai.textanalytics.implementation.ClassifyDocumentResultPropertiesHelper;
import com.azure.ai.textanalytics.models.ClassificationCategory;
import com.azure.ai.textanalytics.models.DetectedLanguage;
import com.azure.ai.textanalytics.models.TextAnalyticsError;
import com.azure.ai.textanalytics.models.TextAnalyticsResult;
import com.azure.ai.textanalytics.models.TextAnalyticsWarning;
import com.azure.ai.textanalytics.models.TextDocumentStatistics;
import com.azure.core.util.IterableStream;

public final class ClassifyDocumentResult
extends TextAnalyticsResult {
    private DetectedLanguage detectedLanguage;
    private IterableStream<ClassificationCategory> classifications;
    private IterableStream<TextAnalyticsWarning> warnings;

    public ClassifyDocumentResult(String id, TextDocumentStatistics textDocumentStatistics, TextAnalyticsError error) {
        super(id, textDocumentStatistics, error);
    }

    public IterableStream<ClassificationCategory> getClassifications() {
        this.throwExceptionIfError();
        return this.classifications;
    }

    public DetectedLanguage getDetectedLanguage() {
        return this.detectedLanguage;
    }

    public IterableStream<TextAnalyticsWarning> getWarnings() {
        return this.warnings;
    }

    private void setDetectedLanguage(DetectedLanguage detectedLanguage) {
        this.detectedLanguage = detectedLanguage;
    }

    private void setClassifications(IterableStream<ClassificationCategory> classifications) {
        this.classifications = classifications;
    }

    private void setWarnings(IterableStream<TextAnalyticsWarning> warnings) {
        this.warnings = warnings;
    }

    static {
        ClassifyDocumentResultPropertiesHelper.setAccessor(new ClassifyDocumentResultPropertiesHelper.ClassifyDocumentResultAccessor(){

            @Override
            public void setClassifications(ClassifyDocumentResult classifyDocumentResult, IterableStream<ClassificationCategory> classifications) {
                classifyDocumentResult.setClassifications((IterableStream<ClassificationCategory>)classifications);
            }

            @Override
            public void setDetectedLanguage(ClassifyDocumentResult classifyDocumentResult, DetectedLanguage detectedLanguage) {
                classifyDocumentResult.setDetectedLanguage(detectedLanguage);
            }

            @Override
            public void setWarnings(ClassifyDocumentResult classifyDocumentResult, IterableStream<TextAnalyticsWarning> warnings) {
                classifyDocumentResult.setWarnings((IterableStream<TextAnalyticsWarning>)warnings);
            }
        });
    }
}

