/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.amqp.implementation.handler;

import com.azure.core.amqp.exception.AmqpErrorContext;
import com.azure.core.amqp.implementation.AmqpLoggingUtils;
import com.azure.core.amqp.implementation.AmqpMetricsProvider;
import com.azure.core.amqp.implementation.ClientConstants;
import com.azure.core.amqp.implementation.ConnectionOptions;
import com.azure.core.amqp.implementation.ExceptionUtil;
import com.azure.core.amqp.implementation.handler.Handler;
import com.azure.core.amqp.implementation.handler.StrictTlsContext;
import com.azure.core.amqp.implementation.handler.StrictTlsContextSpi;
import com.azure.core.util.ClientOptions;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.UserAgentUtil;
import com.azure.core.util.logging.LoggingEventBuilder;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.net.ssl.SSLContext;
import org.apache.qpid.proton.Proton;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.transport.ErrorCondition;
import org.apache.qpid.proton.engine.Connection;
import org.apache.qpid.proton.engine.EndpointState;
import org.apache.qpid.proton.engine.Event;
import org.apache.qpid.proton.engine.SslDomain;
import org.apache.qpid.proton.engine.SslPeerDetails;
import org.apache.qpid.proton.engine.Transport;
import org.apache.qpid.proton.engine.impl.TransportInternal;
import org.apache.qpid.proton.reactor.Handshaker;

public class ConnectionHandler
extends Handler {
    public static final int AMQPS_PORT = 5671;
    public static final int AMQP_PORT = 5672;
    static final Symbol PRODUCT = Symbol.valueOf((String)"product");
    static final Symbol VERSION = Symbol.valueOf((String)"version");
    static final Symbol PLATFORM = Symbol.valueOf((String)"platform");
    static final Symbol FRAMEWORK = Symbol.valueOf((String)"framework");
    static final Symbol USER_AGENT = Symbol.valueOf((String)"user-agent");
    static final int MAX_FRAME_SIZE = 65536;
    static final int CONNECTION_IDLE_TIMEOUT = 60000;
    private final Map<String, Object> connectionProperties;
    private final ConnectionOptions connectionOptions;
    private final SslPeerDetails peerDetails;
    private final AmqpMetricsProvider metricProvider;
    private final boolean enableSsl;

    public ConnectionHandler(String connectionId, ConnectionOptions connectionOptions, AmqpMetricsProvider metricProvider) {
        this(connectionId, connectionOptions, null, metricProvider, false);
    }

    public ConnectionHandler(String connectionId, ConnectionOptions connectionOptions, SslPeerDetails peerDetails, AmqpMetricsProvider metricProvider) {
        this(connectionId, connectionOptions, peerDetails, metricProvider, true);
    }

    ConnectionHandler(String connectionId, ConnectionOptions connectionOptions, SslPeerDetails peerDetails, AmqpMetricsProvider metricProvider, boolean enableSsl) {
        super(connectionId, Objects.requireNonNull(connectionOptions, "'connectionOptions' cannot be null.").getHostname());
        this.add((org.apache.qpid.proton.engine.Handler)new Handshaker());
        this.connectionOptions = connectionOptions;
        this.connectionProperties = new HashMap<String, Object>();
        this.connectionProperties.put(PRODUCT.toString(), connectionOptions.getProduct());
        this.connectionProperties.put(VERSION.toString(), connectionOptions.getClientVersion());
        this.connectionProperties.put(PLATFORM.toString(), ClientConstants.PLATFORM_INFO);
        this.connectionProperties.put(FRAMEWORK.toString(), ClientConstants.FRAMEWORK_INFO);
        ClientOptions clientOptions = connectionOptions.getClientOptions();
        String applicationId = !CoreUtils.isNullOrEmpty((CharSequence)clientOptions.getApplicationId()) ? clientOptions.getApplicationId() : null;
        String userAgent = UserAgentUtil.toUserAgentString((String)applicationId, (String)connectionOptions.getProduct(), (String)connectionOptions.getClientVersion(), null);
        this.connectionProperties.put(USER_AGENT.toString(), userAgent);
        this.peerDetails = enableSsl ? Objects.requireNonNull(peerDetails, "'peerDetails' cannot be null.") : peerDetails;
        this.metricProvider = Objects.requireNonNull(metricProvider, "'metricProvider' cannot be null.");
        this.enableSsl = enableSsl;
    }

    public Map<String, Object> getConnectionProperties() {
        return this.connectionProperties;
    }

    public int getProtocolPort() {
        return this.connectionOptions.getPort();
    }

    public int getMaxFrameSize() {
        return 65536;
    }

    protected void addTransportLayers(Event event, TransportInternal transport) {
        SSLContext defaultSslContext;
        transport.setIdleTimeout(60000);
        if (!this.enableSsl) {
            return;
        }
        SslDomain sslDomain = Proton.sslDomain();
        sslDomain.init(SslDomain.Mode.CLIENT);
        SslDomain.VerifyMode verifyMode = this.connectionOptions.getSslVerifyMode();
        if (verifyMode == SslDomain.VerifyMode.ANONYMOUS_PEER) {
            defaultSslContext = null;
        } else {
            try {
                defaultSslContext = SSLContext.getDefault();
            }
            catch (NoSuchAlgorithmException e) {
                throw this.logger.logExceptionAsError(new RuntimeException("Default SSL algorithm not found in JRE. Please check your JRE setup.", e));
            }
        }
        if (verifyMode == SslDomain.VerifyMode.VERIFY_PEER_NAME) {
            StrictTlsContextSpi serviceProvider = new StrictTlsContextSpi(defaultSslContext);
            StrictTlsContext context = new StrictTlsContext(serviceProvider, defaultSslContext.getProvider(), defaultSslContext.getProtocol());
            sslDomain.setSslContext((SSLContext)context);
            transport.ssl(sslDomain, this.peerDetails);
            return;
        }
        if (verifyMode == SslDomain.VerifyMode.VERIFY_PEER) {
            sslDomain.setSslContext(defaultSslContext);
            sslDomain.setPeerAuthentication(SslDomain.VerifyMode.VERIFY_PEER);
        } else if (verifyMode == SslDomain.VerifyMode.ANONYMOUS_PEER) {
            this.logger.warning("'{}' is not secure.", new Object[]{verifyMode});
            sslDomain.setPeerAuthentication(SslDomain.VerifyMode.ANONYMOUS_PEER);
        } else {
            throw this.logger.logExceptionAsError((RuntimeException)new UnsupportedOperationException("verifyMode is not supported: " + verifyMode));
        }
        transport.ssl(sslDomain);
    }

    public void onConnectionInit(Event event) {
        this.logger.atInfo().addKeyValue("hostName", this.getHostname()).addKeyValue("namespace", this.connectionOptions.getFullyQualifiedNamespace()).log("onConnectionInit");
        Connection connection = event.getConnection();
        if (connection == null) {
            this.logger.warning("Underlying connection is null. Should not be possible.");
            this.close();
            return;
        }
        connection.setHostname(this.connectionOptions.getFullyQualifiedNamespace());
        connection.setContainer(this.getConnectionId());
        HashMap properties = new HashMap();
        this.connectionProperties.forEach((key, value) -> properties.put(Symbol.getSymbol((String)key), value));
        connection.setProperties(properties);
        connection.open();
    }

    public void onConnectionBound(Event event) {
        Transport transport = event.getTransport();
        LoggingEventBuilder builder = this.logger.atInfo().addKeyValue("hostName", this.getHostname());
        if (this.peerDetails != null) {
            builder.addKeyValue("peerDetails", () -> this.peerDetails.getHostname() + ":" + this.peerDetails.getPort());
        }
        builder.log("onConnectionBound");
        this.addTransportLayers(event, (TransportInternal)transport);
        Connection connection = event.getConnection();
        if (connection != null) {
            this.onNext(connection.getRemoteState());
        }
    }

    public void onConnectionUnbound(Event event) {
        Connection connection = event.getConnection();
        this.logger.atInfo().addKeyValue("hostName", connection.getHostname()).addKeyValue("state", (Object)connection.getLocalState()).addKeyValue("remoteState", (Object)connection.getRemoteState()).log("onConnectionUnbound");
        if (connection.getRemoteState() != EndpointState.UNINITIALIZED) {
            connection.free();
        }
        this.close();
    }

    public void onTransportError(Event event) {
        Connection connection = event.getConnection();
        Transport transport = event.getTransport();
        ErrorCondition condition = transport.getCondition();
        AmqpLoggingUtils.addErrorCondition(this.logger.atWarning(), condition).addKeyValue("hostName", connection != null ? connection.getHostname() : "n/a").log("onTransportError");
        this.metricProvider.recordHandlerError(AmqpMetricsProvider.ErrorSource.TRANSPORT, condition);
        if (connection != null) {
            this.notifyErrorContext(connection, condition);
        }
        transport.unbind();
    }

    public void onTransportClosed(Event event) {
        Connection connection = event.getConnection();
        Transport transport = event.getTransport();
        ErrorCondition condition = transport.getCondition();
        AmqpLoggingUtils.addErrorCondition(this.logger.atInfo(), condition).addKeyValue("hostName", connection != null ? connection.getHostname() : "n/a").log("onTransportClosed");
        if (connection != null) {
            this.notifyErrorContext(connection, condition);
        }
    }

    public void onConnectionLocalOpen(Event event) {
        Connection connection = event.getConnection();
        ErrorCondition error = connection.getCondition();
        this.logErrorCondition("onConnectionLocalOpen", connection, error);
    }

    public void onConnectionRemoteOpen(Event event) {
        Connection connection = event.getConnection();
        this.logger.atInfo().addKeyValue("hostName", connection.getHostname()).addKeyValue("remoteContainer", connection.getRemoteContainer()).log("onConnectionRemoteOpen");
        this.onNext(connection.getRemoteState());
    }

    public void onConnectionLocalClose(Event event) {
        Transport transport;
        Connection connection = event.getConnection();
        ErrorCondition error = connection.getCondition();
        this.logErrorCondition("onConnectionLocalClose", connection, error);
        if (connection.getRemoteState() == EndpointState.CLOSED && (transport = connection.getTransport()) != null) {
            transport.unbind();
        }
    }

    public void onConnectionRemoteClose(Event event) {
        Connection connection = event.getConnection();
        ErrorCondition error = connection.getRemoteCondition();
        this.logErrorCondition("onConnectionRemoteClose", connection, error);
        if (error == null) {
            this.onNext(connection.getRemoteState());
        } else {
            this.notifyErrorContext(connection, error);
        }
    }

    public void onConnectionFinal(Event event) {
        Connection connection = event.getConnection();
        ErrorCondition error = connection.getCondition();
        this.logErrorCondition("onConnectionFinal", connection, error);
        this.onNext(EndpointState.CLOSED);
        this.metricProvider.recordConnectionClosed(error);
        this.close();
    }

    public AmqpErrorContext getErrorContext() {
        return new AmqpErrorContext(this.getHostname());
    }

    private void notifyErrorContext(Connection connection, ErrorCondition condition) {
        if (connection == null || connection.getRemoteState() == EndpointState.CLOSED) {
            return;
        }
        if (condition == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalStateException("notifyErrorContext does not have an ErrorCondition."));
        }
        Exception exception = ExceptionUtil.toException(condition.getCondition().toString(), condition.getDescription(), this.getErrorContext());
        this.onError(exception);
    }

    private void logErrorCondition(String eventName, Connection connection, ErrorCondition error) {
        AmqpLoggingUtils.addErrorCondition(this.logger.atInfo(), error).addKeyValue("hostName", connection.getHostname()).log(eventName);
    }
}

