/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.keys.models;

import com.azure.security.keyvault.keys.models.CreateKeyOptions;
import com.azure.security.keyvault.keys.models.KeyOperation;
import com.azure.security.keyvault.keys.models.KeyType;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Map;

public class CreateRsaKeyOptions
extends CreateKeyOptions {
    private Integer keySize;
    private boolean hardwareProtected;

    public CreateRsaKeyOptions(String name) {
        this.name = name;
        this.keyType = KeyType.RSA;
    }

    public Integer getKeySize() {
        return this.keySize;
    }

    public CreateRsaKeyOptions setKeySize(Integer keySize) {
        this.keySize = keySize;
        return this;
    }

    @Override
    public CreateRsaKeyOptions setKeyOperations(KeyOperation ... keyOperations) {
        this.keyOperations = Arrays.asList(keyOperations);
        return this;
    }

    @Override
    public CreateRsaKeyOptions setNotBefore(OffsetDateTime notBefore) {
        super.setNotBefore(notBefore);
        return this;
    }

    @Override
    public CreateRsaKeyOptions setExpiresOn(OffsetDateTime expiresOn) {
        super.setExpiresOn(expiresOn);
        return this;
    }

    @Override
    public CreateRsaKeyOptions setTags(Map<String, String> tags) {
        super.setTags(tags);
        return this;
    }

    @Override
    public CreateRsaKeyOptions setEnabled(Boolean enabled) {
        super.setEnabled(enabled);
        return this;
    }

    public CreateRsaKeyOptions setHardwareProtected(Boolean hardwareProtected) {
        this.hardwareProtected = hardwareProtected;
        this.keyType = hardwareProtected != false ? KeyType.RSA_HSM : KeyType.RSA;
        return this;
    }

    public Boolean isHardwareProtected() {
        return this.hardwareProtected;
    }
}

