/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.secrets.implementation;

import com.azure.core.credential.TokenCredential;
import com.azure.core.credential.TokenRequestContext;
import com.azure.core.http.HttpPipelineCallContext;
import com.azure.core.http.HttpPipelineNextPolicy;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.implementation.util.ImplUtils;
import com.azure.security.keyvault.secrets.implementation.ScopeTokenCache;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import reactor.core.publisher.Mono;

public final class KeyVaultCredentialPolicy
implements HttpPipelinePolicy {
    private static final String WWW_AUTHENTICATE = "WWW-Authenticate";
    private static final String BEARER_TOKEN_PREFIX = "Bearer ";
    private static final String AUTHORIZATION = "Authorization";
    private final ScopeTokenCache cache;

    public KeyVaultCredentialPolicy(TokenCredential credential) {
        Objects.requireNonNull(credential);
        this.cache = new ScopeTokenCache(request -> credential.getToken(request));
    }

    public Mono<HttpResponse> process(HttpPipelineCallContext context, HttpPipelineNextPolicy next) {
        return next.clone().process().doOnNext(HttpResponse::close).map(res -> res.getHeaderValue(WWW_AUTHENTICATE)).map(header -> KeyVaultCredentialPolicy.extractChallenge(header, BEARER_TOKEN_PREFIX)).flatMap(map -> {
            this.cache.setTokenRequest(new TokenRequestContext().addScopes(new String[]{(String)map.get("resource") + "/.default"}));
            return this.cache.getToken();
        }).flatMap(token -> {
            context.getHttpRequest().setHeader(AUTHORIZATION, BEARER_TOKEN_PREFIX + token.getToken());
            return next.process();
        });
    }

    private static Map<String, String> extractChallenge(String authenticateHeader, String authChallengePrefix) {
        if (!KeyVaultCredentialPolicy.isValidChallenge(authenticateHeader, authChallengePrefix)) {
            return null;
        }
        authenticateHeader = authenticateHeader.toLowerCase(Locale.ROOT).replace(authChallengePrefix.toLowerCase(Locale.ROOT), "");
        String[] challenges = authenticateHeader.split(", ");
        HashMap<String, String> challengeMap = new HashMap<String, String>();
        for (String pair : challenges) {
            String[] keyValue = pair.split("=");
            challengeMap.put(keyValue[0].replaceAll("\"", ""), keyValue[1].replaceAll("\"", ""));
        }
        return challengeMap;
    }

    private static boolean isValidChallenge(String authenticateHeader, String authChallengePrefix) {
        return !ImplUtils.isNullOrEmpty((CharSequence)authenticateHeader) && authenticateHeader.toLowerCase(Locale.ROOT).startsWith(authChallengePrefix.toLowerCase(Locale.ROOT));
    }
}

