// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.resourcemanager.authorization.fluent.models.ApplicationInner;
import com.azure.resourcemanager.authorization.fluent.models.DirectoryObjectInner;
import com.azure.resourcemanager.authorization.fluent.models.KeyCredentialInner;
import com.azure.resourcemanager.authorization.fluent.models.PasswordCredentialInner;
import com.azure.resourcemanager.authorization.fluent.models.ServicePrincipalObjectResultInner;
import com.azure.resourcemanager.authorization.models.ApplicationCreateParameters;
import com.azure.resourcemanager.authorization.models.ApplicationUpdateParameters;
import java.util.List;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in ApplicationsClient. */
public interface ApplicationsClient {
    /**
     * Create a new application.
     *
     * @param parameters Request parameters for creating a new application.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.models.GraphErrorException thrown if the request is rejected by
     *     server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return active Directory application information.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<ApplicationInner>> createWithResponseAsync(ApplicationCreateParameters parameters);

    /**
     * Create a new application.
     *
     * @param parameters Request parameters for creating a new application.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.models.GraphErrorException thrown if the request is rejected by
     *     server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return active Directory application information.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<ApplicationInner> createAsync(ApplicationCreateParameters parameters);

    /**
     * Create a new application.
     *
     * @param parameters Request parameters for creating a new application.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.models.GraphErrorException thrown if the request is rejected by
     *     server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return active Directory application information.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ApplicationInner create(ApplicationCreateParameters parameters);

    /**
     * Create a new application.
     *
     * @param parameters Request parameters for creating a new application.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.models.GraphErrorException thrown if the request is rejected by
     *     server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return active Directory application information.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<ApplicationInner> createWithResponse(ApplicationCreateParameters parameters, Context context);

    /**
     * Lists applications by filter parameters.
     *
     * @param filter The filters to apply to the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.models.GraphErrorException thrown if the request is rejected by
     *     server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return application list operation result.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<ApplicationInner> listAsync(String filter);

    /**
     * Lists applications by filter parameters.
     *
     * @throws com.azure.resourcemanager.authorization.models.GraphErrorException thrown if the request is rejected by
     *     server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return application list operation result.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<ApplicationInner> listAsync();

    /**
     * Lists applications by filter parameters.
     *
     * @param filter The filters to apply to the operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.models.GraphErrorException thrown if the request is rejected by
     *     server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return application list operation result.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<ApplicationInner> list(String filter, Context context);

    /**
     * Lists applications by filter parameters.
     *
     * @throws com.azure.resourcemanager.authorization.models.GraphErrorException thrown if the request is rejected by
     *     server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return application list operation result.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<ApplicationInner> list();

    /**
     * Delete an application.
     *
     * @param applicationObjectId Application object ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.models.GraphErrorException thrown if the request is rejected by
     *     server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> deleteWithResponseAsync(String applicationObjectId);

    /**
     * Delete an application.
     *
     * @param applicationObjectId Application object ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.models.GraphErrorException thrown if the request is rejected by
     *     server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteAsync(String applicationObjectId);

    /**
     * Delete an application.
     *
     * @param applicationObjectId Application object ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.models.GraphErrorException thrown if the request is rejected by
     *     server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void delete(String applicationObjectId);

    /**
     * Delete an application.
     *
     * @param applicationObjectId Application object ID.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.models.GraphErrorException thrown if the request is rejected by
     *     server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> deleteWithResponse(String applicationObjectId, Context context);

    /**
     * Get an application by object ID.
     *
     * @param applicationObjectId Application object ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.models.GraphErrorException thrown if the request is rejected by
     *     server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an application by object ID.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<ApplicationInner>> getWithResponseAsync(String applicationObjectId);

    /**
     * Get an application by object ID.
     *
     * @param applicationObjectId Application object ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.models.GraphErrorException thrown if the request is rejected by
     *     server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an application by object ID.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<ApplicationInner> getAsync(String applicationObjectId);

    /**
     * Get an application by object ID.
     *
     * @param applicationObjectId Application object ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.models.GraphErrorException thrown if the request is rejected by
     *     server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an application by object ID.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ApplicationInner get(String applicationObjectId);

    /**
     * Get an application by object ID.
     *
     * @param applicationObjectId Application object ID.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.models.GraphErrorException thrown if the request is rejected by
     *     server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an application by object ID.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<ApplicationInner> getWithResponse(String applicationObjectId, Context context);

    /**
     * Update an existing application.
     *
     * @param applicationObjectId Application object ID.
     * @param parameters Request parameters for updating a new application.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.models.GraphErrorException thrown if the request is rejected by
     *     server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> patchWithResponseAsync(String applicationObjectId, ApplicationUpdateParameters parameters);

    /**
     * Update an existing application.
     *
     * @param applicationObjectId Application object ID.
     * @param parameters Request parameters for updating a new application.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.models.GraphErrorException thrown if the request is rejected by
     *     server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> patchAsync(String applicationObjectId, ApplicationUpdateParameters parameters);

    /**
     * Update an existing application.
     *
     * @param applicationObjectId Application object ID.
     * @param parameters Request parameters for updating a new application.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.models.GraphErrorException thrown if the request is rejected by
     *     server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void patch(String applicationObjectId, ApplicationUpdateParameters parameters);

    /**
     * Update an existing application.
     *
     * @param applicationObjectId Application object ID.
     * @param parameters Request parameters for updating a new application.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.models.GraphErrorException thrown if the request is rejected by
     *     server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> patchWithResponse(
        String applicationObjectId, ApplicationUpdateParameters parameters, Context context);

    /**
     * The owners are a set of non-admin users who are allowed to modify this object.
     *
     * @param applicationObjectId The object ID of the application for which to get owners.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.models.GraphErrorException thrown if the request is rejected by
     *     server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return directoryObject list operation result.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<DirectoryObjectInner> listOwnersAsync(String applicationObjectId);

    /**
     * The owners are a set of non-admin users who are allowed to modify this object.
     *
     * @param applicationObjectId The object ID of the application for which to get owners.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.models.GraphErrorException thrown if the request is rejected by
     *     server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return directoryObject list operation result.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<DirectoryObjectInner> listOwners(String applicationObjectId);

    /**
     * The owners are a set of non-admin users who are allowed to modify this object.
     *
     * @param applicationObjectId The object ID of the application for which to get owners.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.models.GraphErrorException thrown if the request is rejected by
     *     server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return directoryObject list operation result.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<DirectoryObjectInner> listOwners(String applicationObjectId, Context context);

    /**
     * Add an owner to an application.
     *
     * @param applicationObjectId The object ID of the application to which to add the owner.
     * @param url A owner object URL, such as
     *     "https://graph.windows.net/0b1f9851-1bf0-433f-aec3-cb9272f093dc/directoryObjects"
         + "/f260bbc4-c254-447b-94cf-293b5ec434dd",
     *     where "0b1f9851-1bf0-433f-aec3-cb9272f093dc" is the tenantId and "f260bbc4-c254-447b-94cf-293b5ec434dd" is
     *     the objectId of the owner (user, application, servicePrincipal, group) to be added.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.models.GraphErrorException thrown if the request is rejected by
     *     server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> addOwnerWithResponseAsync(String applicationObjectId, String url);

    /**
     * Add an owner to an application.
     *
     * @param applicationObjectId The object ID of the application to which to add the owner.
     * @param url A owner object URL, such as
     *     "https://graph.windows.net/0b1f9851-1bf0-433f-aec3-cb9272f093dc/directoryObjects"
         + "/f260bbc4-c254-447b-94cf-293b5ec434dd",
     *     where "0b1f9851-1bf0-433f-aec3-cb9272f093dc" is the tenantId and "f260bbc4-c254-447b-94cf-293b5ec434dd" is
     *     the objectId of the owner (user, application, servicePrincipal, group) to be added.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.models.GraphErrorException thrown if the request is rejected by
     *     server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> addOwnerAsync(String applicationObjectId, String url);

    /**
     * Add an owner to an application.
     *
     * @param applicationObjectId The object ID of the application to which to add the owner.
     * @param url A owner object URL, such as
     *     "https://graph.windows.net/0b1f9851-1bf0-433f-aec3-cb9272f093dc/directoryObjects"
         + "/f260bbc4-c254-447b-94cf-293b5ec434dd",
     *     where "0b1f9851-1bf0-433f-aec3-cb9272f093dc" is the tenantId and "f260bbc4-c254-447b-94cf-293b5ec434dd" is
     *     the objectId of the owner (user, application, servicePrincipal, group) to be added.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.models.GraphErrorException thrown if the request is rejected by
     *     server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void addOwner(String applicationObjectId, String url);

    /**
     * Add an owner to an application.
     *
     * @param applicationObjectId The object ID of the application to which to add the owner.
     * @param url A owner object URL, such as
     *     "https://graph.windows.net/0b1f9851-1bf0-433f-aec3-cb9272f093dc/directoryObjects"
         + "/f260bbc4-c254-447b-94cf-293b5ec434dd",
     *     where "0b1f9851-1bf0-433f-aec3-cb9272f093dc" is the tenantId and "f260bbc4-c254-447b-94cf-293b5ec434dd" is
     *     the objectId of the owner (user, application, servicePrincipal, group) to be added.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.models.GraphErrorException thrown if the request is rejected by
     *     server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> addOwnerWithResponse(String applicationObjectId, String url, Context context);

    /**
     * Remove a member from owners.
     *
     * @param applicationObjectId The object ID of the application from which to remove the owner.
     * @param ownerObjectId Owner object id.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.models.GraphErrorException thrown if the request is rejected by
     *     server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> removeOwnerWithResponseAsync(String applicationObjectId, String ownerObjectId);

    /**
     * Remove a member from owners.
     *
     * @param applicationObjectId The object ID of the application from which to remove the owner.
     * @param ownerObjectId Owner object id.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.models.GraphErrorException thrown if the request is rejected by
     *     server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> removeOwnerAsync(String applicationObjectId, String ownerObjectId);

    /**
     * Remove a member from owners.
     *
     * @param applicationObjectId The object ID of the application from which to remove the owner.
     * @param ownerObjectId Owner object id.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.models.GraphErrorException thrown if the request is rejected by
     *     server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void removeOwner(String applicationObjectId, String ownerObjectId);

    /**
     * Remove a member from owners.
     *
     * @param applicationObjectId The object ID of the application from which to remove the owner.
     * @param ownerObjectId Owner object id.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.models.GraphErrorException thrown if the request is rejected by
     *     server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> removeOwnerWithResponse(String applicationObjectId, String ownerObjectId, Context context);

    /**
     * Get the keyCredentials associated with an application.
     *
     * @param applicationObjectId Application object ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.models.GraphErrorException thrown if the request is rejected by
     *     server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the keyCredentials associated with an application.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<KeyCredentialInner> listKeyCredentialsAsync(String applicationObjectId);

    /**
     * Get the keyCredentials associated with an application.
     *
     * @param applicationObjectId Application object ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.models.GraphErrorException thrown if the request is rejected by
     *     server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the keyCredentials associated with an application.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<KeyCredentialInner> listKeyCredentials(String applicationObjectId);

    /**
     * Get the keyCredentials associated with an application.
     *
     * @param applicationObjectId Application object ID.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.models.GraphErrorException thrown if the request is rejected by
     *     server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the keyCredentials associated with an application.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<KeyCredentialInner> listKeyCredentials(String applicationObjectId, Context context);

    /**
     * Update the keyCredentials associated with an application.
     *
     * @param applicationObjectId Application object ID.
     * @param value A collection of KeyCredentials.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.models.GraphErrorException thrown if the request is rejected by
     *     server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> updateKeyCredentialsWithResponseAsync(
        String applicationObjectId, List<KeyCredentialInner> value);

    /**
     * Update the keyCredentials associated with an application.
     *
     * @param applicationObjectId Application object ID.
     * @param value A collection of KeyCredentials.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.models.GraphErrorException thrown if the request is rejected by
     *     server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> updateKeyCredentialsAsync(String applicationObjectId, List<KeyCredentialInner> value);

    /**
     * Update the keyCredentials associated with an application.
     *
     * @param applicationObjectId Application object ID.
     * @param value A collection of KeyCredentials.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.models.GraphErrorException thrown if the request is rejected by
     *     server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void updateKeyCredentials(String applicationObjectId, List<KeyCredentialInner> value);

    /**
     * Update the keyCredentials associated with an application.
     *
     * @param applicationObjectId Application object ID.
     * @param value A collection of KeyCredentials.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.models.GraphErrorException thrown if the request is rejected by
     *     server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> updateKeyCredentialsWithResponse(
        String applicationObjectId, List<KeyCredentialInner> value, Context context);

    /**
     * Get the passwordCredentials associated with an application.
     *
     * @param applicationObjectId Application object ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.models.GraphErrorException thrown if the request is rejected by
     *     server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the passwordCredentials associated with an application.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<PasswordCredentialInner> listPasswordCredentialsAsync(String applicationObjectId);

    /**
     * Get the passwordCredentials associated with an application.
     *
     * @param applicationObjectId Application object ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.models.GraphErrorException thrown if the request is rejected by
     *     server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the passwordCredentials associated with an application.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<PasswordCredentialInner> listPasswordCredentials(String applicationObjectId);

    /**
     * Get the passwordCredentials associated with an application.
     *
     * @param applicationObjectId Application object ID.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.models.GraphErrorException thrown if the request is rejected by
     *     server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the passwordCredentials associated with an application.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<PasswordCredentialInner> listPasswordCredentials(String applicationObjectId, Context context);

    /**
     * Update passwordCredentials associated with an application.
     *
     * @param applicationObjectId Application object ID.
     * @param value A collection of PasswordCredentials.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.models.GraphErrorException thrown if the request is rejected by
     *     server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> updatePasswordCredentialsWithResponseAsync(
        String applicationObjectId, List<PasswordCredentialInner> value);

    /**
     * Update passwordCredentials associated with an application.
     *
     * @param applicationObjectId Application object ID.
     * @param value A collection of PasswordCredentials.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.models.GraphErrorException thrown if the request is rejected by
     *     server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> updatePasswordCredentialsAsync(String applicationObjectId, List<PasswordCredentialInner> value);

    /**
     * Update passwordCredentials associated with an application.
     *
     * @param applicationObjectId Application object ID.
     * @param value A collection of PasswordCredentials.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.models.GraphErrorException thrown if the request is rejected by
     *     server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void updatePasswordCredentials(String applicationObjectId, List<PasswordCredentialInner> value);

    /**
     * Update passwordCredentials associated with an application.
     *
     * @param applicationObjectId Application object ID.
     * @param value A collection of PasswordCredentials.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.models.GraphErrorException thrown if the request is rejected by
     *     server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> updatePasswordCredentialsWithResponse(
        String applicationObjectId, List<PasswordCredentialInner> value, Context context);

    /**
     * Gets an object id for a given application id from the current tenant.
     *
     * @param applicationId The application ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.models.GraphErrorException thrown if the request is rejected by
     *     server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an object id for a given application id from the current tenant.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<ServicePrincipalObjectResultInner>> getServicePrincipalsIdByAppIdWithResponseAsync(
        String applicationId);

    /**
     * Gets an object id for a given application id from the current tenant.
     *
     * @param applicationId The application ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.models.GraphErrorException thrown if the request is rejected by
     *     server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an object id for a given application id from the current tenant.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<ServicePrincipalObjectResultInner> getServicePrincipalsIdByAppIdAsync(String applicationId);

    /**
     * Gets an object id for a given application id from the current tenant.
     *
     * @param applicationId The application ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.models.GraphErrorException thrown if the request is rejected by
     *     server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an object id for a given application id from the current tenant.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ServicePrincipalObjectResultInner getServicePrincipalsIdByAppId(String applicationId);

    /**
     * Gets an object id for a given application id from the current tenant.
     *
     * @param applicationId The application ID.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.models.GraphErrorException thrown if the request is rejected by
     *     server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an object id for a given application id from the current tenant.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<ServicePrincipalObjectResultInner> getServicePrincipalsIdByAppIdWithResponse(
        String applicationId, Context context);
}
