// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent;

import com.azure.core.http.HttpPipeline;
import java.time.Duration;

/** The interface for GraphRbacManagementClient class. */
public interface GraphRbacManagementClient {
    /**
     * Gets The tenant ID.
     *
     * @return the tenantId value.
     */
    String getTenantId();

    /**
     * Gets server parameter.
     *
     * @return the endpoint value.
     */
    String getEndpoint();

    /**
     * Gets Api Version.
     *
     * @return the apiVersion value.
     */
    String getApiVersion();

    /**
     * Gets The HTTP pipeline to send requests through.
     *
     * @return the httpPipeline value.
     */
    HttpPipeline getHttpPipeline();

    /**
     * Gets The default poll interval for long-running operation.
     *
     * @return the defaultPollInterval value.
     */
    Duration getDefaultPollInterval();

    /**
     * Gets the SignedInUsersClient object to access its operations.
     *
     * @return the SignedInUsersClient object.
     */
    SignedInUsersClient getSignedInUsers();

    /**
     * Gets the ApplicationsClient object to access its operations.
     *
     * @return the ApplicationsClient object.
     */
    ApplicationsClient getApplications();

    /**
     * Gets the DeletedApplicationsClient object to access its operations.
     *
     * @return the DeletedApplicationsClient object.
     */
    DeletedApplicationsClient getDeletedApplications();

    /**
     * Gets the GroupsClient object to access its operations.
     *
     * @return the GroupsClient object.
     */
    GroupsClient getGroups();

    /**
     * Gets the ServicePrincipalsClient object to access its operations.
     *
     * @return the ServicePrincipalsClient object.
     */
    ServicePrincipalsClient getServicePrincipals();

    /**
     * Gets the UsersClient object to access its operations.
     *
     * @return the UsersClient object.
     */
    UsersClient getUsers();

    /**
     * Gets the ObjectsClient object to access its operations.
     *
     * @return the ObjectsClient object.
     */
    ObjectsClient getObjects();

    /**
     * Gets the DomainsClient object to access its operations.
     *
     * @return the DomainsClient object.
     */
    DomainsClient getDomains();

    /**
     * Gets the OAuth2PermissionGrantsClient object to access its operations.
     *
     * @return the OAuth2PermissionGrantsClient object.
     */
    OAuth2PermissionGrantsClient getOAuth2PermissionGrants();
}
