// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.resourcemanager.authorization.fluent.models.DirectoryObjectInner;
import com.azure.resourcemanager.authorization.fluent.models.KeyCredentialInner;
import com.azure.resourcemanager.authorization.fluent.models.PasswordCredentialInner;
import com.azure.resourcemanager.authorization.fluent.models.ServicePrincipalInner;
import com.azure.resourcemanager.authorization.models.ServicePrincipalBase;
import com.azure.resourcemanager.authorization.models.ServicePrincipalCreateParameters;
import java.util.List;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in ServicePrincipalsClient. */
public interface ServicePrincipalsClient {
    /**
     * Creates a service principal in the directory.
     *
     * @param parameters Request parameters for creating a new service principal.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.models.GraphErrorException thrown if the request is rejected by
     *     server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return active Directory service principal information.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<ServicePrincipalInner>> createWithResponseAsync(ServicePrincipalCreateParameters parameters);

    /**
     * Creates a service principal in the directory.
     *
     * @param parameters Request parameters for creating a new service principal.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.models.GraphErrorException thrown if the request is rejected by
     *     server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return active Directory service principal information.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<ServicePrincipalInner> createAsync(ServicePrincipalCreateParameters parameters);

    /**
     * Creates a service principal in the directory.
     *
     * @param parameters Request parameters for creating a new service principal.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.models.GraphErrorException thrown if the request is rejected by
     *     server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return active Directory service principal information.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ServicePrincipalInner create(ServicePrincipalCreateParameters parameters);

    /**
     * Creates a service principal in the directory.
     *
     * @param parameters Request parameters for creating a new service principal.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.models.GraphErrorException thrown if the request is rejected by
     *     server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return active Directory service principal information.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<ServicePrincipalInner> createWithResponse(ServicePrincipalCreateParameters parameters, Context context);

    /**
     * Gets a list of service principals from the current tenant.
     *
     * @param filter The filter to apply to the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.models.GraphErrorException thrown if the request is rejected by
     *     server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of service principals from the current tenant.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<ServicePrincipalInner> listAsync(String filter);

    /**
     * Gets a list of service principals from the current tenant.
     *
     * @throws com.azure.resourcemanager.authorization.models.GraphErrorException thrown if the request is rejected by
     *     server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of service principals from the current tenant.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<ServicePrincipalInner> listAsync();

    /**
     * Gets a list of service principals from the current tenant.
     *
     * @param filter The filter to apply to the operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.models.GraphErrorException thrown if the request is rejected by
     *     server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of service principals from the current tenant.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<ServicePrincipalInner> list(String filter, Context context);

    /**
     * Gets a list of service principals from the current tenant.
     *
     * @throws com.azure.resourcemanager.authorization.models.GraphErrorException thrown if the request is rejected by
     *     server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of service principals from the current tenant.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<ServicePrincipalInner> list();

    /**
     * Updates a service principal in the directory.
     *
     * @param objectId The object ID of the service principal to delete.
     * @param parameters Active Directory service principal common properties shared among GET, POST and PATCH.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.models.GraphErrorException thrown if the request is rejected by
     *     server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> updateWithResponseAsync(String objectId, ServicePrincipalBase parameters);

    /**
     * Updates a service principal in the directory.
     *
     * @param objectId The object ID of the service principal to delete.
     * @param parameters Active Directory service principal common properties shared among GET, POST and PATCH.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.models.GraphErrorException thrown if the request is rejected by
     *     server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> updateAsync(String objectId, ServicePrincipalBase parameters);

    /**
     * Updates a service principal in the directory.
     *
     * @param objectId The object ID of the service principal to delete.
     * @param parameters Active Directory service principal common properties shared among GET, POST and PATCH.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.models.GraphErrorException thrown if the request is rejected by
     *     server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void update(String objectId, ServicePrincipalBase parameters);

    /**
     * Updates a service principal in the directory.
     *
     * @param objectId The object ID of the service principal to delete.
     * @param parameters Active Directory service principal common properties shared among GET, POST and PATCH.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.models.GraphErrorException thrown if the request is rejected by
     *     server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> updateWithResponse(String objectId, ServicePrincipalBase parameters, Context context);

    /**
     * Deletes a service principal from the directory.
     *
     * @param objectId The object ID of the service principal to delete.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.models.GraphErrorException thrown if the request is rejected by
     *     server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> deleteWithResponseAsync(String objectId);

    /**
     * Deletes a service principal from the directory.
     *
     * @param objectId The object ID of the service principal to delete.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.models.GraphErrorException thrown if the request is rejected by
     *     server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteAsync(String objectId);

    /**
     * Deletes a service principal from the directory.
     *
     * @param objectId The object ID of the service principal to delete.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.models.GraphErrorException thrown if the request is rejected by
     *     server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void delete(String objectId);

    /**
     * Deletes a service principal from the directory.
     *
     * @param objectId The object ID of the service principal to delete.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.models.GraphErrorException thrown if the request is rejected by
     *     server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> deleteWithResponse(String objectId, Context context);

    /**
     * Gets service principal information from the directory. Query by objectId or pass a filter to query by appId.
     *
     * @param objectId The object ID of the service principal to get.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.models.GraphErrorException thrown if the request is rejected by
     *     server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return service principal information from the directory.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<ServicePrincipalInner>> getWithResponseAsync(String objectId);

    /**
     * Gets service principal information from the directory. Query by objectId or pass a filter to query by appId.
     *
     * @param objectId The object ID of the service principal to get.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.models.GraphErrorException thrown if the request is rejected by
     *     server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return service principal information from the directory.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<ServicePrincipalInner> getAsync(String objectId);

    /**
     * Gets service principal information from the directory. Query by objectId or pass a filter to query by appId.
     *
     * @param objectId The object ID of the service principal to get.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.models.GraphErrorException thrown if the request is rejected by
     *     server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return service principal information from the directory.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ServicePrincipalInner get(String objectId);

    /**
     * Gets service principal information from the directory. Query by objectId or pass a filter to query by appId.
     *
     * @param objectId The object ID of the service principal to get.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.models.GraphErrorException thrown if the request is rejected by
     *     server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return service principal information from the directory.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<ServicePrincipalInner> getWithResponse(String objectId, Context context);

    /**
     * The owners are a set of non-admin users who are allowed to modify this object.
     *
     * @param objectId The object ID of the service principal for which to get owners.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.models.GraphErrorException thrown if the request is rejected by
     *     server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return directoryObject list operation result.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<DirectoryObjectInner> listOwnersAsync(String objectId);

    /**
     * The owners are a set of non-admin users who are allowed to modify this object.
     *
     * @param objectId The object ID of the service principal for which to get owners.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.models.GraphErrorException thrown if the request is rejected by
     *     server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return directoryObject list operation result.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<DirectoryObjectInner> listOwners(String objectId);

    /**
     * The owners are a set of non-admin users who are allowed to modify this object.
     *
     * @param objectId The object ID of the service principal for which to get owners.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.models.GraphErrorException thrown if the request is rejected by
     *     server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return directoryObject list operation result.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<DirectoryObjectInner> listOwners(String objectId, Context context);

    /**
     * Get the keyCredentials associated with the specified service principal.
     *
     * @param objectId The object ID of the service principal for which to get keyCredentials.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.models.GraphErrorException thrown if the request is rejected by
     *     server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the keyCredentials associated with the specified service principal.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<KeyCredentialInner> listKeyCredentialsAsync(String objectId);

    /**
     * Get the keyCredentials associated with the specified service principal.
     *
     * @param objectId The object ID of the service principal for which to get keyCredentials.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.models.GraphErrorException thrown if the request is rejected by
     *     server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the keyCredentials associated with the specified service principal.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<KeyCredentialInner> listKeyCredentials(String objectId);

    /**
     * Get the keyCredentials associated with the specified service principal.
     *
     * @param objectId The object ID of the service principal for which to get keyCredentials.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.models.GraphErrorException thrown if the request is rejected by
     *     server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the keyCredentials associated with the specified service principal.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<KeyCredentialInner> listKeyCredentials(String objectId, Context context);

    /**
     * Update the keyCredentials associated with a service principal.
     *
     * @param objectId The object ID for which to get service principal information.
     * @param value A collection of KeyCredentials.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.models.GraphErrorException thrown if the request is rejected by
     *     server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> updateKeyCredentialsWithResponseAsync(String objectId, List<KeyCredentialInner> value);

    /**
     * Update the keyCredentials associated with a service principal.
     *
     * @param objectId The object ID for which to get service principal information.
     * @param value A collection of KeyCredentials.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.models.GraphErrorException thrown if the request is rejected by
     *     server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> updateKeyCredentialsAsync(String objectId, List<KeyCredentialInner> value);

    /**
     * Update the keyCredentials associated with a service principal.
     *
     * @param objectId The object ID for which to get service principal information.
     * @param value A collection of KeyCredentials.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.models.GraphErrorException thrown if the request is rejected by
     *     server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void updateKeyCredentials(String objectId, List<KeyCredentialInner> value);

    /**
     * Update the keyCredentials associated with a service principal.
     *
     * @param objectId The object ID for which to get service principal information.
     * @param value A collection of KeyCredentials.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.models.GraphErrorException thrown if the request is rejected by
     *     server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> updateKeyCredentialsWithResponse(String objectId, List<KeyCredentialInner> value, Context context);

    /**
     * Gets the passwordCredentials associated with a service principal.
     *
     * @param objectId The object ID of the service principal.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.models.GraphErrorException thrown if the request is rejected by
     *     server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the passwordCredentials associated with a service principal.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<PasswordCredentialInner> listPasswordCredentialsAsync(String objectId);

    /**
     * Gets the passwordCredentials associated with a service principal.
     *
     * @param objectId The object ID of the service principal.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.models.GraphErrorException thrown if the request is rejected by
     *     server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the passwordCredentials associated with a service principal.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<PasswordCredentialInner> listPasswordCredentials(String objectId);

    /**
     * Gets the passwordCredentials associated with a service principal.
     *
     * @param objectId The object ID of the service principal.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.models.GraphErrorException thrown if the request is rejected by
     *     server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the passwordCredentials associated with a service principal.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<PasswordCredentialInner> listPasswordCredentials(String objectId, Context context);

    /**
     * Updates the passwordCredentials associated with a service principal.
     *
     * @param objectId The object ID of the service principal.
     * @param value A collection of PasswordCredentials.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.models.GraphErrorException thrown if the request is rejected by
     *     server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> updatePasswordCredentialsWithResponseAsync(
        String objectId, List<PasswordCredentialInner> value);

    /**
     * Updates the passwordCredentials associated with a service principal.
     *
     * @param objectId The object ID of the service principal.
     * @param value A collection of PasswordCredentials.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.models.GraphErrorException thrown if the request is rejected by
     *     server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> updatePasswordCredentialsAsync(String objectId, List<PasswordCredentialInner> value);

    /**
     * Updates the passwordCredentials associated with a service principal.
     *
     * @param objectId The object ID of the service principal.
     * @param value A collection of PasswordCredentials.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.models.GraphErrorException thrown if the request is rejected by
     *     server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void updatePasswordCredentials(String objectId, List<PasswordCredentialInner> value);

    /**
     * Updates the passwordCredentials associated with a service principal.
     *
     * @param objectId The object ID of the service principal.
     * @param value A collection of PasswordCredentials.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.models.GraphErrorException thrown if the request is rejected by
     *     server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> updatePasswordCredentialsWithResponse(
        String objectId, List<PasswordCredentialInner> value, Context context);
}
