// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.resourcemanager.authorization.fluent.models.DirectoryObjectInner;
import com.azure.resourcemanager.authorization.fluent.models.UserInner;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in SignedInUsersClient. */
public interface SignedInUsersClient {
    /**
     * Gets the details for the currently logged-in user.
     *
     * @throws com.azure.resourcemanager.authorization.models.GraphErrorException thrown if the request is rejected by
     *     server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the details for the currently logged-in user.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<UserInner>> getWithResponseAsync();

    /**
     * Gets the details for the currently logged-in user.
     *
     * @throws com.azure.resourcemanager.authorization.models.GraphErrorException thrown if the request is rejected by
     *     server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the details for the currently logged-in user.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<UserInner> getAsync();

    /**
     * Gets the details for the currently logged-in user.
     *
     * @throws com.azure.resourcemanager.authorization.models.GraphErrorException thrown if the request is rejected by
     *     server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the details for the currently logged-in user.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    UserInner get();

    /**
     * Gets the details for the currently logged-in user.
     *
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.models.GraphErrorException thrown if the request is rejected by
     *     server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the details for the currently logged-in user.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<UserInner> getWithResponse(Context context);

    /**
     * Get the list of directory objects that are owned by the user.
     *
     * @throws com.azure.resourcemanager.authorization.models.GraphErrorException thrown if the request is rejected by
     *     server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list of directory objects that are owned by the user.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<DirectoryObjectInner> listOwnedObjectsAsync();

    /**
     * Get the list of directory objects that are owned by the user.
     *
     * @throws com.azure.resourcemanager.authorization.models.GraphErrorException thrown if the request is rejected by
     *     server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list of directory objects that are owned by the user.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<DirectoryObjectInner> listOwnedObjects();

    /**
     * Get the list of directory objects that are owned by the user.
     *
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.models.GraphErrorException thrown if the request is rejected by
     *     server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list of directory objects that are owned by the user.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<DirectoryObjectInner> listOwnedObjects(Context context);
}
