// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.resourcemanager.authorization.fluent.models.UserInner;
import com.azure.resourcemanager.authorization.models.UserCreateParameters;
import com.azure.resourcemanager.authorization.models.UserUpdateParameters;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in UsersClient. */
public interface UsersClient {
    /**
     * Create a new user.
     *
     * @param parameters Request parameters for creating a new work or school account user.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.models.GraphErrorException thrown if the request is rejected by
     *     server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return active Directory user information.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<UserInner>> createWithResponseAsync(UserCreateParameters parameters);

    /**
     * Create a new user.
     *
     * @param parameters Request parameters for creating a new work or school account user.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.models.GraphErrorException thrown if the request is rejected by
     *     server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return active Directory user information.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<UserInner> createAsync(UserCreateParameters parameters);

    /**
     * Create a new user.
     *
     * @param parameters Request parameters for creating a new work or school account user.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.models.GraphErrorException thrown if the request is rejected by
     *     server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return active Directory user information.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    UserInner create(UserCreateParameters parameters);

    /**
     * Create a new user.
     *
     * @param parameters Request parameters for creating a new work or school account user.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.models.GraphErrorException thrown if the request is rejected by
     *     server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return active Directory user information.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<UserInner> createWithResponse(UserCreateParameters parameters, Context context);

    /**
     * Gets list of users for the current tenant.
     *
     * @param filter The filter to apply to the operation.
     * @param expand The expand value for the operation result.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.models.GraphErrorException thrown if the request is rejected by
     *     server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of users for the current tenant.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<UserInner> listAsync(String filter, String expand);

    /**
     * Gets list of users for the current tenant.
     *
     * @throws com.azure.resourcemanager.authorization.models.GraphErrorException thrown if the request is rejected by
     *     server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of users for the current tenant.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<UserInner> listAsync();

    /**
     * Gets list of users for the current tenant.
     *
     * @param filter The filter to apply to the operation.
     * @param expand The expand value for the operation result.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.models.GraphErrorException thrown if the request is rejected by
     *     server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of users for the current tenant.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<UserInner> list(String filter, String expand, Context context);

    /**
     * Gets list of users for the current tenant.
     *
     * @throws com.azure.resourcemanager.authorization.models.GraphErrorException thrown if the request is rejected by
     *     server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of users for the current tenant.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<UserInner> list();

    /**
     * Gets user information from the directory.
     *
     * @param upnOrObjectId The object ID or principal name of the user for which to get information.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.models.GraphErrorException thrown if the request is rejected by
     *     server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return user information from the directory.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<UserInner>> getWithResponseAsync(String upnOrObjectId);

    /**
     * Gets user information from the directory.
     *
     * @param upnOrObjectId The object ID or principal name of the user for which to get information.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.models.GraphErrorException thrown if the request is rejected by
     *     server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return user information from the directory.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<UserInner> getAsync(String upnOrObjectId);

    /**
     * Gets user information from the directory.
     *
     * @param upnOrObjectId The object ID or principal name of the user for which to get information.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.models.GraphErrorException thrown if the request is rejected by
     *     server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return user information from the directory.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    UserInner get(String upnOrObjectId);

    /**
     * Gets user information from the directory.
     *
     * @param upnOrObjectId The object ID or principal name of the user for which to get information.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.models.GraphErrorException thrown if the request is rejected by
     *     server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return user information from the directory.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<UserInner> getWithResponse(String upnOrObjectId, Context context);

    /**
     * Updates a user.
     *
     * @param upnOrObjectId The object ID or principal name of the user to update.
     * @param parameters Request parameters for updating an existing work or school account user.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.models.GraphErrorException thrown if the request is rejected by
     *     server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> updateWithResponseAsync(String upnOrObjectId, UserUpdateParameters parameters);

    /**
     * Updates a user.
     *
     * @param upnOrObjectId The object ID or principal name of the user to update.
     * @param parameters Request parameters for updating an existing work or school account user.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.models.GraphErrorException thrown if the request is rejected by
     *     server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> updateAsync(String upnOrObjectId, UserUpdateParameters parameters);

    /**
     * Updates a user.
     *
     * @param upnOrObjectId The object ID or principal name of the user to update.
     * @param parameters Request parameters for updating an existing work or school account user.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.models.GraphErrorException thrown if the request is rejected by
     *     server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void update(String upnOrObjectId, UserUpdateParameters parameters);

    /**
     * Updates a user.
     *
     * @param upnOrObjectId The object ID or principal name of the user to update.
     * @param parameters Request parameters for updating an existing work or school account user.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.models.GraphErrorException thrown if the request is rejected by
     *     server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> updateWithResponse(String upnOrObjectId, UserUpdateParameters parameters, Context context);

    /**
     * Delete a user.
     *
     * @param upnOrObjectId The object ID or principal name of the user to delete.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.models.GraphErrorException thrown if the request is rejected by
     *     server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> deleteWithResponseAsync(String upnOrObjectId);

    /**
     * Delete a user.
     *
     * @param upnOrObjectId The object ID or principal name of the user to delete.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.models.GraphErrorException thrown if the request is rejected by
     *     server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteAsync(String upnOrObjectId);

    /**
     * Delete a user.
     *
     * @param upnOrObjectId The object ID or principal name of the user to delete.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.models.GraphErrorException thrown if the request is rejected by
     *     server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void delete(String upnOrObjectId);

    /**
     * Delete a user.
     *
     * @param upnOrObjectId The object ID or principal name of the user to delete.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.models.GraphErrorException thrown if the request is rejected by
     *     server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> deleteWithResponse(String upnOrObjectId, Context context);

    /**
     * Gets a collection that contains the object IDs of the groups of which the user is a member.
     *
     * @param objectId The object ID of the user for which to get group membership.
     * @param securityEnabledOnly If true, only membership in security-enabled groups should be checked. Otherwise,
     *     membership in all groups should be checked.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.models.GraphErrorException thrown if the request is rejected by
     *     server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a collection that contains the object IDs of the groups of which the user is a member.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<String> getMemberGroupsAsync(String objectId, boolean securityEnabledOnly);

    /**
     * Gets a collection that contains the object IDs of the groups of which the user is a member.
     *
     * @param objectId The object ID of the user for which to get group membership.
     * @param securityEnabledOnly If true, only membership in security-enabled groups should be checked. Otherwise,
     *     membership in all groups should be checked.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.models.GraphErrorException thrown if the request is rejected by
     *     server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a collection that contains the object IDs of the groups of which the user is a member.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<String> getMemberGroups(String objectId, boolean securityEnabledOnly);

    /**
     * Gets a collection that contains the object IDs of the groups of which the user is a member.
     *
     * @param objectId The object ID of the user for which to get group membership.
     * @param securityEnabledOnly If true, only membership in security-enabled groups should be checked. Otherwise,
     *     membership in all groups should be checked.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.models.GraphErrorException thrown if the request is rejected by
     *     server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a collection that contains the object IDs of the groups of which the user is a member.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<String> getMemberGroups(String objectId, boolean securityEnabledOnly, Context context);
}
