// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;

/** Active Directory Domain information. */
@Fluent
public final class DomainInner {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(DomainInner.class);

    /*
     * the type of the authentication into the domain.
     */
    @JsonProperty(value = "authenticationType", access = JsonProperty.Access.WRITE_ONLY)
    private String authenticationType;

    /*
     * if this is the default domain in the tenant.
     */
    @JsonProperty(value = "isDefault", access = JsonProperty.Access.WRITE_ONLY)
    private Boolean isDefault;

    /*
     * if this domain's ownership is verified.
     */
    @JsonProperty(value = "isVerified", access = JsonProperty.Access.WRITE_ONLY)
    private Boolean isVerified;

    /*
     * the domain name.
     */
    @JsonProperty(value = "name", required = true)
    private String name;

    /*
     * Active Directory Domain information.
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /**
     * Get the authenticationType property: the type of the authentication into the domain.
     *
     * @return the authenticationType value.
     */
    public String authenticationType() {
        return this.authenticationType;
    }

    /**
     * Get the isDefault property: if this is the default domain in the tenant.
     *
     * @return the isDefault value.
     */
    public Boolean isDefault() {
        return this.isDefault;
    }

    /**
     * Get the isVerified property: if this domain's ownership is verified.
     *
     * @return the isVerified value.
     */
    public Boolean isVerified() {
        return this.isVerified;
    }

    /**
     * Get the name property: the domain name.
     *
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: the domain name.
     *
     * @param name the name value to set.
     * @return the DomainInner object itself.
     */
    public DomainInner withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the additionalProperties property: Active Directory Domain information.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: Active Directory Domain information.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the DomainInner object itself.
     */
    public DomainInner withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (name() == null) {
            throw logger
                .logExceptionAsError(
                    new IllegalArgumentException("Missing required property name in model DomainInner"));
        }
    }
}
