// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.authorization.fluent.RoleAssignmentsClient;
import com.azure.resourcemanager.authorization.fluent.models.RoleAssignmentInner;
import com.azure.resourcemanager.authorization.models.RoleAssignmentCreateParameters;
import com.azure.resourcemanager.authorization.models.RoleAssignmentListResult;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsDelete;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsListing;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in RoleAssignmentsClient. */
public final class RoleAssignmentsClientImpl
    implements InnerSupportsListing<RoleAssignmentInner>,
        InnerSupportsDelete<RoleAssignmentInner>,
        RoleAssignmentsClient {
    private final ClientLogger logger = new ClientLogger(RoleAssignmentsClientImpl.class);

    /** The proxy service used to perform REST calls. */
    private final RoleAssignmentsService service;

    /** The service client containing this operation class. */
    private final AuthorizationManagementClientImpl client;

    /**
     * Initializes an instance of RoleAssignmentsClientImpl.
     *
     * @param client the instance of the service client containing this operation class.
     */
    RoleAssignmentsClientImpl(AuthorizationManagementClientImpl client) {
        this.service =
            RestProxy.create(RoleAssignmentsService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for AuthorizationManagementClientRoleAssignments to be used by the proxy
     * service to perform REST calls.
     */
    @Host("{$host}")
    @ServiceInterface(name = "AuthorizationManagem")
    private interface RoleAssignmentsService {
        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Get(
            "/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/{resourceProviderNamespace}"
                + "/{parentResourcePath}/{resourceType}/{resourceName}/providers/Microsoft.Authorization"
                + "/roleAssignments")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<RoleAssignmentListResult>> listForResource(
            @HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("resourceProviderNamespace") String resourceProviderNamespace,
            @PathParam(value = "parentResourcePath", encoded = true) String parentResourcePath,
            @PathParam(value = "resourceType", encoded = true) String resourceType,
            @PathParam("resourceName") String resourceName,
            @QueryParam("$filter") String filter,
            @QueryParam("api-version") String apiVersion,
            @PathParam("subscriptionId") String subscriptionId,
            Context context);

        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Get(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Authorization"
                + "/roleAssignments")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<RoleAssignmentListResult>> listByResourceGroup(
            @HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @QueryParam("$filter") String filter,
            @QueryParam("api-version") String apiVersion,
            @PathParam("subscriptionId") String subscriptionId,
            Context context);

        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Delete("/{scope}/providers/Microsoft.Authorization/roleAssignments/{roleAssignmentName}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<RoleAssignmentInner>> delete(
            @HostParam("$host") String endpoint,
            @PathParam(value = "scope", encoded = true) String scope,
            @PathParam("roleAssignmentName") String roleAssignmentName,
            @QueryParam("api-version") String apiVersion,
            Context context);

        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Put("/{scope}/providers/Microsoft.Authorization/roleAssignments/{roleAssignmentName}")
        @ExpectedResponses({201})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<RoleAssignmentInner>> create(
            @HostParam("$host") String endpoint,
            @PathParam(value = "scope", encoded = true) String scope,
            @PathParam("roleAssignmentName") String roleAssignmentName,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") RoleAssignmentCreateParameters parameters,
            Context context);

        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Get("/{scope}/providers/Microsoft.Authorization/roleAssignments/{roleAssignmentName}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<RoleAssignmentInner>> get(
            @HostParam("$host") String endpoint,
            @PathParam(value = "scope", encoded = true) String scope,
            @PathParam("roleAssignmentName") String roleAssignmentName,
            @QueryParam("api-version") String apiVersion,
            Context context);

        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Delete("/{roleId}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<RoleAssignmentInner>> deleteById(
            @HostParam("$host") String endpoint,
            @PathParam(value = "roleId", encoded = true) String roleId,
            @QueryParam("api-version") String apiVersion,
            Context context);

        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Put("/{roleId}")
        @ExpectedResponses({201})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<RoleAssignmentInner>> createById(
            @HostParam("$host") String endpoint,
            @PathParam(value = "roleId", encoded = true) String roleId,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") RoleAssignmentCreateParameters parameters,
            Context context);

        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Get("/{roleId}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<RoleAssignmentInner>> getById(
            @HostParam("$host") String endpoint,
            @PathParam(value = "roleId", encoded = true) String roleId,
            @QueryParam("api-version") String apiVersion,
            Context context);

        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Get("/subscriptions/{subscriptionId}/providers/Microsoft.Authorization/roleAssignments")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<RoleAssignmentListResult>> list(
            @HostParam("$host") String endpoint,
            @QueryParam("$filter") String filter,
            @QueryParam("api-version") String apiVersion,
            @PathParam("subscriptionId") String subscriptionId,
            Context context);

        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Get("/{scope}/providers/Microsoft.Authorization/roleAssignments")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<RoleAssignmentListResult>> listForScope(
            @HostParam("$host") String endpoint,
            @PathParam(value = "scope", encoded = true) String scope,
            @QueryParam("$filter") String filter,
            @QueryParam("api-version") String apiVersion,
            Context context);

        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<RoleAssignmentListResult>> listForResourceNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, Context context);

        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<RoleAssignmentListResult>> listForResourceGroupNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, Context context);

        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<RoleAssignmentListResult>> listNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, Context context);

        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<RoleAssignmentListResult>> listForScopeNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, Context context);
    }

    /**
     * Gets role assignments for a resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceProviderNamespace The namespace of the resource provider.
     * @param parentResourcePath The parent resource identity.
     * @param resourceType The resource type of the resource.
     * @param resourceName The name of the resource to get role assignments for.
     * @param filter The filter to apply on the operation. Use $filter=atScope() to return all role assignments at or
     *     above the scope. Use $filter=principalId eq {id} to return all role assignments at, above or below the scope
     *     for the specified principal.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role assignments for a resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<RoleAssignmentInner>> listForResourceSinglePageAsync(
        String resourceGroupName,
        String resourceProviderNamespace,
        String parentResourcePath,
        String resourceType,
        String resourceName,
        String filter) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceProviderNamespace == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter resourceProviderNamespace is required and cannot be null."));
        }
        if (parentResourcePath == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter parentResourcePath is required and cannot be null."));
        }
        if (resourceType == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceType is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String apiVersion = "2018-01-01-preview";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .listForResource(
                            this.client.getEndpoint(),
                            resourceGroupName,
                            resourceProviderNamespace,
                            parentResourcePath,
                            resourceType,
                            resourceName,
                            filter,
                            apiVersion,
                            this.client.getSubscriptionId(),
                            context))
            .<PagedResponse<RoleAssignmentInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Gets role assignments for a resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceProviderNamespace The namespace of the resource provider.
     * @param parentResourcePath The parent resource identity.
     * @param resourceType The resource type of the resource.
     * @param resourceName The name of the resource to get role assignments for.
     * @param filter The filter to apply on the operation. Use $filter=atScope() to return all role assignments at or
     *     above the scope. Use $filter=principalId eq {id} to return all role assignments at, above or below the scope
     *     for the specified principal.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role assignments for a resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<RoleAssignmentInner>> listForResourceSinglePageAsync(
        String resourceGroupName,
        String resourceProviderNamespace,
        String parentResourcePath,
        String resourceType,
        String resourceName,
        String filter,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceProviderNamespace == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter resourceProviderNamespace is required and cannot be null."));
        }
        if (parentResourcePath == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter parentResourcePath is required and cannot be null."));
        }
        if (resourceType == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceType is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String apiVersion = "2018-01-01-preview";
        context = this.client.mergeContext(context);
        return service
            .listForResource(
                this.client.getEndpoint(),
                resourceGroupName,
                resourceProviderNamespace,
                parentResourcePath,
                resourceType,
                resourceName,
                filter,
                apiVersion,
                this.client.getSubscriptionId(),
                context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null));
    }

    /**
     * Gets role assignments for a resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceProviderNamespace The namespace of the resource provider.
     * @param parentResourcePath The parent resource identity.
     * @param resourceType The resource type of the resource.
     * @param resourceName The name of the resource to get role assignments for.
     * @param filter The filter to apply on the operation. Use $filter=atScope() to return all role assignments at or
     *     above the scope. Use $filter=principalId eq {id} to return all role assignments at, above or below the scope
     *     for the specified principal.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role assignments for a resource.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<RoleAssignmentInner> listForResourceAsync(
        String resourceGroupName,
        String resourceProviderNamespace,
        String parentResourcePath,
        String resourceType,
        String resourceName,
        String filter) {
        return new PagedFlux<>(
            () ->
                listForResourceSinglePageAsync(
                    resourceGroupName,
                    resourceProviderNamespace,
                    parentResourcePath,
                    resourceType,
                    resourceName,
                    filter),
            nextLink -> listForResourceNextSinglePageAsync(nextLink));
    }

    /**
     * Gets role assignments for a resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceProviderNamespace The namespace of the resource provider.
     * @param parentResourcePath The parent resource identity.
     * @param resourceType The resource type of the resource.
     * @param resourceName The name of the resource to get role assignments for.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role assignments for a resource.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<RoleAssignmentInner> listForResourceAsync(
        String resourceGroupName,
        String resourceProviderNamespace,
        String parentResourcePath,
        String resourceType,
        String resourceName) {
        final String filter = null;
        return new PagedFlux<>(
            () ->
                listForResourceSinglePageAsync(
                    resourceGroupName,
                    resourceProviderNamespace,
                    parentResourcePath,
                    resourceType,
                    resourceName,
                    filter),
            nextLink -> listForResourceNextSinglePageAsync(nextLink));
    }

    /**
     * Gets role assignments for a resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceProviderNamespace The namespace of the resource provider.
     * @param parentResourcePath The parent resource identity.
     * @param resourceType The resource type of the resource.
     * @param resourceName The name of the resource to get role assignments for.
     * @param filter The filter to apply on the operation. Use $filter=atScope() to return all role assignments at or
     *     above the scope. Use $filter=principalId eq {id} to return all role assignments at, above or below the scope
     *     for the specified principal.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role assignments for a resource.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<RoleAssignmentInner> listForResourceAsync(
        String resourceGroupName,
        String resourceProviderNamespace,
        String parentResourcePath,
        String resourceType,
        String resourceName,
        String filter,
        Context context) {
        return new PagedFlux<>(
            () ->
                listForResourceSinglePageAsync(
                    resourceGroupName,
                    resourceProviderNamespace,
                    parentResourcePath,
                    resourceType,
                    resourceName,
                    filter,
                    context),
            nextLink -> listForResourceNextSinglePageAsync(nextLink, context));
    }

    /**
     * Gets role assignments for a resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceProviderNamespace The namespace of the resource provider.
     * @param parentResourcePath The parent resource identity.
     * @param resourceType The resource type of the resource.
     * @param resourceName The name of the resource to get role assignments for.
     * @param filter The filter to apply on the operation. Use $filter=atScope() to return all role assignments at or
     *     above the scope. Use $filter=principalId eq {id} to return all role assignments at, above or below the scope
     *     for the specified principal.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role assignments for a resource.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<RoleAssignmentInner> listForResource(
        String resourceGroupName,
        String resourceProviderNamespace,
        String parentResourcePath,
        String resourceType,
        String resourceName,
        String filter,
        Context context) {
        return new PagedIterable<>(
            listForResourceAsync(
                resourceGroupName,
                resourceProviderNamespace,
                parentResourcePath,
                resourceType,
                resourceName,
                filter,
                context));
    }

    /**
     * Gets role assignments for a resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceProviderNamespace The namespace of the resource provider.
     * @param parentResourcePath The parent resource identity.
     * @param resourceType The resource type of the resource.
     * @param resourceName The name of the resource to get role assignments for.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role assignments for a resource.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<RoleAssignmentInner> listForResource(
        String resourceGroupName,
        String resourceProviderNamespace,
        String parentResourcePath,
        String resourceType,
        String resourceName) {
        final String filter = null;
        return new PagedIterable<>(
            listForResourceAsync(
                resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, filter));
    }

    /**
     * Gets role assignments for a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param filter The filter to apply on the operation. Use $filter=atScope() to return all role assignments at or
     *     above the scope. Use $filter=principalId eq {id} to return all role assignments at, above or below the scope
     *     for the specified principal.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role assignments for a resource group.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<RoleAssignmentInner>> listByResourceGroupSinglePageAsync(
        String resourceGroupName, String filter) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String apiVersion = "2018-01-01-preview";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .listByResourceGroup(
                            this.client.getEndpoint(),
                            resourceGroupName,
                            filter,
                            apiVersion,
                            this.client.getSubscriptionId(),
                            context))
            .<PagedResponse<RoleAssignmentInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Gets role assignments for a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param filter The filter to apply on the operation. Use $filter=atScope() to return all role assignments at or
     *     above the scope. Use $filter=principalId eq {id} to return all role assignments at, above or below the scope
     *     for the specified principal.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role assignments for a resource group.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<RoleAssignmentInner>> listByResourceGroupSinglePageAsync(
        String resourceGroupName, String filter, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String apiVersion = "2018-01-01-preview";
        context = this.client.mergeContext(context);
        return service
            .listByResourceGroup(
                this.client.getEndpoint(),
                resourceGroupName,
                filter,
                apiVersion,
                this.client.getSubscriptionId(),
                context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null));
    }

    /**
     * Gets role assignments for a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param filter The filter to apply on the operation. Use $filter=atScope() to return all role assignments at or
     *     above the scope. Use $filter=principalId eq {id} to return all role assignments at, above or below the scope
     *     for the specified principal.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role assignments for a resource group.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<RoleAssignmentInner> listByResourceGroupAsync(String resourceGroupName, String filter) {
        return new PagedFlux<>(
            () -> listByResourceGroupSinglePageAsync(resourceGroupName, filter),
            nextLink -> listForResourceGroupNextSinglePageAsync(nextLink));
    }

    /**
     * Gets role assignments for a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role assignments for a resource group.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<RoleAssignmentInner> listByResourceGroupAsync(String resourceGroupName) {
        final String filter = null;
        return new PagedFlux<>(
            () -> listByResourceGroupSinglePageAsync(resourceGroupName, filter),
            nextLink -> listForResourceGroupNextSinglePageAsync(nextLink));
    }

    /**
     * Gets role assignments for a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param filter The filter to apply on the operation. Use $filter=atScope() to return all role assignments at or
     *     above the scope. Use $filter=principalId eq {id} to return all role assignments at, above or below the scope
     *     for the specified principal.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role assignments for a resource group.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<RoleAssignmentInner> listByResourceGroupAsync(
        String resourceGroupName, String filter, Context context) {
        return new PagedFlux<>(
            () -> listByResourceGroupSinglePageAsync(resourceGroupName, filter, context),
            nextLink -> listForResourceGroupNextSinglePageAsync(nextLink, context));
    }

    /**
     * Gets role assignments for a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param filter The filter to apply on the operation. Use $filter=atScope() to return all role assignments at or
     *     above the scope. Use $filter=principalId eq {id} to return all role assignments at, above or below the scope
     *     for the specified principal.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role assignments for a resource group.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<RoleAssignmentInner> listByResourceGroup(
        String resourceGroupName, String filter, Context context) {
        return new PagedIterable<>(listByResourceGroupAsync(resourceGroupName, filter, context));
    }

    /**
     * Gets role assignments for a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role assignments for a resource group.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<RoleAssignmentInner> listByResourceGroup(String resourceGroupName) {
        final String filter = null;
        return new PagedIterable<>(listByResourceGroupAsync(resourceGroupName, filter));
    }

    /**
     * Deletes a role assignment.
     *
     * @param scope The scope of the role assignment to delete.
     * @param roleAssignmentName The name of the role assignment to delete.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role Assignments.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<RoleAssignmentInner>> deleteWithResponseAsync(String scope, String roleAssignmentName) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error(new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (roleAssignmentName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter roleAssignmentName is required and cannot be null."));
        }
        final String apiVersion = "2018-01-01-preview";
        return FluxUtil
            .withContext(
                context -> service.delete(this.client.getEndpoint(), scope, roleAssignmentName, apiVersion, context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Deletes a role assignment.
     *
     * @param scope The scope of the role assignment to delete.
     * @param roleAssignmentName The name of the role assignment to delete.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role Assignments.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<RoleAssignmentInner>> deleteWithResponseAsync(
        String scope, String roleAssignmentName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error(new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (roleAssignmentName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter roleAssignmentName is required and cannot be null."));
        }
        final String apiVersion = "2018-01-01-preview";
        context = this.client.mergeContext(context);
        return service.delete(this.client.getEndpoint(), scope, roleAssignmentName, apiVersion, context);
    }

    /**
     * Deletes a role assignment.
     *
     * @param scope The scope of the role assignment to delete.
     * @param roleAssignmentName The name of the role assignment to delete.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role Assignments.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<RoleAssignmentInner> deleteAsync(String scope, String roleAssignmentName) {
        return deleteWithResponseAsync(scope, roleAssignmentName)
            .flatMap(
                (Response<RoleAssignmentInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Deletes a role assignment.
     *
     * @param scope The scope of the role assignment to delete.
     * @param roleAssignmentName The name of the role assignment to delete.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role Assignments.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public RoleAssignmentInner delete(String scope, String roleAssignmentName) {
        return deleteAsync(scope, roleAssignmentName).block();
    }

    /**
     * Deletes a role assignment.
     *
     * @param scope The scope of the role assignment to delete.
     * @param roleAssignmentName The name of the role assignment to delete.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role Assignments.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<RoleAssignmentInner> deleteWithResponse(String scope, String roleAssignmentName, Context context) {
        return deleteWithResponseAsync(scope, roleAssignmentName, context).block();
    }

    /**
     * Creates a role assignment.
     *
     * @param scope The scope of the role assignment to create. The scope can be any REST resource instance. For
     *     example, use '/subscriptions/{subscription-id}/' for a subscription,
     *     '/subscriptions/{subscription-id}/resourceGroups/{resource-group-name}' for a resource group, and
     *     '/subscriptions/{subscription-id}/resourceGroups/{resource-group-name}/providers/{resource-provider}/{resource-type}/{resource-name}'
     *     for a resource.
     * @param roleAssignmentName The name of the role assignment to create. It can be any valid GUID.
     * @param parameters Role assignment create parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role Assignments.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<RoleAssignmentInner>> createWithResponseAsync(
        String scope, String roleAssignmentName, RoleAssignmentCreateParameters parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error(new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (roleAssignmentName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter roleAssignmentName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        final String apiVersion = "2018-01-01-preview";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .create(this.client.getEndpoint(), scope, roleAssignmentName, apiVersion, parameters, context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Creates a role assignment.
     *
     * @param scope The scope of the role assignment to create. The scope can be any REST resource instance. For
     *     example, use '/subscriptions/{subscription-id}/' for a subscription,
     *     '/subscriptions/{subscription-id}/resourceGroups/{resource-group-name}' for a resource group, and
     *     '/subscriptions/{subscription-id}/resourceGroups/{resource-group-name}/providers/{resource-provider}/{resource-type}/{resource-name}'
     *     for a resource.
     * @param roleAssignmentName The name of the role assignment to create. It can be any valid GUID.
     * @param parameters Role assignment create parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role Assignments.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<RoleAssignmentInner>> createWithResponseAsync(
        String scope, String roleAssignmentName, RoleAssignmentCreateParameters parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error(new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (roleAssignmentName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter roleAssignmentName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        final String apiVersion = "2018-01-01-preview";
        context = this.client.mergeContext(context);
        return service.create(this.client.getEndpoint(), scope, roleAssignmentName, apiVersion, parameters, context);
    }

    /**
     * Creates a role assignment.
     *
     * @param scope The scope of the role assignment to create. The scope can be any REST resource instance. For
     *     example, use '/subscriptions/{subscription-id}/' for a subscription,
     *     '/subscriptions/{subscription-id}/resourceGroups/{resource-group-name}' for a resource group, and
     *     '/subscriptions/{subscription-id}/resourceGroups/{resource-group-name}/providers/{resource-provider}/{resource-type}/{resource-name}'
     *     for a resource.
     * @param roleAssignmentName The name of the role assignment to create. It can be any valid GUID.
     * @param parameters Role assignment create parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role Assignments.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<RoleAssignmentInner> createAsync(
        String scope, String roleAssignmentName, RoleAssignmentCreateParameters parameters) {
        return createWithResponseAsync(scope, roleAssignmentName, parameters)
            .flatMap(
                (Response<RoleAssignmentInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Creates a role assignment.
     *
     * @param scope The scope of the role assignment to create. The scope can be any REST resource instance. For
     *     example, use '/subscriptions/{subscription-id}/' for a subscription,
     *     '/subscriptions/{subscription-id}/resourceGroups/{resource-group-name}' for a resource group, and
     *     '/subscriptions/{subscription-id}/resourceGroups/{resource-group-name}/providers/{resource-provider}/{resource-type}/{resource-name}'
     *     for a resource.
     * @param roleAssignmentName The name of the role assignment to create. It can be any valid GUID.
     * @param parameters Role assignment create parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role Assignments.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public RoleAssignmentInner create(
        String scope, String roleAssignmentName, RoleAssignmentCreateParameters parameters) {
        return createAsync(scope, roleAssignmentName, parameters).block();
    }

    /**
     * Creates a role assignment.
     *
     * @param scope The scope of the role assignment to create. The scope can be any REST resource instance. For
     *     example, use '/subscriptions/{subscription-id}/' for a subscription,
     *     '/subscriptions/{subscription-id}/resourceGroups/{resource-group-name}' for a resource group, and
     *     '/subscriptions/{subscription-id}/resourceGroups/{resource-group-name}/providers/{resource-provider}/{resource-type}/{resource-name}'
     *     for a resource.
     * @param roleAssignmentName The name of the role assignment to create. It can be any valid GUID.
     * @param parameters Role assignment create parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role Assignments.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<RoleAssignmentInner> createWithResponse(
        String scope, String roleAssignmentName, RoleAssignmentCreateParameters parameters, Context context) {
        return createWithResponseAsync(scope, roleAssignmentName, parameters, context).block();
    }

    /**
     * Get the specified role assignment.
     *
     * @param scope The scope of the role assignment.
     * @param roleAssignmentName The name of the role assignment to get.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the specified role assignment.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<RoleAssignmentInner>> getWithResponseAsync(String scope, String roleAssignmentName) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error(new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (roleAssignmentName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter roleAssignmentName is required and cannot be null."));
        }
        final String apiVersion = "2018-01-01-preview";
        return FluxUtil
            .withContext(
                context -> service.get(this.client.getEndpoint(), scope, roleAssignmentName, apiVersion, context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get the specified role assignment.
     *
     * @param scope The scope of the role assignment.
     * @param roleAssignmentName The name of the role assignment to get.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the specified role assignment.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<RoleAssignmentInner>> getWithResponseAsync(
        String scope, String roleAssignmentName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error(new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (roleAssignmentName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter roleAssignmentName is required and cannot be null."));
        }
        final String apiVersion = "2018-01-01-preview";
        context = this.client.mergeContext(context);
        return service.get(this.client.getEndpoint(), scope, roleAssignmentName, apiVersion, context);
    }

    /**
     * Get the specified role assignment.
     *
     * @param scope The scope of the role assignment.
     * @param roleAssignmentName The name of the role assignment to get.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the specified role assignment.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<RoleAssignmentInner> getAsync(String scope, String roleAssignmentName) {
        return getWithResponseAsync(scope, roleAssignmentName)
            .flatMap(
                (Response<RoleAssignmentInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Get the specified role assignment.
     *
     * @param scope The scope of the role assignment.
     * @param roleAssignmentName The name of the role assignment to get.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the specified role assignment.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public RoleAssignmentInner get(String scope, String roleAssignmentName) {
        return getAsync(scope, roleAssignmentName).block();
    }

    /**
     * Get the specified role assignment.
     *
     * @param scope The scope of the role assignment.
     * @param roleAssignmentName The name of the role assignment to get.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the specified role assignment.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<RoleAssignmentInner> getWithResponse(String scope, String roleAssignmentName, Context context) {
        return getWithResponseAsync(scope, roleAssignmentName, context).block();
    }

    /**
     * Deletes a role assignment.
     *
     * @param roleId The ID of the role assignment to delete.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role Assignments.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<RoleAssignmentInner>> deleteByIdWithResponseAsync(String roleId) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (roleId == null) {
            return Mono.error(new IllegalArgumentException("Parameter roleId is required and cannot be null."));
        }
        final String apiVersion = "2018-01-01-preview";
        return FluxUtil
            .withContext(context -> service.deleteById(this.client.getEndpoint(), roleId, apiVersion, context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Deletes a role assignment.
     *
     * @param roleId The ID of the role assignment to delete.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role Assignments.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<RoleAssignmentInner>> deleteByIdWithResponseAsync(String roleId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (roleId == null) {
            return Mono.error(new IllegalArgumentException("Parameter roleId is required and cannot be null."));
        }
        final String apiVersion = "2018-01-01-preview";
        context = this.client.mergeContext(context);
        return service.deleteById(this.client.getEndpoint(), roleId, apiVersion, context);
    }

    /**
     * Deletes a role assignment.
     *
     * @param roleId The ID of the role assignment to delete.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role Assignments.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<RoleAssignmentInner> deleteByIdAsync(String roleId) {
        return deleteByIdWithResponseAsync(roleId)
            .flatMap(
                (Response<RoleAssignmentInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Deletes a role assignment.
     *
     * @param roleId The ID of the role assignment to delete.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role Assignments.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public RoleAssignmentInner deleteById(String roleId) {
        return deleteByIdAsync(roleId).block();
    }

    /**
     * Deletes a role assignment.
     *
     * @param roleId The ID of the role assignment to delete.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role Assignments.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<RoleAssignmentInner> deleteByIdWithResponse(String roleId, Context context) {
        return deleteByIdWithResponseAsync(roleId, context).block();
    }

    /**
     * Creates a role assignment by ID.
     *
     * @param roleId The ID of the role assignment to create.
     * @param parameters Role assignment create parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role Assignments.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<RoleAssignmentInner>> createByIdWithResponseAsync(
        String roleId, RoleAssignmentCreateParameters parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (roleId == null) {
            return Mono.error(new IllegalArgumentException("Parameter roleId is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        final String apiVersion = "2018-01-01-preview";
        return FluxUtil
            .withContext(
                context -> service.createById(this.client.getEndpoint(), roleId, apiVersion, parameters, context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Creates a role assignment by ID.
     *
     * @param roleId The ID of the role assignment to create.
     * @param parameters Role assignment create parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role Assignments.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<RoleAssignmentInner>> createByIdWithResponseAsync(
        String roleId, RoleAssignmentCreateParameters parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (roleId == null) {
            return Mono.error(new IllegalArgumentException("Parameter roleId is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        final String apiVersion = "2018-01-01-preview";
        context = this.client.mergeContext(context);
        return service.createById(this.client.getEndpoint(), roleId, apiVersion, parameters, context);
    }

    /**
     * Creates a role assignment by ID.
     *
     * @param roleId The ID of the role assignment to create.
     * @param parameters Role assignment create parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role Assignments.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<RoleAssignmentInner> createByIdAsync(String roleId, RoleAssignmentCreateParameters parameters) {
        return createByIdWithResponseAsync(roleId, parameters)
            .flatMap(
                (Response<RoleAssignmentInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Creates a role assignment by ID.
     *
     * @param roleId The ID of the role assignment to create.
     * @param parameters Role assignment create parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role Assignments.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public RoleAssignmentInner createById(String roleId, RoleAssignmentCreateParameters parameters) {
        return createByIdAsync(roleId, parameters).block();
    }

    /**
     * Creates a role assignment by ID.
     *
     * @param roleId The ID of the role assignment to create.
     * @param parameters Role assignment create parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role Assignments.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<RoleAssignmentInner> createByIdWithResponse(
        String roleId, RoleAssignmentCreateParameters parameters, Context context) {
        return createByIdWithResponseAsync(roleId, parameters, context).block();
    }

    /**
     * Gets a role assignment by ID.
     *
     * @param roleId The ID of the role assignment to get.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a role assignment by ID.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<RoleAssignmentInner>> getByIdWithResponseAsync(String roleId) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (roleId == null) {
            return Mono.error(new IllegalArgumentException("Parameter roleId is required and cannot be null."));
        }
        final String apiVersion = "2018-01-01-preview";
        return FluxUtil
            .withContext(context -> service.getById(this.client.getEndpoint(), roleId, apiVersion, context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Gets a role assignment by ID.
     *
     * @param roleId The ID of the role assignment to get.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a role assignment by ID.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<RoleAssignmentInner>> getByIdWithResponseAsync(String roleId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (roleId == null) {
            return Mono.error(new IllegalArgumentException("Parameter roleId is required and cannot be null."));
        }
        final String apiVersion = "2018-01-01-preview";
        context = this.client.mergeContext(context);
        return service.getById(this.client.getEndpoint(), roleId, apiVersion, context);
    }

    /**
     * Gets a role assignment by ID.
     *
     * @param roleId The ID of the role assignment to get.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a role assignment by ID.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<RoleAssignmentInner> getByIdAsync(String roleId) {
        return getByIdWithResponseAsync(roleId)
            .flatMap(
                (Response<RoleAssignmentInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Gets a role assignment by ID.
     *
     * @param roleId The ID of the role assignment to get.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a role assignment by ID.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public RoleAssignmentInner getById(String roleId) {
        return getByIdAsync(roleId).block();
    }

    /**
     * Gets a role assignment by ID.
     *
     * @param roleId The ID of the role assignment to get.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a role assignment by ID.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<RoleAssignmentInner> getByIdWithResponse(String roleId, Context context) {
        return getByIdWithResponseAsync(roleId, context).block();
    }

    /**
     * Gets all role assignments for the subscription.
     *
     * @param filter The filter to apply on the operation. Use $filter=atScope() to return all role assignments at or
     *     above the scope. Use $filter=principalId eq {id} to return all role assignments at, above or below the scope
     *     for the specified principal.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all role assignments for the subscription.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<RoleAssignmentInner>> listSinglePageAsync(String filter) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String apiVersion = "2018-01-01-preview";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .list(this.client.getEndpoint(), filter, apiVersion, this.client.getSubscriptionId(), context))
            .<PagedResponse<RoleAssignmentInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Gets all role assignments for the subscription.
     *
     * @param filter The filter to apply on the operation. Use $filter=atScope() to return all role assignments at or
     *     above the scope. Use $filter=principalId eq {id} to return all role assignments at, above or below the scope
     *     for the specified principal.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all role assignments for the subscription.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<RoleAssignmentInner>> listSinglePageAsync(String filter, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String apiVersion = "2018-01-01-preview";
        context = this.client.mergeContext(context);
        return service
            .list(this.client.getEndpoint(), filter, apiVersion, this.client.getSubscriptionId(), context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null));
    }

    /**
     * Gets all role assignments for the subscription.
     *
     * @param filter The filter to apply on the operation. Use $filter=atScope() to return all role assignments at or
     *     above the scope. Use $filter=principalId eq {id} to return all role assignments at, above or below the scope
     *     for the specified principal.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all role assignments for the subscription.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<RoleAssignmentInner> listAsync(String filter) {
        return new PagedFlux<>(() -> listSinglePageAsync(filter), nextLink -> listNextSinglePageAsync(nextLink));
    }

    /**
     * Gets all role assignments for the subscription.
     *
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all role assignments for the subscription.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<RoleAssignmentInner> listAsync() {
        final String filter = null;
        return new PagedFlux<>(() -> listSinglePageAsync(filter), nextLink -> listNextSinglePageAsync(nextLink));
    }

    /**
     * Gets all role assignments for the subscription.
     *
     * @param filter The filter to apply on the operation. Use $filter=atScope() to return all role assignments at or
     *     above the scope. Use $filter=principalId eq {id} to return all role assignments at, above or below the scope
     *     for the specified principal.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all role assignments for the subscription.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<RoleAssignmentInner> listAsync(String filter, Context context) {
        return new PagedFlux<>(
            () -> listSinglePageAsync(filter, context), nextLink -> listNextSinglePageAsync(nextLink, context));
    }

    /**
     * Gets all role assignments for the subscription.
     *
     * @param filter The filter to apply on the operation. Use $filter=atScope() to return all role assignments at or
     *     above the scope. Use $filter=principalId eq {id} to return all role assignments at, above or below the scope
     *     for the specified principal.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all role assignments for the subscription.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<RoleAssignmentInner> list(String filter, Context context) {
        return new PagedIterable<>(listAsync(filter, context));
    }

    /**
     * Gets all role assignments for the subscription.
     *
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all role assignments for the subscription.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<RoleAssignmentInner> list() {
        final String filter = null;
        return new PagedIterable<>(listAsync(filter));
    }

    /**
     * Gets role assignments for a scope.
     *
     * @param scope The scope of the role assignments.
     * @param filter The filter to apply on the operation. Use $filter=atScope() to return all role assignments at or
     *     above the scope. Use $filter=principalId eq {id} to return all role assignments at, above or below the scope
     *     for the specified principal.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role assignments for a scope.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<RoleAssignmentInner>> listForScopeSinglePageAsync(String scope, String filter) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error(new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        final String apiVersion = "2018-01-01-preview";
        return FluxUtil
            .withContext(context -> service.listForScope(this.client.getEndpoint(), scope, filter, apiVersion, context))
            .<PagedResponse<RoleAssignmentInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Gets role assignments for a scope.
     *
     * @param scope The scope of the role assignments.
     * @param filter The filter to apply on the operation. Use $filter=atScope() to return all role assignments at or
     *     above the scope. Use $filter=principalId eq {id} to return all role assignments at, above or below the scope
     *     for the specified principal.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role assignments for a scope.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<RoleAssignmentInner>> listForScopeSinglePageAsync(
        String scope, String filter, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error(new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        final String apiVersion = "2018-01-01-preview";
        context = this.client.mergeContext(context);
        return service
            .listForScope(this.client.getEndpoint(), scope, filter, apiVersion, context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null));
    }

    /**
     * Gets role assignments for a scope.
     *
     * @param scope The scope of the role assignments.
     * @param filter The filter to apply on the operation. Use $filter=atScope() to return all role assignments at or
     *     above the scope. Use $filter=principalId eq {id} to return all role assignments at, above or below the scope
     *     for the specified principal.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role assignments for a scope.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<RoleAssignmentInner> listForScopeAsync(String scope, String filter) {
        return new PagedFlux<>(
            () -> listForScopeSinglePageAsync(scope, filter), nextLink -> listForScopeNextSinglePageAsync(nextLink));
    }

    /**
     * Gets role assignments for a scope.
     *
     * @param scope The scope of the role assignments.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role assignments for a scope.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<RoleAssignmentInner> listForScopeAsync(String scope) {
        final String filter = null;
        return new PagedFlux<>(
            () -> listForScopeSinglePageAsync(scope, filter), nextLink -> listForScopeNextSinglePageAsync(nextLink));
    }

    /**
     * Gets role assignments for a scope.
     *
     * @param scope The scope of the role assignments.
     * @param filter The filter to apply on the operation. Use $filter=atScope() to return all role assignments at or
     *     above the scope. Use $filter=principalId eq {id} to return all role assignments at, above or below the scope
     *     for the specified principal.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role assignments for a scope.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<RoleAssignmentInner> listForScopeAsync(String scope, String filter, Context context) {
        return new PagedFlux<>(
            () -> listForScopeSinglePageAsync(scope, filter, context),
            nextLink -> listForScopeNextSinglePageAsync(nextLink, context));
    }

    /**
     * Gets role assignments for a scope.
     *
     * @param scope The scope of the role assignments.
     * @param filter The filter to apply on the operation. Use $filter=atScope() to return all role assignments at or
     *     above the scope. Use $filter=principalId eq {id} to return all role assignments at, above or below the scope
     *     for the specified principal.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role assignments for a scope.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<RoleAssignmentInner> listForScope(String scope, String filter, Context context) {
        return new PagedIterable<>(listForScopeAsync(scope, filter, context));
    }

    /**
     * Gets role assignments for a scope.
     *
     * @param scope The scope of the role assignments.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role assignments for a scope.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<RoleAssignmentInner> listForScope(String scope) {
        final String filter = null;
        return new PagedIterable<>(listForScopeAsync(scope, filter));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role assignment list operation result.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<RoleAssignmentInner>> listForResourceNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil
            .withContext(context -> service.listForResourceNext(nextLink, context))
            .<PagedResponse<RoleAssignmentInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role assignment list operation result.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<RoleAssignmentInner>> listForResourceNextSinglePageAsync(
        String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return service
            .listForResourceNext(nextLink, context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role assignment list operation result.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<RoleAssignmentInner>> listForResourceGroupNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil
            .withContext(context -> service.listForResourceGroupNext(nextLink, context))
            .<PagedResponse<RoleAssignmentInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role assignment list operation result.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<RoleAssignmentInner>> listForResourceGroupNextSinglePageAsync(
        String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return service
            .listForResourceGroupNext(nextLink, context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role assignment list operation result.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<RoleAssignmentInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil
            .withContext(context -> service.listNext(nextLink, context))
            .<PagedResponse<RoleAssignmentInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role assignment list operation result.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<RoleAssignmentInner>> listNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return service
            .listNext(nextLink, context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role assignment list operation result.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<RoleAssignmentInner>> listForScopeNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil
            .withContext(context -> service.listForScopeNext(nextLink, context))
            .<PagedResponse<RoleAssignmentInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role assignment list operation result.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<RoleAssignmentInner>> listForScopeNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return service
            .listForScopeNext(nextLink, context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null));
    }
}
