// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.authorization.fluent.RoleDefinitionsClient;
import com.azure.resourcemanager.authorization.fluent.models.RoleDefinitionInner;
import com.azure.resourcemanager.authorization.models.RoleDefinitionListResult;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsDelete;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in RoleDefinitionsClient. */
public final class RoleDefinitionsClientImpl
    implements InnerSupportsDelete<RoleDefinitionInner>, RoleDefinitionsClient {
    private final ClientLogger logger = new ClientLogger(RoleDefinitionsClientImpl.class);

    /** The proxy service used to perform REST calls. */
    private final RoleDefinitionsService service;

    /** The service client containing this operation class. */
    private final AuthorizationManagementClientImpl client;

    /**
     * Initializes an instance of RoleDefinitionsClientImpl.
     *
     * @param client the instance of the service client containing this operation class.
     */
    RoleDefinitionsClientImpl(AuthorizationManagementClientImpl client) {
        this.service =
            RestProxy.create(RoleDefinitionsService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for AuthorizationManagementClientRoleDefinitions to be used by the proxy
     * service to perform REST calls.
     */
    @Host("{$host}")
    @ServiceInterface(name = "AuthorizationManagem")
    private interface RoleDefinitionsService {
        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Delete("/{scope}/providers/Microsoft.Authorization/roleDefinitions/{roleDefinitionId}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<RoleDefinitionInner>> delete(
            @HostParam("$host") String endpoint,
            @PathParam(value = "scope", encoded = true) String scope,
            @PathParam("roleDefinitionId") String roleDefinitionId,
            @QueryParam("api-version") String apiVersion,
            Context context);

        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Get("/{scope}/providers/Microsoft.Authorization/roleDefinitions/{roleDefinitionId}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<RoleDefinitionInner>> get(
            @HostParam("$host") String endpoint,
            @PathParam(value = "scope", encoded = true) String scope,
            @PathParam("roleDefinitionId") String roleDefinitionId,
            @QueryParam("api-version") String apiVersion,
            Context context);

        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Put("/{scope}/providers/Microsoft.Authorization/roleDefinitions/{roleDefinitionId}")
        @ExpectedResponses({201})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<RoleDefinitionInner>> createOrUpdate(
            @HostParam("$host") String endpoint,
            @PathParam(value = "scope", encoded = true) String scope,
            @PathParam("roleDefinitionId") String roleDefinitionId,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") RoleDefinitionInner roleDefinition,
            Context context);

        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Get("/{scope}/providers/Microsoft.Authorization/roleDefinitions")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<RoleDefinitionListResult>> list(
            @HostParam("$host") String endpoint,
            @PathParam(value = "scope", encoded = true) String scope,
            @QueryParam("$filter") String filter,
            @QueryParam("api-version") String apiVersion,
            Context context);

        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Get("/{roleId}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<RoleDefinitionInner>> getById(
            @HostParam("$host") String endpoint,
            @PathParam(value = "roleId", encoded = true) String roleId,
            @QueryParam("api-version") String apiVersion,
            Context context);

        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<RoleDefinitionListResult>> listNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, Context context);
    }

    /**
     * Deletes a role definition.
     *
     * @param scope The scope of the role definition.
     * @param roleDefinitionId The ID of the role definition to delete.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role definition.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<RoleDefinitionInner>> deleteWithResponseAsync(String scope, String roleDefinitionId) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error(new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (roleDefinitionId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter roleDefinitionId is required and cannot be null."));
        }
        final String apiVersion = "2018-01-01-preview";
        return FluxUtil
            .withContext(
                context -> service.delete(this.client.getEndpoint(), scope, roleDefinitionId, apiVersion, context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Deletes a role definition.
     *
     * @param scope The scope of the role definition.
     * @param roleDefinitionId The ID of the role definition to delete.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role definition.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<RoleDefinitionInner>> deleteWithResponseAsync(
        String scope, String roleDefinitionId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error(new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (roleDefinitionId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter roleDefinitionId is required and cannot be null."));
        }
        final String apiVersion = "2018-01-01-preview";
        context = this.client.mergeContext(context);
        return service.delete(this.client.getEndpoint(), scope, roleDefinitionId, apiVersion, context);
    }

    /**
     * Deletes a role definition.
     *
     * @param scope The scope of the role definition.
     * @param roleDefinitionId The ID of the role definition to delete.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role definition.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<RoleDefinitionInner> deleteAsync(String scope, String roleDefinitionId) {
        return deleteWithResponseAsync(scope, roleDefinitionId)
            .flatMap(
                (Response<RoleDefinitionInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Deletes a role definition.
     *
     * @param scope The scope of the role definition.
     * @param roleDefinitionId The ID of the role definition to delete.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role definition.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public RoleDefinitionInner delete(String scope, String roleDefinitionId) {
        return deleteAsync(scope, roleDefinitionId).block();
    }

    /**
     * Deletes a role definition.
     *
     * @param scope The scope of the role definition.
     * @param roleDefinitionId The ID of the role definition to delete.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role definition.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<RoleDefinitionInner> deleteWithResponse(String scope, String roleDefinitionId, Context context) {
        return deleteWithResponseAsync(scope, roleDefinitionId, context).block();
    }

    /**
     * Get role definition by name (GUID).
     *
     * @param scope The scope of the role definition.
     * @param roleDefinitionId The ID of the role definition.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role definition by name (GUID).
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<RoleDefinitionInner>> getWithResponseAsync(String scope, String roleDefinitionId) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error(new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (roleDefinitionId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter roleDefinitionId is required and cannot be null."));
        }
        final String apiVersion = "2018-01-01-preview";
        return FluxUtil
            .withContext(
                context -> service.get(this.client.getEndpoint(), scope, roleDefinitionId, apiVersion, context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get role definition by name (GUID).
     *
     * @param scope The scope of the role definition.
     * @param roleDefinitionId The ID of the role definition.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role definition by name (GUID).
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<RoleDefinitionInner>> getWithResponseAsync(
        String scope, String roleDefinitionId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error(new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (roleDefinitionId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter roleDefinitionId is required and cannot be null."));
        }
        final String apiVersion = "2018-01-01-preview";
        context = this.client.mergeContext(context);
        return service.get(this.client.getEndpoint(), scope, roleDefinitionId, apiVersion, context);
    }

    /**
     * Get role definition by name (GUID).
     *
     * @param scope The scope of the role definition.
     * @param roleDefinitionId The ID of the role definition.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role definition by name (GUID).
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<RoleDefinitionInner> getAsync(String scope, String roleDefinitionId) {
        return getWithResponseAsync(scope, roleDefinitionId)
            .flatMap(
                (Response<RoleDefinitionInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Get role definition by name (GUID).
     *
     * @param scope The scope of the role definition.
     * @param roleDefinitionId The ID of the role definition.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role definition by name (GUID).
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public RoleDefinitionInner get(String scope, String roleDefinitionId) {
        return getAsync(scope, roleDefinitionId).block();
    }

    /**
     * Get role definition by name (GUID).
     *
     * @param scope The scope of the role definition.
     * @param roleDefinitionId The ID of the role definition.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role definition by name (GUID).
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<RoleDefinitionInner> getWithResponse(String scope, String roleDefinitionId, Context context) {
        return getWithResponseAsync(scope, roleDefinitionId, context).block();
    }

    /**
     * Creates or updates a role definition.
     *
     * @param scope The scope of the role definition.
     * @param roleDefinitionId The ID of the role definition.
     * @param roleDefinition Role definition.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role definition.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<RoleDefinitionInner>> createOrUpdateWithResponseAsync(
        String scope, String roleDefinitionId, RoleDefinitionInner roleDefinition) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error(new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (roleDefinitionId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter roleDefinitionId is required and cannot be null."));
        }
        if (roleDefinition == null) {
            return Mono.error(new IllegalArgumentException("Parameter roleDefinition is required and cannot be null."));
        } else {
            roleDefinition.validate();
        }
        final String apiVersion = "2018-01-01-preview";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .createOrUpdate(
                            this.client.getEndpoint(), scope, roleDefinitionId, apiVersion, roleDefinition, context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Creates or updates a role definition.
     *
     * @param scope The scope of the role definition.
     * @param roleDefinitionId The ID of the role definition.
     * @param roleDefinition Role definition.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role definition.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<RoleDefinitionInner>> createOrUpdateWithResponseAsync(
        String scope, String roleDefinitionId, RoleDefinitionInner roleDefinition, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error(new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (roleDefinitionId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter roleDefinitionId is required and cannot be null."));
        }
        if (roleDefinition == null) {
            return Mono.error(new IllegalArgumentException("Parameter roleDefinition is required and cannot be null."));
        } else {
            roleDefinition.validate();
        }
        final String apiVersion = "2018-01-01-preview";
        context = this.client.mergeContext(context);
        return service
            .createOrUpdate(this.client.getEndpoint(), scope, roleDefinitionId, apiVersion, roleDefinition, context);
    }

    /**
     * Creates or updates a role definition.
     *
     * @param scope The scope of the role definition.
     * @param roleDefinitionId The ID of the role definition.
     * @param roleDefinition Role definition.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role definition.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<RoleDefinitionInner> createOrUpdateAsync(
        String scope, String roleDefinitionId, RoleDefinitionInner roleDefinition) {
        return createOrUpdateWithResponseAsync(scope, roleDefinitionId, roleDefinition)
            .flatMap(
                (Response<RoleDefinitionInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Creates or updates a role definition.
     *
     * @param scope The scope of the role definition.
     * @param roleDefinitionId The ID of the role definition.
     * @param roleDefinition Role definition.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role definition.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public RoleDefinitionInner createOrUpdate(
        String scope, String roleDefinitionId, RoleDefinitionInner roleDefinition) {
        return createOrUpdateAsync(scope, roleDefinitionId, roleDefinition).block();
    }

    /**
     * Creates or updates a role definition.
     *
     * @param scope The scope of the role definition.
     * @param roleDefinitionId The ID of the role definition.
     * @param roleDefinition Role definition.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role definition.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<RoleDefinitionInner> createOrUpdateWithResponse(
        String scope, String roleDefinitionId, RoleDefinitionInner roleDefinition, Context context) {
        return createOrUpdateWithResponseAsync(scope, roleDefinitionId, roleDefinition, context).block();
    }

    /**
     * Get all role definitions that are applicable at scope and above.
     *
     * @param scope The scope of the role definition.
     * @param filter The filter to apply on the operation. Use atScopeAndBelow filter to search below the given scope as
     *     well.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all role definitions that are applicable at scope and above.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<RoleDefinitionInner>> listSinglePageAsync(String scope, String filter) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error(new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        final String apiVersion = "2018-01-01-preview";
        return FluxUtil
            .withContext(context -> service.list(this.client.getEndpoint(), scope, filter, apiVersion, context))
            .<PagedResponse<RoleDefinitionInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get all role definitions that are applicable at scope and above.
     *
     * @param scope The scope of the role definition.
     * @param filter The filter to apply on the operation. Use atScopeAndBelow filter to search below the given scope as
     *     well.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all role definitions that are applicable at scope and above.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<RoleDefinitionInner>> listSinglePageAsync(String scope, String filter, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error(new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        final String apiVersion = "2018-01-01-preview";
        context = this.client.mergeContext(context);
        return service
            .list(this.client.getEndpoint(), scope, filter, apiVersion, context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null));
    }

    /**
     * Get all role definitions that are applicable at scope and above.
     *
     * @param scope The scope of the role definition.
     * @param filter The filter to apply on the operation. Use atScopeAndBelow filter to search below the given scope as
     *     well.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all role definitions that are applicable at scope and above.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<RoleDefinitionInner> listAsync(String scope, String filter) {
        return new PagedFlux<>(() -> listSinglePageAsync(scope, filter), nextLink -> listNextSinglePageAsync(nextLink));
    }

    /**
     * Get all role definitions that are applicable at scope and above.
     *
     * @param scope The scope of the role definition.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all role definitions that are applicable at scope and above.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<RoleDefinitionInner> listAsync(String scope) {
        final String filter = null;
        return new PagedFlux<>(() -> listSinglePageAsync(scope, filter), nextLink -> listNextSinglePageAsync(nextLink));
    }

    /**
     * Get all role definitions that are applicable at scope and above.
     *
     * @param scope The scope of the role definition.
     * @param filter The filter to apply on the operation. Use atScopeAndBelow filter to search below the given scope as
     *     well.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all role definitions that are applicable at scope and above.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<RoleDefinitionInner> listAsync(String scope, String filter, Context context) {
        return new PagedFlux<>(
            () -> listSinglePageAsync(scope, filter, context), nextLink -> listNextSinglePageAsync(nextLink, context));
    }

    /**
     * Get all role definitions that are applicable at scope and above.
     *
     * @param scope The scope of the role definition.
     * @param filter The filter to apply on the operation. Use atScopeAndBelow filter to search below the given scope as
     *     well.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all role definitions that are applicable at scope and above.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<RoleDefinitionInner> list(String scope, String filter, Context context) {
        return new PagedIterable<>(listAsync(scope, filter, context));
    }

    /**
     * Get all role definitions that are applicable at scope and above.
     *
     * @param scope The scope of the role definition.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all role definitions that are applicable at scope and above.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<RoleDefinitionInner> list(String scope) {
        final String filter = null;
        return new PagedIterable<>(listAsync(scope, filter));
    }

    /**
     * Gets a role definition by ID.
     *
     * @param roleId The fully qualified role definition ID. Use the format,
     *     /subscriptions/{guid}/providers/Microsoft.Authorization/roleDefinitions/{roleDefinitionId} for subscription
     *     level role definitions, or /providers/Microsoft.Authorization/roleDefinitions/{roleDefinitionId} for tenant
     *     level role definitions.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a role definition by ID.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<RoleDefinitionInner>> getByIdWithResponseAsync(String roleId) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (roleId == null) {
            return Mono.error(new IllegalArgumentException("Parameter roleId is required and cannot be null."));
        }
        final String apiVersion = "2018-01-01-preview";
        return FluxUtil
            .withContext(context -> service.getById(this.client.getEndpoint(), roleId, apiVersion, context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Gets a role definition by ID.
     *
     * @param roleId The fully qualified role definition ID. Use the format,
     *     /subscriptions/{guid}/providers/Microsoft.Authorization/roleDefinitions/{roleDefinitionId} for subscription
     *     level role definitions, or /providers/Microsoft.Authorization/roleDefinitions/{roleDefinitionId} for tenant
     *     level role definitions.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a role definition by ID.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<RoleDefinitionInner>> getByIdWithResponseAsync(String roleId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (roleId == null) {
            return Mono.error(new IllegalArgumentException("Parameter roleId is required and cannot be null."));
        }
        final String apiVersion = "2018-01-01-preview";
        context = this.client.mergeContext(context);
        return service.getById(this.client.getEndpoint(), roleId, apiVersion, context);
    }

    /**
     * Gets a role definition by ID.
     *
     * @param roleId The fully qualified role definition ID. Use the format,
     *     /subscriptions/{guid}/providers/Microsoft.Authorization/roleDefinitions/{roleDefinitionId} for subscription
     *     level role definitions, or /providers/Microsoft.Authorization/roleDefinitions/{roleDefinitionId} for tenant
     *     level role definitions.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a role definition by ID.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<RoleDefinitionInner> getByIdAsync(String roleId) {
        return getByIdWithResponseAsync(roleId)
            .flatMap(
                (Response<RoleDefinitionInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Gets a role definition by ID.
     *
     * @param roleId The fully qualified role definition ID. Use the format,
     *     /subscriptions/{guid}/providers/Microsoft.Authorization/roleDefinitions/{roleDefinitionId} for subscription
     *     level role definitions, or /providers/Microsoft.Authorization/roleDefinitions/{roleDefinitionId} for tenant
     *     level role definitions.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a role definition by ID.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public RoleDefinitionInner getById(String roleId) {
        return getByIdAsync(roleId).block();
    }

    /**
     * Gets a role definition by ID.
     *
     * @param roleId The fully qualified role definition ID. Use the format,
     *     /subscriptions/{guid}/providers/Microsoft.Authorization/roleDefinitions/{roleDefinitionId} for subscription
     *     level role definitions, or /providers/Microsoft.Authorization/roleDefinitions/{roleDefinitionId} for tenant
     *     level role definitions.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a role definition by ID.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<RoleDefinitionInner> getByIdWithResponse(String roleId, Context context) {
        return getByIdWithResponseAsync(roleId, context).block();
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role definition list operation result.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<RoleDefinitionInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil
            .withContext(context -> service.listNext(nextLink, context))
            .<PagedResponse<RoleDefinitionInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role definition list operation result.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<RoleDefinitionInner>> listNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return service
            .listNext(nextLink, context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null));
    }
}
