// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.authorization.fluent.ServicePrincipalsClient;
import com.azure.resourcemanager.authorization.fluent.models.DirectoryObjectInner;
import com.azure.resourcemanager.authorization.fluent.models.KeyCredentialInner;
import com.azure.resourcemanager.authorization.fluent.models.PasswordCredentialInner;
import com.azure.resourcemanager.authorization.fluent.models.ServicePrincipalInner;
import com.azure.resourcemanager.authorization.models.DirectoryObjectListResult;
import com.azure.resourcemanager.authorization.models.GraphErrorException;
import com.azure.resourcemanager.authorization.models.KeyCredentialListResult;
import com.azure.resourcemanager.authorization.models.KeyCredentialsUpdateParameters;
import com.azure.resourcemanager.authorization.models.PasswordCredentialListResult;
import com.azure.resourcemanager.authorization.models.PasswordCredentialsUpdateParameters;
import com.azure.resourcemanager.authorization.models.ServicePrincipalBase;
import com.azure.resourcemanager.authorization.models.ServicePrincipalCreateParameters;
import com.azure.resourcemanager.authorization.models.ServicePrincipalListResult;
import java.util.List;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in ServicePrincipalsClient. */
public final class ServicePrincipalsClientImpl implements ServicePrincipalsClient {
    private final ClientLogger logger = new ClientLogger(ServicePrincipalsClientImpl.class);

    /** The proxy service used to perform REST calls. */
    private final ServicePrincipalsService service;

    /** The service client containing this operation class. */
    private final GraphRbacManagementClientImpl client;

    /**
     * Initializes an instance of ServicePrincipalsClientImpl.
     *
     * @param client the instance of the service client containing this operation class.
     */
    ServicePrincipalsClientImpl(GraphRbacManagementClientImpl client) {
        this.service =
            RestProxy.create(ServicePrincipalsService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for GraphRbacManagementClientServicePrincipals to be used by the proxy
     * service to perform REST calls.
     */
    @Host("{$host}")
    @ServiceInterface(name = "GraphRbacManagementC")
    private interface ServicePrincipalsService {
        @Headers({"Accept: application/json,text/json", "Content-Type: application/json"})
        @Post("/{tenantID}/servicePrincipals")
        @ExpectedResponses({201})
        @UnexpectedResponseExceptionType(GraphErrorException.class)
        Mono<Response<ServicePrincipalInner>> create(
            @HostParam("$host") String endpoint,
            @QueryParam("api-version") String apiVersion,
            @PathParam("tenantID") String tenantId,
            @BodyParam("application/json") ServicePrincipalCreateParameters parameters,
            Context context);

        @Headers({"Accept: application/json,text/json", "Content-Type: application/json"})
        @Get("/{tenantID}/servicePrincipals")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(GraphErrorException.class)
        Mono<Response<ServicePrincipalListResult>> list(
            @HostParam("$host") String endpoint,
            @QueryParam("$filter") String filter,
            @QueryParam("api-version") String apiVersion,
            @PathParam("tenantID") String tenantId,
            Context context);

        @Headers({"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Patch("/{tenantID}/servicePrincipals/{objectId}")
        @ExpectedResponses({204})
        @UnexpectedResponseExceptionType(GraphErrorException.class)
        Mono<Response<Void>> update(
            @HostParam("$host") String endpoint,
            @PathParam("objectId") String objectId,
            @QueryParam("api-version") String apiVersion,
            @PathParam("tenantID") String tenantId,
            @BodyParam("application/json") ServicePrincipalBase parameters,
            Context context);

        @Headers({"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Delete("/{tenantID}/servicePrincipals/{objectId}")
        @ExpectedResponses({204})
        @UnexpectedResponseExceptionType(GraphErrorException.class)
        Mono<Response<Void>> delete(
            @HostParam("$host") String endpoint,
            @PathParam("objectId") String objectId,
            @QueryParam("api-version") String apiVersion,
            @PathParam("tenantID") String tenantId,
            Context context);

        @Headers({"Accept: application/json,text/json", "Content-Type: application/json"})
        @Get("/{tenantID}/servicePrincipals/{objectId}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(GraphErrorException.class)
        Mono<Response<ServicePrincipalInner>> get(
            @HostParam("$host") String endpoint,
            @PathParam("objectId") String objectId,
            @QueryParam("api-version") String apiVersion,
            @PathParam("tenantID") String tenantId,
            Context context);

        @Headers({"Accept: application/json,text/json", "Content-Type: application/json"})
        @Get("/{tenantID}/servicePrincipals/{objectId}/owners")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(GraphErrorException.class)
        Mono<Response<DirectoryObjectListResult>> listOwners(
            @HostParam("$host") String endpoint,
            @PathParam("objectId") String objectId,
            @QueryParam("api-version") String apiVersion,
            @PathParam("tenantID") String tenantId,
            Context context);

        @Headers({"Accept: application/json,text/json", "Content-Type: application/json"})
        @Get("/{tenantID}/servicePrincipals/{objectId}/keyCredentials")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(GraphErrorException.class)
        Mono<Response<KeyCredentialListResult>> listKeyCredentials(
            @HostParam("$host") String endpoint,
            @PathParam("objectId") String objectId,
            @QueryParam("api-version") String apiVersion,
            @PathParam("tenantID") String tenantId,
            Context context);

        @Headers({"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Patch("/{tenantID}/servicePrincipals/{objectId}/keyCredentials")
        @ExpectedResponses({204})
        @UnexpectedResponseExceptionType(GraphErrorException.class)
        Mono<Response<Void>> updateKeyCredentials(
            @HostParam("$host") String endpoint,
            @PathParam("objectId") String objectId,
            @QueryParam("api-version") String apiVersion,
            @PathParam("tenantID") String tenantId,
            @BodyParam("application/json") KeyCredentialsUpdateParameters parameters,
            Context context);

        @Headers({"Accept: application/json,text/json", "Content-Type: application/json"})
        @Get("/{tenantID}/servicePrincipals/{objectId}/passwordCredentials")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(GraphErrorException.class)
        Mono<Response<PasswordCredentialListResult>> listPasswordCredentials(
            @HostParam("$host") String endpoint,
            @PathParam("objectId") String objectId,
            @QueryParam("api-version") String apiVersion,
            @PathParam("tenantID") String tenantId,
            Context context);

        @Headers({"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Patch("/{tenantID}/servicePrincipals/{objectId}/passwordCredentials")
        @ExpectedResponses({204})
        @UnexpectedResponseExceptionType(GraphErrorException.class)
        Mono<Response<Void>> updatePasswordCredentials(
            @HostParam("$host") String endpoint,
            @PathParam("objectId") String objectId,
            @QueryParam("api-version") String apiVersion,
            @PathParam("tenantID") String tenantId,
            @BodyParam("application/json") PasswordCredentialsUpdateParameters parameters,
            Context context);

        @Headers({"Accept: application/json,text/json", "Content-Type: application/json"})
        @Get("/{tenantID}/{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(GraphErrorException.class)
        Mono<Response<ServicePrincipalListResult>> listNext(
            @HostParam("$host") String endpoint,
            @PathParam(value = "nextLink", encoded = true) String nextLink,
            @QueryParam("api-version") String apiVersion,
            @PathParam("tenantID") String tenantId,
            Context context);

        @Headers({"Accept: application/json,text/json", "Content-Type: application/json"})
        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(GraphErrorException.class)
        Mono<Response<DirectoryObjectListResult>> listOwnersNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, Context context);
    }

    /**
     * Creates a service principal in the directory.
     *
     * @param parameters Request parameters for creating a new service principal.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws GraphErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return active Directory service principal information.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<ServicePrincipalInner>> createWithResponseAsync(ServicePrincipalCreateParameters parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getTenantId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getTenantId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        return FluxUtil
            .withContext(
                context ->
                    service
                        .create(
                            this.client.getEndpoint(),
                            this.client.getApiVersion(),
                            this.client.getTenantId(),
                            parameters,
                            context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Creates a service principal in the directory.
     *
     * @param parameters Request parameters for creating a new service principal.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws GraphErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return active Directory service principal information.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<ServicePrincipalInner>> createWithResponseAsync(
        ServicePrincipalCreateParameters parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getTenantId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getTenantId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        context = this.client.mergeContext(context);
        return service
            .create(
                this.client.getEndpoint(), this.client.getApiVersion(), this.client.getTenantId(), parameters, context);
    }

    /**
     * Creates a service principal in the directory.
     *
     * @param parameters Request parameters for creating a new service principal.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws GraphErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return active Directory service principal information.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ServicePrincipalInner> createAsync(ServicePrincipalCreateParameters parameters) {
        return createWithResponseAsync(parameters)
            .flatMap(
                (Response<ServicePrincipalInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Creates a service principal in the directory.
     *
     * @param parameters Request parameters for creating a new service principal.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws GraphErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return active Directory service principal information.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ServicePrincipalInner create(ServicePrincipalCreateParameters parameters) {
        return createAsync(parameters).block();
    }

    /**
     * Creates a service principal in the directory.
     *
     * @param parameters Request parameters for creating a new service principal.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws GraphErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return active Directory service principal information.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<ServicePrincipalInner> createWithResponse(
        ServicePrincipalCreateParameters parameters, Context context) {
        return createWithResponseAsync(parameters, context).block();
    }

    /**
     * Gets a list of service principals from the current tenant.
     *
     * @param filter The filter to apply to the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws GraphErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of service principals from the current tenant.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<ServicePrincipalInner>> listSinglePageAsync(String filter) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getTenantId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getTenantId() is required and cannot be null."));
        }
        return FluxUtil
            .withContext(
                context ->
                    service
                        .list(
                            this.client.getEndpoint(),
                            filter,
                            this.client.getApiVersion(),
                            this.client.getTenantId(),
                            context))
            .<PagedResponse<ServicePrincipalInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Gets a list of service principals from the current tenant.
     *
     * @param filter The filter to apply to the operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws GraphErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of service principals from the current tenant.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<ServicePrincipalInner>> listSinglePageAsync(String filter, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getTenantId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getTenantId() is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return service
            .list(this.client.getEndpoint(), filter, this.client.getApiVersion(), this.client.getTenantId(), context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null));
    }

    /**
     * Gets a list of service principals from the current tenant.
     *
     * @param filter The filter to apply to the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws GraphErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of service principals from the current tenant.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<ServicePrincipalInner> listAsync(String filter) {
        return new PagedFlux<>(() -> listSinglePageAsync(filter), nextLink -> listNextSinglePageAsync(nextLink));
    }

    /**
     * Gets a list of service principals from the current tenant.
     *
     * @throws GraphErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of service principals from the current tenant.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<ServicePrincipalInner> listAsync() {
        final String filter = null;
        return new PagedFlux<>(() -> listSinglePageAsync(filter), nextLink -> listNextSinglePageAsync(nextLink));
    }

    /**
     * Gets a list of service principals from the current tenant.
     *
     * @param filter The filter to apply to the operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws GraphErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of service principals from the current tenant.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<ServicePrincipalInner> listAsync(String filter, Context context) {
        return new PagedFlux<>(
            () -> listSinglePageAsync(filter, context), nextLink -> listNextSinglePageAsync(nextLink, context));
    }

    /**
     * Gets a list of service principals from the current tenant.
     *
     * @param filter The filter to apply to the operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws GraphErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of service principals from the current tenant.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<ServicePrincipalInner> list(String filter, Context context) {
        return new PagedIterable<>(listAsync(filter, context));
    }

    /**
     * Gets a list of service principals from the current tenant.
     *
     * @throws GraphErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of service principals from the current tenant.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<ServicePrincipalInner> list() {
        final String filter = null;
        return new PagedIterable<>(listAsync(filter));
    }

    /**
     * Updates a service principal in the directory.
     *
     * @param objectId The object ID of the service principal to delete.
     * @param parameters Active Directory service principal common properties shared among GET, POST and PATCH.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws GraphErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> updateWithResponseAsync(String objectId, ServicePrincipalBase parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (objectId == null) {
            return Mono.error(new IllegalArgumentException("Parameter objectId is required and cannot be null."));
        }
        if (this.client.getTenantId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getTenantId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        return FluxUtil
            .withContext(
                context ->
                    service
                        .update(
                            this.client.getEndpoint(),
                            objectId,
                            this.client.getApiVersion(),
                            this.client.getTenantId(),
                            parameters,
                            context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Updates a service principal in the directory.
     *
     * @param objectId The object ID of the service principal to delete.
     * @param parameters Active Directory service principal common properties shared among GET, POST and PATCH.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws GraphErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> updateWithResponseAsync(
        String objectId, ServicePrincipalBase parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (objectId == null) {
            return Mono.error(new IllegalArgumentException("Parameter objectId is required and cannot be null."));
        }
        if (this.client.getTenantId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getTenantId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        context = this.client.mergeContext(context);
        return service
            .update(
                this.client.getEndpoint(),
                objectId,
                this.client.getApiVersion(),
                this.client.getTenantId(),
                parameters,
                context);
    }

    /**
     * Updates a service principal in the directory.
     *
     * @param objectId The object ID of the service principal to delete.
     * @param parameters Active Directory service principal common properties shared among GET, POST and PATCH.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws GraphErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> updateAsync(String objectId, ServicePrincipalBase parameters) {
        return updateWithResponseAsync(objectId, parameters).flatMap((Response<Void> res) -> Mono.empty());
    }

    /**
     * Updates a service principal in the directory.
     *
     * @param objectId The object ID of the service principal to delete.
     * @param parameters Active Directory service principal common properties shared among GET, POST and PATCH.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws GraphErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void update(String objectId, ServicePrincipalBase parameters) {
        updateAsync(objectId, parameters).block();
    }

    /**
     * Updates a service principal in the directory.
     *
     * @param objectId The object ID of the service principal to delete.
     * @param parameters Active Directory service principal common properties shared among GET, POST and PATCH.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws GraphErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> updateWithResponse(String objectId, ServicePrincipalBase parameters, Context context) {
        return updateWithResponseAsync(objectId, parameters, context).block();
    }

    /**
     * Deletes a service principal from the directory.
     *
     * @param objectId The object ID of the service principal to delete.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws GraphErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> deleteWithResponseAsync(String objectId) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (objectId == null) {
            return Mono.error(new IllegalArgumentException("Parameter objectId is required and cannot be null."));
        }
        if (this.client.getTenantId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getTenantId() is required and cannot be null."));
        }
        return FluxUtil
            .withContext(
                context ->
                    service
                        .delete(
                            this.client.getEndpoint(),
                            objectId,
                            this.client.getApiVersion(),
                            this.client.getTenantId(),
                            context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Deletes a service principal from the directory.
     *
     * @param objectId The object ID of the service principal to delete.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws GraphErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String objectId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (objectId == null) {
            return Mono.error(new IllegalArgumentException("Parameter objectId is required and cannot be null."));
        }
        if (this.client.getTenantId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getTenantId() is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return service
            .delete(
                this.client.getEndpoint(), objectId, this.client.getApiVersion(), this.client.getTenantId(), context);
    }

    /**
     * Deletes a service principal from the directory.
     *
     * @param objectId The object ID of the service principal to delete.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws GraphErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String objectId) {
        return deleteWithResponseAsync(objectId).flatMap((Response<Void> res) -> Mono.empty());
    }

    /**
     * Deletes a service principal from the directory.
     *
     * @param objectId The object ID of the service principal to delete.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws GraphErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void delete(String objectId) {
        deleteAsync(objectId).block();
    }

    /**
     * Deletes a service principal from the directory.
     *
     * @param objectId The object ID of the service principal to delete.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws GraphErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(String objectId, Context context) {
        return deleteWithResponseAsync(objectId, context).block();
    }

    /**
     * Gets service principal information from the directory. Query by objectId or pass a filter to query by appId.
     *
     * @param objectId The object ID of the service principal to get.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws GraphErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return service principal information from the directory.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<ServicePrincipalInner>> getWithResponseAsync(String objectId) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (objectId == null) {
            return Mono.error(new IllegalArgumentException("Parameter objectId is required and cannot be null."));
        }
        if (this.client.getTenantId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getTenantId() is required and cannot be null."));
        }
        return FluxUtil
            .withContext(
                context ->
                    service
                        .get(
                            this.client.getEndpoint(),
                            objectId,
                            this.client.getApiVersion(),
                            this.client.getTenantId(),
                            context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Gets service principal information from the directory. Query by objectId or pass a filter to query by appId.
     *
     * @param objectId The object ID of the service principal to get.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws GraphErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return service principal information from the directory.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<ServicePrincipalInner>> getWithResponseAsync(String objectId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (objectId == null) {
            return Mono.error(new IllegalArgumentException("Parameter objectId is required and cannot be null."));
        }
        if (this.client.getTenantId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getTenantId() is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return service
            .get(this.client.getEndpoint(), objectId, this.client.getApiVersion(), this.client.getTenantId(), context);
    }

    /**
     * Gets service principal information from the directory. Query by objectId or pass a filter to query by appId.
     *
     * @param objectId The object ID of the service principal to get.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws GraphErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return service principal information from the directory.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ServicePrincipalInner> getAsync(String objectId) {
        return getWithResponseAsync(objectId)
            .flatMap(
                (Response<ServicePrincipalInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Gets service principal information from the directory. Query by objectId or pass a filter to query by appId.
     *
     * @param objectId The object ID of the service principal to get.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws GraphErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return service principal information from the directory.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ServicePrincipalInner get(String objectId) {
        return getAsync(objectId).block();
    }

    /**
     * Gets service principal information from the directory. Query by objectId or pass a filter to query by appId.
     *
     * @param objectId The object ID of the service principal to get.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws GraphErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return service principal information from the directory.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<ServicePrincipalInner> getWithResponse(String objectId, Context context) {
        return getWithResponseAsync(objectId, context).block();
    }

    /**
     * The owners are a set of non-admin users who are allowed to modify this object.
     *
     * @param objectId The object ID of the service principal for which to get owners.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws GraphErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return directoryObject list operation result.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DirectoryObjectInner>> listOwnersSinglePageAsync(String objectId) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (objectId == null) {
            return Mono.error(new IllegalArgumentException("Parameter objectId is required and cannot be null."));
        }
        if (this.client.getTenantId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getTenantId() is required and cannot be null."));
        }
        return FluxUtil
            .withContext(
                context ->
                    service
                        .listOwners(
                            this.client.getEndpoint(),
                            objectId,
                            this.client.getApiVersion(),
                            this.client.getTenantId(),
                            context))
            .<PagedResponse<DirectoryObjectInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * The owners are a set of non-admin users who are allowed to modify this object.
     *
     * @param objectId The object ID of the service principal for which to get owners.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws GraphErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return directoryObject list operation result.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DirectoryObjectInner>> listOwnersSinglePageAsync(String objectId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (objectId == null) {
            return Mono.error(new IllegalArgumentException("Parameter objectId is required and cannot be null."));
        }
        if (this.client.getTenantId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getTenantId() is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return service
            .listOwners(
                this.client.getEndpoint(), objectId, this.client.getApiVersion(), this.client.getTenantId(), context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null));
    }

    /**
     * The owners are a set of non-admin users who are allowed to modify this object.
     *
     * @param objectId The object ID of the service principal for which to get owners.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws GraphErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return directoryObject list operation result.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<DirectoryObjectInner> listOwnersAsync(String objectId) {
        return new PagedFlux<>(
            () -> listOwnersSinglePageAsync(objectId), nextLink -> listOwnersNextSinglePageAsync(nextLink));
    }

    /**
     * The owners are a set of non-admin users who are allowed to modify this object.
     *
     * @param objectId The object ID of the service principal for which to get owners.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws GraphErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return directoryObject list operation result.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<DirectoryObjectInner> listOwnersAsync(String objectId, Context context) {
        return new PagedFlux<>(
            () -> listOwnersSinglePageAsync(objectId, context),
            nextLink -> listOwnersNextSinglePageAsync(nextLink, context));
    }

    /**
     * The owners are a set of non-admin users who are allowed to modify this object.
     *
     * @param objectId The object ID of the service principal for which to get owners.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws GraphErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return directoryObject list operation result.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<DirectoryObjectInner> listOwners(String objectId) {
        return new PagedIterable<>(listOwnersAsync(objectId));
    }

    /**
     * The owners are a set of non-admin users who are allowed to modify this object.
     *
     * @param objectId The object ID of the service principal for which to get owners.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws GraphErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return directoryObject list operation result.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<DirectoryObjectInner> listOwners(String objectId, Context context) {
        return new PagedIterable<>(listOwnersAsync(objectId, context));
    }

    /**
     * Get the keyCredentials associated with the specified service principal.
     *
     * @param objectId The object ID of the service principal for which to get keyCredentials.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws GraphErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the keyCredentials associated with the specified service principal.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<KeyCredentialInner>> listKeyCredentialsSinglePageAsync(String objectId) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (objectId == null) {
            return Mono.error(new IllegalArgumentException("Parameter objectId is required and cannot be null."));
        }
        if (this.client.getTenantId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getTenantId() is required and cannot be null."));
        }
        return FluxUtil
            .withContext(
                context ->
                    service
                        .listKeyCredentials(
                            this.client.getEndpoint(),
                            objectId,
                            this.client.getApiVersion(),
                            this.client.getTenantId(),
                            context))
            .<PagedResponse<KeyCredentialInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(), res.getStatusCode(), res.getHeaders(), res.getValue().value(), null, null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get the keyCredentials associated with the specified service principal.
     *
     * @param objectId The object ID of the service principal for which to get keyCredentials.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws GraphErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the keyCredentials associated with the specified service principal.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<KeyCredentialInner>> listKeyCredentialsSinglePageAsync(
        String objectId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (objectId == null) {
            return Mono.error(new IllegalArgumentException("Parameter objectId is required and cannot be null."));
        }
        if (this.client.getTenantId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getTenantId() is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return service
            .listKeyCredentials(
                this.client.getEndpoint(), objectId, this.client.getApiVersion(), this.client.getTenantId(), context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(), res.getStatusCode(), res.getHeaders(), res.getValue().value(), null, null));
    }

    /**
     * Get the keyCredentials associated with the specified service principal.
     *
     * @param objectId The object ID of the service principal for which to get keyCredentials.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws GraphErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the keyCredentials associated with the specified service principal.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<KeyCredentialInner> listKeyCredentialsAsync(String objectId) {
        return new PagedFlux<>(() -> listKeyCredentialsSinglePageAsync(objectId));
    }

    /**
     * Get the keyCredentials associated with the specified service principal.
     *
     * @param objectId The object ID of the service principal for which to get keyCredentials.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws GraphErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the keyCredentials associated with the specified service principal.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<KeyCredentialInner> listKeyCredentialsAsync(String objectId, Context context) {
        return new PagedFlux<>(() -> listKeyCredentialsSinglePageAsync(objectId, context));
    }

    /**
     * Get the keyCredentials associated with the specified service principal.
     *
     * @param objectId The object ID of the service principal for which to get keyCredentials.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws GraphErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the keyCredentials associated with the specified service principal.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<KeyCredentialInner> listKeyCredentials(String objectId) {
        return new PagedIterable<>(listKeyCredentialsAsync(objectId));
    }

    /**
     * Get the keyCredentials associated with the specified service principal.
     *
     * @param objectId The object ID of the service principal for which to get keyCredentials.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws GraphErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the keyCredentials associated with the specified service principal.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<KeyCredentialInner> listKeyCredentials(String objectId, Context context) {
        return new PagedIterable<>(listKeyCredentialsAsync(objectId, context));
    }

    /**
     * Update the keyCredentials associated with a service principal.
     *
     * @param objectId The object ID for which to get service principal information.
     * @param value A collection of KeyCredentials.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws GraphErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> updateKeyCredentialsWithResponseAsync(String objectId, List<KeyCredentialInner> value) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (objectId == null) {
            return Mono.error(new IllegalArgumentException("Parameter objectId is required and cannot be null."));
        }
        if (this.client.getTenantId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getTenantId() is required and cannot be null."));
        }
        if (value == null) {
            return Mono.error(new IllegalArgumentException("Parameter value is required and cannot be null."));
        } else {
            value.forEach(e -> e.validate());
        }
        KeyCredentialsUpdateParameters parameters = new KeyCredentialsUpdateParameters();
        parameters.withValue(value);
        return FluxUtil
            .withContext(
                context ->
                    service
                        .updateKeyCredentials(
                            this.client.getEndpoint(),
                            objectId,
                            this.client.getApiVersion(),
                            this.client.getTenantId(),
                            parameters,
                            context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Update the keyCredentials associated with a service principal.
     *
     * @param objectId The object ID for which to get service principal information.
     * @param value A collection of KeyCredentials.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws GraphErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> updateKeyCredentialsWithResponseAsync(
        String objectId, List<KeyCredentialInner> value, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (objectId == null) {
            return Mono.error(new IllegalArgumentException("Parameter objectId is required and cannot be null."));
        }
        if (this.client.getTenantId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getTenantId() is required and cannot be null."));
        }
        if (value == null) {
            return Mono.error(new IllegalArgumentException("Parameter value is required and cannot be null."));
        } else {
            value.forEach(e -> e.validate());
        }
        KeyCredentialsUpdateParameters parameters = new KeyCredentialsUpdateParameters();
        parameters.withValue(value);
        context = this.client.mergeContext(context);
        return service
            .updateKeyCredentials(
                this.client.getEndpoint(),
                objectId,
                this.client.getApiVersion(),
                this.client.getTenantId(),
                parameters,
                context);
    }

    /**
     * Update the keyCredentials associated with a service principal.
     *
     * @param objectId The object ID for which to get service principal information.
     * @param value A collection of KeyCredentials.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws GraphErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> updateKeyCredentialsAsync(String objectId, List<KeyCredentialInner> value) {
        return updateKeyCredentialsWithResponseAsync(objectId, value).flatMap((Response<Void> res) -> Mono.empty());
    }

    /**
     * Update the keyCredentials associated with a service principal.
     *
     * @param objectId The object ID for which to get service principal information.
     * @param value A collection of KeyCredentials.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws GraphErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void updateKeyCredentials(String objectId, List<KeyCredentialInner> value) {
        updateKeyCredentialsAsync(objectId, value).block();
    }

    /**
     * Update the keyCredentials associated with a service principal.
     *
     * @param objectId The object ID for which to get service principal information.
     * @param value A collection of KeyCredentials.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws GraphErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> updateKeyCredentialsWithResponse(
        String objectId, List<KeyCredentialInner> value, Context context) {
        return updateKeyCredentialsWithResponseAsync(objectId, value, context).block();
    }

    /**
     * Gets the passwordCredentials associated with a service principal.
     *
     * @param objectId The object ID of the service principal.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws GraphErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the passwordCredentials associated with a service principal.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<PasswordCredentialInner>> listPasswordCredentialsSinglePageAsync(String objectId) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (objectId == null) {
            return Mono.error(new IllegalArgumentException("Parameter objectId is required and cannot be null."));
        }
        if (this.client.getTenantId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getTenantId() is required and cannot be null."));
        }
        return FluxUtil
            .withContext(
                context ->
                    service
                        .listPasswordCredentials(
                            this.client.getEndpoint(),
                            objectId,
                            this.client.getApiVersion(),
                            this.client.getTenantId(),
                            context))
            .<PagedResponse<PasswordCredentialInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(), res.getStatusCode(), res.getHeaders(), res.getValue().value(), null, null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Gets the passwordCredentials associated with a service principal.
     *
     * @param objectId The object ID of the service principal.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws GraphErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the passwordCredentials associated with a service principal.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<PasswordCredentialInner>> listPasswordCredentialsSinglePageAsync(
        String objectId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (objectId == null) {
            return Mono.error(new IllegalArgumentException("Parameter objectId is required and cannot be null."));
        }
        if (this.client.getTenantId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getTenantId() is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return service
            .listPasswordCredentials(
                this.client.getEndpoint(), objectId, this.client.getApiVersion(), this.client.getTenantId(), context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(), res.getStatusCode(), res.getHeaders(), res.getValue().value(), null, null));
    }

    /**
     * Gets the passwordCredentials associated with a service principal.
     *
     * @param objectId The object ID of the service principal.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws GraphErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the passwordCredentials associated with a service principal.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<PasswordCredentialInner> listPasswordCredentialsAsync(String objectId) {
        return new PagedFlux<>(() -> listPasswordCredentialsSinglePageAsync(objectId));
    }

    /**
     * Gets the passwordCredentials associated with a service principal.
     *
     * @param objectId The object ID of the service principal.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws GraphErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the passwordCredentials associated with a service principal.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<PasswordCredentialInner> listPasswordCredentialsAsync(String objectId, Context context) {
        return new PagedFlux<>(() -> listPasswordCredentialsSinglePageAsync(objectId, context));
    }

    /**
     * Gets the passwordCredentials associated with a service principal.
     *
     * @param objectId The object ID of the service principal.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws GraphErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the passwordCredentials associated with a service principal.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<PasswordCredentialInner> listPasswordCredentials(String objectId) {
        return new PagedIterable<>(listPasswordCredentialsAsync(objectId));
    }

    /**
     * Gets the passwordCredentials associated with a service principal.
     *
     * @param objectId The object ID of the service principal.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws GraphErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the passwordCredentials associated with a service principal.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<PasswordCredentialInner> listPasswordCredentials(String objectId, Context context) {
        return new PagedIterable<>(listPasswordCredentialsAsync(objectId, context));
    }

    /**
     * Updates the passwordCredentials associated with a service principal.
     *
     * @param objectId The object ID of the service principal.
     * @param value A collection of PasswordCredentials.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws GraphErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> updatePasswordCredentialsWithResponseAsync(
        String objectId, List<PasswordCredentialInner> value) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (objectId == null) {
            return Mono.error(new IllegalArgumentException("Parameter objectId is required and cannot be null."));
        }
        if (this.client.getTenantId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getTenantId() is required and cannot be null."));
        }
        if (value == null) {
            return Mono.error(new IllegalArgumentException("Parameter value is required and cannot be null."));
        } else {
            value.forEach(e -> e.validate());
        }
        PasswordCredentialsUpdateParameters parameters = new PasswordCredentialsUpdateParameters();
        parameters.withValue(value);
        return FluxUtil
            .withContext(
                context ->
                    service
                        .updatePasswordCredentials(
                            this.client.getEndpoint(),
                            objectId,
                            this.client.getApiVersion(),
                            this.client.getTenantId(),
                            parameters,
                            context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Updates the passwordCredentials associated with a service principal.
     *
     * @param objectId The object ID of the service principal.
     * @param value A collection of PasswordCredentials.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws GraphErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> updatePasswordCredentialsWithResponseAsync(
        String objectId, List<PasswordCredentialInner> value, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (objectId == null) {
            return Mono.error(new IllegalArgumentException("Parameter objectId is required and cannot be null."));
        }
        if (this.client.getTenantId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getTenantId() is required and cannot be null."));
        }
        if (value == null) {
            return Mono.error(new IllegalArgumentException("Parameter value is required and cannot be null."));
        } else {
            value.forEach(e -> e.validate());
        }
        PasswordCredentialsUpdateParameters parameters = new PasswordCredentialsUpdateParameters();
        parameters.withValue(value);
        context = this.client.mergeContext(context);
        return service
            .updatePasswordCredentials(
                this.client.getEndpoint(),
                objectId,
                this.client.getApiVersion(),
                this.client.getTenantId(),
                parameters,
                context);
    }

    /**
     * Updates the passwordCredentials associated with a service principal.
     *
     * @param objectId The object ID of the service principal.
     * @param value A collection of PasswordCredentials.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws GraphErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> updatePasswordCredentialsAsync(String objectId, List<PasswordCredentialInner> value) {
        return updatePasswordCredentialsWithResponseAsync(objectId, value)
            .flatMap((Response<Void> res) -> Mono.empty());
    }

    /**
     * Updates the passwordCredentials associated with a service principal.
     *
     * @param objectId The object ID of the service principal.
     * @param value A collection of PasswordCredentials.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws GraphErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void updatePasswordCredentials(String objectId, List<PasswordCredentialInner> value) {
        updatePasswordCredentialsAsync(objectId, value).block();
    }

    /**
     * Updates the passwordCredentials associated with a service principal.
     *
     * @param objectId The object ID of the service principal.
     * @param value A collection of PasswordCredentials.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws GraphErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> updatePasswordCredentialsWithResponse(
        String objectId, List<PasswordCredentialInner> value, Context context) {
        return updatePasswordCredentialsWithResponseAsync(objectId, value, context).block();
    }

    /**
     * Gets a list of service principals from the current tenant.
     *
     * @param nextLink Next link for the list operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws GraphErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of service principals from the current tenant.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<ServicePrincipalInner>> listNextSinglePageAsync(String nextLink) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getTenantId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getTenantId() is required and cannot be null."));
        }
        return FluxUtil
            .withContext(
                context ->
                    service
                        .listNext(
                            this.client.getEndpoint(),
                            nextLink,
                            this.client.getApiVersion(),
                            this.client.getTenantId(),
                            context))
            .<PagedResponse<ServicePrincipalInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Gets a list of service principals from the current tenant.
     *
     * @param nextLink Next link for the list operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws GraphErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of service principals from the current tenant.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<ServicePrincipalInner>> listNextSinglePageAsync(String nextLink, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getTenantId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getTenantId() is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return service
            .listNext(
                this.client.getEndpoint(), nextLink, this.client.getApiVersion(), this.client.getTenantId(), context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws GraphErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return directoryObject list operation result.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DirectoryObjectInner>> listOwnersNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil
            .withContext(context -> service.listOwnersNext(nextLink, context))
            .<PagedResponse<DirectoryObjectInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws GraphErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return directoryObject list operation result.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DirectoryObjectInner>> listOwnersNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return service
            .listOwnersNext(nextLink, context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null));
    }
}
