// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.authorization.fluent.models.DomainInner;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** Server response for Get tenant domains API call. */
@Fluent
public final class DomainListResult {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(DomainListResult.class);

    /*
     * the list of domains.
     */
    @JsonProperty(value = "value")
    private List<DomainInner> value;

    /**
     * Get the value property: the list of domains.
     *
     * @return the value value.
     */
    public List<DomainInner> value() {
        return this.value;
    }

    /**
     * Set the value property: the list of domains.
     *
     * @param value the value value to set.
     * @return the DomainListResult object itself.
     */
    public DomainListResult withValue(List<DomainInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }
}
