// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.JsonFlatten;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Active Directory error information. */
@JsonFlatten
@Fluent
public class GraphError {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(GraphError.class);

    /*
     * Error code.
     */
    @JsonProperty(value = "odata\\.error.code")
    private String code;

    /*
     * Error message value.
     */
    @JsonProperty(value = "odata\\.error.message.value")
    private String message;

    /**
     * Get the code property: Error code.
     *
     * @return the code value.
     */
    public String code() {
        return this.code;
    }

    /**
     * Set the code property: Error code.
     *
     * @param code the code value to set.
     * @return the GraphError object itself.
     */
    public GraphError withCode(String code) {
        this.code = code;
        return this;
    }

    /**
     * Get the message property: Error message value.
     *
     * @return the message value.
     */
    public String message() {
        return this.message;
    }

    /**
     * Set the message property: Error message value.
     *
     * @param message the message value to set.
     * @return the GraphError object itself.
     */
    public GraphError withMessage(String message) {
        this.message = message;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
