// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.authorization.fluent.models.ADGroupInner;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** Server response for Get tenant groups API call. */
@Fluent
public final class GroupListResult {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(GroupListResult.class);

    /*
     * A collection of Active Directory groups.
     */
    @JsonProperty(value = "value")
    private List<ADGroupInner> value;

    /*
     * The URL to get the next set of results.
     */
    @JsonProperty(value = "odata.nextLink")
    private String odataNextLink;

    /**
     * Get the value property: A collection of Active Directory groups.
     *
     * @return the value value.
     */
    public List<ADGroupInner> value() {
        return this.value;
    }

    /**
     * Set the value property: A collection of Active Directory groups.
     *
     * @param value the value value to set.
     * @return the GroupListResult object itself.
     */
    public GroupListResult withValue(List<ADGroupInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the odataNextLink property: The URL to get the next set of results.
     *
     * @return the odataNextLink value.
     */
    public String odataNextLink() {
        return this.odataNextLink;
    }

    /**
     * Set the odataNextLink property: The URL to get the next set of results.
     *
     * @param odataNextLink the odataNextLink value to set.
     * @return the GroupListResult object itself.
     */
    public GroupListResult withOdataNextLink(String odataNextLink) {
        this.odataNextLink = odataNextLink;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }
}
