// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.authorization.fluent.models.OAuth2PermissionGrantInner;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** Server response for get oauth2 permissions grants. */
@Fluent
public final class OAuth2PermissionGrantListResult {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(OAuth2PermissionGrantListResult.class);

    /*
     * the list of oauth2 permissions grants
     */
    @JsonProperty(value = "value")
    private List<OAuth2PermissionGrantInner> value;

    /*
     * the URL to get the next set of results.
     */
    @JsonProperty(value = "odata.nextLink")
    private String odataNextLink;

    /**
     * Get the value property: the list of oauth2 permissions grants.
     *
     * @return the value value.
     */
    public List<OAuth2PermissionGrantInner> value() {
        return this.value;
    }

    /**
     * Set the value property: the list of oauth2 permissions grants.
     *
     * @param value the value value to set.
     * @return the OAuth2PermissionGrantListResult object itself.
     */
    public OAuth2PermissionGrantListResult withValue(List<OAuth2PermissionGrantInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the odataNextLink property: the URL to get the next set of results.
     *
     * @return the odataNextLink value.
     */
    public String odataNextLink() {
        return this.odataNextLink;
    }

    /**
     * Set the odataNextLink property: the URL to get the next set of results.
     *
     * @param odataNextLink the odataNextLink value to set.
     * @return the OAuth2PermissionGrantListResult object itself.
     */
    public OAuth2PermissionGrantListResult withOdataNextLink(String odataNextLink) {
        this.odataNextLink = odataNextLink;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }
}
