// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.authorization.fluent.models.PasswordCredentialInner;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** Request parameters for a PasswordCredentials update operation. */
@Fluent
public final class PasswordCredentialsUpdateParameters {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(PasswordCredentialsUpdateParameters.class);

    /*
     * A collection of PasswordCredentials.
     */
    @JsonProperty(value = "value", required = true)
    private List<PasswordCredentialInner> value;

    /**
     * Get the value property: A collection of PasswordCredentials.
     *
     * @return the value value.
     */
    public List<PasswordCredentialInner> value() {
        return this.value;
    }

    /**
     * Set the value property: A collection of PasswordCredentials.
     *
     * @param value the value value to set.
     * @return the PasswordCredentialsUpdateParameters object itself.
     */
    public PasswordCredentialsUpdateParameters withValue(List<PasswordCredentialInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() == null) {
            throw logger
                .logExceptionAsError(
                    new IllegalArgumentException(
                        "Missing required property value in model PasswordCredentialsUpdateParameters"));
        } else {
            value().forEach(e -> e.validate());
        }
    }
}
