// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** Contains information about the pre-authorized permissions. */
@Fluent
public final class PreAuthorizedApplicationPermission {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(PreAuthorizedApplicationPermission.class);

    /*
     * Indicates whether the permission set is DirectAccess or impersonation.
     */
    @JsonProperty(value = "directAccessGrant")
    private Boolean directAccessGrant;

    /*
     * The list of permissions.
     */
    @JsonProperty(value = "accessGrants")
    private List<String> accessGrants;

    /**
     * Get the directAccessGrant property: Indicates whether the permission set is DirectAccess or impersonation.
     *
     * @return the directAccessGrant value.
     */
    public Boolean directAccessGrant() {
        return this.directAccessGrant;
    }

    /**
     * Set the directAccessGrant property: Indicates whether the permission set is DirectAccess or impersonation.
     *
     * @param directAccessGrant the directAccessGrant value to set.
     * @return the PreAuthorizedApplicationPermission object itself.
     */
    public PreAuthorizedApplicationPermission withDirectAccessGrant(Boolean directAccessGrant) {
        this.directAccessGrant = directAccessGrant;
        return this;
    }

    /**
     * Get the accessGrants property: The list of permissions.
     *
     * @return the accessGrants value.
     */
    public List<String> accessGrants() {
        return this.accessGrants;
    }

    /**
     * Set the accessGrants property: The list of permissions.
     *
     * @param accessGrants the accessGrants value to set.
     * @return the PreAuthorizedApplicationPermission object itself.
     */
    public PreAuthorizedApplicationPermission withAccessGrants(List<String> accessGrants) {
        this.accessGrants = accessGrants;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
