// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Specifies the set of OAuth 2.0 permission scopes and app roles under the specified resource that an application
 * requires access to. The specified OAuth 2.0 permission scopes may be requested by client applications (through the
 * requiredResourceAccess collection) when calling a resource application. The requiredResourceAccess property of the
 * Application entity is a collection of RequiredResourceAccess.
 */
@Fluent
public final class RequiredResourceAccess {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(RequiredResourceAccess.class);

    /*
     * The list of OAuth2.0 permission scopes and app roles that the
     * application requires from the specified resource.
     */
    @JsonProperty(value = "resourceAccess", required = true)
    private List<ResourceAccess> resourceAccess;

    /*
     * The unique identifier for the resource that the application requires
     * access to. This should be equal to the appId declared on the target
     * resource application.
     */
    @JsonProperty(value = "resourceAppId")
    private String resourceAppId;

    /*
     * Specifies the set of OAuth 2.0 permission scopes and app roles under the
     * specified resource that an application requires access to. The specified
     * OAuth 2.0 permission scopes may be requested by client applications
     * (through the requiredResourceAccess collection) when calling a resource
     * application. The requiredResourceAccess property of the Application
     * entity is a collection of RequiredResourceAccess.
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /**
     * Get the resourceAccess property: The list of OAuth2.0 permission scopes and app roles that the application
     * requires from the specified resource.
     *
     * @return the resourceAccess value.
     */
    public List<ResourceAccess> resourceAccess() {
        return this.resourceAccess;
    }

    /**
     * Set the resourceAccess property: The list of OAuth2.0 permission scopes and app roles that the application
     * requires from the specified resource.
     *
     * @param resourceAccess the resourceAccess value to set.
     * @return the RequiredResourceAccess object itself.
     */
    public RequiredResourceAccess withResourceAccess(List<ResourceAccess> resourceAccess) {
        this.resourceAccess = resourceAccess;
        return this;
    }

    /**
     * Get the resourceAppId property: The unique identifier for the resource that the application requires access to.
     * This should be equal to the appId declared on the target resource application.
     *
     * @return the resourceAppId value.
     */
    public String resourceAppId() {
        return this.resourceAppId;
    }

    /**
     * Set the resourceAppId property: The unique identifier for the resource that the application requires access to.
     * This should be equal to the appId declared on the target resource application.
     *
     * @param resourceAppId the resourceAppId value to set.
     * @return the RequiredResourceAccess object itself.
     */
    public RequiredResourceAccess withResourceAppId(String resourceAppId) {
        this.resourceAppId = resourceAppId;
        return this;
    }

    /**
     * Get the additionalProperties property: Specifies the set of OAuth 2.0 permission scopes and app roles under the
     * specified resource that an application requires access to. The specified OAuth 2.0 permission scopes may be
     * requested by client applications (through the requiredResourceAccess collection) when calling a resource
     * application. The requiredResourceAccess property of the Application entity is a collection of
     * RequiredResourceAccess.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: Specifies the set of OAuth 2.0 permission scopes and app roles under the
     * specified resource that an application requires access to. The specified OAuth 2.0 permission scopes may be
     * requested by client applications (through the requiredResourceAccess collection) when calling a resource
     * application. The requiredResourceAccess property of the Application entity is a collection of
     * RequiredResourceAccess.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the RequiredResourceAccess object itself.
     */
    public RequiredResourceAccess withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (resourceAccess() == null) {
            throw logger
                .logExceptionAsError(
                    new IllegalArgumentException(
                        "Missing required property resourceAccess in model RequiredResourceAccess"));
        } else {
            resourceAccess().forEach(e -> e.validate());
        }
    }
}
