// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;

/** Contains information about a sign-in name of a local account user in an Azure Active Directory B2C tenant. */
@Fluent
public final class SignInName {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(SignInName.class);

    /*
     * A string value that can be used to classify user sign-in types in your
     * directory, such as 'emailAddress' or 'userName'.
     */
    @JsonProperty(value = "type")
    private String type;

    /*
     * The sign-in used by the local account. Must be unique across the
     * company/tenant. For example, 'johnc@example.com'.
     */
    @JsonProperty(value = "value")
    private String value;

    /*
     * Contains information about a sign-in name of a local account user in an
     * Azure Active Directory B2C tenant.
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /**
     * Get the type property: A string value that can be used to classify user sign-in types in your directory, such as
     * 'emailAddress' or 'userName'.
     *
     * @return the type value.
     */
    public String type() {
        return this.type;
    }

    /**
     * Set the type property: A string value that can be used to classify user sign-in types in your directory, such as
     * 'emailAddress' or 'userName'.
     *
     * @param type the type value to set.
     * @return the SignInName object itself.
     */
    public SignInName withType(String type) {
        this.type = type;
        return this;
    }

    /**
     * Get the value property: The sign-in used by the local account. Must be unique across the company/tenant. For
     * example, 'johnc@example.com'.
     *
     * @return the value value.
     */
    public String value() {
        return this.value;
    }

    /**
     * Set the value property: The sign-in used by the local account. Must be unique across the company/tenant. For
     * example, 'johnc@example.com'.
     *
     * @param value the value value to set.
     * @return the SignInName object itself.
     */
    public SignInName withValue(String value) {
        this.value = value;
        return this;
    }

    /**
     * Get the additionalProperties property: Contains information about a sign-in name of a local account user in an
     * Azure Active Directory B2C tenant.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: Contains information about a sign-in name of a local account user in an
     * Azure Active Directory B2C tenant.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the SignInName object itself.
     */
    public SignInName withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
