/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.authorization.fluent.models.DirectoryObjectInner;
import com.azure.resourcemanager.authorization.fluent.models.KeyCredentialInner;
import com.azure.resourcemanager.authorization.fluent.models.PasswordCredentialInner;
import com.azure.resourcemanager.authorization.models.AppRole;
import com.azure.resourcemanager.authorization.models.GroupMembershipClaimTypes;
import com.azure.resourcemanager.authorization.models.InformationalUrl;
import com.azure.resourcemanager.authorization.models.OAuth2Permission;
import com.azure.resourcemanager.authorization.models.OptionalClaims;
import com.azure.resourcemanager.authorization.models.PreAuthorizedApplication;
import com.azure.resourcemanager.authorization.models.RequiredResourceAccess;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="objectType")
@JsonTypeName(value="Application")
public final class ApplicationInner
extends DirectoryObjectInner {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(ApplicationInner.class);
    @JsonProperty(value="appId")
    private String appId;
    @JsonProperty(value="allowGuestsSignIn")
    private Boolean allowGuestsSignIn;
    @JsonProperty(value="allowPassthroughUsers")
    private Boolean allowPassthroughUsers;
    @JsonProperty(value="appLogoUrl")
    private String appLogoUrl;
    @JsonProperty(value="appRoles")
    private List<AppRole> appRoles;
    @JsonProperty(value="appPermissions")
    private List<String> appPermissions;
    @JsonProperty(value="availableToOtherTenants")
    private Boolean availableToOtherTenants;
    @JsonProperty(value="displayName")
    private String displayName;
    @JsonProperty(value="errorUrl")
    private String errorUrl;
    @JsonProperty(value="groupMembershipClaims")
    private GroupMembershipClaimTypes groupMembershipClaims;
    @JsonProperty(value="homepage")
    private String homepage;
    @JsonProperty(value="identifierUris")
    private List<String> identifierUris;
    @JsonProperty(value="informationalUrls")
    private InformationalUrl informationalUrls;
    @JsonProperty(value="isDeviceOnlyAuthSupported")
    private Boolean isDeviceOnlyAuthSupported;
    @JsonProperty(value="keyCredentials")
    private List<KeyCredentialInner> keyCredentials;
    @JsonProperty(value="knownClientApplications")
    private List<String> knownClientApplications;
    @JsonProperty(value="logoutUrl")
    private String logoutUrl;
    @JsonProperty(value="oauth2AllowImplicitFlow")
    private Boolean oauth2AllowImplicitFlow;
    @JsonProperty(value="oauth2AllowUrlPathMatching")
    private Boolean oauth2AllowUrlPathMatching;
    @JsonProperty(value="oauth2Permissions")
    private List<OAuth2Permission> oauth2Permissions;
    @JsonProperty(value="oauth2RequirePostResponse")
    private Boolean oauth2RequirePostResponse;
    @JsonProperty(value="orgRestrictions")
    private List<String> orgRestrictions;
    @JsonProperty(value="optionalClaims")
    private OptionalClaims optionalClaims;
    @JsonProperty(value="passwordCredentials")
    private List<PasswordCredentialInner> passwordCredentials;
    @JsonProperty(value="preAuthorizedApplications")
    private List<PreAuthorizedApplication> preAuthorizedApplications;
    @JsonProperty(value="publicClient")
    private Boolean publicClient;
    @JsonProperty(value="publisherDomain")
    private String publisherDomain;
    @JsonProperty(value="replyUrls")
    private List<String> replyUrls;
    @JsonProperty(value="requiredResourceAccess")
    private List<RequiredResourceAccess> requiredResourceAccess;
    @JsonProperty(value="samlMetadataUrl")
    private String samlMetadataUrl;
    @JsonProperty(value="signInAudience")
    private String signInAudience;
    @JsonProperty(value="wwwHomepage")
    private String wwwHomepage;

    public String appId() {
        return this.appId;
    }

    public ApplicationInner withAppId(String appId) {
        this.appId = appId;
        return this;
    }

    public Boolean allowGuestsSignIn() {
        return this.allowGuestsSignIn;
    }

    public ApplicationInner withAllowGuestsSignIn(Boolean allowGuestsSignIn) {
        this.allowGuestsSignIn = allowGuestsSignIn;
        return this;
    }

    public Boolean allowPassthroughUsers() {
        return this.allowPassthroughUsers;
    }

    public ApplicationInner withAllowPassthroughUsers(Boolean allowPassthroughUsers) {
        this.allowPassthroughUsers = allowPassthroughUsers;
        return this;
    }

    public String appLogoUrl() {
        return this.appLogoUrl;
    }

    public ApplicationInner withAppLogoUrl(String appLogoUrl) {
        this.appLogoUrl = appLogoUrl;
        return this;
    }

    public List<AppRole> appRoles() {
        return this.appRoles;
    }

    public ApplicationInner withAppRoles(List<AppRole> appRoles) {
        this.appRoles = appRoles;
        return this;
    }

    public List<String> appPermissions() {
        return this.appPermissions;
    }

    public ApplicationInner withAppPermissions(List<String> appPermissions) {
        this.appPermissions = appPermissions;
        return this;
    }

    public Boolean availableToOtherTenants() {
        return this.availableToOtherTenants;
    }

    public ApplicationInner withAvailableToOtherTenants(Boolean availableToOtherTenants) {
        this.availableToOtherTenants = availableToOtherTenants;
        return this;
    }

    public String displayName() {
        return this.displayName;
    }

    public ApplicationInner withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public String errorUrl() {
        return this.errorUrl;
    }

    public ApplicationInner withErrorUrl(String errorUrl) {
        this.errorUrl = errorUrl;
        return this;
    }

    public GroupMembershipClaimTypes groupMembershipClaims() {
        return this.groupMembershipClaims;
    }

    public ApplicationInner withGroupMembershipClaims(GroupMembershipClaimTypes groupMembershipClaims) {
        this.groupMembershipClaims = groupMembershipClaims;
        return this;
    }

    public String homepage() {
        return this.homepage;
    }

    public ApplicationInner withHomepage(String homepage) {
        this.homepage = homepage;
        return this;
    }

    public List<String> identifierUris() {
        return this.identifierUris;
    }

    public ApplicationInner withIdentifierUris(List<String> identifierUris) {
        this.identifierUris = identifierUris;
        return this;
    }

    public InformationalUrl informationalUrls() {
        return this.informationalUrls;
    }

    public ApplicationInner withInformationalUrls(InformationalUrl informationalUrls) {
        this.informationalUrls = informationalUrls;
        return this;
    }

    public Boolean isDeviceOnlyAuthSupported() {
        return this.isDeviceOnlyAuthSupported;
    }

    public ApplicationInner withIsDeviceOnlyAuthSupported(Boolean isDeviceOnlyAuthSupported) {
        this.isDeviceOnlyAuthSupported = isDeviceOnlyAuthSupported;
        return this;
    }

    public List<KeyCredentialInner> keyCredentials() {
        return this.keyCredentials;
    }

    public ApplicationInner withKeyCredentials(List<KeyCredentialInner> keyCredentials) {
        this.keyCredentials = keyCredentials;
        return this;
    }

    public List<String> knownClientApplications() {
        return this.knownClientApplications;
    }

    public ApplicationInner withKnownClientApplications(List<String> knownClientApplications) {
        this.knownClientApplications = knownClientApplications;
        return this;
    }

    public String logoutUrl() {
        return this.logoutUrl;
    }

    public ApplicationInner withLogoutUrl(String logoutUrl) {
        this.logoutUrl = logoutUrl;
        return this;
    }

    public Boolean oauth2AllowImplicitFlow() {
        return this.oauth2AllowImplicitFlow;
    }

    public ApplicationInner withOauth2AllowImplicitFlow(Boolean oauth2AllowImplicitFlow) {
        this.oauth2AllowImplicitFlow = oauth2AllowImplicitFlow;
        return this;
    }

    public Boolean oauth2AllowUrlPathMatching() {
        return this.oauth2AllowUrlPathMatching;
    }

    public ApplicationInner withOauth2AllowUrlPathMatching(Boolean oauth2AllowUrlPathMatching) {
        this.oauth2AllowUrlPathMatching = oauth2AllowUrlPathMatching;
        return this;
    }

    public List<OAuth2Permission> oauth2Permissions() {
        return this.oauth2Permissions;
    }

    public ApplicationInner withOauth2Permissions(List<OAuth2Permission> oauth2Permissions) {
        this.oauth2Permissions = oauth2Permissions;
        return this;
    }

    public Boolean oauth2RequirePostResponse() {
        return this.oauth2RequirePostResponse;
    }

    public ApplicationInner withOauth2RequirePostResponse(Boolean oauth2RequirePostResponse) {
        this.oauth2RequirePostResponse = oauth2RequirePostResponse;
        return this;
    }

    public List<String> orgRestrictions() {
        return this.orgRestrictions;
    }

    public ApplicationInner withOrgRestrictions(List<String> orgRestrictions) {
        this.orgRestrictions = orgRestrictions;
        return this;
    }

    public OptionalClaims optionalClaims() {
        return this.optionalClaims;
    }

    public ApplicationInner withOptionalClaims(OptionalClaims optionalClaims) {
        this.optionalClaims = optionalClaims;
        return this;
    }

    public List<PasswordCredentialInner> passwordCredentials() {
        return this.passwordCredentials;
    }

    public ApplicationInner withPasswordCredentials(List<PasswordCredentialInner> passwordCredentials) {
        this.passwordCredentials = passwordCredentials;
        return this;
    }

    public List<PreAuthorizedApplication> preAuthorizedApplications() {
        return this.preAuthorizedApplications;
    }

    public ApplicationInner withPreAuthorizedApplications(List<PreAuthorizedApplication> preAuthorizedApplications) {
        this.preAuthorizedApplications = preAuthorizedApplications;
        return this;
    }

    public Boolean publicClient() {
        return this.publicClient;
    }

    public ApplicationInner withPublicClient(Boolean publicClient) {
        this.publicClient = publicClient;
        return this;
    }

    public String publisherDomain() {
        return this.publisherDomain;
    }

    public ApplicationInner withPublisherDomain(String publisherDomain) {
        this.publisherDomain = publisherDomain;
        return this;
    }

    public List<String> replyUrls() {
        return this.replyUrls;
    }

    public ApplicationInner withReplyUrls(List<String> replyUrls) {
        this.replyUrls = replyUrls;
        return this;
    }

    public List<RequiredResourceAccess> requiredResourceAccess() {
        return this.requiredResourceAccess;
    }

    public ApplicationInner withRequiredResourceAccess(List<RequiredResourceAccess> requiredResourceAccess) {
        this.requiredResourceAccess = requiredResourceAccess;
        return this;
    }

    public String samlMetadataUrl() {
        return this.samlMetadataUrl;
    }

    public ApplicationInner withSamlMetadataUrl(String samlMetadataUrl) {
        this.samlMetadataUrl = samlMetadataUrl;
        return this;
    }

    public String signInAudience() {
        return this.signInAudience;
    }

    public ApplicationInner withSignInAudience(String signInAudience) {
        this.signInAudience = signInAudience;
        return this;
    }

    public String wwwHomepage() {
        return this.wwwHomepage;
    }

    public ApplicationInner withWwwHomepage(String wwwHomepage) {
        this.wwwHomepage = wwwHomepage;
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.appRoles() != null) {
            this.appRoles().forEach(e -> e.validate());
        }
        if (this.informationalUrls() != null) {
            this.informationalUrls().validate();
        }
        if (this.keyCredentials() != null) {
            this.keyCredentials().forEach(e -> e.validate());
        }
        if (this.oauth2Permissions() != null) {
            this.oauth2Permissions().forEach(e -> e.validate());
        }
        if (this.optionalClaims() != null) {
            this.optionalClaims().validate();
        }
        if (this.passwordCredentials() != null) {
            this.passwordCredentials().forEach(e -> e.validate());
        }
        if (this.preAuthorizedApplications() != null) {
            this.preAuthorizedApplications().forEach(e -> e.validate());
        }
        if (this.requiredResourceAccess() != null) {
            this.requiredResourceAccess().forEach(e -> e.validate());
        }
    }
}

