/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.implementation;

import com.azure.core.management.AzureEnvironment;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.authorization.fluent.models.KeyCredentialInner;
import com.azure.resourcemanager.authorization.implementation.HasCredential;
import com.azure.resourcemanager.authorization.implementation.ServicePrincipalImpl;
import com.azure.resourcemanager.authorization.models.CertificateCredential;
import com.azure.resourcemanager.authorization.models.CertificateType;
import com.azure.resourcemanager.resources.fluentcore.model.implementation.IndexableRefreshableWrapperImpl;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.Base64;
import reactor.core.publisher.Mono;

class CertificateCredentialImpl<T extends HasCredential<T>>
extends IndexableRefreshableWrapperImpl<CertificateCredential, KeyCredentialInner>
implements CertificateCredential,
CertificateCredential.Definition<T>,
CertificateCredential.UpdateDefinition<T> {
    private String name;
    private HasCredential<T> parent;
    private OutputStream authFile;
    private String privateKeyPath;
    private String privateKeyPassword;
    private final ClientLogger logger = new ClientLogger(CertificateCredentialImpl.class);

    CertificateCredentialImpl(KeyCredentialInner keyCredential) {
        super((Object)keyCredential);
        this.name = keyCredential.customKeyIdentifier() != null && !keyCredential.customKeyIdentifier().isEmpty() ? new String(Base64.getMimeDecoder().decode(keyCredential.customKeyIdentifier()), StandardCharsets.UTF_8) : keyCredential.keyId();
    }

    CertificateCredentialImpl(String name, HasCredential<T> parent) {
        super((Object)new KeyCredentialInner().withUsage("Verify").withCustomKeyIdentifier(Base64.getEncoder().encodeToString(name.getBytes(StandardCharsets.UTF_8))).withStartDate(OffsetDateTime.now()).withEndDate(OffsetDateTime.now().plusYears(1L)));
        this.name = name;
        this.parent = parent;
    }

    public Mono<CertificateCredential> refreshAsync() {
        throw this.logger.logExceptionAsError((RuntimeException)new UnsupportedOperationException("Cannot refresh credentials."));
    }

    protected Mono<KeyCredentialInner> getInnerAsync() {
        throw this.logger.logExceptionAsError((RuntimeException)new UnsupportedOperationException("Cannot refresh credentials."));
    }

    @Override
    public OffsetDateTime startDate() {
        return ((KeyCredentialInner)this.innerModel()).startDate();
    }

    @Override
    public OffsetDateTime endDate() {
        return ((KeyCredentialInner)this.innerModel()).endDate();
    }

    @Override
    public String value() {
        return ((KeyCredentialInner)this.innerModel()).value();
    }

    public T attach() {
        return this.parent.withCertificateCredential(this);
    }

    @Override
    public CertificateCredentialImpl<T> withStartDate(OffsetDateTime startDate) {
        OffsetDateTime original = this.startDate();
        ((KeyCredentialInner)this.innerModel()).withStartDate(startDate);
        this.withDuration(Duration.between(original, this.endDate()));
        return this;
    }

    @Override
    public CertificateCredentialImpl<T> withDuration(Duration duration) {
        ((KeyCredentialInner)this.innerModel()).withEndDate(this.startDate().plus(duration));
        return this;
    }

    @Override
    public CertificateCredentialImpl<T> withAsymmetricX509Certificate() {
        ((KeyCredentialInner)this.innerModel()).withType(CertificateType.ASYMMETRIC_X509_CERT.toString());
        return this;
    }

    @Override
    public CertificateCredentialImpl<T> withSymmetricEncryption() {
        ((KeyCredentialInner)this.innerModel()).withType(CertificateType.SYMMETRIC.toString());
        return this;
    }

    @Override
    public CertificateCredentialImpl<T> withPublicKey(byte[] certificate) {
        ((KeyCredentialInner)this.innerModel()).withValue(Base64.getEncoder().encodeToString(certificate));
        return this;
    }

    @Override
    public CertificateCredentialImpl<T> withSecretKey(byte[] secret) {
        ((KeyCredentialInner)this.innerModel()).withValue(Base64.getEncoder().encodeToString(secret));
        return this;
    }

    void exportAuthFile(ServicePrincipalImpl servicePrincipal) {
        if (this.authFile == null) {
            return;
        }
        AzureEnvironment environment = AzureEnvironment.AZURE;
        StringBuilder builder = new StringBuilder("{\n");
        builder.append("  ").append(String.format("\"clientId\": \"%s\",", servicePrincipal.applicationId())).append("\n");
        builder.append("  ").append(String.format("\"clientCertificate\": \"%s\",", this.privateKeyPath.replace("\\", "\\\\"))).append("\n");
        builder.append("  ").append(String.format("\"clientCertificatePassword\": \"%s\",", this.privateKeyPassword)).append("\n");
        builder.append("  ").append(String.format("\"tenantId\": \"%s\",", servicePrincipal.manager().tenantId())).append("\n");
        builder.append("  ").append(String.format("\"subscriptionId\": \"%s\",", servicePrincipal.assignedSubscription)).append("\n");
        builder.append("  ").append(String.format("\"activeDirectoryEndpointUrl\": \"%s\",", environment.getActiveDirectoryEndpoint())).append("\n");
        builder.append("  ").append(String.format("\"resourceManagerEndpointUrl\": \"%s\",", environment.getResourceManagerEndpoint())).append("\n");
        builder.append("  ").append(String.format("\"activeDirectoryGraphResourceId\": \"%s\",", environment.getGraphEndpoint())).append("\n");
        builder.append("  ").append(String.format("\"managementEndpointUrl\": \"%s\"", environment.getManagementEndpoint())).append("\n");
        builder.append("}");
        try {
            this.authFile.write(builder.toString().getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            throw this.logger.logExceptionAsError(new RuntimeException(e));
        }
    }

    @Override
    public CertificateCredentialImpl<T> withAuthFileToExport(OutputStream outputStream) {
        this.authFile = outputStream;
        return this;
    }

    @Override
    public CertificateCredentialImpl<T> withPrivateKeyFile(String privateKeyPath) {
        this.privateKeyPath = privateKeyPath;
        return this;
    }

    @Override
    public CertificateCredentialImpl<T> withPrivateKeyPassword(String privateKeyPassword) {
        this.privateKeyPassword = privateKeyPassword;
        return this;
    }

    public String id() {
        return ((KeyCredentialInner)this.innerModel()).keyId();
    }

    public String name() {
        return this.name;
    }
}

