/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.implementation;

import com.azure.resourcemanager.authorization.AuthorizationManager;
import com.azure.resourcemanager.authorization.fluent.models.KeyCredentialInner;
import com.azure.resourcemanager.authorization.fluent.models.PasswordCredentialInner;
import com.azure.resourcemanager.authorization.fluent.models.ServicePrincipalInner;
import com.azure.resourcemanager.authorization.implementation.CertificateCredentialImpl;
import com.azure.resourcemanager.authorization.implementation.HasCredential;
import com.azure.resourcemanager.authorization.implementation.PasswordCredentialImpl;
import com.azure.resourcemanager.authorization.models.ActiveDirectoryApplication;
import com.azure.resourcemanager.authorization.models.BuiltInRole;
import com.azure.resourcemanager.authorization.models.CertificateCredential;
import com.azure.resourcemanager.authorization.models.PasswordCredential;
import com.azure.resourcemanager.authorization.models.RoleAssignment;
import com.azure.resourcemanager.authorization.models.ServicePrincipal;
import com.azure.resourcemanager.authorization.models.ServicePrincipalCreateParameters;
import com.azure.resourcemanager.resources.fluentcore.model.Creatable;
import com.azure.resourcemanager.resources.fluentcore.model.implementation.CreatableUpdatableImpl;
import com.azure.resourcemanager.resources.fluentcore.model.implementation.IndexableRefreshableWrapperImpl;
import com.azure.resourcemanager.resources.models.ResourceGroup;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class ServicePrincipalImpl
extends CreatableUpdatableImpl<ServicePrincipal, ServicePrincipalInner, ServicePrincipalImpl>
implements ServicePrincipal,
ServicePrincipal.Definition,
ServicePrincipal.Update,
HasCredential<ServicePrincipalImpl> {
    private AuthorizationManager manager;
    private Map<String, PasswordCredential> cachedPasswordCredentials;
    private Map<String, CertificateCredential> cachedCertificateCredentials;
    private Map<String, RoleAssignment> cachedRoleAssignments;
    private ServicePrincipalCreateParameters createParameters;
    private Creatable<ActiveDirectoryApplication> applicationCreatable;
    private Map<String, BuiltInRole> rolesToCreate;
    private Set<String> rolesToDelete;
    String assignedSubscription;
    private List<CertificateCredentialImpl<?>> certificateCredentialsToCreate;
    private List<PasswordCredentialImpl<?>> passwordCredentialsToCreate;
    private Set<String> certificateCredentialsToDelete;
    private Set<String> passwordCredentialsToDelete;

    ServicePrincipalImpl(ServicePrincipalInner innerObject, AuthorizationManager manager) {
        super(innerObject.displayName(), (Object)innerObject);
        this.manager = manager;
        this.createParameters = new ServicePrincipalCreateParameters();
        this.createParameters.withAccountEnabled(true);
        this.cachedRoleAssignments = new HashMap<String, RoleAssignment>();
        this.rolesToCreate = new HashMap<String, BuiltInRole>();
        this.rolesToDelete = new HashSet<String>();
        this.cachedCertificateCredentials = new HashMap<String, CertificateCredential>();
        this.certificateCredentialsToCreate = new ArrayList();
        this.certificateCredentialsToDelete = new HashSet<String>();
        this.cachedPasswordCredentials = new HashMap<String, PasswordCredential>();
        this.passwordCredentialsToCreate = new ArrayList();
        this.passwordCredentialsToDelete = new HashSet<String>();
    }

    @Override
    public String applicationId() {
        return ((ServicePrincipalInner)this.innerModel()).appId();
    }

    @Override
    public List<String> servicePrincipalNames() {
        return ((ServicePrincipalInner)this.innerModel()).servicePrincipalNames();
    }

    @Override
    public Map<String, PasswordCredential> passwordCredentials() {
        return Collections.unmodifiableMap(this.cachedPasswordCredentials);
    }

    @Override
    public Map<String, CertificateCredential> certificateCredentials() {
        return Collections.unmodifiableMap(this.cachedCertificateCredentials);
    }

    @Override
    public Set<RoleAssignment> roleAssignments() {
        return Collections.unmodifiableSet(new HashSet<RoleAssignment>(this.cachedRoleAssignments.values()));
    }

    protected Mono<ServicePrincipalInner> getInnerAsync() {
        return this.manager.serviceClient().getServicePrincipals().getAsync(this.id());
    }

    public Mono<ServicePrincipal> createResourceAsync() {
        Mono sp = Mono.just((Object)this);
        if (this.isInCreateMode()) {
            if (this.applicationCreatable != null) {
                ActiveDirectoryApplication application = (ActiveDirectoryApplication)this.taskResult(this.applicationCreatable.key());
                this.createParameters.withAppId(application.applicationId());
            }
            sp = this.manager.serviceClient().getServicePrincipals().createAsync(this.createParameters).map(this.innerToFluentMap((IndexableRefreshableWrapperImpl)this));
        }
        return sp.flatMap(servicePrincipal -> this.submitCredentialsAsync((ServicePrincipal)servicePrincipal).mergeWith(this.submitRolesAsync((ServicePrincipal)servicePrincipal)).last()).map(servicePrincipal -> {
            for (PasswordCredentialImpl<?> passwordCredentialImpl : this.passwordCredentialsToCreate) {
                passwordCredentialImpl.exportAuthFile((ServicePrincipalImpl)servicePrincipal);
            }
            for (CertificateCredentialImpl certificateCredentialImpl : this.certificateCredentialsToCreate) {
                certificateCredentialImpl.exportAuthFile((ServicePrincipalImpl)servicePrincipal);
            }
            this.passwordCredentialsToCreate.clear();
            this.certificateCredentialsToCreate.clear();
            return servicePrincipal;
        });
    }

    private Mono<ServicePrincipal> submitCredentialsAsync(ServicePrincipal sp) {
        Mono mono = Mono.empty();
        if (!this.certificateCredentialsToCreate.isEmpty() || !this.certificateCredentialsToDelete.isEmpty()) {
            HashMap<String, CertificateCredential> newCerts = new HashMap<String, CertificateCredential>(this.cachedCertificateCredentials);
            for (String string : this.certificateCredentialsToDelete) {
                newCerts.remove(string);
            }
            for (CertificateCredential certificateCredential : this.certificateCredentialsToCreate) {
                newCerts.put(certificateCredential.name(), certificateCredential);
            }
            Iterator<PasswordCredentialImpl<?>> updateKeyCredentials = new ArrayList();
            for (CertificateCredential certificateCredential : newCerts.values()) {
                updateKeyCredentials.add((PasswordCredentialImpl<?>)((Object)((KeyCredentialInner)certificateCredential.innerModel())));
            }
            mono = mono.concatWith((Publisher)this.manager().serviceClient().getServicePrincipals().updateKeyCredentialsAsync(sp.id(), (List<KeyCredentialInner>)((Object)updateKeyCredentials)).then(Mono.just((Object)this))).last();
        }
        if (!this.passwordCredentialsToCreate.isEmpty() || !this.passwordCredentialsToDelete.isEmpty()) {
            HashMap<String, PasswordCredential> newPasses = new HashMap<String, PasswordCredential>(this.cachedPasswordCredentials);
            for (String string : this.passwordCredentialsToDelete) {
                newPasses.remove(string);
            }
            for (PasswordCredential passwordCredential : this.passwordCredentialsToCreate) {
                newPasses.put(passwordCredential.name(), passwordCredential);
            }
            ArrayList<PasswordCredentialInner> updatePasswordCredentials = new ArrayList<PasswordCredentialInner>();
            for (PasswordCredential passwordCredential : newPasses.values()) {
                updatePasswordCredentials.add((PasswordCredentialInner)passwordCredential.innerModel());
            }
            mono = mono.concatWith((Publisher)this.manager().serviceClient().getServicePrincipals().updatePasswordCredentialsAsync(sp.id(), updatePasswordCredentials).then(Mono.just((Object)this))).last();
        }
        return mono.flatMap(servicePrincipal -> {
            this.passwordCredentialsToDelete.clear();
            this.certificateCredentialsToDelete.clear();
            return this.refreshCredentialsAsync();
        });
    }

    private Mono<ServicePrincipal> submitRolesAsync(ServicePrincipal servicePrincipal) {
        Mono create = this.rolesToCreate.isEmpty() ? Mono.just((Object)servicePrincipal) : Flux.fromIterable(this.rolesToCreate.entrySet()).flatMap(roleEntry -> ((RoleAssignment.DefinitionStages.Blank)this.manager().roleAssignments().define(this.manager().internalContext().randomUuid())).forServicePrincipal(servicePrincipal).withBuiltInRole((BuiltInRole)((Object)((Object)roleEntry.getValue()))).withScope((String)roleEntry.getKey()).createAsync()).doOnNext(indexable -> this.cachedRoleAssignments.put(indexable.id(), (RoleAssignment)indexable)).last().map(indexable -> {
            this.rolesToCreate.clear();
            return servicePrincipal;
        });
        Mono delete = this.rolesToDelete.isEmpty() ? Mono.just((Object)servicePrincipal) : Flux.fromIterable(this.rolesToDelete).flatMap(role -> this.manager().roleAssignments().deleteByIdAsync(this.cachedRoleAssignments.get(role).id()).thenReturn(role)).doOnNext(s -> this.cachedRoleAssignments.remove(s)).last().map(s -> {
            this.rolesToDelete.clear();
            return servicePrincipal;
        });
        return create.mergeWith((Publisher)delete).last();
    }

    public boolean isInCreateMode() {
        return this.id() == null;
    }

    Mono<ServicePrincipal> refreshCredentialsAsync() {
        return Mono.just((Object)this).map(servicePrincipal -> {
            servicePrincipal.cachedCertificateCredentials.clear();
            servicePrincipal.cachedPasswordCredentials.clear();
            return servicePrincipal;
        }).concatWith((Publisher)this.manager().serviceClient().getServicePrincipals().listKeyCredentialsAsync(this.id()).map(keyCredentialInner -> {
            CertificateCredentialImpl credential = new CertificateCredentialImpl((KeyCredentialInner)keyCredentialInner);
            this.cachedCertificateCredentials.put(credential.name(), credential);
            return this;
        })).concatWith((Publisher)this.manager().serviceClient().getServicePrincipals().listPasswordCredentialsAsync(this.id()).map(passwordCredentialInner -> {
            PasswordCredentialImpl credential = new PasswordCredentialImpl((PasswordCredentialInner)passwordCredentialInner);
            this.cachedPasswordCredentials.put(credential.name(), credential);
            return this;
        })).last();
    }

    public Mono<ServicePrincipal> refreshAsync() {
        return this.getInnerAsync().map(this.innerToFluentMap((IndexableRefreshableWrapperImpl)this)).flatMap(application -> this.refreshCredentialsAsync());
    }

    public CertificateCredentialImpl<ServicePrincipalImpl> defineCertificateCredential(String name) {
        return new CertificateCredentialImpl<ServicePrincipalImpl>(name, this);
    }

    public PasswordCredentialImpl<ServicePrincipalImpl> definePasswordCredential(String name) {
        return new PasswordCredentialImpl<ServicePrincipalImpl>(name, this);
    }

    @Override
    public ServicePrincipalImpl withoutCredential(String name) {
        if (this.cachedPasswordCredentials.containsKey(name)) {
            this.passwordCredentialsToDelete.add(name);
        } else if (this.cachedCertificateCredentials.containsKey(name)) {
            this.certificateCredentialsToDelete.add(name);
        }
        return this;
    }

    @Override
    public ServicePrincipalImpl withCertificateCredential(CertificateCredentialImpl<?> credential) {
        this.certificateCredentialsToCreate.add(credential);
        return this;
    }

    @Override
    public ServicePrincipalImpl withPasswordCredential(PasswordCredentialImpl<?> credential) {
        this.passwordCredentialsToCreate.add(credential);
        return this;
    }

    @Override
    public ServicePrincipalImpl withExistingApplication(String id) {
        this.createParameters.withAppId(id);
        return this;
    }

    @Override
    public ServicePrincipalImpl withExistingApplication(ActiveDirectoryApplication application) {
        this.createParameters.withAppId(application.applicationId());
        return this;
    }

    @Override
    public ServicePrincipalImpl withNewApplication(Creatable<ActiveDirectoryApplication> applicationCreatable) {
        this.addDependency(applicationCreatable);
        this.applicationCreatable = applicationCreatable;
        return this;
    }

    @Override
    public ServicePrincipalImpl withNewApplication(String signOnUrl) {
        return this.withNewApplication(((ActiveDirectoryApplication.DefinitionStages.Blank)this.manager.applications().define(this.name())).withSignOnUrl(signOnUrl).withIdentifierUrl(signOnUrl));
    }

    @Override
    public ServicePrincipalImpl withNewRole(BuiltInRole role, String scope) {
        this.rolesToCreate.put(scope, role);
        return this;
    }

    @Override
    public ServicePrincipalImpl withNewRoleInSubscription(BuiltInRole role, String subscriptionId) {
        this.assignedSubscription = subscriptionId;
        return this.withNewRole(role, "subscriptions/" + subscriptionId);
    }

    @Override
    public ServicePrincipalImpl withNewRoleInResourceGroup(BuiltInRole role, ResourceGroup resourceGroup) {
        return this.withNewRole(role, resourceGroup.id());
    }

    @Override
    public ServicePrincipal.Update withoutRole(RoleAssignment roleAssignment) {
        this.rolesToDelete.add(roleAssignment.id());
        return this;
    }

    public String id() {
        return ((ServicePrincipalInner)this.innerModel()).objectId();
    }

    public AuthorizationManager manager() {
        return this.manager;
    }
}

