/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.authorization.fluent.models.KeyCredentialInner;
import com.azure.resourcemanager.authorization.fluent.models.PasswordCredentialInner;
import com.azure.resourcemanager.authorization.models.AppRole;
import com.azure.resourcemanager.authorization.models.GroupMembershipClaimTypes;
import com.azure.resourcemanager.authorization.models.InformationalUrl;
import com.azure.resourcemanager.authorization.models.OAuth2Permission;
import com.azure.resourcemanager.authorization.models.OptionalClaims;
import com.azure.resourcemanager.authorization.models.PreAuthorizedApplication;
import com.azure.resourcemanager.authorization.models.RequiredResourceAccess;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public class ApplicationBase {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(ApplicationBase.class);
    @JsonProperty(value="allowGuestsSignIn")
    private Boolean allowGuestsSignIn;
    @JsonProperty(value="allowPassthroughUsers")
    private Boolean allowPassthroughUsers;
    @JsonProperty(value="appLogoUrl")
    private String appLogoUrl;
    @JsonProperty(value="appRoles")
    private List<AppRole> appRoles;
    @JsonProperty(value="appPermissions")
    private List<String> appPermissions;
    @JsonProperty(value="availableToOtherTenants")
    private Boolean availableToOtherTenants;
    @JsonProperty(value="errorUrl")
    private String errorUrl;
    @JsonProperty(value="groupMembershipClaims")
    private GroupMembershipClaimTypes groupMembershipClaims;
    @JsonProperty(value="homepage")
    private String homepage;
    @JsonProperty(value="informationalUrls")
    private InformationalUrl informationalUrls;
    @JsonProperty(value="isDeviceOnlyAuthSupported")
    private Boolean isDeviceOnlyAuthSupported;
    @JsonProperty(value="keyCredentials")
    private List<KeyCredentialInner> keyCredentials;
    @JsonProperty(value="knownClientApplications")
    private List<String> knownClientApplications;
    @JsonProperty(value="logoutUrl")
    private String logoutUrl;
    @JsonProperty(value="oauth2AllowImplicitFlow")
    private Boolean oauth2AllowImplicitFlow;
    @JsonProperty(value="oauth2AllowUrlPathMatching")
    private Boolean oauth2AllowUrlPathMatching;
    @JsonProperty(value="oauth2Permissions")
    private List<OAuth2Permission> oauth2Permissions;
    @JsonProperty(value="oauth2RequirePostResponse")
    private Boolean oauth2RequirePostResponse;
    @JsonProperty(value="orgRestrictions")
    private List<String> orgRestrictions;
    @JsonProperty(value="optionalClaims")
    private OptionalClaims optionalClaims;
    @JsonProperty(value="passwordCredentials")
    private List<PasswordCredentialInner> passwordCredentials;
    @JsonProperty(value="preAuthorizedApplications")
    private List<PreAuthorizedApplication> preAuthorizedApplications;
    @JsonProperty(value="publicClient")
    private Boolean publicClient;
    @JsonProperty(value="publisherDomain")
    private String publisherDomain;
    @JsonProperty(value="replyUrls")
    private List<String> replyUrls;
    @JsonProperty(value="requiredResourceAccess")
    private List<RequiredResourceAccess> requiredResourceAccess;
    @JsonProperty(value="samlMetadataUrl")
    private String samlMetadataUrl;
    @JsonProperty(value="signInAudience")
    private String signInAudience;
    @JsonProperty(value="wwwHomepage")
    private String wwwHomepage;

    public Boolean allowGuestsSignIn() {
        return this.allowGuestsSignIn;
    }

    public ApplicationBase withAllowGuestsSignIn(Boolean allowGuestsSignIn) {
        this.allowGuestsSignIn = allowGuestsSignIn;
        return this;
    }

    public Boolean allowPassthroughUsers() {
        return this.allowPassthroughUsers;
    }

    public ApplicationBase withAllowPassthroughUsers(Boolean allowPassthroughUsers) {
        this.allowPassthroughUsers = allowPassthroughUsers;
        return this;
    }

    public String appLogoUrl() {
        return this.appLogoUrl;
    }

    public ApplicationBase withAppLogoUrl(String appLogoUrl) {
        this.appLogoUrl = appLogoUrl;
        return this;
    }

    public List<AppRole> appRoles() {
        return this.appRoles;
    }

    public ApplicationBase withAppRoles(List<AppRole> appRoles) {
        this.appRoles = appRoles;
        return this;
    }

    public List<String> appPermissions() {
        return this.appPermissions;
    }

    public ApplicationBase withAppPermissions(List<String> appPermissions) {
        this.appPermissions = appPermissions;
        return this;
    }

    public Boolean availableToOtherTenants() {
        return this.availableToOtherTenants;
    }

    public ApplicationBase withAvailableToOtherTenants(Boolean availableToOtherTenants) {
        this.availableToOtherTenants = availableToOtherTenants;
        return this;
    }

    public String errorUrl() {
        return this.errorUrl;
    }

    public ApplicationBase withErrorUrl(String errorUrl) {
        this.errorUrl = errorUrl;
        return this;
    }

    public GroupMembershipClaimTypes groupMembershipClaims() {
        return this.groupMembershipClaims;
    }

    public ApplicationBase withGroupMembershipClaims(GroupMembershipClaimTypes groupMembershipClaims) {
        this.groupMembershipClaims = groupMembershipClaims;
        return this;
    }

    public String homepage() {
        return this.homepage;
    }

    public ApplicationBase withHomepage(String homepage) {
        this.homepage = homepage;
        return this;
    }

    public InformationalUrl informationalUrls() {
        return this.informationalUrls;
    }

    public ApplicationBase withInformationalUrls(InformationalUrl informationalUrls) {
        this.informationalUrls = informationalUrls;
        return this;
    }

    public Boolean isDeviceOnlyAuthSupported() {
        return this.isDeviceOnlyAuthSupported;
    }

    public ApplicationBase withIsDeviceOnlyAuthSupported(Boolean isDeviceOnlyAuthSupported) {
        this.isDeviceOnlyAuthSupported = isDeviceOnlyAuthSupported;
        return this;
    }

    public List<KeyCredentialInner> keyCredentials() {
        return this.keyCredentials;
    }

    public ApplicationBase withKeyCredentials(List<KeyCredentialInner> keyCredentials) {
        this.keyCredentials = keyCredentials;
        return this;
    }

    public List<String> knownClientApplications() {
        return this.knownClientApplications;
    }

    public ApplicationBase withKnownClientApplications(List<String> knownClientApplications) {
        this.knownClientApplications = knownClientApplications;
        return this;
    }

    public String logoutUrl() {
        return this.logoutUrl;
    }

    public ApplicationBase withLogoutUrl(String logoutUrl) {
        this.logoutUrl = logoutUrl;
        return this;
    }

    public Boolean oauth2AllowImplicitFlow() {
        return this.oauth2AllowImplicitFlow;
    }

    public ApplicationBase withOauth2AllowImplicitFlow(Boolean oauth2AllowImplicitFlow) {
        this.oauth2AllowImplicitFlow = oauth2AllowImplicitFlow;
        return this;
    }

    public Boolean oauth2AllowUrlPathMatching() {
        return this.oauth2AllowUrlPathMatching;
    }

    public ApplicationBase withOauth2AllowUrlPathMatching(Boolean oauth2AllowUrlPathMatching) {
        this.oauth2AllowUrlPathMatching = oauth2AllowUrlPathMatching;
        return this;
    }

    public List<OAuth2Permission> oauth2Permissions() {
        return this.oauth2Permissions;
    }

    public ApplicationBase withOauth2Permissions(List<OAuth2Permission> oauth2Permissions) {
        this.oauth2Permissions = oauth2Permissions;
        return this;
    }

    public Boolean oauth2RequirePostResponse() {
        return this.oauth2RequirePostResponse;
    }

    public ApplicationBase withOauth2RequirePostResponse(Boolean oauth2RequirePostResponse) {
        this.oauth2RequirePostResponse = oauth2RequirePostResponse;
        return this;
    }

    public List<String> orgRestrictions() {
        return this.orgRestrictions;
    }

    public ApplicationBase withOrgRestrictions(List<String> orgRestrictions) {
        this.orgRestrictions = orgRestrictions;
        return this;
    }

    public OptionalClaims optionalClaims() {
        return this.optionalClaims;
    }

    public ApplicationBase withOptionalClaims(OptionalClaims optionalClaims) {
        this.optionalClaims = optionalClaims;
        return this;
    }

    public List<PasswordCredentialInner> passwordCredentials() {
        return this.passwordCredentials;
    }

    public ApplicationBase withPasswordCredentials(List<PasswordCredentialInner> passwordCredentials) {
        this.passwordCredentials = passwordCredentials;
        return this;
    }

    public List<PreAuthorizedApplication> preAuthorizedApplications() {
        return this.preAuthorizedApplications;
    }

    public ApplicationBase withPreAuthorizedApplications(List<PreAuthorizedApplication> preAuthorizedApplications) {
        this.preAuthorizedApplications = preAuthorizedApplications;
        return this;
    }

    public Boolean publicClient() {
        return this.publicClient;
    }

    public ApplicationBase withPublicClient(Boolean publicClient) {
        this.publicClient = publicClient;
        return this;
    }

    public String publisherDomain() {
        return this.publisherDomain;
    }

    public ApplicationBase withPublisherDomain(String publisherDomain) {
        this.publisherDomain = publisherDomain;
        return this;
    }

    public List<String> replyUrls() {
        return this.replyUrls;
    }

    public ApplicationBase withReplyUrls(List<String> replyUrls) {
        this.replyUrls = replyUrls;
        return this;
    }

    public List<RequiredResourceAccess> requiredResourceAccess() {
        return this.requiredResourceAccess;
    }

    public ApplicationBase withRequiredResourceAccess(List<RequiredResourceAccess> requiredResourceAccess) {
        this.requiredResourceAccess = requiredResourceAccess;
        return this;
    }

    public String samlMetadataUrl() {
        return this.samlMetadataUrl;
    }

    public ApplicationBase withSamlMetadataUrl(String samlMetadataUrl) {
        this.samlMetadataUrl = samlMetadataUrl;
        return this;
    }

    public String signInAudience() {
        return this.signInAudience;
    }

    public ApplicationBase withSignInAudience(String signInAudience) {
        this.signInAudience = signInAudience;
        return this;
    }

    public String wwwHomepage() {
        return this.wwwHomepage;
    }

    public ApplicationBase withWwwHomepage(String wwwHomepage) {
        this.wwwHomepage = wwwHomepage;
        return this;
    }

    public void validate() {
        if (this.appRoles() != null) {
            this.appRoles().forEach(e -> e.validate());
        }
        if (this.informationalUrls() != null) {
            this.informationalUrls().validate();
        }
        if (this.keyCredentials() != null) {
            this.keyCredentials().forEach(e -> e.validate());
        }
        if (this.oauth2Permissions() != null) {
            this.oauth2Permissions().forEach(e -> e.validate());
        }
        if (this.optionalClaims() != null) {
            this.optionalClaims().validate();
        }
        if (this.passwordCredentials() != null) {
            this.passwordCredentials().forEach(e -> e.validate());
        }
        if (this.preAuthorizedApplications() != null) {
            this.preAuthorizedApplications().forEach(e -> e.validate());
        }
        if (this.requiredResourceAccess() != null) {
            this.requiredResourceAccess().forEach(e -> e.validate());
        }
    }
}

