/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.authorization.models.PreAuthorizedApplicationExtension;
import com.azure.resourcemanager.authorization.models.PreAuthorizedApplicationPermission;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class PreAuthorizedApplication {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(PreAuthorizedApplication.class);
    @JsonProperty(value="appId")
    private String appId;
    @JsonProperty(value="permissions")
    private List<PreAuthorizedApplicationPermission> permissions;
    @JsonProperty(value="extensions")
    private List<PreAuthorizedApplicationExtension> extensions;

    public String appId() {
        return this.appId;
    }

    public PreAuthorizedApplication withAppId(String appId) {
        this.appId = appId;
        return this;
    }

    public List<PreAuthorizedApplicationPermission> permissions() {
        return this.permissions;
    }

    public PreAuthorizedApplication withPermissions(List<PreAuthorizedApplicationPermission> permissions) {
        this.permissions = permissions;
        return this;
    }

    public List<PreAuthorizedApplicationExtension> extensions() {
        return this.extensions;
    }

    public PreAuthorizedApplication withExtensions(List<PreAuthorizedApplicationExtension> extensions) {
        this.extensions = extensions;
        return this;
    }

    public void validate() {
        if (this.permissions() != null) {
            this.permissions().forEach(e -> e.validate());
        }
        if (this.extensions() != null) {
            this.extensions().forEach(e -> e.validate());
        }
    }
}

