/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.msi.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.msi.fluent.SystemAssignedIdentitiesClient;
import com.azure.resourcemanager.msi.fluent.models.SystemAssignedIdentityInner;
import com.azure.resourcemanager.msi.implementation.ManagedServiceIdentityClientImpl;
import reactor.core.publisher.Mono;

public final class SystemAssignedIdentitiesClientImpl
implements SystemAssignedIdentitiesClient {
    private final ClientLogger logger = new ClientLogger(SystemAssignedIdentitiesClientImpl.class);
    private final SystemAssignedIdentitiesService service;
    private final ManagedServiceIdentityClientImpl client;

    SystemAssignedIdentitiesClientImpl(ManagedServiceIdentityClientImpl client) {
        this.service = (SystemAssignedIdentitiesService)RestProxy.create(SystemAssignedIdentitiesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    public Mono<Response<SystemAssignedIdentityInner>> getByScopeWithResponseAsync(String scope) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.getByScope(this.client.getEndpoint(), scope, this.client.getApiVersion(), (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<SystemAssignedIdentityInner>> getByScopeWithResponseAsync(String scope, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.getByScope(this.client.getEndpoint(), scope, this.client.getApiVersion(), context);
    }

    @Override
    public Mono<SystemAssignedIdentityInner> getByScopeAsync(String scope) {
        return this.getByScopeWithResponseAsync(scope).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((SystemAssignedIdentityInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    public SystemAssignedIdentityInner getByScope(String scope) {
        return (SystemAssignedIdentityInner)((Object)this.getByScopeAsync(scope).block());
    }

    @Override
    public Response<SystemAssignedIdentityInner> getByScopeWithResponse(String scope, Context context) {
        return (Response)this.getByScopeWithResponseAsync(scope, context).block();
    }

    @Host(value="{$host}")
    @ServiceInterface(name="ManagedServiceIdenti")
    private static interface SystemAssignedIdentitiesService {
        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/{scope}/providers/Microsoft.ManagedIdentity/identities/default")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SystemAssignedIdentityInner>> getByScope(@HostParam(value="$host") String var1, @PathParam(value="scope", encoded=true) String var2, @QueryParam(value="api-version") String var3, Context var4);
    }
}

