// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.implementation;

import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.resourcemanager.sql.fluent.LongTermRetentionBackupsClient;
import com.azure.resourcemanager.sql.fluent.models.LongTermRetentionBackupInner;
import com.azure.resourcemanager.sql.models.LongTermRetentionBackupListResult;
import com.azure.resourcemanager.sql.models.LongTermRetentionDatabaseState;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in LongTermRetentionBackupsClient. */
public final class LongTermRetentionBackupsClientImpl implements LongTermRetentionBackupsClient {
    private final ClientLogger logger = new ClientLogger(LongTermRetentionBackupsClientImpl.class);

    /** The proxy service used to perform REST calls. */
    private final LongTermRetentionBackupsService service;

    /** The service client containing this operation class. */
    private final SqlManagementClientImpl client;

    /**
     * Initializes an instance of LongTermRetentionBackupsClientImpl.
     *
     * @param client the instance of the service client containing this operation class.
     */
    LongTermRetentionBackupsClientImpl(SqlManagementClientImpl client) {
        this.service =
            RestProxy
                .create(LongTermRetentionBackupsService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for SqlManagementClientLongTermRetentionBackups to be used by the proxy
     * service to perform REST calls.
     */
    @Host("{$host}")
    @ServiceInterface(name = "SqlManagementClientL")
    private interface LongTermRetentionBackupsService {
        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Get(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/locations"
                + "/{locationName}/longTermRetentionServers/{longTermRetentionServerName}/longTermRetentionDatabases"
                + "/{longTermRetentionDatabaseName}/longTermRetentionBackups/{backupName}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<LongTermRetentionBackupInner>> getByResourceGroup(
            @HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("locationName") String locationName,
            @PathParam("longTermRetentionServerName") String longTermRetentionServerName,
            @PathParam("longTermRetentionDatabaseName") String longTermRetentionDatabaseName,
            @PathParam("backupName") String backupName,
            @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion,
            Context context);

        @Headers({"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Delete(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/locations"
                + "/{locationName}/longTermRetentionServers/{longTermRetentionServerName}/longTermRetentionDatabases"
                + "/{longTermRetentionDatabaseName}/longTermRetentionBackups/{backupName}")
        @ExpectedResponses({200, 202})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> deleteByResourceGroup(
            @HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("locationName") String locationName,
            @PathParam("longTermRetentionServerName") String longTermRetentionServerName,
            @PathParam("longTermRetentionDatabaseName") String longTermRetentionDatabaseName,
            @PathParam("backupName") String backupName,
            @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion,
            Context context);

        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Get(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/locations"
                + "/{locationName}/longTermRetentionServers/{longTermRetentionServerName}/longTermRetentionDatabases"
                + "/{longTermRetentionDatabaseName}/longTermRetentionBackups")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<LongTermRetentionBackupListResult>> listByResourceGroupDatabase(
            @HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("locationName") String locationName,
            @PathParam("longTermRetentionServerName") String longTermRetentionServerName,
            @PathParam("longTermRetentionDatabaseName") String longTermRetentionDatabaseName,
            @QueryParam("onlyLatestPerDatabase") Boolean onlyLatestPerDatabase,
            @QueryParam("databaseState") LongTermRetentionDatabaseState databaseState,
            @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion,
            Context context);

        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Get(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/locations"
                + "/{locationName}/longTermRetentionBackups")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<LongTermRetentionBackupListResult>> listByResourceGroupLocation(
            @HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("locationName") String locationName,
            @QueryParam("onlyLatestPerDatabase") Boolean onlyLatestPerDatabase,
            @QueryParam("databaseState") LongTermRetentionDatabaseState databaseState,
            @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion,
            Context context);

        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Get(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/locations"
                + "/{locationName}/longTermRetentionServers/{longTermRetentionServerName}/longTermRetentionBackups")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<LongTermRetentionBackupListResult>> listByResourceGroupServer(
            @HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("locationName") String locationName,
            @PathParam("longTermRetentionServerName") String longTermRetentionServerName,
            @QueryParam("onlyLatestPerDatabase") Boolean onlyLatestPerDatabase,
            @QueryParam("databaseState") LongTermRetentionDatabaseState databaseState,
            @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion,
            Context context);

        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Get(
            "/subscriptions/{subscriptionId}/providers/Microsoft.Sql/locations/{locationName}/longTermRetentionServers"
                + "/{longTermRetentionServerName}/longTermRetentionDatabases/{longTermRetentionDatabaseName}"
                + "/longTermRetentionBackups/{backupName}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<LongTermRetentionBackupInner>> get(
            @HostParam("$host") String endpoint,
            @PathParam("locationName") String locationName,
            @PathParam("longTermRetentionServerName") String longTermRetentionServerName,
            @PathParam("longTermRetentionDatabaseName") String longTermRetentionDatabaseName,
            @PathParam("backupName") String backupName,
            @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion,
            Context context);

        @Headers({"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Delete(
            "/subscriptions/{subscriptionId}/providers/Microsoft.Sql/locations/{locationName}/longTermRetentionServers"
                + "/{longTermRetentionServerName}/longTermRetentionDatabases/{longTermRetentionDatabaseName}"
                + "/longTermRetentionBackups/{backupName}")
        @ExpectedResponses({200, 202})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> delete(
            @HostParam("$host") String endpoint,
            @PathParam("locationName") String locationName,
            @PathParam("longTermRetentionServerName") String longTermRetentionServerName,
            @PathParam("longTermRetentionDatabaseName") String longTermRetentionDatabaseName,
            @PathParam("backupName") String backupName,
            @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion,
            Context context);

        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Get(
            "/subscriptions/{subscriptionId}/providers/Microsoft.Sql/locations/{locationName}/longTermRetentionServers"
                + "/{longTermRetentionServerName}/longTermRetentionDatabases/{longTermRetentionDatabaseName}"
                + "/longTermRetentionBackups")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<LongTermRetentionBackupListResult>> listByDatabase(
            @HostParam("$host") String endpoint,
            @PathParam("locationName") String locationName,
            @PathParam("longTermRetentionServerName") String longTermRetentionServerName,
            @PathParam("longTermRetentionDatabaseName") String longTermRetentionDatabaseName,
            @QueryParam("onlyLatestPerDatabase") Boolean onlyLatestPerDatabase,
            @QueryParam("databaseState") LongTermRetentionDatabaseState databaseState,
            @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion,
            Context context);

        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Get(
            "/subscriptions/{subscriptionId}/providers/Microsoft.Sql/locations/{locationName}/longTermRetentionBackups")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<LongTermRetentionBackupListResult>> listByLocation(
            @HostParam("$host") String endpoint,
            @PathParam("locationName") String locationName,
            @QueryParam("onlyLatestPerDatabase") Boolean onlyLatestPerDatabase,
            @QueryParam("databaseState") LongTermRetentionDatabaseState databaseState,
            @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion,
            Context context);

        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Get(
            "/subscriptions/{subscriptionId}/providers/Microsoft.Sql/locations/{locationName}/longTermRetentionServers"
                + "/{longTermRetentionServerName}/longTermRetentionBackups")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<LongTermRetentionBackupListResult>> listByServer(
            @HostParam("$host") String endpoint,
            @PathParam("locationName") String locationName,
            @PathParam("longTermRetentionServerName") String longTermRetentionServerName,
            @QueryParam("onlyLatestPerDatabase") Boolean onlyLatestPerDatabase,
            @QueryParam("databaseState") LongTermRetentionDatabaseState databaseState,
            @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion,
            Context context);

        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<LongTermRetentionBackupListResult>> listByResourceGroupDatabaseNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, Context context);

        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<LongTermRetentionBackupListResult>> listByResourceGroupLocationNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, Context context);

        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<LongTermRetentionBackupListResult>> listByResourceGroupServerNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, Context context);

        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<LongTermRetentionBackupListResult>> listByDatabaseNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, Context context);

        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<LongTermRetentionBackupListResult>> listByLocationNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, Context context);

        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<LongTermRetentionBackupListResult>> listByServerNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, Context context);
    }

    /**
     * Gets a long term retention backup.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @param longTermRetentionDatabaseName The name of the database.
     * @param backupName The backup name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a long term retention backup.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<LongTermRetentionBackupInner>> getByResourceGroupWithResponseAsync(
        String resourceGroupName,
        String locationName,
        String longTermRetentionServerName,
        String longTermRetentionDatabaseName,
        String backupName) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (locationName == null) {
            return Mono.error(new IllegalArgumentException("Parameter locationName is required and cannot be null."));
        }
        if (longTermRetentionServerName == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter longTermRetentionServerName is required and cannot be null."));
        }
        if (longTermRetentionDatabaseName == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter longTermRetentionDatabaseName is required and cannot be null."));
        }
        if (backupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter backupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String apiVersion = "2017-03-01-preview";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .getByResourceGroup(
                            this.client.getEndpoint(),
                            resourceGroupName,
                            locationName,
                            longTermRetentionServerName,
                            longTermRetentionDatabaseName,
                            backupName,
                            this.client.getSubscriptionId(),
                            apiVersion,
                            context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Gets a long term retention backup.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @param longTermRetentionDatabaseName The name of the database.
     * @param backupName The backup name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a long term retention backup.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<LongTermRetentionBackupInner>> getByResourceGroupWithResponseAsync(
        String resourceGroupName,
        String locationName,
        String longTermRetentionServerName,
        String longTermRetentionDatabaseName,
        String backupName,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (locationName == null) {
            return Mono.error(new IllegalArgumentException("Parameter locationName is required and cannot be null."));
        }
        if (longTermRetentionServerName == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter longTermRetentionServerName is required and cannot be null."));
        }
        if (longTermRetentionDatabaseName == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter longTermRetentionDatabaseName is required and cannot be null."));
        }
        if (backupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter backupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String apiVersion = "2017-03-01-preview";
        context = this.client.mergeContext(context);
        return service
            .getByResourceGroup(
                this.client.getEndpoint(),
                resourceGroupName,
                locationName,
                longTermRetentionServerName,
                longTermRetentionDatabaseName,
                backupName,
                this.client.getSubscriptionId(),
                apiVersion,
                context);
    }

    /**
     * Gets a long term retention backup.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @param longTermRetentionDatabaseName The name of the database.
     * @param backupName The backup name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a long term retention backup.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<LongTermRetentionBackupInner> getByResourceGroupAsync(
        String resourceGroupName,
        String locationName,
        String longTermRetentionServerName,
        String longTermRetentionDatabaseName,
        String backupName) {
        return getByResourceGroupWithResponseAsync(
                resourceGroupName, locationName, longTermRetentionServerName, longTermRetentionDatabaseName, backupName)
            .flatMap(
                (Response<LongTermRetentionBackupInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Gets a long term retention backup.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @param longTermRetentionDatabaseName The name of the database.
     * @param backupName The backup name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a long term retention backup.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public LongTermRetentionBackupInner getByResourceGroup(
        String resourceGroupName,
        String locationName,
        String longTermRetentionServerName,
        String longTermRetentionDatabaseName,
        String backupName) {
        return getByResourceGroupAsync(
                resourceGroupName, locationName, longTermRetentionServerName, longTermRetentionDatabaseName, backupName)
            .block();
    }

    /**
     * Gets a long term retention backup.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @param longTermRetentionDatabaseName The name of the database.
     * @param backupName The backup name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a long term retention backup.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<LongTermRetentionBackupInner> getByResourceGroupWithResponse(
        String resourceGroupName,
        String locationName,
        String longTermRetentionServerName,
        String longTermRetentionDatabaseName,
        String backupName,
        Context context) {
        return getByResourceGroupWithResponseAsync(
                resourceGroupName,
                locationName,
                longTermRetentionServerName,
                longTermRetentionDatabaseName,
                backupName,
                context)
            .block();
    }

    /**
     * Deletes a long term retention backup.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @param longTermRetentionDatabaseName The name of the database.
     * @param backupName The backup name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> deleteByResourceGroupWithResponseAsync(
        String resourceGroupName,
        String locationName,
        String longTermRetentionServerName,
        String longTermRetentionDatabaseName,
        String backupName) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (locationName == null) {
            return Mono.error(new IllegalArgumentException("Parameter locationName is required and cannot be null."));
        }
        if (longTermRetentionServerName == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter longTermRetentionServerName is required and cannot be null."));
        }
        if (longTermRetentionDatabaseName == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter longTermRetentionDatabaseName is required and cannot be null."));
        }
        if (backupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter backupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String apiVersion = "2017-03-01-preview";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .deleteByResourceGroup(
                            this.client.getEndpoint(),
                            resourceGroupName,
                            locationName,
                            longTermRetentionServerName,
                            longTermRetentionDatabaseName,
                            backupName,
                            this.client.getSubscriptionId(),
                            apiVersion,
                            context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Deletes a long term retention backup.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @param longTermRetentionDatabaseName The name of the database.
     * @param backupName The backup name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteByResourceGroupWithResponseAsync(
        String resourceGroupName,
        String locationName,
        String longTermRetentionServerName,
        String longTermRetentionDatabaseName,
        String backupName,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (locationName == null) {
            return Mono.error(new IllegalArgumentException("Parameter locationName is required and cannot be null."));
        }
        if (longTermRetentionServerName == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter longTermRetentionServerName is required and cannot be null."));
        }
        if (longTermRetentionDatabaseName == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter longTermRetentionDatabaseName is required and cannot be null."));
        }
        if (backupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter backupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String apiVersion = "2017-03-01-preview";
        context = this.client.mergeContext(context);
        return service
            .deleteByResourceGroup(
                this.client.getEndpoint(),
                resourceGroupName,
                locationName,
                longTermRetentionServerName,
                longTermRetentionDatabaseName,
                backupName,
                this.client.getSubscriptionId(),
                apiVersion,
                context);
    }

    /**
     * Deletes a long term retention backup.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @param longTermRetentionDatabaseName The name of the database.
     * @param backupName The backup name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PollerFlux<PollResult<Void>, Void> beginDeleteByResourceGroupAsync(
        String resourceGroupName,
        String locationName,
        String longTermRetentionServerName,
        String longTermRetentionDatabaseName,
        String backupName) {
        Mono<Response<Flux<ByteBuffer>>> mono =
            deleteByResourceGroupWithResponseAsync(
                resourceGroupName,
                locationName,
                longTermRetentionServerName,
                longTermRetentionDatabaseName,
                backupName);
        return this
            .client
            .<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class, Context.NONE);
    }

    /**
     * Deletes a long term retention backup.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @param longTermRetentionDatabaseName The name of the database.
     * @param backupName The backup name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private PollerFlux<PollResult<Void>, Void> beginDeleteByResourceGroupAsync(
        String resourceGroupName,
        String locationName,
        String longTermRetentionServerName,
        String longTermRetentionDatabaseName,
        String backupName,
        Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono =
            deleteByResourceGroupWithResponseAsync(
                resourceGroupName,
                locationName,
                longTermRetentionServerName,
                longTermRetentionDatabaseName,
                backupName,
                context);
        return this
            .client
            .<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class, context);
    }

    /**
     * Deletes a long term retention backup.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @param longTermRetentionDatabaseName The name of the database.
     * @param backupName The backup name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SyncPoller<PollResult<Void>, Void> beginDeleteByResourceGroup(
        String resourceGroupName,
        String locationName,
        String longTermRetentionServerName,
        String longTermRetentionDatabaseName,
        String backupName) {
        return beginDeleteByResourceGroupAsync(
                resourceGroupName, locationName, longTermRetentionServerName, longTermRetentionDatabaseName, backupName)
            .getSyncPoller();
    }

    /**
     * Deletes a long term retention backup.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @param longTermRetentionDatabaseName The name of the database.
     * @param backupName The backup name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SyncPoller<PollResult<Void>, Void> beginDeleteByResourceGroup(
        String resourceGroupName,
        String locationName,
        String longTermRetentionServerName,
        String longTermRetentionDatabaseName,
        String backupName,
        Context context) {
        return beginDeleteByResourceGroupAsync(
                resourceGroupName,
                locationName,
                longTermRetentionServerName,
                longTermRetentionDatabaseName,
                backupName,
                context)
            .getSyncPoller();
    }

    /**
     * Deletes a long term retention backup.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @param longTermRetentionDatabaseName The name of the database.
     * @param backupName The backup name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteByResourceGroupAsync(
        String resourceGroupName,
        String locationName,
        String longTermRetentionServerName,
        String longTermRetentionDatabaseName,
        String backupName) {
        return beginDeleteByResourceGroupAsync(
                resourceGroupName, locationName, longTermRetentionServerName, longTermRetentionDatabaseName, backupName)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Deletes a long term retention backup.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @param longTermRetentionDatabaseName The name of the database.
     * @param backupName The backup name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Void> deleteByResourceGroupAsync(
        String resourceGroupName,
        String locationName,
        String longTermRetentionServerName,
        String longTermRetentionDatabaseName,
        String backupName,
        Context context) {
        return beginDeleteByResourceGroupAsync(
                resourceGroupName,
                locationName,
                longTermRetentionServerName,
                longTermRetentionDatabaseName,
                backupName,
                context)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Deletes a long term retention backup.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @param longTermRetentionDatabaseName The name of the database.
     * @param backupName The backup name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void deleteByResourceGroup(
        String resourceGroupName,
        String locationName,
        String longTermRetentionServerName,
        String longTermRetentionDatabaseName,
        String backupName) {
        deleteByResourceGroupAsync(
                resourceGroupName, locationName, longTermRetentionServerName, longTermRetentionDatabaseName, backupName)
            .block();
    }

    /**
     * Deletes a long term retention backup.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @param longTermRetentionDatabaseName The name of the database.
     * @param backupName The backup name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void deleteByResourceGroup(
        String resourceGroupName,
        String locationName,
        String longTermRetentionServerName,
        String longTermRetentionDatabaseName,
        String backupName,
        Context context) {
        deleteByResourceGroupAsync(
                resourceGroupName,
                locationName,
                longTermRetentionServerName,
                longTermRetentionDatabaseName,
                backupName,
                context)
            .block();
    }

    /**
     * Lists all long term retention backups for a database.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @param longTermRetentionDatabaseName The name of the database.
     * @param onlyLatestPerDatabase Whether or not to only get the latest backup for each database.
     * @param databaseState Whether to query against just live databases, just deleted databases, or all databases.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of long term retention backups.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<LongTermRetentionBackupInner>> listByResourceGroupDatabaseSinglePageAsync(
        String resourceGroupName,
        String locationName,
        String longTermRetentionServerName,
        String longTermRetentionDatabaseName,
        Boolean onlyLatestPerDatabase,
        LongTermRetentionDatabaseState databaseState) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (locationName == null) {
            return Mono.error(new IllegalArgumentException("Parameter locationName is required and cannot be null."));
        }
        if (longTermRetentionServerName == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter longTermRetentionServerName is required and cannot be null."));
        }
        if (longTermRetentionDatabaseName == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter longTermRetentionDatabaseName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String apiVersion = "2017-03-01-preview";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .listByResourceGroupDatabase(
                            this.client.getEndpoint(),
                            resourceGroupName,
                            locationName,
                            longTermRetentionServerName,
                            longTermRetentionDatabaseName,
                            onlyLatestPerDatabase,
                            databaseState,
                            this.client.getSubscriptionId(),
                            apiVersion,
                            context))
            .<PagedResponse<LongTermRetentionBackupInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Lists all long term retention backups for a database.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @param longTermRetentionDatabaseName The name of the database.
     * @param onlyLatestPerDatabase Whether or not to only get the latest backup for each database.
     * @param databaseState Whether to query against just live databases, just deleted databases, or all databases.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of long term retention backups.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<LongTermRetentionBackupInner>> listByResourceGroupDatabaseSinglePageAsync(
        String resourceGroupName,
        String locationName,
        String longTermRetentionServerName,
        String longTermRetentionDatabaseName,
        Boolean onlyLatestPerDatabase,
        LongTermRetentionDatabaseState databaseState,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (locationName == null) {
            return Mono.error(new IllegalArgumentException("Parameter locationName is required and cannot be null."));
        }
        if (longTermRetentionServerName == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter longTermRetentionServerName is required and cannot be null."));
        }
        if (longTermRetentionDatabaseName == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter longTermRetentionDatabaseName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String apiVersion = "2017-03-01-preview";
        context = this.client.mergeContext(context);
        return service
            .listByResourceGroupDatabase(
                this.client.getEndpoint(),
                resourceGroupName,
                locationName,
                longTermRetentionServerName,
                longTermRetentionDatabaseName,
                onlyLatestPerDatabase,
                databaseState,
                this.client.getSubscriptionId(),
                apiVersion,
                context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null));
    }

    /**
     * Lists all long term retention backups for a database.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @param longTermRetentionDatabaseName The name of the database.
     * @param onlyLatestPerDatabase Whether or not to only get the latest backup for each database.
     * @param databaseState Whether to query against just live databases, just deleted databases, or all databases.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of long term retention backups.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<LongTermRetentionBackupInner> listByResourceGroupDatabaseAsync(
        String resourceGroupName,
        String locationName,
        String longTermRetentionServerName,
        String longTermRetentionDatabaseName,
        Boolean onlyLatestPerDatabase,
        LongTermRetentionDatabaseState databaseState) {
        return new PagedFlux<>(
            () ->
                listByResourceGroupDatabaseSinglePageAsync(
                    resourceGroupName,
                    locationName,
                    longTermRetentionServerName,
                    longTermRetentionDatabaseName,
                    onlyLatestPerDatabase,
                    databaseState),
            nextLink -> listByResourceGroupDatabaseNextSinglePageAsync(nextLink));
    }

    /**
     * Lists all long term retention backups for a database.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @param longTermRetentionDatabaseName The name of the database.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of long term retention backups.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<LongTermRetentionBackupInner> listByResourceGroupDatabaseAsync(
        String resourceGroupName,
        String locationName,
        String longTermRetentionServerName,
        String longTermRetentionDatabaseName) {
        final Boolean onlyLatestPerDatabase = null;
        final LongTermRetentionDatabaseState databaseState = null;
        return new PagedFlux<>(
            () ->
                listByResourceGroupDatabaseSinglePageAsync(
                    resourceGroupName,
                    locationName,
                    longTermRetentionServerName,
                    longTermRetentionDatabaseName,
                    onlyLatestPerDatabase,
                    databaseState),
            nextLink -> listByResourceGroupDatabaseNextSinglePageAsync(nextLink));
    }

    /**
     * Lists all long term retention backups for a database.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @param longTermRetentionDatabaseName The name of the database.
     * @param onlyLatestPerDatabase Whether or not to only get the latest backup for each database.
     * @param databaseState Whether to query against just live databases, just deleted databases, or all databases.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of long term retention backups.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<LongTermRetentionBackupInner> listByResourceGroupDatabaseAsync(
        String resourceGroupName,
        String locationName,
        String longTermRetentionServerName,
        String longTermRetentionDatabaseName,
        Boolean onlyLatestPerDatabase,
        LongTermRetentionDatabaseState databaseState,
        Context context) {
        return new PagedFlux<>(
            () ->
                listByResourceGroupDatabaseSinglePageAsync(
                    resourceGroupName,
                    locationName,
                    longTermRetentionServerName,
                    longTermRetentionDatabaseName,
                    onlyLatestPerDatabase,
                    databaseState,
                    context),
            nextLink -> listByResourceGroupDatabaseNextSinglePageAsync(nextLink, context));
    }

    /**
     * Lists all long term retention backups for a database.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @param longTermRetentionDatabaseName The name of the database.
     * @param onlyLatestPerDatabase Whether or not to only get the latest backup for each database.
     * @param databaseState Whether to query against just live databases, just deleted databases, or all databases.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of long term retention backups.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<LongTermRetentionBackupInner> listByResourceGroupDatabase(
        String resourceGroupName,
        String locationName,
        String longTermRetentionServerName,
        String longTermRetentionDatabaseName,
        Boolean onlyLatestPerDatabase,
        LongTermRetentionDatabaseState databaseState,
        Context context) {
        return new PagedIterable<>(
            listByResourceGroupDatabaseAsync(
                resourceGroupName,
                locationName,
                longTermRetentionServerName,
                longTermRetentionDatabaseName,
                onlyLatestPerDatabase,
                databaseState,
                context));
    }

    /**
     * Lists all long term retention backups for a database.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @param longTermRetentionDatabaseName The name of the database.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of long term retention backups.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<LongTermRetentionBackupInner> listByResourceGroupDatabase(
        String resourceGroupName,
        String locationName,
        String longTermRetentionServerName,
        String longTermRetentionDatabaseName) {
        final Boolean onlyLatestPerDatabase = null;
        final LongTermRetentionDatabaseState databaseState = null;
        return new PagedIterable<>(
            listByResourceGroupDatabaseAsync(
                resourceGroupName,
                locationName,
                longTermRetentionServerName,
                longTermRetentionDatabaseName,
                onlyLatestPerDatabase,
                databaseState));
    }

    /**
     * Lists the long term retention backups for a given location.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param locationName The location of the database.
     * @param onlyLatestPerDatabase Whether or not to only get the latest backup for each database.
     * @param databaseState Whether to query against just live databases, just deleted databases, or all databases.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of long term retention backups.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<LongTermRetentionBackupInner>> listByResourceGroupLocationSinglePageAsync(
        String resourceGroupName,
        String locationName,
        Boolean onlyLatestPerDatabase,
        LongTermRetentionDatabaseState databaseState) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (locationName == null) {
            return Mono.error(new IllegalArgumentException("Parameter locationName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String apiVersion = "2017-03-01-preview";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .listByResourceGroupLocation(
                            this.client.getEndpoint(),
                            resourceGroupName,
                            locationName,
                            onlyLatestPerDatabase,
                            databaseState,
                            this.client.getSubscriptionId(),
                            apiVersion,
                            context))
            .<PagedResponse<LongTermRetentionBackupInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Lists the long term retention backups for a given location.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param locationName The location of the database.
     * @param onlyLatestPerDatabase Whether or not to only get the latest backup for each database.
     * @param databaseState Whether to query against just live databases, just deleted databases, or all databases.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of long term retention backups.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<LongTermRetentionBackupInner>> listByResourceGroupLocationSinglePageAsync(
        String resourceGroupName,
        String locationName,
        Boolean onlyLatestPerDatabase,
        LongTermRetentionDatabaseState databaseState,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (locationName == null) {
            return Mono.error(new IllegalArgumentException("Parameter locationName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String apiVersion = "2017-03-01-preview";
        context = this.client.mergeContext(context);
        return service
            .listByResourceGroupLocation(
                this.client.getEndpoint(),
                resourceGroupName,
                locationName,
                onlyLatestPerDatabase,
                databaseState,
                this.client.getSubscriptionId(),
                apiVersion,
                context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null));
    }

    /**
     * Lists the long term retention backups for a given location.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param locationName The location of the database.
     * @param onlyLatestPerDatabase Whether or not to only get the latest backup for each database.
     * @param databaseState Whether to query against just live databases, just deleted databases, or all databases.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of long term retention backups.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<LongTermRetentionBackupInner> listByResourceGroupLocationAsync(
        String resourceGroupName,
        String locationName,
        Boolean onlyLatestPerDatabase,
        LongTermRetentionDatabaseState databaseState) {
        return new PagedFlux<>(
            () ->
                listByResourceGroupLocationSinglePageAsync(
                    resourceGroupName, locationName, onlyLatestPerDatabase, databaseState),
            nextLink -> listByResourceGroupLocationNextSinglePageAsync(nextLink));
    }

    /**
     * Lists the long term retention backups for a given location.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param locationName The location of the database.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of long term retention backups.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<LongTermRetentionBackupInner> listByResourceGroupLocationAsync(
        String resourceGroupName, String locationName) {
        final Boolean onlyLatestPerDatabase = null;
        final LongTermRetentionDatabaseState databaseState = null;
        return new PagedFlux<>(
            () ->
                listByResourceGroupLocationSinglePageAsync(
                    resourceGroupName, locationName, onlyLatestPerDatabase, databaseState),
            nextLink -> listByResourceGroupLocationNextSinglePageAsync(nextLink));
    }

    /**
     * Lists the long term retention backups for a given location.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param locationName The location of the database.
     * @param onlyLatestPerDatabase Whether or not to only get the latest backup for each database.
     * @param databaseState Whether to query against just live databases, just deleted databases, or all databases.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of long term retention backups.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<LongTermRetentionBackupInner> listByResourceGroupLocationAsync(
        String resourceGroupName,
        String locationName,
        Boolean onlyLatestPerDatabase,
        LongTermRetentionDatabaseState databaseState,
        Context context) {
        return new PagedFlux<>(
            () ->
                listByResourceGroupLocationSinglePageAsync(
                    resourceGroupName, locationName, onlyLatestPerDatabase, databaseState, context),
            nextLink -> listByResourceGroupLocationNextSinglePageAsync(nextLink, context));
    }

    /**
     * Lists the long term retention backups for a given location.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param locationName The location of the database.
     * @param onlyLatestPerDatabase Whether or not to only get the latest backup for each database.
     * @param databaseState Whether to query against just live databases, just deleted databases, or all databases.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of long term retention backups.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<LongTermRetentionBackupInner> listByResourceGroupLocation(
        String resourceGroupName,
        String locationName,
        Boolean onlyLatestPerDatabase,
        LongTermRetentionDatabaseState databaseState,
        Context context) {
        return new PagedIterable<>(
            listByResourceGroupLocationAsync(
                resourceGroupName, locationName, onlyLatestPerDatabase, databaseState, context));
    }

    /**
     * Lists the long term retention backups for a given location.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param locationName The location of the database.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of long term retention backups.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<LongTermRetentionBackupInner> listByResourceGroupLocation(
        String resourceGroupName, String locationName) {
        final Boolean onlyLatestPerDatabase = null;
        final LongTermRetentionDatabaseState databaseState = null;
        return new PagedIterable<>(
            listByResourceGroupLocationAsync(resourceGroupName, locationName, onlyLatestPerDatabase, databaseState));
    }

    /**
     * Lists the long term retention backups for a given server.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @param onlyLatestPerDatabase Whether or not to only get the latest backup for each database.
     * @param databaseState Whether to query against just live databases, just deleted databases, or all databases.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of long term retention backups.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<LongTermRetentionBackupInner>> listByResourceGroupServerSinglePageAsync(
        String resourceGroupName,
        String locationName,
        String longTermRetentionServerName,
        Boolean onlyLatestPerDatabase,
        LongTermRetentionDatabaseState databaseState) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (locationName == null) {
            return Mono.error(new IllegalArgumentException("Parameter locationName is required and cannot be null."));
        }
        if (longTermRetentionServerName == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter longTermRetentionServerName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String apiVersion = "2017-03-01-preview";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .listByResourceGroupServer(
                            this.client.getEndpoint(),
                            resourceGroupName,
                            locationName,
                            longTermRetentionServerName,
                            onlyLatestPerDatabase,
                            databaseState,
                            this.client.getSubscriptionId(),
                            apiVersion,
                            context))
            .<PagedResponse<LongTermRetentionBackupInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Lists the long term retention backups for a given server.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @param onlyLatestPerDatabase Whether or not to only get the latest backup for each database.
     * @param databaseState Whether to query against just live databases, just deleted databases, or all databases.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of long term retention backups.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<LongTermRetentionBackupInner>> listByResourceGroupServerSinglePageAsync(
        String resourceGroupName,
        String locationName,
        String longTermRetentionServerName,
        Boolean onlyLatestPerDatabase,
        LongTermRetentionDatabaseState databaseState,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (locationName == null) {
            return Mono.error(new IllegalArgumentException("Parameter locationName is required and cannot be null."));
        }
        if (longTermRetentionServerName == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter longTermRetentionServerName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String apiVersion = "2017-03-01-preview";
        context = this.client.mergeContext(context);
        return service
            .listByResourceGroupServer(
                this.client.getEndpoint(),
                resourceGroupName,
                locationName,
                longTermRetentionServerName,
                onlyLatestPerDatabase,
                databaseState,
                this.client.getSubscriptionId(),
                apiVersion,
                context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null));
    }

    /**
     * Lists the long term retention backups for a given server.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @param onlyLatestPerDatabase Whether or not to only get the latest backup for each database.
     * @param databaseState Whether to query against just live databases, just deleted databases, or all databases.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of long term retention backups.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<LongTermRetentionBackupInner> listByResourceGroupServerAsync(
        String resourceGroupName,
        String locationName,
        String longTermRetentionServerName,
        Boolean onlyLatestPerDatabase,
        LongTermRetentionDatabaseState databaseState) {
        return new PagedFlux<>(
            () ->
                listByResourceGroupServerSinglePageAsync(
                    resourceGroupName, locationName, longTermRetentionServerName, onlyLatestPerDatabase, databaseState),
            nextLink -> listByResourceGroupServerNextSinglePageAsync(nextLink));
    }

    /**
     * Lists the long term retention backups for a given server.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of long term retention backups.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<LongTermRetentionBackupInner> listByResourceGroupServerAsync(
        String resourceGroupName, String locationName, String longTermRetentionServerName) {
        final Boolean onlyLatestPerDatabase = null;
        final LongTermRetentionDatabaseState databaseState = null;
        return new PagedFlux<>(
            () ->
                listByResourceGroupServerSinglePageAsync(
                    resourceGroupName, locationName, longTermRetentionServerName, onlyLatestPerDatabase, databaseState),
            nextLink -> listByResourceGroupServerNextSinglePageAsync(nextLink));
    }

    /**
     * Lists the long term retention backups for a given server.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @param onlyLatestPerDatabase Whether or not to only get the latest backup for each database.
     * @param databaseState Whether to query against just live databases, just deleted databases, or all databases.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of long term retention backups.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<LongTermRetentionBackupInner> listByResourceGroupServerAsync(
        String resourceGroupName,
        String locationName,
        String longTermRetentionServerName,
        Boolean onlyLatestPerDatabase,
        LongTermRetentionDatabaseState databaseState,
        Context context) {
        return new PagedFlux<>(
            () ->
                listByResourceGroupServerSinglePageAsync(
                    resourceGroupName,
                    locationName,
                    longTermRetentionServerName,
                    onlyLatestPerDatabase,
                    databaseState,
                    context),
            nextLink -> listByResourceGroupServerNextSinglePageAsync(nextLink, context));
    }

    /**
     * Lists the long term retention backups for a given server.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @param onlyLatestPerDatabase Whether or not to only get the latest backup for each database.
     * @param databaseState Whether to query against just live databases, just deleted databases, or all databases.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of long term retention backups.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<LongTermRetentionBackupInner> listByResourceGroupServer(
        String resourceGroupName,
        String locationName,
        String longTermRetentionServerName,
        Boolean onlyLatestPerDatabase,
        LongTermRetentionDatabaseState databaseState,
        Context context) {
        return new PagedIterable<>(
            listByResourceGroupServerAsync(
                resourceGroupName,
                locationName,
                longTermRetentionServerName,
                onlyLatestPerDatabase,
                databaseState,
                context));
    }

    /**
     * Lists the long term retention backups for a given server.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of long term retention backups.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<LongTermRetentionBackupInner> listByResourceGroupServer(
        String resourceGroupName, String locationName, String longTermRetentionServerName) {
        final Boolean onlyLatestPerDatabase = null;
        final LongTermRetentionDatabaseState databaseState = null;
        return new PagedIterable<>(
            listByResourceGroupServerAsync(
                resourceGroupName, locationName, longTermRetentionServerName, onlyLatestPerDatabase, databaseState));
    }

    /**
     * Gets a long term retention backup.
     *
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @param longTermRetentionDatabaseName The name of the database.
     * @param backupName The backup name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a long term retention backup.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<LongTermRetentionBackupInner>> getWithResponseAsync(
        String locationName,
        String longTermRetentionServerName,
        String longTermRetentionDatabaseName,
        String backupName) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (locationName == null) {
            return Mono.error(new IllegalArgumentException("Parameter locationName is required and cannot be null."));
        }
        if (longTermRetentionServerName == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter longTermRetentionServerName is required and cannot be null."));
        }
        if (longTermRetentionDatabaseName == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter longTermRetentionDatabaseName is required and cannot be null."));
        }
        if (backupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter backupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String apiVersion = "2017-03-01-preview";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .get(
                            this.client.getEndpoint(),
                            locationName,
                            longTermRetentionServerName,
                            longTermRetentionDatabaseName,
                            backupName,
                            this.client.getSubscriptionId(),
                            apiVersion,
                            context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Gets a long term retention backup.
     *
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @param longTermRetentionDatabaseName The name of the database.
     * @param backupName The backup name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a long term retention backup.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<LongTermRetentionBackupInner>> getWithResponseAsync(
        String locationName,
        String longTermRetentionServerName,
        String longTermRetentionDatabaseName,
        String backupName,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (locationName == null) {
            return Mono.error(new IllegalArgumentException("Parameter locationName is required and cannot be null."));
        }
        if (longTermRetentionServerName == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter longTermRetentionServerName is required and cannot be null."));
        }
        if (longTermRetentionDatabaseName == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter longTermRetentionDatabaseName is required and cannot be null."));
        }
        if (backupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter backupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String apiVersion = "2017-03-01-preview";
        context = this.client.mergeContext(context);
        return service
            .get(
                this.client.getEndpoint(),
                locationName,
                longTermRetentionServerName,
                longTermRetentionDatabaseName,
                backupName,
                this.client.getSubscriptionId(),
                apiVersion,
                context);
    }

    /**
     * Gets a long term retention backup.
     *
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @param longTermRetentionDatabaseName The name of the database.
     * @param backupName The backup name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a long term retention backup.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<LongTermRetentionBackupInner> getAsync(
        String locationName,
        String longTermRetentionServerName,
        String longTermRetentionDatabaseName,
        String backupName) {
        return getWithResponseAsync(
                locationName, longTermRetentionServerName, longTermRetentionDatabaseName, backupName)
            .flatMap(
                (Response<LongTermRetentionBackupInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Gets a long term retention backup.
     *
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @param longTermRetentionDatabaseName The name of the database.
     * @param backupName The backup name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a long term retention backup.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public LongTermRetentionBackupInner get(
        String locationName,
        String longTermRetentionServerName,
        String longTermRetentionDatabaseName,
        String backupName) {
        return getAsync(locationName, longTermRetentionServerName, longTermRetentionDatabaseName, backupName).block();
    }

    /**
     * Gets a long term retention backup.
     *
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @param longTermRetentionDatabaseName The name of the database.
     * @param backupName The backup name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a long term retention backup.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<LongTermRetentionBackupInner> getWithResponse(
        String locationName,
        String longTermRetentionServerName,
        String longTermRetentionDatabaseName,
        String backupName,
        Context context) {
        return getWithResponseAsync(
                locationName, longTermRetentionServerName, longTermRetentionDatabaseName, backupName, context)
            .block();
    }

    /**
     * Deletes a long term retention backup.
     *
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @param longTermRetentionDatabaseName The name of the database.
     * @param backupName The backup name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(
        String locationName,
        String longTermRetentionServerName,
        String longTermRetentionDatabaseName,
        String backupName) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (locationName == null) {
            return Mono.error(new IllegalArgumentException("Parameter locationName is required and cannot be null."));
        }
        if (longTermRetentionServerName == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter longTermRetentionServerName is required and cannot be null."));
        }
        if (longTermRetentionDatabaseName == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter longTermRetentionDatabaseName is required and cannot be null."));
        }
        if (backupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter backupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String apiVersion = "2017-03-01-preview";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .delete(
                            this.client.getEndpoint(),
                            locationName,
                            longTermRetentionServerName,
                            longTermRetentionDatabaseName,
                            backupName,
                            this.client.getSubscriptionId(),
                            apiVersion,
                            context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Deletes a long term retention backup.
     *
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @param longTermRetentionDatabaseName The name of the database.
     * @param backupName The backup name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(
        String locationName,
        String longTermRetentionServerName,
        String longTermRetentionDatabaseName,
        String backupName,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (locationName == null) {
            return Mono.error(new IllegalArgumentException("Parameter locationName is required and cannot be null."));
        }
        if (longTermRetentionServerName == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter longTermRetentionServerName is required and cannot be null."));
        }
        if (longTermRetentionDatabaseName == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter longTermRetentionDatabaseName is required and cannot be null."));
        }
        if (backupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter backupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String apiVersion = "2017-03-01-preview";
        context = this.client.mergeContext(context);
        return service
            .delete(
                this.client.getEndpoint(),
                locationName,
                longTermRetentionServerName,
                longTermRetentionDatabaseName,
                backupName,
                this.client.getSubscriptionId(),
                apiVersion,
                context);
    }

    /**
     * Deletes a long term retention backup.
     *
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @param longTermRetentionDatabaseName The name of the database.
     * @param backupName The backup name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PollerFlux<PollResult<Void>, Void> beginDeleteAsync(
        String locationName,
        String longTermRetentionServerName,
        String longTermRetentionDatabaseName,
        String backupName) {
        Mono<Response<Flux<ByteBuffer>>> mono =
            deleteWithResponseAsync(
                locationName, longTermRetentionServerName, longTermRetentionDatabaseName, backupName);
        return this
            .client
            .<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class, Context.NONE);
    }

    /**
     * Deletes a long term retention backup.
     *
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @param longTermRetentionDatabaseName The name of the database.
     * @param backupName The backup name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(
        String locationName,
        String longTermRetentionServerName,
        String longTermRetentionDatabaseName,
        String backupName,
        Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono =
            deleteWithResponseAsync(
                locationName, longTermRetentionServerName, longTermRetentionDatabaseName, backupName, context);
        return this
            .client
            .<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class, context);
    }

    /**
     * Deletes a long term retention backup.
     *
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @param longTermRetentionDatabaseName The name of the database.
     * @param backupName The backup name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SyncPoller<PollResult<Void>, Void> beginDelete(
        String locationName,
        String longTermRetentionServerName,
        String longTermRetentionDatabaseName,
        String backupName) {
        return beginDeleteAsync(locationName, longTermRetentionServerName, longTermRetentionDatabaseName, backupName)
            .getSyncPoller();
    }

    /**
     * Deletes a long term retention backup.
     *
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @param longTermRetentionDatabaseName The name of the database.
     * @param backupName The backup name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SyncPoller<PollResult<Void>, Void> beginDelete(
        String locationName,
        String longTermRetentionServerName,
        String longTermRetentionDatabaseName,
        String backupName,
        Context context) {
        return beginDeleteAsync(
                locationName, longTermRetentionServerName, longTermRetentionDatabaseName, backupName, context)
            .getSyncPoller();
    }

    /**
     * Deletes a long term retention backup.
     *
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @param longTermRetentionDatabaseName The name of the database.
     * @param backupName The backup name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteAsync(
        String locationName,
        String longTermRetentionServerName,
        String longTermRetentionDatabaseName,
        String backupName) {
        return beginDeleteAsync(locationName, longTermRetentionServerName, longTermRetentionDatabaseName, backupName)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Deletes a long term retention backup.
     *
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @param longTermRetentionDatabaseName The name of the database.
     * @param backupName The backup name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Void> deleteAsync(
        String locationName,
        String longTermRetentionServerName,
        String longTermRetentionDatabaseName,
        String backupName,
        Context context) {
        return beginDeleteAsync(
                locationName, longTermRetentionServerName, longTermRetentionDatabaseName, backupName, context)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Deletes a long term retention backup.
     *
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @param longTermRetentionDatabaseName The name of the database.
     * @param backupName The backup name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void delete(
        String locationName,
        String longTermRetentionServerName,
        String longTermRetentionDatabaseName,
        String backupName) {
        deleteAsync(locationName, longTermRetentionServerName, longTermRetentionDatabaseName, backupName).block();
    }

    /**
     * Deletes a long term retention backup.
     *
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @param longTermRetentionDatabaseName The name of the database.
     * @param backupName The backup name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void delete(
        String locationName,
        String longTermRetentionServerName,
        String longTermRetentionDatabaseName,
        String backupName,
        Context context) {
        deleteAsync(locationName, longTermRetentionServerName, longTermRetentionDatabaseName, backupName, context)
            .block();
    }

    /**
     * Lists all long term retention backups for a database.
     *
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @param longTermRetentionDatabaseName The name of the database.
     * @param onlyLatestPerDatabase Whether or not to only get the latest backup for each database.
     * @param databaseState Whether to query against just live databases, just deleted databases, or all databases.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of long term retention backups.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<LongTermRetentionBackupInner>> listByDatabaseSinglePageAsync(
        String locationName,
        String longTermRetentionServerName,
        String longTermRetentionDatabaseName,
        Boolean onlyLatestPerDatabase,
        LongTermRetentionDatabaseState databaseState) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (locationName == null) {
            return Mono.error(new IllegalArgumentException("Parameter locationName is required and cannot be null."));
        }
        if (longTermRetentionServerName == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter longTermRetentionServerName is required and cannot be null."));
        }
        if (longTermRetentionDatabaseName == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter longTermRetentionDatabaseName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String apiVersion = "2017-03-01-preview";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .listByDatabase(
                            this.client.getEndpoint(),
                            locationName,
                            longTermRetentionServerName,
                            longTermRetentionDatabaseName,
                            onlyLatestPerDatabase,
                            databaseState,
                            this.client.getSubscriptionId(),
                            apiVersion,
                            context))
            .<PagedResponse<LongTermRetentionBackupInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Lists all long term retention backups for a database.
     *
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @param longTermRetentionDatabaseName The name of the database.
     * @param onlyLatestPerDatabase Whether or not to only get the latest backup for each database.
     * @param databaseState Whether to query against just live databases, just deleted databases, or all databases.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of long term retention backups.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<LongTermRetentionBackupInner>> listByDatabaseSinglePageAsync(
        String locationName,
        String longTermRetentionServerName,
        String longTermRetentionDatabaseName,
        Boolean onlyLatestPerDatabase,
        LongTermRetentionDatabaseState databaseState,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (locationName == null) {
            return Mono.error(new IllegalArgumentException("Parameter locationName is required and cannot be null."));
        }
        if (longTermRetentionServerName == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter longTermRetentionServerName is required and cannot be null."));
        }
        if (longTermRetentionDatabaseName == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter longTermRetentionDatabaseName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String apiVersion = "2017-03-01-preview";
        context = this.client.mergeContext(context);
        return service
            .listByDatabase(
                this.client.getEndpoint(),
                locationName,
                longTermRetentionServerName,
                longTermRetentionDatabaseName,
                onlyLatestPerDatabase,
                databaseState,
                this.client.getSubscriptionId(),
                apiVersion,
                context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null));
    }

    /**
     * Lists all long term retention backups for a database.
     *
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @param longTermRetentionDatabaseName The name of the database.
     * @param onlyLatestPerDatabase Whether or not to only get the latest backup for each database.
     * @param databaseState Whether to query against just live databases, just deleted databases, or all databases.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of long term retention backups.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<LongTermRetentionBackupInner> listByDatabaseAsync(
        String locationName,
        String longTermRetentionServerName,
        String longTermRetentionDatabaseName,
        Boolean onlyLatestPerDatabase,
        LongTermRetentionDatabaseState databaseState) {
        return new PagedFlux<>(
            () ->
                listByDatabaseSinglePageAsync(
                    locationName,
                    longTermRetentionServerName,
                    longTermRetentionDatabaseName,
                    onlyLatestPerDatabase,
                    databaseState),
            nextLink -> listByDatabaseNextSinglePageAsync(nextLink));
    }

    /**
     * Lists all long term retention backups for a database.
     *
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @param longTermRetentionDatabaseName The name of the database.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of long term retention backups.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<LongTermRetentionBackupInner> listByDatabaseAsync(
        String locationName, String longTermRetentionServerName, String longTermRetentionDatabaseName) {
        final Boolean onlyLatestPerDatabase = null;
        final LongTermRetentionDatabaseState databaseState = null;
        return new PagedFlux<>(
            () ->
                listByDatabaseSinglePageAsync(
                    locationName,
                    longTermRetentionServerName,
                    longTermRetentionDatabaseName,
                    onlyLatestPerDatabase,
                    databaseState),
            nextLink -> listByDatabaseNextSinglePageAsync(nextLink));
    }

    /**
     * Lists all long term retention backups for a database.
     *
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @param longTermRetentionDatabaseName The name of the database.
     * @param onlyLatestPerDatabase Whether or not to only get the latest backup for each database.
     * @param databaseState Whether to query against just live databases, just deleted databases, or all databases.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of long term retention backups.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<LongTermRetentionBackupInner> listByDatabaseAsync(
        String locationName,
        String longTermRetentionServerName,
        String longTermRetentionDatabaseName,
        Boolean onlyLatestPerDatabase,
        LongTermRetentionDatabaseState databaseState,
        Context context) {
        return new PagedFlux<>(
            () ->
                listByDatabaseSinglePageAsync(
                    locationName,
                    longTermRetentionServerName,
                    longTermRetentionDatabaseName,
                    onlyLatestPerDatabase,
                    databaseState,
                    context),
            nextLink -> listByDatabaseNextSinglePageAsync(nextLink, context));
    }

    /**
     * Lists all long term retention backups for a database.
     *
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @param longTermRetentionDatabaseName The name of the database.
     * @param onlyLatestPerDatabase Whether or not to only get the latest backup for each database.
     * @param databaseState Whether to query against just live databases, just deleted databases, or all databases.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of long term retention backups.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<LongTermRetentionBackupInner> listByDatabase(
        String locationName,
        String longTermRetentionServerName,
        String longTermRetentionDatabaseName,
        Boolean onlyLatestPerDatabase,
        LongTermRetentionDatabaseState databaseState,
        Context context) {
        return new PagedIterable<>(
            listByDatabaseAsync(
                locationName,
                longTermRetentionServerName,
                longTermRetentionDatabaseName,
                onlyLatestPerDatabase,
                databaseState,
                context));
    }

    /**
     * Lists all long term retention backups for a database.
     *
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @param longTermRetentionDatabaseName The name of the database.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of long term retention backups.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<LongTermRetentionBackupInner> listByDatabase(
        String locationName, String longTermRetentionServerName, String longTermRetentionDatabaseName) {
        final Boolean onlyLatestPerDatabase = null;
        final LongTermRetentionDatabaseState databaseState = null;
        return new PagedIterable<>(
            listByDatabaseAsync(
                locationName,
                longTermRetentionServerName,
                longTermRetentionDatabaseName,
                onlyLatestPerDatabase,
                databaseState));
    }

    /**
     * Lists the long term retention backups for a given location.
     *
     * @param locationName The location of the database.
     * @param onlyLatestPerDatabase Whether or not to only get the latest backup for each database.
     * @param databaseState Whether to query against just live databases, just deleted databases, or all databases.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of long term retention backups.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<LongTermRetentionBackupInner>> listByLocationSinglePageAsync(
        String locationName, Boolean onlyLatestPerDatabase, LongTermRetentionDatabaseState databaseState) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (locationName == null) {
            return Mono.error(new IllegalArgumentException("Parameter locationName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String apiVersion = "2017-03-01-preview";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .listByLocation(
                            this.client.getEndpoint(),
                            locationName,
                            onlyLatestPerDatabase,
                            databaseState,
                            this.client.getSubscriptionId(),
                            apiVersion,
                            context))
            .<PagedResponse<LongTermRetentionBackupInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Lists the long term retention backups for a given location.
     *
     * @param locationName The location of the database.
     * @param onlyLatestPerDatabase Whether or not to only get the latest backup for each database.
     * @param databaseState Whether to query against just live databases, just deleted databases, or all databases.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of long term retention backups.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<LongTermRetentionBackupInner>> listByLocationSinglePageAsync(
        String locationName,
        Boolean onlyLatestPerDatabase,
        LongTermRetentionDatabaseState databaseState,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (locationName == null) {
            return Mono.error(new IllegalArgumentException("Parameter locationName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String apiVersion = "2017-03-01-preview";
        context = this.client.mergeContext(context);
        return service
            .listByLocation(
                this.client.getEndpoint(),
                locationName,
                onlyLatestPerDatabase,
                databaseState,
                this.client.getSubscriptionId(),
                apiVersion,
                context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null));
    }

    /**
     * Lists the long term retention backups for a given location.
     *
     * @param locationName The location of the database.
     * @param onlyLatestPerDatabase Whether or not to only get the latest backup for each database.
     * @param databaseState Whether to query against just live databases, just deleted databases, or all databases.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of long term retention backups.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<LongTermRetentionBackupInner> listByLocationAsync(
        String locationName, Boolean onlyLatestPerDatabase, LongTermRetentionDatabaseState databaseState) {
        return new PagedFlux<>(
            () -> listByLocationSinglePageAsync(locationName, onlyLatestPerDatabase, databaseState),
            nextLink -> listByLocationNextSinglePageAsync(nextLink));
    }

    /**
     * Lists the long term retention backups for a given location.
     *
     * @param locationName The location of the database.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of long term retention backups.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<LongTermRetentionBackupInner> listByLocationAsync(String locationName) {
        final Boolean onlyLatestPerDatabase = null;
        final LongTermRetentionDatabaseState databaseState = null;
        return new PagedFlux<>(
            () -> listByLocationSinglePageAsync(locationName, onlyLatestPerDatabase, databaseState),
            nextLink -> listByLocationNextSinglePageAsync(nextLink));
    }

    /**
     * Lists the long term retention backups for a given location.
     *
     * @param locationName The location of the database.
     * @param onlyLatestPerDatabase Whether or not to only get the latest backup for each database.
     * @param databaseState Whether to query against just live databases, just deleted databases, or all databases.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of long term retention backups.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<LongTermRetentionBackupInner> listByLocationAsync(
        String locationName,
        Boolean onlyLatestPerDatabase,
        LongTermRetentionDatabaseState databaseState,
        Context context) {
        return new PagedFlux<>(
            () -> listByLocationSinglePageAsync(locationName, onlyLatestPerDatabase, databaseState, context),
            nextLink -> listByLocationNextSinglePageAsync(nextLink, context));
    }

    /**
     * Lists the long term retention backups for a given location.
     *
     * @param locationName The location of the database.
     * @param onlyLatestPerDatabase Whether or not to only get the latest backup for each database.
     * @param databaseState Whether to query against just live databases, just deleted databases, or all databases.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of long term retention backups.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<LongTermRetentionBackupInner> listByLocation(
        String locationName,
        Boolean onlyLatestPerDatabase,
        LongTermRetentionDatabaseState databaseState,
        Context context) {
        return new PagedIterable<>(listByLocationAsync(locationName, onlyLatestPerDatabase, databaseState, context));
    }

    /**
     * Lists the long term retention backups for a given location.
     *
     * @param locationName The location of the database.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of long term retention backups.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<LongTermRetentionBackupInner> listByLocation(String locationName) {
        final Boolean onlyLatestPerDatabase = null;
        final LongTermRetentionDatabaseState databaseState = null;
        return new PagedIterable<>(listByLocationAsync(locationName, onlyLatestPerDatabase, databaseState));
    }

    /**
     * Lists the long term retention backups for a given server.
     *
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @param onlyLatestPerDatabase Whether or not to only get the latest backup for each database.
     * @param databaseState Whether to query against just live databases, just deleted databases, or all databases.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of long term retention backups.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<LongTermRetentionBackupInner>> listByServerSinglePageAsync(
        String locationName,
        String longTermRetentionServerName,
        Boolean onlyLatestPerDatabase,
        LongTermRetentionDatabaseState databaseState) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (locationName == null) {
            return Mono.error(new IllegalArgumentException("Parameter locationName is required and cannot be null."));
        }
        if (longTermRetentionServerName == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter longTermRetentionServerName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String apiVersion = "2017-03-01-preview";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .listByServer(
                            this.client.getEndpoint(),
                            locationName,
                            longTermRetentionServerName,
                            onlyLatestPerDatabase,
                            databaseState,
                            this.client.getSubscriptionId(),
                            apiVersion,
                            context))
            .<PagedResponse<LongTermRetentionBackupInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Lists the long term retention backups for a given server.
     *
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @param onlyLatestPerDatabase Whether or not to only get the latest backup for each database.
     * @param databaseState Whether to query against just live databases, just deleted databases, or all databases.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of long term retention backups.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<LongTermRetentionBackupInner>> listByServerSinglePageAsync(
        String locationName,
        String longTermRetentionServerName,
        Boolean onlyLatestPerDatabase,
        LongTermRetentionDatabaseState databaseState,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (locationName == null) {
            return Mono.error(new IllegalArgumentException("Parameter locationName is required and cannot be null."));
        }
        if (longTermRetentionServerName == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter longTermRetentionServerName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String apiVersion = "2017-03-01-preview";
        context = this.client.mergeContext(context);
        return service
            .listByServer(
                this.client.getEndpoint(),
                locationName,
                longTermRetentionServerName,
                onlyLatestPerDatabase,
                databaseState,
                this.client.getSubscriptionId(),
                apiVersion,
                context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null));
    }

    /**
     * Lists the long term retention backups for a given server.
     *
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @param onlyLatestPerDatabase Whether or not to only get the latest backup for each database.
     * @param databaseState Whether to query against just live databases, just deleted databases, or all databases.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of long term retention backups.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<LongTermRetentionBackupInner> listByServerAsync(
        String locationName,
        String longTermRetentionServerName,
        Boolean onlyLatestPerDatabase,
        LongTermRetentionDatabaseState databaseState) {
        return new PagedFlux<>(
            () ->
                listByServerSinglePageAsync(
                    locationName, longTermRetentionServerName, onlyLatestPerDatabase, databaseState),
            nextLink -> listByServerNextSinglePageAsync(nextLink));
    }

    /**
     * Lists the long term retention backups for a given server.
     *
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of long term retention backups.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<LongTermRetentionBackupInner> listByServerAsync(
        String locationName, String longTermRetentionServerName) {
        final Boolean onlyLatestPerDatabase = null;
        final LongTermRetentionDatabaseState databaseState = null;
        return new PagedFlux<>(
            () ->
                listByServerSinglePageAsync(
                    locationName, longTermRetentionServerName, onlyLatestPerDatabase, databaseState),
            nextLink -> listByServerNextSinglePageAsync(nextLink));
    }

    /**
     * Lists the long term retention backups for a given server.
     *
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @param onlyLatestPerDatabase Whether or not to only get the latest backup for each database.
     * @param databaseState Whether to query against just live databases, just deleted databases, or all databases.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of long term retention backups.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<LongTermRetentionBackupInner> listByServerAsync(
        String locationName,
        String longTermRetentionServerName,
        Boolean onlyLatestPerDatabase,
        LongTermRetentionDatabaseState databaseState,
        Context context) {
        return new PagedFlux<>(
            () ->
                listByServerSinglePageAsync(
                    locationName, longTermRetentionServerName, onlyLatestPerDatabase, databaseState, context),
            nextLink -> listByServerNextSinglePageAsync(nextLink, context));
    }

    /**
     * Lists the long term retention backups for a given server.
     *
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @param onlyLatestPerDatabase Whether or not to only get the latest backup for each database.
     * @param databaseState Whether to query against just live databases, just deleted databases, or all databases.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of long term retention backups.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<LongTermRetentionBackupInner> listByServer(
        String locationName,
        String longTermRetentionServerName,
        Boolean onlyLatestPerDatabase,
        LongTermRetentionDatabaseState databaseState,
        Context context) {
        return new PagedIterable<>(
            listByServerAsync(
                locationName, longTermRetentionServerName, onlyLatestPerDatabase, databaseState, context));
    }

    /**
     * Lists the long term retention backups for a given server.
     *
     * @param locationName The location of the database.
     * @param longTermRetentionServerName The name of the server.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of long term retention backups.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<LongTermRetentionBackupInner> listByServer(
        String locationName, String longTermRetentionServerName) {
        final Boolean onlyLatestPerDatabase = null;
        final LongTermRetentionDatabaseState databaseState = null;
        return new PagedIterable<>(
            listByServerAsync(locationName, longTermRetentionServerName, onlyLatestPerDatabase, databaseState));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of long term retention backups.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<LongTermRetentionBackupInner>> listByResourceGroupDatabaseNextSinglePageAsync(
        String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil
            .withContext(context -> service.listByResourceGroupDatabaseNext(nextLink, context))
            .<PagedResponse<LongTermRetentionBackupInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of long term retention backups.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<LongTermRetentionBackupInner>> listByResourceGroupDatabaseNextSinglePageAsync(
        String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return service
            .listByResourceGroupDatabaseNext(nextLink, context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of long term retention backups.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<LongTermRetentionBackupInner>> listByResourceGroupLocationNextSinglePageAsync(
        String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil
            .withContext(context -> service.listByResourceGroupLocationNext(nextLink, context))
            .<PagedResponse<LongTermRetentionBackupInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of long term retention backups.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<LongTermRetentionBackupInner>> listByResourceGroupLocationNextSinglePageAsync(
        String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return service
            .listByResourceGroupLocationNext(nextLink, context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of long term retention backups.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<LongTermRetentionBackupInner>> listByResourceGroupServerNextSinglePageAsync(
        String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil
            .withContext(context -> service.listByResourceGroupServerNext(nextLink, context))
            .<PagedResponse<LongTermRetentionBackupInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of long term retention backups.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<LongTermRetentionBackupInner>> listByResourceGroupServerNextSinglePageAsync(
        String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return service
            .listByResourceGroupServerNext(nextLink, context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of long term retention backups.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<LongTermRetentionBackupInner>> listByDatabaseNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil
            .withContext(context -> service.listByDatabaseNext(nextLink, context))
            .<PagedResponse<LongTermRetentionBackupInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of long term retention backups.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<LongTermRetentionBackupInner>> listByDatabaseNextSinglePageAsync(
        String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return service
            .listByDatabaseNext(nextLink, context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of long term retention backups.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<LongTermRetentionBackupInner>> listByLocationNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil
            .withContext(context -> service.listByLocationNext(nextLink, context))
            .<PagedResponse<LongTermRetentionBackupInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of long term retention backups.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<LongTermRetentionBackupInner>> listByLocationNextSinglePageAsync(
        String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return service
            .listByLocationNext(nextLink, context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of long term retention backups.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<LongTermRetentionBackupInner>> listByServerNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil
            .withContext(context -> service.listByServerNext(nextLink, context))
            .<PagedResponse<LongTermRetentionBackupInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of long term retention backups.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<LongTermRetentionBackupInner>> listByServerNextSinglePageAsync(
        String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return service
            .listByServerNext(nextLink, context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null));
    }
}
