// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.implementation;

import com.azure.core.annotation.ServiceClient;
import com.azure.core.http.HttpPipeline;
import com.azure.core.management.AzureEnvironment;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.resources.fluentcore.AzureServiceClient;
import com.azure.resourcemanager.sql.fluent.BackupLongTermRetentionPoliciesClient;
import com.azure.resourcemanager.sql.fluent.BackupShortTermRetentionPoliciesClient;
import com.azure.resourcemanager.sql.fluent.CapabilitiesClient;
import com.azure.resourcemanager.sql.fluent.DataMaskingPoliciesClient;
import com.azure.resourcemanager.sql.fluent.DataMaskingRulesClient;
import com.azure.resourcemanager.sql.fluent.DatabaseAutomaticTuningsClient;
import com.azure.resourcemanager.sql.fluent.DatabaseBlobAuditingPoliciesClient;
import com.azure.resourcemanager.sql.fluent.DatabaseOperationsClient;
import com.azure.resourcemanager.sql.fluent.DatabaseThreatDetectionPoliciesClient;
import com.azure.resourcemanager.sql.fluent.DatabaseUsagesClient;
import com.azure.resourcemanager.sql.fluent.DatabaseVulnerabilityAssessmentRuleBaselinesClient;
import com.azure.resourcemanager.sql.fluent.DatabaseVulnerabilityAssessmentScansClient;
import com.azure.resourcemanager.sql.fluent.DatabaseVulnerabilityAssessmentsClient;
import com.azure.resourcemanager.sql.fluent.DatabasesClient;
import com.azure.resourcemanager.sql.fluent.ElasticPoolActivitiesClient;
import com.azure.resourcemanager.sql.fluent.ElasticPoolDatabaseActivitiesClient;
import com.azure.resourcemanager.sql.fluent.ElasticPoolOperationsClient;
import com.azure.resourcemanager.sql.fluent.ElasticPoolsClient;
import com.azure.resourcemanager.sql.fluent.EncryptionProtectorsClient;
import com.azure.resourcemanager.sql.fluent.ExtendedDatabaseBlobAuditingPoliciesClient;
import com.azure.resourcemanager.sql.fluent.ExtendedServerBlobAuditingPoliciesClient;
import com.azure.resourcemanager.sql.fluent.FailoverGroupsClient;
import com.azure.resourcemanager.sql.fluent.FirewallRulesClient;
import com.azure.resourcemanager.sql.fluent.GeoBackupPoliciesClient;
import com.azure.resourcemanager.sql.fluent.InstanceFailoverGroupsClient;
import com.azure.resourcemanager.sql.fluent.InstancePoolsClient;
import com.azure.resourcemanager.sql.fluent.JobAgentsClient;
import com.azure.resourcemanager.sql.fluent.JobCredentialsClient;
import com.azure.resourcemanager.sql.fluent.JobExecutionsClient;
import com.azure.resourcemanager.sql.fluent.JobStepExecutionsClient;
import com.azure.resourcemanager.sql.fluent.JobStepsClient;
import com.azure.resourcemanager.sql.fluent.JobTargetExecutionsClient;
import com.azure.resourcemanager.sql.fluent.JobTargetGroupsClient;
import com.azure.resourcemanager.sql.fluent.JobVersionsClient;
import com.azure.resourcemanager.sql.fluent.JobsClient;
import com.azure.resourcemanager.sql.fluent.LongTermRetentionBackupsClient;
import com.azure.resourcemanager.sql.fluent.LongTermRetentionManagedInstanceBackupsClient;
import com.azure.resourcemanager.sql.fluent.ManagedBackupShortTermRetentionPoliciesClient;
import com.azure.resourcemanager.sql.fluent.ManagedDatabaseRestoreDetailsClient;
import com.azure.resourcemanager.sql.fluent.ManagedDatabaseSecurityAlertPoliciesClient;
import com.azure.resourcemanager.sql.fluent.ManagedDatabaseSensitivityLabelsClient;
import com.azure.resourcemanager.sql.fluent.ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClient;
import com.azure.resourcemanager.sql.fluent.ManagedDatabaseVulnerabilityAssessmentScansClient;
import com.azure.resourcemanager.sql.fluent.ManagedDatabaseVulnerabilityAssessmentsClient;
import com.azure.resourcemanager.sql.fluent.ManagedDatabasesClient;
import com.azure.resourcemanager.sql.fluent.ManagedInstanceAdministratorsClient;
import com.azure.resourcemanager.sql.fluent.ManagedInstanceEncryptionProtectorsClient;
import com.azure.resourcemanager.sql.fluent.ManagedInstanceKeysClient;
import com.azure.resourcemanager.sql.fluent.ManagedInstanceLongTermRetentionPoliciesClient;
import com.azure.resourcemanager.sql.fluent.ManagedInstanceOperationsClient;
import com.azure.resourcemanager.sql.fluent.ManagedInstanceTdeCertificatesClient;
import com.azure.resourcemanager.sql.fluent.ManagedInstanceVulnerabilityAssessmentsClient;
import com.azure.resourcemanager.sql.fluent.ManagedInstancesClient;
import com.azure.resourcemanager.sql.fluent.ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesClient;
import com.azure.resourcemanager.sql.fluent.ManagedServerSecurityAlertPoliciesClient;
import com.azure.resourcemanager.sql.fluent.OperationsClient;
import com.azure.resourcemanager.sql.fluent.PrivateEndpointConnectionsClient;
import com.azure.resourcemanager.sql.fluent.PrivateLinkResourcesClient;
import com.azure.resourcemanager.sql.fluent.RecommendedElasticPoolsClient;
import com.azure.resourcemanager.sql.fluent.RecoverableDatabasesClient;
import com.azure.resourcemanager.sql.fluent.RecoverableManagedDatabasesClient;
import com.azure.resourcemanager.sql.fluent.ReplicationLinksClient;
import com.azure.resourcemanager.sql.fluent.RestorableDroppedDatabasesClient;
import com.azure.resourcemanager.sql.fluent.RestorableDroppedManagedDatabasesClient;
import com.azure.resourcemanager.sql.fluent.RestorePointsClient;
import com.azure.resourcemanager.sql.fluent.SensitivityLabelsClient;
import com.azure.resourcemanager.sql.fluent.ServerAutomaticTuningsClient;
import com.azure.resourcemanager.sql.fluent.ServerAzureADAdministratorsClient;
import com.azure.resourcemanager.sql.fluent.ServerBlobAuditingPoliciesClient;
import com.azure.resourcemanager.sql.fluent.ServerCommunicationLinksClient;
import com.azure.resourcemanager.sql.fluent.ServerConnectionPoliciesClient;
import com.azure.resourcemanager.sql.fluent.ServerDnsAliasesClient;
import com.azure.resourcemanager.sql.fluent.ServerKeysClient;
import com.azure.resourcemanager.sql.fluent.ServerSecurityAlertPoliciesClient;
import com.azure.resourcemanager.sql.fluent.ServerUsagesClient;
import com.azure.resourcemanager.sql.fluent.ServerVulnerabilityAssessmentsClient;
import com.azure.resourcemanager.sql.fluent.ServersClient;
import com.azure.resourcemanager.sql.fluent.ServiceObjectivesClient;
import com.azure.resourcemanager.sql.fluent.ServiceTierAdvisorsClient;
import com.azure.resourcemanager.sql.fluent.SqlManagementClient;
import com.azure.resourcemanager.sql.fluent.SubscriptionUsagesClient;
import com.azure.resourcemanager.sql.fluent.SyncAgentsClient;
import com.azure.resourcemanager.sql.fluent.SyncGroupsClient;
import com.azure.resourcemanager.sql.fluent.SyncMembersClient;
import com.azure.resourcemanager.sql.fluent.TdeCertificatesClient;
import com.azure.resourcemanager.sql.fluent.TransparentDataEncryptionActivitiesClient;
import com.azure.resourcemanager.sql.fluent.TransparentDataEncryptionsClient;
import com.azure.resourcemanager.sql.fluent.UsagesClient;
import com.azure.resourcemanager.sql.fluent.VirtualClustersClient;
import com.azure.resourcemanager.sql.fluent.VirtualNetworkRulesClient;
import com.azure.resourcemanager.sql.fluent.WorkloadClassifiersClient;
import com.azure.resourcemanager.sql.fluent.WorkloadGroupsClient;
import java.time.Duration;

/** Initializes a new instance of the SqlManagementClientImpl type. */
@ServiceClient(builder = SqlManagementClientBuilder.class)
public final class SqlManagementClientImpl extends AzureServiceClient implements SqlManagementClient {
    private final ClientLogger logger = new ClientLogger(SqlManagementClientImpl.class);

    /** The subscription ID that identifies an Azure subscription. */
    private final String subscriptionId;

    /**
     * Gets The subscription ID that identifies an Azure subscription.
     *
     * @return the subscriptionId value.
     */
    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    /** server parameter. */
    private final String endpoint;

    /**
     * Gets server parameter.
     *
     * @return the endpoint value.
     */
    public String getEndpoint() {
        return this.endpoint;
    }

    /** The HTTP pipeline to send requests through. */
    private final HttpPipeline httpPipeline;

    /**
     * Gets The HTTP pipeline to send requests through.
     *
     * @return the httpPipeline value.
     */
    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    /** The serializer to serialize an object into a string. */
    private final SerializerAdapter serializerAdapter;

    /**
     * Gets The serializer to serialize an object into a string.
     *
     * @return the serializerAdapter value.
     */
    SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    /** The default poll interval for long-running operation. */
    private final Duration defaultPollInterval;

    /**
     * Gets The default poll interval for long-running operation.
     *
     * @return the defaultPollInterval value.
     */
    public Duration getDefaultPollInterval() {
        return this.defaultPollInterval;
    }

    /** The RecoverableDatabasesClient object to access its operations. */
    private final RecoverableDatabasesClient recoverableDatabases;

    /**
     * Gets the RecoverableDatabasesClient object to access its operations.
     *
     * @return the RecoverableDatabasesClient object.
     */
    public RecoverableDatabasesClient getRecoverableDatabases() {
        return this.recoverableDatabases;
    }

    /** The RestorableDroppedDatabasesClient object to access its operations. */
    private final RestorableDroppedDatabasesClient restorableDroppedDatabases;

    /**
     * Gets the RestorableDroppedDatabasesClient object to access its operations.
     *
     * @return the RestorableDroppedDatabasesClient object.
     */
    public RestorableDroppedDatabasesClient getRestorableDroppedDatabases() {
        return this.restorableDroppedDatabases;
    }

    /** The ServerConnectionPoliciesClient object to access its operations. */
    private final ServerConnectionPoliciesClient serverConnectionPolicies;

    /**
     * Gets the ServerConnectionPoliciesClient object to access its operations.
     *
     * @return the ServerConnectionPoliciesClient object.
     */
    public ServerConnectionPoliciesClient getServerConnectionPolicies() {
        return this.serverConnectionPolicies;
    }

    /** The DatabaseThreatDetectionPoliciesClient object to access its operations. */
    private final DatabaseThreatDetectionPoliciesClient databaseThreatDetectionPolicies;

    /**
     * Gets the DatabaseThreatDetectionPoliciesClient object to access its operations.
     *
     * @return the DatabaseThreatDetectionPoliciesClient object.
     */
    public DatabaseThreatDetectionPoliciesClient getDatabaseThreatDetectionPolicies() {
        return this.databaseThreatDetectionPolicies;
    }

    /** The DataMaskingPoliciesClient object to access its operations. */
    private final DataMaskingPoliciesClient dataMaskingPolicies;

    /**
     * Gets the DataMaskingPoliciesClient object to access its operations.
     *
     * @return the DataMaskingPoliciesClient object.
     */
    public DataMaskingPoliciesClient getDataMaskingPolicies() {
        return this.dataMaskingPolicies;
    }

    /** The DataMaskingRulesClient object to access its operations. */
    private final DataMaskingRulesClient dataMaskingRules;

    /**
     * Gets the DataMaskingRulesClient object to access its operations.
     *
     * @return the DataMaskingRulesClient object.
     */
    public DataMaskingRulesClient getDataMaskingRules() {
        return this.dataMaskingRules;
    }

    /** The FirewallRulesClient object to access its operations. */
    private final FirewallRulesClient firewallRules;

    /**
     * Gets the FirewallRulesClient object to access its operations.
     *
     * @return the FirewallRulesClient object.
     */
    public FirewallRulesClient getFirewallRules() {
        return this.firewallRules;
    }

    /** The GeoBackupPoliciesClient object to access its operations. */
    private final GeoBackupPoliciesClient geoBackupPolicies;

    /**
     * Gets the GeoBackupPoliciesClient object to access its operations.
     *
     * @return the GeoBackupPoliciesClient object.
     */
    public GeoBackupPoliciesClient getGeoBackupPolicies() {
        return this.geoBackupPolicies;
    }

    /** The DatabasesClient object to access its operations. */
    private final DatabasesClient databases;

    /**
     * Gets the DatabasesClient object to access its operations.
     *
     * @return the DatabasesClient object.
     */
    public DatabasesClient getDatabases() {
        return this.databases;
    }

    /** The ElasticPoolsClient object to access its operations. */
    private final ElasticPoolsClient elasticPools;

    /**
     * Gets the ElasticPoolsClient object to access its operations.
     *
     * @return the ElasticPoolsClient object.
     */
    public ElasticPoolsClient getElasticPools() {
        return this.elasticPools;
    }

    /** The RecommendedElasticPoolsClient object to access its operations. */
    private final RecommendedElasticPoolsClient recommendedElasticPools;

    /**
     * Gets the RecommendedElasticPoolsClient object to access its operations.
     *
     * @return the RecommendedElasticPoolsClient object.
     */
    public RecommendedElasticPoolsClient getRecommendedElasticPools() {
        return this.recommendedElasticPools;
    }

    /** The ReplicationLinksClient object to access its operations. */
    private final ReplicationLinksClient replicationLinks;

    /**
     * Gets the ReplicationLinksClient object to access its operations.
     *
     * @return the ReplicationLinksClient object.
     */
    public ReplicationLinksClient getReplicationLinks() {
        return this.replicationLinks;
    }

    /** The ServerCommunicationLinksClient object to access its operations. */
    private final ServerCommunicationLinksClient serverCommunicationLinks;

    /**
     * Gets the ServerCommunicationLinksClient object to access its operations.
     *
     * @return the ServerCommunicationLinksClient object.
     */
    public ServerCommunicationLinksClient getServerCommunicationLinks() {
        return this.serverCommunicationLinks;
    }

    /** The ServiceObjectivesClient object to access its operations. */
    private final ServiceObjectivesClient serviceObjectives;

    /**
     * Gets the ServiceObjectivesClient object to access its operations.
     *
     * @return the ServiceObjectivesClient object.
     */
    public ServiceObjectivesClient getServiceObjectives() {
        return this.serviceObjectives;
    }

    /** The ElasticPoolActivitiesClient object to access its operations. */
    private final ElasticPoolActivitiesClient elasticPoolActivities;

    /**
     * Gets the ElasticPoolActivitiesClient object to access its operations.
     *
     * @return the ElasticPoolActivitiesClient object.
     */
    public ElasticPoolActivitiesClient getElasticPoolActivities() {
        return this.elasticPoolActivities;
    }

    /** The ElasticPoolDatabaseActivitiesClient object to access its operations. */
    private final ElasticPoolDatabaseActivitiesClient elasticPoolDatabaseActivities;

    /**
     * Gets the ElasticPoolDatabaseActivitiesClient object to access its operations.
     *
     * @return the ElasticPoolDatabaseActivitiesClient object.
     */
    public ElasticPoolDatabaseActivitiesClient getElasticPoolDatabaseActivities() {
        return this.elasticPoolDatabaseActivities;
    }

    /** The ServiceTierAdvisorsClient object to access its operations. */
    private final ServiceTierAdvisorsClient serviceTierAdvisors;

    /**
     * Gets the ServiceTierAdvisorsClient object to access its operations.
     *
     * @return the ServiceTierAdvisorsClient object.
     */
    public ServiceTierAdvisorsClient getServiceTierAdvisors() {
        return this.serviceTierAdvisors;
    }

    /** The TransparentDataEncryptionsClient object to access its operations. */
    private final TransparentDataEncryptionsClient transparentDataEncryptions;

    /**
     * Gets the TransparentDataEncryptionsClient object to access its operations.
     *
     * @return the TransparentDataEncryptionsClient object.
     */
    public TransparentDataEncryptionsClient getTransparentDataEncryptions() {
        return this.transparentDataEncryptions;
    }

    /** The TransparentDataEncryptionActivitiesClient object to access its operations. */
    private final TransparentDataEncryptionActivitiesClient transparentDataEncryptionActivities;

    /**
     * Gets the TransparentDataEncryptionActivitiesClient object to access its operations.
     *
     * @return the TransparentDataEncryptionActivitiesClient object.
     */
    public TransparentDataEncryptionActivitiesClient getTransparentDataEncryptionActivities() {
        return this.transparentDataEncryptionActivities;
    }

    /** The ServerUsagesClient object to access its operations. */
    private final ServerUsagesClient serverUsages;

    /**
     * Gets the ServerUsagesClient object to access its operations.
     *
     * @return the ServerUsagesClient object.
     */
    public ServerUsagesClient getServerUsages() {
        return this.serverUsages;
    }

    /** The DatabaseUsagesClient object to access its operations. */
    private final DatabaseUsagesClient databaseUsages;

    /**
     * Gets the DatabaseUsagesClient object to access its operations.
     *
     * @return the DatabaseUsagesClient object.
     */
    public DatabaseUsagesClient getDatabaseUsages() {
        return this.databaseUsages;
    }

    /** The DatabaseAutomaticTuningsClient object to access its operations. */
    private final DatabaseAutomaticTuningsClient databaseAutomaticTunings;

    /**
     * Gets the DatabaseAutomaticTuningsClient object to access its operations.
     *
     * @return the DatabaseAutomaticTuningsClient object.
     */
    public DatabaseAutomaticTuningsClient getDatabaseAutomaticTunings() {
        return this.databaseAutomaticTunings;
    }

    /** The EncryptionProtectorsClient object to access its operations. */
    private final EncryptionProtectorsClient encryptionProtectors;

    /**
     * Gets the EncryptionProtectorsClient object to access its operations.
     *
     * @return the EncryptionProtectorsClient object.
     */
    public EncryptionProtectorsClient getEncryptionProtectors() {
        return this.encryptionProtectors;
    }

    /** The FailoverGroupsClient object to access its operations. */
    private final FailoverGroupsClient failoverGroups;

    /**
     * Gets the FailoverGroupsClient object to access its operations.
     *
     * @return the FailoverGroupsClient object.
     */
    public FailoverGroupsClient getFailoverGroups() {
        return this.failoverGroups;
    }

    /** The OperationsClient object to access its operations. */
    private final OperationsClient operations;

    /**
     * Gets the OperationsClient object to access its operations.
     *
     * @return the OperationsClient object.
     */
    public OperationsClient getOperations() {
        return this.operations;
    }

    /** The ServerKeysClient object to access its operations. */
    private final ServerKeysClient serverKeys;

    /**
     * Gets the ServerKeysClient object to access its operations.
     *
     * @return the ServerKeysClient object.
     */
    public ServerKeysClient getServerKeys() {
        return this.serverKeys;
    }

    /** The SyncAgentsClient object to access its operations. */
    private final SyncAgentsClient syncAgents;

    /**
     * Gets the SyncAgentsClient object to access its operations.
     *
     * @return the SyncAgentsClient object.
     */
    public SyncAgentsClient getSyncAgents() {
        return this.syncAgents;
    }

    /** The SyncGroupsClient object to access its operations. */
    private final SyncGroupsClient syncGroups;

    /**
     * Gets the SyncGroupsClient object to access its operations.
     *
     * @return the SyncGroupsClient object.
     */
    public SyncGroupsClient getSyncGroups() {
        return this.syncGroups;
    }

    /** The SyncMembersClient object to access its operations. */
    private final SyncMembersClient syncMembers;

    /**
     * Gets the SyncMembersClient object to access its operations.
     *
     * @return the SyncMembersClient object.
     */
    public SyncMembersClient getSyncMembers() {
        return this.syncMembers;
    }

    /** The SubscriptionUsagesClient object to access its operations. */
    private final SubscriptionUsagesClient subscriptionUsages;

    /**
     * Gets the SubscriptionUsagesClient object to access its operations.
     *
     * @return the SubscriptionUsagesClient object.
     */
    public SubscriptionUsagesClient getSubscriptionUsages() {
        return this.subscriptionUsages;
    }

    /** The VirtualClustersClient object to access its operations. */
    private final VirtualClustersClient virtualClusters;

    /**
     * Gets the VirtualClustersClient object to access its operations.
     *
     * @return the VirtualClustersClient object.
     */
    public VirtualClustersClient getVirtualClusters() {
        return this.virtualClusters;
    }

    /** The VirtualNetworkRulesClient object to access its operations. */
    private final VirtualNetworkRulesClient virtualNetworkRules;

    /**
     * Gets the VirtualNetworkRulesClient object to access its operations.
     *
     * @return the VirtualNetworkRulesClient object.
     */
    public VirtualNetworkRulesClient getVirtualNetworkRules() {
        return this.virtualNetworkRules;
    }

    /** The ExtendedDatabaseBlobAuditingPoliciesClient object to access its operations. */
    private final ExtendedDatabaseBlobAuditingPoliciesClient extendedDatabaseBlobAuditingPolicies;

    /**
     * Gets the ExtendedDatabaseBlobAuditingPoliciesClient object to access its operations.
     *
     * @return the ExtendedDatabaseBlobAuditingPoliciesClient object.
     */
    public ExtendedDatabaseBlobAuditingPoliciesClient getExtendedDatabaseBlobAuditingPolicies() {
        return this.extendedDatabaseBlobAuditingPolicies;
    }

    /** The ExtendedServerBlobAuditingPoliciesClient object to access its operations. */
    private final ExtendedServerBlobAuditingPoliciesClient extendedServerBlobAuditingPolicies;

    /**
     * Gets the ExtendedServerBlobAuditingPoliciesClient object to access its operations.
     *
     * @return the ExtendedServerBlobAuditingPoliciesClient object.
     */
    public ExtendedServerBlobAuditingPoliciesClient getExtendedServerBlobAuditingPolicies() {
        return this.extendedServerBlobAuditingPolicies;
    }

    /** The ServerBlobAuditingPoliciesClient object to access its operations. */
    private final ServerBlobAuditingPoliciesClient serverBlobAuditingPolicies;

    /**
     * Gets the ServerBlobAuditingPoliciesClient object to access its operations.
     *
     * @return the ServerBlobAuditingPoliciesClient object.
     */
    public ServerBlobAuditingPoliciesClient getServerBlobAuditingPolicies() {
        return this.serverBlobAuditingPolicies;
    }

    /** The DatabaseBlobAuditingPoliciesClient object to access its operations. */
    private final DatabaseBlobAuditingPoliciesClient databaseBlobAuditingPolicies;

    /**
     * Gets the DatabaseBlobAuditingPoliciesClient object to access its operations.
     *
     * @return the DatabaseBlobAuditingPoliciesClient object.
     */
    public DatabaseBlobAuditingPoliciesClient getDatabaseBlobAuditingPolicies() {
        return this.databaseBlobAuditingPolicies;
    }

    /** The DatabaseVulnerabilityAssessmentRuleBaselinesClient object to access its operations. */
    private final DatabaseVulnerabilityAssessmentRuleBaselinesClient databaseVulnerabilityAssessmentRuleBaselines;

    /**
     * Gets the DatabaseVulnerabilityAssessmentRuleBaselinesClient object to access its operations.
     *
     * @return the DatabaseVulnerabilityAssessmentRuleBaselinesClient object.
     */
    public DatabaseVulnerabilityAssessmentRuleBaselinesClient getDatabaseVulnerabilityAssessmentRuleBaselines() {
        return this.databaseVulnerabilityAssessmentRuleBaselines;
    }

    /** The DatabaseVulnerabilityAssessmentsClient object to access its operations. */
    private final DatabaseVulnerabilityAssessmentsClient databaseVulnerabilityAssessments;

    /**
     * Gets the DatabaseVulnerabilityAssessmentsClient object to access its operations.
     *
     * @return the DatabaseVulnerabilityAssessmentsClient object.
     */
    public DatabaseVulnerabilityAssessmentsClient getDatabaseVulnerabilityAssessments() {
        return this.databaseVulnerabilityAssessments;
    }

    /** The JobAgentsClient object to access its operations. */
    private final JobAgentsClient jobAgents;

    /**
     * Gets the JobAgentsClient object to access its operations.
     *
     * @return the JobAgentsClient object.
     */
    public JobAgentsClient getJobAgents() {
        return this.jobAgents;
    }

    /** The JobCredentialsClient object to access its operations. */
    private final JobCredentialsClient jobCredentials;

    /**
     * Gets the JobCredentialsClient object to access its operations.
     *
     * @return the JobCredentialsClient object.
     */
    public JobCredentialsClient getJobCredentials() {
        return this.jobCredentials;
    }

    /** The JobExecutionsClient object to access its operations. */
    private final JobExecutionsClient jobExecutions;

    /**
     * Gets the JobExecutionsClient object to access its operations.
     *
     * @return the JobExecutionsClient object.
     */
    public JobExecutionsClient getJobExecutions() {
        return this.jobExecutions;
    }

    /** The JobsClient object to access its operations. */
    private final JobsClient jobs;

    /**
     * Gets the JobsClient object to access its operations.
     *
     * @return the JobsClient object.
     */
    public JobsClient getJobs() {
        return this.jobs;
    }

    /** The JobStepExecutionsClient object to access its operations. */
    private final JobStepExecutionsClient jobStepExecutions;

    /**
     * Gets the JobStepExecutionsClient object to access its operations.
     *
     * @return the JobStepExecutionsClient object.
     */
    public JobStepExecutionsClient getJobStepExecutions() {
        return this.jobStepExecutions;
    }

    /** The JobStepsClient object to access its operations. */
    private final JobStepsClient jobSteps;

    /**
     * Gets the JobStepsClient object to access its operations.
     *
     * @return the JobStepsClient object.
     */
    public JobStepsClient getJobSteps() {
        return this.jobSteps;
    }

    /** The JobTargetExecutionsClient object to access its operations. */
    private final JobTargetExecutionsClient jobTargetExecutions;

    /**
     * Gets the JobTargetExecutionsClient object to access its operations.
     *
     * @return the JobTargetExecutionsClient object.
     */
    public JobTargetExecutionsClient getJobTargetExecutions() {
        return this.jobTargetExecutions;
    }

    /** The JobTargetGroupsClient object to access its operations. */
    private final JobTargetGroupsClient jobTargetGroups;

    /**
     * Gets the JobTargetGroupsClient object to access its operations.
     *
     * @return the JobTargetGroupsClient object.
     */
    public JobTargetGroupsClient getJobTargetGroups() {
        return this.jobTargetGroups;
    }

    /** The JobVersionsClient object to access its operations. */
    private final JobVersionsClient jobVersions;

    /**
     * Gets the JobVersionsClient object to access its operations.
     *
     * @return the JobVersionsClient object.
     */
    public JobVersionsClient getJobVersions() {
        return this.jobVersions;
    }

    /** The LongTermRetentionBackupsClient object to access its operations. */
    private final LongTermRetentionBackupsClient longTermRetentionBackups;

    /**
     * Gets the LongTermRetentionBackupsClient object to access its operations.
     *
     * @return the LongTermRetentionBackupsClient object.
     */
    public LongTermRetentionBackupsClient getLongTermRetentionBackups() {
        return this.longTermRetentionBackups;
    }

    /** The BackupLongTermRetentionPoliciesClient object to access its operations. */
    private final BackupLongTermRetentionPoliciesClient backupLongTermRetentionPolicies;

    /**
     * Gets the BackupLongTermRetentionPoliciesClient object to access its operations.
     *
     * @return the BackupLongTermRetentionPoliciesClient object.
     */
    public BackupLongTermRetentionPoliciesClient getBackupLongTermRetentionPolicies() {
        return this.backupLongTermRetentionPolicies;
    }

    /** The ManagedBackupShortTermRetentionPoliciesClient object to access its operations. */
    private final ManagedBackupShortTermRetentionPoliciesClient managedBackupShortTermRetentionPolicies;

    /**
     * Gets the ManagedBackupShortTermRetentionPoliciesClient object to access its operations.
     *
     * @return the ManagedBackupShortTermRetentionPoliciesClient object.
     */
    public ManagedBackupShortTermRetentionPoliciesClient getManagedBackupShortTermRetentionPolicies() {
        return this.managedBackupShortTermRetentionPolicies;
    }

    /** The ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesClient object to access its operations. */
    private final ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesClient
        managedRestorableDroppedDatabaseBackupShortTermRetentionPolicies;

    /**
     * Gets the ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesClient object to access its operations.
     *
     * @return the ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesClient object.
     */
    public ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesClient
        getManagedRestorableDroppedDatabaseBackupShortTermRetentionPolicies() {
        return this.managedRestorableDroppedDatabaseBackupShortTermRetentionPolicies;
    }

    /** The ServerAutomaticTuningsClient object to access its operations. */
    private final ServerAutomaticTuningsClient serverAutomaticTunings;

    /**
     * Gets the ServerAutomaticTuningsClient object to access its operations.
     *
     * @return the ServerAutomaticTuningsClient object.
     */
    public ServerAutomaticTuningsClient getServerAutomaticTunings() {
        return this.serverAutomaticTunings;
    }

    /** The ServerDnsAliasesClient object to access its operations. */
    private final ServerDnsAliasesClient serverDnsAliases;

    /**
     * Gets the ServerDnsAliasesClient object to access its operations.
     *
     * @return the ServerDnsAliasesClient object.
     */
    public ServerDnsAliasesClient getServerDnsAliases() {
        return this.serverDnsAliases;
    }

    /** The ServerSecurityAlertPoliciesClient object to access its operations. */
    private final ServerSecurityAlertPoliciesClient serverSecurityAlertPolicies;

    /**
     * Gets the ServerSecurityAlertPoliciesClient object to access its operations.
     *
     * @return the ServerSecurityAlertPoliciesClient object.
     */
    public ServerSecurityAlertPoliciesClient getServerSecurityAlertPolicies() {
        return this.serverSecurityAlertPolicies;
    }

    /** The RestorableDroppedManagedDatabasesClient object to access its operations. */
    private final RestorableDroppedManagedDatabasesClient restorableDroppedManagedDatabases;

    /**
     * Gets the RestorableDroppedManagedDatabasesClient object to access its operations.
     *
     * @return the RestorableDroppedManagedDatabasesClient object.
     */
    public RestorableDroppedManagedDatabasesClient getRestorableDroppedManagedDatabases() {
        return this.restorableDroppedManagedDatabases;
    }

    /** The RestorePointsClient object to access its operations. */
    private final RestorePointsClient restorePoints;

    /**
     * Gets the RestorePointsClient object to access its operations.
     *
     * @return the RestorePointsClient object.
     */
    public RestorePointsClient getRestorePoints() {
        return this.restorePoints;
    }

    /** The ManagedDatabaseSecurityAlertPoliciesClient object to access its operations. */
    private final ManagedDatabaseSecurityAlertPoliciesClient managedDatabaseSecurityAlertPolicies;

    /**
     * Gets the ManagedDatabaseSecurityAlertPoliciesClient object to access its operations.
     *
     * @return the ManagedDatabaseSecurityAlertPoliciesClient object.
     */
    public ManagedDatabaseSecurityAlertPoliciesClient getManagedDatabaseSecurityAlertPolicies() {
        return this.managedDatabaseSecurityAlertPolicies;
    }

    /** The ManagedServerSecurityAlertPoliciesClient object to access its operations. */
    private final ManagedServerSecurityAlertPoliciesClient managedServerSecurityAlertPolicies;

    /**
     * Gets the ManagedServerSecurityAlertPoliciesClient object to access its operations.
     *
     * @return the ManagedServerSecurityAlertPoliciesClient object.
     */
    public ManagedServerSecurityAlertPoliciesClient getManagedServerSecurityAlertPolicies() {
        return this.managedServerSecurityAlertPolicies;
    }

    /** The SensitivityLabelsClient object to access its operations. */
    private final SensitivityLabelsClient sensitivityLabels;

    /**
     * Gets the SensitivityLabelsClient object to access its operations.
     *
     * @return the SensitivityLabelsClient object.
     */
    public SensitivityLabelsClient getSensitivityLabels() {
        return this.sensitivityLabels;
    }

    /** The ManagedInstanceAdministratorsClient object to access its operations. */
    private final ManagedInstanceAdministratorsClient managedInstanceAdministrators;

    /**
     * Gets the ManagedInstanceAdministratorsClient object to access its operations.
     *
     * @return the ManagedInstanceAdministratorsClient object.
     */
    public ManagedInstanceAdministratorsClient getManagedInstanceAdministrators() {
        return this.managedInstanceAdministrators;
    }

    /** The DatabaseOperationsClient object to access its operations. */
    private final DatabaseOperationsClient databaseOperations;

    /**
     * Gets the DatabaseOperationsClient object to access its operations.
     *
     * @return the DatabaseOperationsClient object.
     */
    public DatabaseOperationsClient getDatabaseOperations() {
        return this.databaseOperations;
    }

    /** The ElasticPoolOperationsClient object to access its operations. */
    private final ElasticPoolOperationsClient elasticPoolOperations;

    /**
     * Gets the ElasticPoolOperationsClient object to access its operations.
     *
     * @return the ElasticPoolOperationsClient object.
     */
    public ElasticPoolOperationsClient getElasticPoolOperations() {
        return this.elasticPoolOperations;
    }

    /** The DatabaseVulnerabilityAssessmentScansClient object to access its operations. */
    private final DatabaseVulnerabilityAssessmentScansClient databaseVulnerabilityAssessmentScans;

    /**
     * Gets the DatabaseVulnerabilityAssessmentScansClient object to access its operations.
     *
     * @return the DatabaseVulnerabilityAssessmentScansClient object.
     */
    public DatabaseVulnerabilityAssessmentScansClient getDatabaseVulnerabilityAssessmentScans() {
        return this.databaseVulnerabilityAssessmentScans;
    }

    /** The ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClient object to access its operations. */
    private final ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClient
        managedDatabaseVulnerabilityAssessmentRuleBaselines;

    /**
     * Gets the ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClient object to access its operations.
     *
     * @return the ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClient object.
     */
    public ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClient
        getManagedDatabaseVulnerabilityAssessmentRuleBaselines() {
        return this.managedDatabaseVulnerabilityAssessmentRuleBaselines;
    }

    /** The ManagedDatabaseVulnerabilityAssessmentScansClient object to access its operations. */
    private final ManagedDatabaseVulnerabilityAssessmentScansClient managedDatabaseVulnerabilityAssessmentScans;

    /**
     * Gets the ManagedDatabaseVulnerabilityAssessmentScansClient object to access its operations.
     *
     * @return the ManagedDatabaseVulnerabilityAssessmentScansClient object.
     */
    public ManagedDatabaseVulnerabilityAssessmentScansClient getManagedDatabaseVulnerabilityAssessmentScans() {
        return this.managedDatabaseVulnerabilityAssessmentScans;
    }

    /** The ManagedDatabaseVulnerabilityAssessmentsClient object to access its operations. */
    private final ManagedDatabaseVulnerabilityAssessmentsClient managedDatabaseVulnerabilityAssessments;

    /**
     * Gets the ManagedDatabaseVulnerabilityAssessmentsClient object to access its operations.
     *
     * @return the ManagedDatabaseVulnerabilityAssessmentsClient object.
     */
    public ManagedDatabaseVulnerabilityAssessmentsClient getManagedDatabaseVulnerabilityAssessments() {
        return this.managedDatabaseVulnerabilityAssessments;
    }

    /** The InstanceFailoverGroupsClient object to access its operations. */
    private final InstanceFailoverGroupsClient instanceFailoverGroups;

    /**
     * Gets the InstanceFailoverGroupsClient object to access its operations.
     *
     * @return the InstanceFailoverGroupsClient object.
     */
    public InstanceFailoverGroupsClient getInstanceFailoverGroups() {
        return this.instanceFailoverGroups;
    }

    /** The BackupShortTermRetentionPoliciesClient object to access its operations. */
    private final BackupShortTermRetentionPoliciesClient backupShortTermRetentionPolicies;

    /**
     * Gets the BackupShortTermRetentionPoliciesClient object to access its operations.
     *
     * @return the BackupShortTermRetentionPoliciesClient object.
     */
    public BackupShortTermRetentionPoliciesClient getBackupShortTermRetentionPolicies() {
        return this.backupShortTermRetentionPolicies;
    }

    /** The TdeCertificatesClient object to access its operations. */
    private final TdeCertificatesClient tdeCertificates;

    /**
     * Gets the TdeCertificatesClient object to access its operations.
     *
     * @return the TdeCertificatesClient object.
     */
    public TdeCertificatesClient getTdeCertificates() {
        return this.tdeCertificates;
    }

    /** The ManagedInstanceTdeCertificatesClient object to access its operations. */
    private final ManagedInstanceTdeCertificatesClient managedInstanceTdeCertificates;

    /**
     * Gets the ManagedInstanceTdeCertificatesClient object to access its operations.
     *
     * @return the ManagedInstanceTdeCertificatesClient object.
     */
    public ManagedInstanceTdeCertificatesClient getManagedInstanceTdeCertificates() {
        return this.managedInstanceTdeCertificates;
    }

    /** The ManagedInstanceKeysClient object to access its operations. */
    private final ManagedInstanceKeysClient managedInstanceKeys;

    /**
     * Gets the ManagedInstanceKeysClient object to access its operations.
     *
     * @return the ManagedInstanceKeysClient object.
     */
    public ManagedInstanceKeysClient getManagedInstanceKeys() {
        return this.managedInstanceKeys;
    }

    /** The ManagedInstanceEncryptionProtectorsClient object to access its operations. */
    private final ManagedInstanceEncryptionProtectorsClient managedInstanceEncryptionProtectors;

    /**
     * Gets the ManagedInstanceEncryptionProtectorsClient object to access its operations.
     *
     * @return the ManagedInstanceEncryptionProtectorsClient object.
     */
    public ManagedInstanceEncryptionProtectorsClient getManagedInstanceEncryptionProtectors() {
        return this.managedInstanceEncryptionProtectors;
    }

    /** The RecoverableManagedDatabasesClient object to access its operations. */
    private final RecoverableManagedDatabasesClient recoverableManagedDatabases;

    /**
     * Gets the RecoverableManagedDatabasesClient object to access its operations.
     *
     * @return the RecoverableManagedDatabasesClient object.
     */
    public RecoverableManagedDatabasesClient getRecoverableManagedDatabases() {
        return this.recoverableManagedDatabases;
    }

    /** The ManagedInstanceVulnerabilityAssessmentsClient object to access its operations. */
    private final ManagedInstanceVulnerabilityAssessmentsClient managedInstanceVulnerabilityAssessments;

    /**
     * Gets the ManagedInstanceVulnerabilityAssessmentsClient object to access its operations.
     *
     * @return the ManagedInstanceVulnerabilityAssessmentsClient object.
     */
    public ManagedInstanceVulnerabilityAssessmentsClient getManagedInstanceVulnerabilityAssessments() {
        return this.managedInstanceVulnerabilityAssessments;
    }

    /** The ServerVulnerabilityAssessmentsClient object to access its operations. */
    private final ServerVulnerabilityAssessmentsClient serverVulnerabilityAssessments;

    /**
     * Gets the ServerVulnerabilityAssessmentsClient object to access its operations.
     *
     * @return the ServerVulnerabilityAssessmentsClient object.
     */
    public ServerVulnerabilityAssessmentsClient getServerVulnerabilityAssessments() {
        return this.serverVulnerabilityAssessments;
    }

    /** The ManagedDatabaseSensitivityLabelsClient object to access its operations. */
    private final ManagedDatabaseSensitivityLabelsClient managedDatabaseSensitivityLabels;

    /**
     * Gets the ManagedDatabaseSensitivityLabelsClient object to access its operations.
     *
     * @return the ManagedDatabaseSensitivityLabelsClient object.
     */
    public ManagedDatabaseSensitivityLabelsClient getManagedDatabaseSensitivityLabels() {
        return this.managedDatabaseSensitivityLabels;
    }

    /** The InstancePoolsClient object to access its operations. */
    private final InstancePoolsClient instancePools;

    /**
     * Gets the InstancePoolsClient object to access its operations.
     *
     * @return the InstancePoolsClient object.
     */
    public InstancePoolsClient getInstancePools() {
        return this.instancePools;
    }

    /** The UsagesClient object to access its operations. */
    private final UsagesClient usages;

    /**
     * Gets the UsagesClient object to access its operations.
     *
     * @return the UsagesClient object.
     */
    public UsagesClient getUsages() {
        return this.usages;
    }

    /** The ManagedInstancesClient object to access its operations. */
    private final ManagedInstancesClient managedInstances;

    /**
     * Gets the ManagedInstancesClient object to access its operations.
     *
     * @return the ManagedInstancesClient object.
     */
    public ManagedInstancesClient getManagedInstances() {
        return this.managedInstances;
    }

    /** The PrivateEndpointConnectionsClient object to access its operations. */
    private final PrivateEndpointConnectionsClient privateEndpointConnections;

    /**
     * Gets the PrivateEndpointConnectionsClient object to access its operations.
     *
     * @return the PrivateEndpointConnectionsClient object.
     */
    public PrivateEndpointConnectionsClient getPrivateEndpointConnections() {
        return this.privateEndpointConnections;
    }

    /** The PrivateLinkResourcesClient object to access its operations. */
    private final PrivateLinkResourcesClient privateLinkResources;

    /**
     * Gets the PrivateLinkResourcesClient object to access its operations.
     *
     * @return the PrivateLinkResourcesClient object.
     */
    public PrivateLinkResourcesClient getPrivateLinkResources() {
        return this.privateLinkResources;
    }

    /** The ServersClient object to access its operations. */
    private final ServersClient servers;

    /**
     * Gets the ServersClient object to access its operations.
     *
     * @return the ServersClient object.
     */
    public ServersClient getServers() {
        return this.servers;
    }

    /** The CapabilitiesClient object to access its operations. */
    private final CapabilitiesClient capabilities;

    /**
     * Gets the CapabilitiesClient object to access its operations.
     *
     * @return the CapabilitiesClient object.
     */
    public CapabilitiesClient getCapabilities() {
        return this.capabilities;
    }

    /** The LongTermRetentionManagedInstanceBackupsClient object to access its operations. */
    private final LongTermRetentionManagedInstanceBackupsClient longTermRetentionManagedInstanceBackups;

    /**
     * Gets the LongTermRetentionManagedInstanceBackupsClient object to access its operations.
     *
     * @return the LongTermRetentionManagedInstanceBackupsClient object.
     */
    public LongTermRetentionManagedInstanceBackupsClient getLongTermRetentionManagedInstanceBackups() {
        return this.longTermRetentionManagedInstanceBackups;
    }

    /** The ManagedInstanceLongTermRetentionPoliciesClient object to access its operations. */
    private final ManagedInstanceLongTermRetentionPoliciesClient managedInstanceLongTermRetentionPolicies;

    /**
     * Gets the ManagedInstanceLongTermRetentionPoliciesClient object to access its operations.
     *
     * @return the ManagedInstanceLongTermRetentionPoliciesClient object.
     */
    public ManagedInstanceLongTermRetentionPoliciesClient getManagedInstanceLongTermRetentionPolicies() {
        return this.managedInstanceLongTermRetentionPolicies;
    }

    /** The WorkloadGroupsClient object to access its operations. */
    private final WorkloadGroupsClient workloadGroups;

    /**
     * Gets the WorkloadGroupsClient object to access its operations.
     *
     * @return the WorkloadGroupsClient object.
     */
    public WorkloadGroupsClient getWorkloadGroups() {
        return this.workloadGroups;
    }

    /** The WorkloadClassifiersClient object to access its operations. */
    private final WorkloadClassifiersClient workloadClassifiers;

    /**
     * Gets the WorkloadClassifiersClient object to access its operations.
     *
     * @return the WorkloadClassifiersClient object.
     */
    public WorkloadClassifiersClient getWorkloadClassifiers() {
        return this.workloadClassifiers;
    }

    /** The ManagedDatabaseRestoreDetailsClient object to access its operations. */
    private final ManagedDatabaseRestoreDetailsClient managedDatabaseRestoreDetails;

    /**
     * Gets the ManagedDatabaseRestoreDetailsClient object to access its operations.
     *
     * @return the ManagedDatabaseRestoreDetailsClient object.
     */
    public ManagedDatabaseRestoreDetailsClient getManagedDatabaseRestoreDetails() {
        return this.managedDatabaseRestoreDetails;
    }

    /** The ManagedDatabasesClient object to access its operations. */
    private final ManagedDatabasesClient managedDatabases;

    /**
     * Gets the ManagedDatabasesClient object to access its operations.
     *
     * @return the ManagedDatabasesClient object.
     */
    public ManagedDatabasesClient getManagedDatabases() {
        return this.managedDatabases;
    }

    /** The ServerAzureADAdministratorsClient object to access its operations. */
    private final ServerAzureADAdministratorsClient serverAzureADAdministrators;

    /**
     * Gets the ServerAzureADAdministratorsClient object to access its operations.
     *
     * @return the ServerAzureADAdministratorsClient object.
     */
    public ServerAzureADAdministratorsClient getServerAzureADAdministrators() {
        return this.serverAzureADAdministrators;
    }

    /** The ManagedInstanceOperationsClient object to access its operations. */
    private final ManagedInstanceOperationsClient managedInstanceOperations;

    /**
     * Gets the ManagedInstanceOperationsClient object to access its operations.
     *
     * @return the ManagedInstanceOperationsClient object.
     */
    public ManagedInstanceOperationsClient getManagedInstanceOperations() {
        return this.managedInstanceOperations;
    }

    /**
     * Initializes an instance of SqlManagementClient client.
     *
     * @param httpPipeline The HTTP pipeline to send requests through.
     * @param serializerAdapter The serializer to serialize an object into a string.
     * @param defaultPollInterval The default poll interval for long-running operation.
     * @param environment The Azure environment.
     * @param subscriptionId The subscription ID that identifies an Azure subscription.
     * @param endpoint server parameter.
     */
    SqlManagementClientImpl(
        HttpPipeline httpPipeline,
        SerializerAdapter serializerAdapter,
        Duration defaultPollInterval,
        AzureEnvironment environment,
        String subscriptionId,
        String endpoint) {
        super(httpPipeline, serializerAdapter, environment);
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.defaultPollInterval = defaultPollInterval;
        this.subscriptionId = subscriptionId;
        this.endpoint = endpoint;
        this.recoverableDatabases = new RecoverableDatabasesClientImpl(this);
        this.restorableDroppedDatabases = new RestorableDroppedDatabasesClientImpl(this);
        this.serverConnectionPolicies = new ServerConnectionPoliciesClientImpl(this);
        this.databaseThreatDetectionPolicies = new DatabaseThreatDetectionPoliciesClientImpl(this);
        this.dataMaskingPolicies = new DataMaskingPoliciesClientImpl(this);
        this.dataMaskingRules = new DataMaskingRulesClientImpl(this);
        this.firewallRules = new FirewallRulesClientImpl(this);
        this.geoBackupPolicies = new GeoBackupPoliciesClientImpl(this);
        this.databases = new DatabasesClientImpl(this);
        this.elasticPools = new ElasticPoolsClientImpl(this);
        this.recommendedElasticPools = new RecommendedElasticPoolsClientImpl(this);
        this.replicationLinks = new ReplicationLinksClientImpl(this);
        this.serverCommunicationLinks = new ServerCommunicationLinksClientImpl(this);
        this.serviceObjectives = new ServiceObjectivesClientImpl(this);
        this.elasticPoolActivities = new ElasticPoolActivitiesClientImpl(this);
        this.elasticPoolDatabaseActivities = new ElasticPoolDatabaseActivitiesClientImpl(this);
        this.serviceTierAdvisors = new ServiceTierAdvisorsClientImpl(this);
        this.transparentDataEncryptions = new TransparentDataEncryptionsClientImpl(this);
        this.transparentDataEncryptionActivities = new TransparentDataEncryptionActivitiesClientImpl(this);
        this.serverUsages = new ServerUsagesClientImpl(this);
        this.databaseUsages = new DatabaseUsagesClientImpl(this);
        this.databaseAutomaticTunings = new DatabaseAutomaticTuningsClientImpl(this);
        this.encryptionProtectors = new EncryptionProtectorsClientImpl(this);
        this.failoverGroups = new FailoverGroupsClientImpl(this);
        this.operations = new OperationsClientImpl(this);
        this.serverKeys = new ServerKeysClientImpl(this);
        this.syncAgents = new SyncAgentsClientImpl(this);
        this.syncGroups = new SyncGroupsClientImpl(this);
        this.syncMembers = new SyncMembersClientImpl(this);
        this.subscriptionUsages = new SubscriptionUsagesClientImpl(this);
        this.virtualClusters = new VirtualClustersClientImpl(this);
        this.virtualNetworkRules = new VirtualNetworkRulesClientImpl(this);
        this.extendedDatabaseBlobAuditingPolicies = new ExtendedDatabaseBlobAuditingPoliciesClientImpl(this);
        this.extendedServerBlobAuditingPolicies = new ExtendedServerBlobAuditingPoliciesClientImpl(this);
        this.serverBlobAuditingPolicies = new ServerBlobAuditingPoliciesClientImpl(this);
        this.databaseBlobAuditingPolicies = new DatabaseBlobAuditingPoliciesClientImpl(this);
        this.databaseVulnerabilityAssessmentRuleBaselines =
            new DatabaseVulnerabilityAssessmentRuleBaselinesClientImpl(this);
        this.databaseVulnerabilityAssessments = new DatabaseVulnerabilityAssessmentsClientImpl(this);
        this.jobAgents = new JobAgentsClientImpl(this);
        this.jobCredentials = new JobCredentialsClientImpl(this);
        this.jobExecutions = new JobExecutionsClientImpl(this);
        this.jobs = new JobsClientImpl(this);
        this.jobStepExecutions = new JobStepExecutionsClientImpl(this);
        this.jobSteps = new JobStepsClientImpl(this);
        this.jobTargetExecutions = new JobTargetExecutionsClientImpl(this);
        this.jobTargetGroups = new JobTargetGroupsClientImpl(this);
        this.jobVersions = new JobVersionsClientImpl(this);
        this.longTermRetentionBackups = new LongTermRetentionBackupsClientImpl(this);
        this.backupLongTermRetentionPolicies = new BackupLongTermRetentionPoliciesClientImpl(this);
        this.managedBackupShortTermRetentionPolicies = new ManagedBackupShortTermRetentionPoliciesClientImpl(this);
        this.managedRestorableDroppedDatabaseBackupShortTermRetentionPolicies =
            new ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesClientImpl(this);
        this.serverAutomaticTunings = new ServerAutomaticTuningsClientImpl(this);
        this.serverDnsAliases = new ServerDnsAliasesClientImpl(this);
        this.serverSecurityAlertPolicies = new ServerSecurityAlertPoliciesClientImpl(this);
        this.restorableDroppedManagedDatabases = new RestorableDroppedManagedDatabasesClientImpl(this);
        this.restorePoints = new RestorePointsClientImpl(this);
        this.managedDatabaseSecurityAlertPolicies = new ManagedDatabaseSecurityAlertPoliciesClientImpl(this);
        this.managedServerSecurityAlertPolicies = new ManagedServerSecurityAlertPoliciesClientImpl(this);
        this.sensitivityLabels = new SensitivityLabelsClientImpl(this);
        this.managedInstanceAdministrators = new ManagedInstanceAdministratorsClientImpl(this);
        this.databaseOperations = new DatabaseOperationsClientImpl(this);
        this.elasticPoolOperations = new ElasticPoolOperationsClientImpl(this);
        this.databaseVulnerabilityAssessmentScans = new DatabaseVulnerabilityAssessmentScansClientImpl(this);
        this.managedDatabaseVulnerabilityAssessmentRuleBaselines =
            new ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClientImpl(this);
        this.managedDatabaseVulnerabilityAssessmentScans =
            new ManagedDatabaseVulnerabilityAssessmentScansClientImpl(this);
        this.managedDatabaseVulnerabilityAssessments = new ManagedDatabaseVulnerabilityAssessmentsClientImpl(this);
        this.instanceFailoverGroups = new InstanceFailoverGroupsClientImpl(this);
        this.backupShortTermRetentionPolicies = new BackupShortTermRetentionPoliciesClientImpl(this);
        this.tdeCertificates = new TdeCertificatesClientImpl(this);
        this.managedInstanceTdeCertificates = new ManagedInstanceTdeCertificatesClientImpl(this);
        this.managedInstanceKeys = new ManagedInstanceKeysClientImpl(this);
        this.managedInstanceEncryptionProtectors = new ManagedInstanceEncryptionProtectorsClientImpl(this);
        this.recoverableManagedDatabases = new RecoverableManagedDatabasesClientImpl(this);
        this.managedInstanceVulnerabilityAssessments = new ManagedInstanceVulnerabilityAssessmentsClientImpl(this);
        this.serverVulnerabilityAssessments = new ServerVulnerabilityAssessmentsClientImpl(this);
        this.managedDatabaseSensitivityLabels = new ManagedDatabaseSensitivityLabelsClientImpl(this);
        this.instancePools = new InstancePoolsClientImpl(this);
        this.usages = new UsagesClientImpl(this);
        this.managedInstances = new ManagedInstancesClientImpl(this);
        this.privateEndpointConnections = new PrivateEndpointConnectionsClientImpl(this);
        this.privateLinkResources = new PrivateLinkResourcesClientImpl(this);
        this.servers = new ServersClientImpl(this);
        this.capabilities = new CapabilitiesClientImpl(this);
        this.longTermRetentionManagedInstanceBackups = new LongTermRetentionManagedInstanceBackupsClientImpl(this);
        this.managedInstanceLongTermRetentionPolicies = new ManagedInstanceLongTermRetentionPoliciesClientImpl(this);
        this.workloadGroups = new WorkloadGroupsClientImpl(this);
        this.workloadClassifiers = new WorkloadClassifiersClientImpl(this);
        this.managedDatabaseRestoreDetails = new ManagedDatabaseRestoreDetailsClientImpl(this);
        this.managedDatabases = new ManagedDatabasesClientImpl(this);
        this.serverAzureADAdministrators = new ServerAzureADAdministratorsClientImpl(this);
        this.managedInstanceOperations = new ManagedInstanceOperationsClientImpl(this);
    }
}
