// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Contains the information necessary to perform a complete database restore operation. */
@Fluent
public final class CompleteDatabaseRestoreDefinition {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(CompleteDatabaseRestoreDefinition.class);

    /*
     * The last backup name to apply
     */
    @JsonProperty(value = "lastBackupName", required = true)
    private String lastBackupName;

    /**
     * Get the lastBackupName property: The last backup name to apply.
     *
     * @return the lastBackupName value.
     */
    public String lastBackupName() {
        return this.lastBackupName;
    }

    /**
     * Set the lastBackupName property: The last backup name to apply.
     *
     * @param lastBackupName the lastBackupName value to set.
     * @return the CompleteDatabaseRestoreDefinition object itself.
     */
    public CompleteDatabaseRestoreDefinition withLastBackupName(String lastBackupName) {
        this.lastBackupName = lastBackupName;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (lastBackupName() == null) {
            throw logger
                .logExceptionAsError(
                    new IllegalArgumentException(
                        "Missing required property lastBackupName in model CompleteDatabaseRestoreDefinition"));
        }
    }
}
