// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Contains the information necessary to perform a create database restore point operation. */
@Fluent
public final class CreateDatabaseRestorePointDefinition {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(CreateDatabaseRestorePointDefinition.class);

    /*
     * The restore point label to apply
     */
    @JsonProperty(value = "restorePointLabel", required = true)
    private String restorePointLabel;

    /**
     * Get the restorePointLabel property: The restore point label to apply.
     *
     * @return the restorePointLabel value.
     */
    public String restorePointLabel() {
        return this.restorePointLabel;
    }

    /**
     * Set the restorePointLabel property: The restore point label to apply.
     *
     * @param restorePointLabel the restorePointLabel value to set.
     * @return the CreateDatabaseRestorePointDefinition object itself.
     */
    public CreateDatabaseRestorePointDefinition withRestorePointLabel(String restorePointLabel) {
        this.restorePointLabel = restorePointLabel;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (restorePointLabel() == null) {
            throw logger
                .logExceptionAsError(
                    new IllegalArgumentException(
                        "Missing required property restorePointLabel in model CreateDatabaseRestorePointDefinition"));
        }
    }
}
