// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

/** The managed instance virtual cores capability. */
@Fluent
public final class InstancePoolVcoresCapability {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(InstancePoolVcoresCapability.class);

    /*
     * The virtual cores identifier.
     */
    @JsonProperty(value = "name", access = JsonProperty.Access.WRITE_ONLY)
    private String name;

    /*
     * The virtual cores value.
     */
    @JsonProperty(value = "value", access = JsonProperty.Access.WRITE_ONLY)
    private Integer value;

    /*
     * Storage limit.
     */
    @JsonProperty(value = "storageLimit", access = JsonProperty.Access.WRITE_ONLY)
    private MaxSizeCapability storageLimit;

    /*
     * The status of the capability.
     */
    @JsonProperty(value = "status", access = JsonProperty.Access.WRITE_ONLY)
    private CapabilityStatus status;

    /*
     * The reason for the capability not being available.
     */
    @JsonProperty(value = "reason")
    private String reason;

    /**
     * Get the name property: The virtual cores identifier.
     *
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Get the value property: The virtual cores value.
     *
     * @return the value value.
     */
    public Integer value() {
        return this.value;
    }

    /**
     * Get the storageLimit property: Storage limit.
     *
     * @return the storageLimit value.
     */
    public MaxSizeCapability storageLimit() {
        return this.storageLimit;
    }

    /**
     * Get the status property: The status of the capability.
     *
     * @return the status value.
     */
    public CapabilityStatus status() {
        return this.status;
    }

    /**
     * Get the reason property: The reason for the capability not being available.
     *
     * @return the reason value.
     */
    public String reason() {
        return this.reason;
    }

    /**
     * Set the reason property: The reason for the capability not being available.
     *
     * @param reason the reason value to set.
     * @return the InstancePoolVcoresCapability object itself.
     */
    public InstancePoolVcoresCapability withReason(String reason) {
        this.reason = reason;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (storageLimit() != null) {
            storageLimit().validate();
        }
    }
}
