// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/** Defines values for RecommendedIndexAction. */
public enum RecommendedIndexAction {
    /** Enum value Create. */
    CREATE("Create"),

    /** Enum value Drop. */
    DROP("Drop"),

    /** Enum value Rebuild. */
    REBUILD("Rebuild");

    /** The actual serialized value for a RecommendedIndexAction instance. */
    private final String value;

    RecommendedIndexAction(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a RecommendedIndexAction instance.
     *
     * @param value the serialized value to parse.
     * @return the parsed RecommendedIndexAction object, or null if unable to parse.
     */
    @JsonCreator
    public static RecommendedIndexAction fromString(String value) {
        RecommendedIndexAction[] items = RecommendedIndexAction.values();
        for (RecommendedIndexAction item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    @JsonValue
    @Override
    public String toString() {
        return this.value;
    }
}
