// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/** Defines values for RecommendedIndexType. */
public enum RecommendedIndexType {
    /** Enum value CLUSTERED. */
    CLUSTERED("CLUSTERED"),

    /** Enum value NONCLUSTERED. */
    NONCLUSTERED("NONCLUSTERED"),

    /** Enum value COLUMNSTORE. */
    COLUMNSTORE("COLUMNSTORE"),

    /** Enum value CLUSTERED COLUMNSTORE. */
    CLUSTERED_COLUMNSTORE("CLUSTERED COLUMNSTORE");

    /** The actual serialized value for a RecommendedIndexType instance. */
    private final String value;

    RecommendedIndexType(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a RecommendedIndexType instance.
     *
     * @param value the serialized value to parse.
     * @return the parsed RecommendedIndexType object, or null if unable to parse.
     */
    @JsonCreator
    public static RecommendedIndexType fromString(String value) {
        RecommendedIndexType[] items = RecommendedIndexType.values();
        for (RecommendedIndexType item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    @JsonValue
    @Override
    public String toString() {
        return this.value;
    }
}
