// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.JsonFlatten;
import com.azure.core.management.ProxyResource;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

/** A TDE certificate that can be uploaded into a server. */
@JsonFlatten
@Fluent
public class TdeCertificate extends ProxyResource {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(TdeCertificate.class);

    /*
     * The base64 encoded certificate private blob.
     */
    @JsonProperty(value = "properties.privateBlob")
    private String privateBlob;

    /*
     * The certificate password.
     */
    @JsonProperty(value = "properties.certPassword")
    private String certPassword;

    /**
     * Get the privateBlob property: The base64 encoded certificate private blob.
     *
     * @return the privateBlob value.
     */
    public String privateBlob() {
        return this.privateBlob;
    }

    /**
     * Set the privateBlob property: The base64 encoded certificate private blob.
     *
     * @param privateBlob the privateBlob value to set.
     * @return the TdeCertificate object itself.
     */
    public TdeCertificate withPrivateBlob(String privateBlob) {
        this.privateBlob = privateBlob;
        return this;
    }

    /**
     * Get the certPassword property: The certificate password.
     *
     * @return the certPassword value.
     */
    public String certPassword() {
        return this.certPassword;
    }

    /**
     * Set the certPassword property: The certificate password.
     *
     * @param certPassword the certPassword value to set.
     * @return the TdeCertificate object itself.
     */
    public TdeCertificate withCertPassword(String certPassword) {
        this.certPassword = certPassword;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
