/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.management.ProxyResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.sql.models.SyncDirection;
import com.azure.resourcemanager.sql.models.SyncMemberDbType;
import com.azure.resourcemanager.sql.models.SyncMemberState;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.UUID;

@JsonFlatten
public class SyncMemberInner
extends ProxyResource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(SyncMemberInner.class);
    @JsonProperty(value="properties.databaseType")
    private SyncMemberDbType databaseType;
    @JsonProperty(value="properties.syncAgentId")
    private String syncAgentId;
    @JsonProperty(value="properties.sqlServerDatabaseId")
    private UUID sqlServerDatabaseId;
    @JsonProperty(value="properties.serverName")
    private String serverName;
    @JsonProperty(value="properties.databaseName")
    private String databaseName;
    @JsonProperty(value="properties.userName")
    private String username;
    @JsonProperty(value="properties.password")
    private String password;
    @JsonProperty(value="properties.syncDirection")
    private SyncDirection syncDirection;
    @JsonProperty(value="properties.syncState", access=JsonProperty.Access.WRITE_ONLY)
    private SyncMemberState syncState;

    public SyncMemberDbType databaseType() {
        return this.databaseType;
    }

    public SyncMemberInner withDatabaseType(SyncMemberDbType databaseType) {
        this.databaseType = databaseType;
        return this;
    }

    public String syncAgentId() {
        return this.syncAgentId;
    }

    public SyncMemberInner withSyncAgentId(String syncAgentId) {
        this.syncAgentId = syncAgentId;
        return this;
    }

    public UUID sqlServerDatabaseId() {
        return this.sqlServerDatabaseId;
    }

    public SyncMemberInner withSqlServerDatabaseId(UUID sqlServerDatabaseId) {
        this.sqlServerDatabaseId = sqlServerDatabaseId;
        return this;
    }

    public String serverName() {
        return this.serverName;
    }

    public SyncMemberInner withServerName(String serverName) {
        this.serverName = serverName;
        return this;
    }

    public String databaseName() {
        return this.databaseName;
    }

    public SyncMemberInner withDatabaseName(String databaseName) {
        this.databaseName = databaseName;
        return this;
    }

    public String username() {
        return this.username;
    }

    public SyncMemberInner withUsername(String username) {
        this.username = username;
        return this;
    }

    public String password() {
        return this.password;
    }

    public SyncMemberInner withPassword(String password) {
        this.password = password;
        return this;
    }

    public SyncDirection syncDirection() {
        return this.syncDirection;
    }

    public SyncMemberInner withSyncDirection(SyncDirection syncDirection) {
        this.syncDirection = syncDirection;
        return this;
    }

    public SyncMemberState syncState() {
        return this.syncState;
    }

    public void validate() {
    }
}

