/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.implementation;

import com.azure.resourcemanager.resources.fluentcore.model.implementation.RefreshableWrapperImpl;
import com.azure.resourcemanager.sql.SqlServerManager;
import com.azure.resourcemanager.sql.fluent.SqlManagementClient;
import com.azure.resourcemanager.sql.fluent.models.SubscriptionUsageInner;
import com.azure.resourcemanager.sql.models.SqlSubscriptionUsageMetric;
import java.util.Objects;
import reactor.core.publisher.Mono;

public class SqlSubscriptionUsageMetricImpl
extends RefreshableWrapperImpl<SubscriptionUsageInner, SqlSubscriptionUsageMetric>
implements SqlSubscriptionUsageMetric {
    private final SqlServerManager sqlServerManager;
    private final String location;

    protected SqlSubscriptionUsageMetricImpl(String location, SubscriptionUsageInner innerObject, SqlServerManager sqlServerManager) {
        super((Object)innerObject);
        Objects.requireNonNull(sqlServerManager);
        this.sqlServerManager = sqlServerManager;
        this.location = location;
    }

    protected Mono<SubscriptionUsageInner> getInnerAsync() {
        return ((SqlManagementClient)this.sqlServerManager.serviceClient()).getSubscriptionUsages().getAsync(this.location, this.name());
    }

    public String name() {
        return ((SubscriptionUsageInner)((Object)this.innerModel())).name();
    }

    public String id() {
        return ((SubscriptionUsageInner)((Object)this.innerModel())).id();
    }

    @Override
    public String displayName() {
        return ((SubscriptionUsageInner)((Object)this.innerModel())).displayName();
    }

    @Override
    public double currentValue() {
        return ((SubscriptionUsageInner)((Object)this.innerModel())).currentValue() != null ? ((SubscriptionUsageInner)((Object)this.innerModel())).currentValue() : 0.0;
    }

    @Override
    public double limit() {
        return ((SubscriptionUsageInner)((Object)this.innerModel())).limit() != null ? ((SubscriptionUsageInner)((Object)this.innerModel())).limit() : 0.0;
    }

    @Override
    public String unit() {
        return ((SubscriptionUsageInner)((Object)this.innerModel())).unit();
    }

    @Override
    public String type() {
        return ((SubscriptionUsageInner)((Object)this.innerModel())).type();
    }
}

